/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HighlightersRecycler {
    private final MultiMap<TextRange, RangeHighlighter> incinerator = new MultiMap();

    HighlightersRecycler() {
    }

    void recycleHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            HighlightersRecycler.$$$reportNull$$$0(0);
        }
        if (highlighter.isValid()) {
            this.incinerator.putValue(ProperTextRange.create((Segment)highlighter), highlighter);
        }
    }

    @Nullable
    RangeHighlighter pickupHighlighterFromGarbageBin(int startOffset, int endOffset, int layer) {
        TextRange range = new TextRange(startOffset, endOffset);
        Collection<RangeHighlighter> collection = this.incinerator.get(range);
        for (RangeHighlighter highlighter : collection) {
            if (!highlighter.isValid() || highlighter.getLayer() != layer) continue;
            this.incinerator.remove(range, highlighter);
            return highlighter;
        }
        return null;
    }

    @NotNull
    Collection<? extends RangeHighlighter> forAllInGarbageBin() {
        Collection<RangeHighlighter> collection = this.incinerator.values();
        if (collection == null) {
            HighlightersRecycler.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightersRecycler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightersRecycler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forAllInGarbageBin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recycleHighlighter";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

