/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CanISilentlyChange;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.TransferToEDTQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    @NotNull
    private final ProperTextRange myVisibleRange;
    @NotNull
    private final CanISilentlyChange.Result myCanChangeFileSilently;
    private volatile boolean myIsEssentialHighlightingOnly;
    private final Long2ObjectMap<RangeMarker> myRanges2markersCache;
    private final TransferToEDTQueue<Runnable> myEDTQueue;
    private volatile boolean myInContent;
    private static final Key<ConcurrentMap<PsiFile, HighlightingSession>> HIGHLIGHTING_SESSION = Key.create("HIGHLIGHTING_SESSION");

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, @NotNull CanISilentlyChange.Result canChangeFileSilently) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(0);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(1);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(2);
        }
        if (canChangeFileSilently == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(3);
        }
        this.myRanges2markersCache = new Long2ObjectOpenHashMap<RangeMarker>();
        this.myPsiFile = psiFile;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = ReadAction.compute(() -> psiFile.getProject());
        this.myDocument = ReadAction.compute(() -> psiFile.getOriginalFile().getViewProvider().getDocument());
        this.myVisibleRange = visibleRange;
        this.myCanChangeFileSilently = canChangeFileSilently;
        this.myEDTQueue = new TransferToEDTQueue<Runnable>("Apply highlighting results", runnable -> {
            runnable.run();
            return true;
        }, __ -> this.myProject.isDisposed() || this.getProgressIndicator().isCanceled()){

            @Override
            protected void schedule(@NotNull Runnable updateRunnable) {
                if (updateRunnable == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(updateRunnable, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateRunnable", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl$1", "schedule"));
            }
        };
    }

    void applyInEDT(@NotNull Runnable runnable) {
        if (runnable == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(4);
        }
        this.myEDTQueue.offer(runnable);
    }

    boolean canChangeFileSilently() {
        return this.myCanChangeFileSilently.canIReally(this.myInContent);
    }

    @NotNull
    static HighlightingSession getFromCurrentIndicator(@NotNull PsiFile file2) {
        DaemonProgressIndicator indicator;
        Map map2;
        if (file2 == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(5);
        }
        if ((map2 = (Map)(indicator = GlobalInspectionContextBase.assertUnderDaemonProgress()).getUserData(HIGHLIGHTING_SESSION)) == null) {
            throw new IllegalStateException("No HighlightingSession stored in " + indicator);
        }
        HighlightingSession session = (HighlightingSession)map2.get(file2);
        if (session == null) {
            String mapStr = map2.entrySet().stream().map(e -> {
                PsiFile storedFile = (PsiFile)e.getKey();
                return storedFile + ": " + System.identityHashCode(storedFile) + " (" + storedFile.getClass() + ") -> " + e.getValue();
            }).collect(Collectors.joining("; "));
            throw new IllegalStateException("No HighlightingSession found for " + file2 + ": " + System.identityHashCode(file2) + " (" + file2.getClass() + ") in " + indicator + " in map: " + mapStr);
        }
        HighlightingSession highlightingSession = session;
        if (highlightingSession == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(6);
        }
        return highlightingSession;
    }

    static void getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @NotNull DaemonProgressIndicator progressIndicator, @NotNull ProperTextRange visibleRange) {
        Map map2;
        HighlightingSession session;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(7);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(8);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(9);
        }
        HighlightingSession highlightingSession = session = (map2 = (Map)progressIndicator.getUserData(HIGHLIGHTING_SESSION)) == null ? null : (HighlightingSession)map2.get(psiFile);
        if (session == null) {
            HighlightingSessionImpl.createHighlightingSession(psiFile, progressIndicator, null, visibleRange, CanISilentlyChange.Result.UH_UH);
        }
    }

    @NotNull
    static HighlightingSessionImpl createHighlightingSession(@NotNull PsiFile psiFile, @Nullable Editor editor2, @Nullable EditorColorsScheme editorColorsScheme, @NotNull DaemonProgressIndicator progressIndicator) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(10);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextRange fileRange = psiFile.getTextRange();
        ProperTextRange visibleRange = editor2 == null ? ProperTextRange.create(ObjectUtils.notNull(fileRange, TextRange.EMPTY_RANGE)) : VisibleHighlightingPassFactory.calculateVisibleRange(editor2);
        CanISilentlyChange.Result canChangeFileSilently = CanISilentlyChange.thisFile(psiFile);
        return (HighlightingSessionImpl)HighlightingSessionImpl.createHighlightingSession(psiFile, progressIndicator, editorColorsScheme, visibleRange, canChangeFileSilently);
    }

    @NotNull
    static HighlightingSession createHighlightingSession(@NotNull PsiFile psiFile, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, @NotNull CanISilentlyChange.Result canChangeFileSilently) {
        Map map2;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(12);
        }
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(13);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(14);
        }
        if (canChangeFileSilently == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(15);
        }
        if ((map2 = (Map)progressIndicator.getUserData(HIGHLIGHTING_SESSION)) == null) {
            map2 = progressIndicator.putUserDataIfAbsent(HIGHLIGHTING_SESSION, new ConcurrentHashMap());
        }
        HighlightingSessionImpl session = new HighlightingSessionImpl(psiFile, progressIndicator, editorColorsScheme, visibleRange, canChangeFileSilently);
        map2.put(psiFile, session);
        HighlightingSessionImpl highlightingSessionImpl = session;
        if (highlightingSessionImpl == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(16);
        }
        return highlightingSessionImpl;
    }

    @ApiStatus.Internal
    public static void runInsideHighlightingSession(@NotNull PsiFile file2, @Nullable EditorColorsScheme editorColorsScheme, @NotNull ProperTextRange visibleRange, boolean canChangeFileSilently, @NotNull Runnable runnable) {
        if (file2 == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(17);
        }
        if (visibleRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(18);
        }
        if (runnable == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(19);
        }
        DaemonProgressIndicator indicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        HighlightingSessionImpl.createHighlightingSession(file2, indicator, editorColorsScheme, visibleRange, canChangeFileSilently ? CanISilentlyChange.Result.UH_HUH : CanISilentlyChange.Result.UH_UH);
        runnable.run();
    }

    static void waitForAllSessionsHighlightInfosApplied(@NotNull DaemonProgressIndicator progressIndicator) {
        ConcurrentMap<PsiFile, HighlightingSession> map2;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(20);
        }
        if ((map2 = progressIndicator.getUserData(HIGHLIGHTING_SESSION)) != null) {
            for (HighlightingSession session : map2.values()) {
                ((HighlightingSessionImpl)session).waitForHighlightInfosApplied();
            }
        }
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(21);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(22);
        }
        return document;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(23);
        }
        return progressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(24);
        }
        return project2;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info2, @NotNull TextRange restrictedRange, int groupId) {
        if (info2 == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(25);
        }
        if (restrictedRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(26);
        }
        this.applyInEDT(() -> UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.getPsiFile(), this.getDocument(), restrictedRange, info2, this.getColorsScheme(), groupId, this.myRanges2markersCache));
    }

    void queueDisposeHighlighter(@NotNull HighlightInfo info2) {
        RangeHighlighterEx highlighter;
        if (info2 == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(27);
        }
        if ((highlighter = info2.getHighlighter()) == null) {
            return;
        }
        this.applyInEDT(() -> {
            Object actualInfo = highlighter.getErrorStripeTooltip();
            if (actualInfo == info2 && info2.getHighlighter() == highlighter) {
                highlighter.dispose();
            }
        });
    }

    void waitForHighlightInfosApplied() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEDTQueue.drain();
    }

    static void clearProgressIndicator(@NotNull DaemonProgressIndicator indicator) {
        if (indicator == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(28);
        }
        indicator.putUserData(HIGHLIGHTING_SESSION, null);
    }

    @Override
    @NotNull
    public ProperTextRange getVisibleRange() {
        ProperTextRange properTextRange = this.myVisibleRange;
        if (properTextRange == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(29);
        }
        return properTextRange;
    }

    @Override
    public boolean isEssentialHighlightingOnly() {
        return this.myIsEssentialHighlightingOnly;
    }

    public String toString() {
        return "HighlightingSessionImpl: myVisibleRange:" + this.myVisibleRange + "; myPsiFile: " + this.myPsiFile + (this.myIsEssentialHighlightingOnly ? "; essentialHighlightingOnly" : "");
    }

    void additionalSetupFromBackground(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            HighlightingSessionImpl.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        this.myIsEssentialHighlightingOnly = HighlightingLevelManager.getInstance(psiFile.getProject()).runEssentialHighlightingOnly(psiFile);
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        this.myInContent = virtualFile2 != null && ModuleUtilCore.projectContainsFile(psiFile.getProject(), virtualFile2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 16, 21, 22, 23, 24, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canChangeFileSilently";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictedRange";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromCurrentIndicator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightingSession";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyInEDT";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFromCurrentIndicator";
                break;
            }
            case 6: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHighlightingSession";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingSession";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runInsideHighlightingSession";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllSessionsHighlightInfosApplied";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "queueHighlightInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "queueDisposeHighlighter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "clearProgressIndicator";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "additionalSetupFromBackground";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 16, 21, 22, 23, 24, 29 -> new IllegalStateException(string2);
        };
    }
}

