/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.IndentGuideRenderer;
import com.intellij.codeInsight.daemon.impl.IndentsPassFilterUtils;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class IndentsPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Key<List<RangeHighlighter>> INDENT_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create("INDENT_HIGHLIGHTERS_IN_EDITOR_KEY");
    private static final Key<Long> LAST_TIME_INDENTS_BUILT = Key.create("LAST_TIME_INDENTS_BUILT");
    private final Editor myEditor;
    private final PsiFile myFile;
    private volatile List<TextRange> myRanges;
    private volatile List<IndentGuideDescriptor> myDescriptors;
    private static final CustomHighlighterRenderer RENDERER = new IndentGuideRenderer();

    public IndentsPass(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            IndentsPass.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            IndentsPass.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            IndentsPass.$$$reportNull$$$0(2);
        }
        super(project2, editor2.getDocument(), false);
        this.myRanges = Collections.emptyList();
        this.myDescriptors = Collections.emptyList();
        this.myEditor = editor2;
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Long stamp;
        if (progress == null) {
            IndentsPass.$$$reportNull$$$0(3);
        }
        if ((stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT)) != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        this.myDescriptors = this.buildDescriptors();
        ArrayList<TextRange> ranges2 = new ArrayList<TextRange>();
        for (IndentGuideDescriptor descriptor2 : this.myDescriptors) {
            ProgressManager.checkCanceled();
            int endOffset = descriptor2.endLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(descriptor2.endLine) : this.myDocument.getTextLength();
            ranges2.add(new TextRange(this.myDocument.getLineStartOffset(descriptor2.startLine), endOffset));
        }
        ranges2.sort(Segment.BY_START_OFFSET_THEN_END_OFFSET);
        this.myRanges = ranges2;
    }

    private long nowStamp() {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            return -1L;
        }
        return this.myDocument.getModificationStamp() ^ (long)this.getTabSize() << 24;
    }

    private int getTabSize() {
        return EditorUtil.getTabSize((Editor)this.myEditor);
    }

    @Override
    public void doApplyInformationToEditor() {
        Long stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT);
        if (stamp != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        List oldHighlighters = (List)this.myEditor.getUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        MarkupModel mm = this.myEditor.getMarkupModel();
        int curRange = 0;
        if (oldHighlighters != null) {
            RangeHighlighter highlighter;
            oldHighlighters.sort(Comparator.comparing(h -> !h.isValid()).thenComparing(Segment.BY_START_OFFSET_THEN_END_OFFSET));
            int curHighlight = 0;
            while (curRange < this.myRanges.size() && curHighlight < oldHighlighters.size()) {
                TextRange range = this.myRanges.get(curRange);
                RangeHighlighter highlighter2 = (RangeHighlighter)oldHighlighters.get(curHighlight);
                if (!highlighter2.isValid()) break;
                int cmp = IndentsPass.compare(range, highlighter2);
                if (cmp < 0) {
                    newHighlighters.add(IndentsPass.createHighlighter(mm, range));
                    ++curRange;
                    continue;
                }
                if (cmp > 0) {
                    highlighter2.dispose();
                    ++curHighlight;
                    continue;
                }
                newHighlighters.add(highlighter2);
                ++curHighlight;
                ++curRange;
            }
            while (curHighlight < oldHighlighters.size() && (highlighter = (RangeHighlighter)oldHighlighters.get(curHighlight)).isValid()) {
                highlighter.dispose();
                ++curHighlight;
            }
        }
        int startRangeIndex = curRange;
        DocumentUtil.executeInBulk(this.myDocument, this.myRanges.size() > 10000, () -> {
            for (int i2 = startRangeIndex; i2 < this.myRanges.size(); ++i2) {
                newHighlighters.add(IndentsPass.createHighlighter(mm, this.myRanges.get(i2)));
            }
        });
        this.myEditor.putUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY, newHighlighters);
        this.myEditor.putUserData(LAST_TIME_INDENTS_BUILT, (Object)this.nowStamp());
        this.myEditor.getIndentsModel().assumeIndents(this.myDescriptors);
    }

    private List<IndentGuideDescriptor> buildDescriptors() {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            return Collections.emptyList();
        }
        IndentsCalculator calculator = new IndentsCalculator();
        calculator.calculate();
        int[] lineIndents = calculator.lineIndents;
        IntArrayList lines2 = new IntArrayList();
        IntArrayList indents = new IntArrayList();
        lines2.push(0);
        indents.push(0);
        ArrayList<IndentGuideDescriptor> descriptors = new ArrayList<IndentGuideDescriptor>();
        for (int line = 1; line < lineIndents.length; ++line) {
            ProgressManager.checkCanceled();
            int curIndent = Math.abs(lineIndents[line]);
            block1: while (!indents.isEmpty() && curIndent <= indents.topInt()) {
                ProgressManager.checkCanceled();
                int level = indents.popInt();
                int startLine = lines2.popInt();
                if (level <= 0) continue;
                for (int i2 = startLine; i2 < line; ++i2) {
                    if (level == Math.abs(lineIndents[i2])) continue;
                    IndentGuideDescriptor descriptor2 = this.createDescriptor(level, startLine, line, lineIndents);
                    if (!IndentsPassFilterUtils.shouldShowIndentGuide(this.myEditor, descriptor2)) continue block1;
                    descriptors.add(descriptor2);
                    continue block1;
                }
            }
            int prevLine = line - 1;
            int prevIndent = Math.abs(lineIndents[prevLine]);
            if (curIndent - prevIndent <= 1) continue;
            lines2.push(prevLine);
            indents.push(prevIndent);
        }
        while (!indents.isEmpty()) {
            IndentGuideDescriptor descriptor3;
            ProgressManager.checkCanceled();
            int level = indents.popInt();
            int startLine = lines2.popInt();
            if (level <= 0 || !IndentsPassFilterUtils.shouldShowIndentGuide(this.myEditor, descriptor3 = this.createDescriptor(level, startLine, this.myDocument.getLineCount(), lineIndents))) continue;
            descriptors.add(descriptor3);
        }
        return descriptors;
    }

    private IndentGuideDescriptor createDescriptor(int level, int startLine, int endLine, int[] lineIndents) {
        while (startLine > 0 && lineIndents[startLine] < 0) {
            --startLine;
        }
        int codeConstructStartLine = this.findCodeConstructStartLine(startLine);
        return new IndentGuideDescriptor(level, codeConstructStartLine, startLine, endLine);
    }

    private int findCodeConstructStartLine(int startLine) {
        HighlighterIterator iterator2;
        Language language;
        int lineStartOffset;
        Document document = this.myEditor.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        int firstNonWsOffset = CharArrayUtil.shiftForward(text2, lineStartOffset = document.getLineStartOffset(startLine), " \t");
        FileType type = PsiUtilBase.getPsiFileAtOffset(this.myFile, firstNonWsOffset).getFileType();
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(type, language = PsiUtilCore.getLanguageAtOffset(this.myFile, firstNonWsOffset));
        if (braceMatcher.isLBraceToken(iterator2 = this.myEditor.getHighlighter().createIterator(firstNonWsOffset), text2, type)) {
            int codeConstructStart = braceMatcher.getCodeConstructStart(this.myFile, firstNonWsOffset);
            return document.getLineNumber(codeConstructStart);
        }
        return startLine;
    }

    @NotNull
    private static RangeHighlighter createHighlighter(MarkupModel mm, TextRange range) {
        RangeHighlighter highlighter = mm.addRangeHighlighter(null, range.getStartOffset(), range.getEndOffset(), 0, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setCustomRenderer(RENDERER);
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            IndentsPass.$$$reportNull$$$0(4);
        }
        return rangeHighlighter;
    }

    private static int compare(@NotNull TextRange r, @NotNull RangeHighlighter h) {
        int answer;
        if (r == null) {
            IndentsPass.$$$reportNull$$$0(5);
        }
        if (h == null) {
            IndentsPass.$$$reportNull$$$0(6);
        }
        return (answer = r.getStartOffset() - h.getStartOffset()) != 0 ? answer : r.getEndOffset() - h.getEndOffset();
    }

    @TestOnly
    @NotNull
    public List<IndentGuideDescriptor> getDescriptors() {
        return new ArrayList<IndentGuideDescriptor>(this.myDescriptors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/IndentsPass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IndentsPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }

    private class IndentsCalculator {
        @NotNull
        final Map<Language, TokenSet> myComments = new HashMap<Language, TokenSet>();
        final int @NotNull [] lineIndents;
        @NotNull
        final CharSequence myChars;

        IndentsCalculator() {
            this.lineIndents = new int[IndentsPass.this.myDocument.getLineCount()];
            this.myChars = IndentsPass.this.myDocument.getCharsSequence();
        }

        void calculate() {
            FileType fileType = IndentsPass.this.myFile.getFileType();
            int tabSize = IndentsPass.this.getTabSize();
            for (int line = 0; line < this.lineIndents.length; ++line) {
                int offset2;
                ProgressManager.checkCanceled();
                int lineStart = IndentsPass.this.myDocument.getLineStartOffset(line);
                int lineEnd = IndentsPass.this.myDocument.getLineEndOffset(line);
                int column = 0;
                block5: for (offset2 = lineStart; offset2 < lineEnd; ++offset2) {
                    switch (this.myChars.charAt(offset2)) {
                        case ' ': {
                            ++column;
                            continue block5;
                        }
                        case '\t': {
                            column = (column / tabSize + 1) * tabSize;
                            continue block5;
                        }
                    }
                }
                this.lineIndents[line] = offset2 == lineEnd || this.isComment(offset2) ? -1 : column;
            }
            int topIndent = 0;
            for (int line = 0; line < this.lineIndents.length; ++line) {
                ProgressManager.checkCanceled();
                if (this.lineIndents[line] >= 0) {
                    topIndent = this.lineIndents[line];
                    continue;
                }
                int startLine = line;
                while (line < this.lineIndents.length && this.lineIndents[line] < 0) {
                    ++line;
                }
                int bottomIndent = line < this.lineIndents.length ? this.lineIndents[line] : topIndent;
                int indent = Math.min(topIndent, bottomIndent);
                if (bottomIndent < topIndent) {
                    int lineStart = IndentsPass.this.myDocument.getLineStartOffset(line);
                    int lineEnd = IndentsPass.this.myDocument.getLineEndOffset(line);
                    int nonWhitespaceOffset = CharArrayUtil.shiftForward(this.myChars, lineStart, lineEnd, " \t");
                    HighlighterIterator iterator2 = IndentsPass.this.myEditor.getHighlighter().createIterator(nonWhitespaceOffset);
                    IElementType tokenType = iterator2.getTokenType();
                    if (BraceMatchingUtil.isRBraceToken(iterator2, this.myChars, fileType) || tokenType != null && !CodeBlockSupportHandler.findMarkersRanges(IndentsPass.this.myFile, tokenType.getLanguage(), nonWhitespaceOffset).isEmpty()) {
                        indent = topIndent;
                    }
                }
                for (int blankLine = startLine; blankLine < line; ++blankLine) {
                    assert (this.lineIndents[blankLine] == -1);
                    this.lineIndents[blankLine] = -Math.min(topIndent, indent);
                }
                --line;
            }
        }

        private boolean isComment(int offset2) {
            HighlighterIterator it = IndentsPass.this.myEditor.getHighlighter().createIterator(offset2);
            IElementType tokenType = it.getTokenType();
            Language language = tokenType.getLanguage();
            TokenSet comments = this.myComments.get(language);
            if (comments == null) {
                ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (definition != null) {
                    comments = definition.getCommentTokens();
                }
                if (comments == null) {
                    return false;
                }
                this.myComments.put(language, comments);
            }
            return comments.contains(tokenType);
        }
    }
}

