/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InjectedGeneralHighlightingPass
extends GeneralHighlightingPass {
    private final @Nullable Collection<? extends @NotNull TextRange> myReducedRanges;

    InjectedGeneralHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @Nullable Collection<? extends @NotNull TextRange> reducedRanges, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor2, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoProcessor == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        super(file2, document, startOffset, endOffset, updateAll, priorityRange, editor2, highlightInfoProcessor);
        this.myReducedRanges = reducedRanges;
    }

    @Override
    @NotNull
    protected String getPresentableName() {
        String string2 = IdeBundle.message((String)"highlighting.pass.injected.presentable.name", (Object[])new Object[0]);
        if (string2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        if (!Registry.is("editor.injected.highlighting.enabled")) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, new CommonProcessors.CollectProcessor(allDivided));
        List allInsideElements = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> d.inside));
        List allOutsideElements = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> d.outside));
        ArrayList resultInside = new ArrayList(100);
        ArrayList<HighlightInfo> resultOutside = new ArrayList<HighlightInfo>(100);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(this.myProject);
        TextAttributesKey fragmentKey = EditorColors.createInjectedLanguageFragmentKey((Language)this.myFile.getLanguage());
        this.processInjectedPsiFiles(allInsideElements, allOutsideElements, progress, (injectedPsi, places) -> this.addInjectedPsiHighlights(injectedLanguageManager, injectedPsi, places, fragmentKey, patchedInfo -> {
            this.queueInfoToUpdateIncrementally((HighlightInfo)patchedInfo, this.getId());
            List list2 = this.myHighlights;
            synchronized (list2) {
                if (this.myRestrictRange.contains((Segment)patchedInfo)) {
                    resultInside.add(patchedInfo);
                } else {
                    resultOutside.add((HighlightInfo)patchedInfo);
                }
            }
        }));
        List list2 = this.myHighlights;
        synchronized (list2) {
            if (resultOutside.isEmpty()) {
                this.myHighlights.addAll(resultInside);
                this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), this.myHighlights, this.myRestrictRange, this.myRestrictRange, this.getId());
            } else {
                boolean priorityIntersectionHasElements = this.myPriorityRange.intersectsStrict(this.myRestrictRange);
                if (!(allInsideElements.isEmpty() && resultInside.isEmpty() || !priorityIntersectionHasElements)) {
                    this.myHighlights.addAll(resultInside);
                    this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), resultInside, this.myPriorityRange, this.myRestrictRange, this.getId());
                } else {
                    for (HighlightInfo info2 : resultInside) {
                        if (!this.myRestrictRange.contains(info2) || this.myPriorityRange.contains(info2)) continue;
                        resultOutside.add(info2);
                    }
                }
                this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), resultOutside, this.myRestrictRange, new ProperTextRange(0, this.myDocument.getTextLength()), this.getId());
            }
        }
    }

    private void processInjectedPsiFiles(@NotNull List<? extends PsiElement> elements1, @NotNull List<? extends PsiElement> elements2, @NotNull ProgressIndicator progress, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        if (elements1 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        if (elements2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        if (progress == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        if (visitor2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InjectedLanguageManagerImpl injectedLanguageManager = InjectedLanguageManagerImpl.getInstanceImpl(this.myProject);
        List<DocumentWindow> cachedInjected = injectedLanguageManager.getCachedInjectedDocumentsInRange(this.myFile, this.myFile.getTextRange());
        HashSet<PsiLanguageInjectionHost> hosts = new HashSet<PsiLanguageInjectionHost>(elements1.size() + elements2.size() + cachedInjected.size());
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.myProject);
        for (DocumentWindow documentRange : cachedInjected) {
            PsiLanguageInjectionHost context2;
            PsiFile file2;
            ProgressManager.checkCanceled();
            if (!documentRange.isValid() || (file2 = psiDocumentManager.getPsiFile(documentRange)) == null || (context2 = injectedLanguageManager.getInjectionHost(file2)) == null || !context2.isValid() || file2.getProject().isDisposed() || !this.myUpdateAll && !this.myRestrictRange.contains(context2.getTextRange()) || this.myReducedRanges != null && !ContainerUtil.exists(this.myReducedRanges, reducedRange -> reducedRange.contains(context2.getTextRange()))) continue;
            hosts.add(context2);
        }
        CommonProcessors.CollectProcessor<PsiElement> collectInjectableProcessor = new CommonProcessors.CollectProcessor<PsiElement>(hosts){

            @Override
            public boolean process(PsiElement t) {
                ProgressManager.checkCanceled();
                if (InjectedLanguageUtil.isInjectable(t, false)) {
                    super.process(t);
                }
                return true;
            }
        };
        injectedLanguageManager.processInjectableElements(elements1, (Processor<? super PsiElement>)collectInjectableProcessor);
        injectedLanguageManager.processInjectableElements(elements2, (Processor<? super PsiElement>)collectInjectableProcessor);
        this.setProgressLimit(hosts.size());
        Set visitedInjected = ContainerUtil.newConcurrentSet();
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(hosts), progress, element -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            injectedLanguageManager.enumerateEx((PsiElement)element, this.myFile, false, (injectedPsi, places) -> {
                if (visitedInjected.add(injectedPsi)) {
                    visitor2.visit(injectedPsi, places);
                }
            });
            this.advanceProgress(1L);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private HighlightInfoHolder createInfoHolder(final @NotNull PsiFile injectedPsi, final @NotNull DocumentWindow documentWindow, final @NotNull InjectedLanguageManager injectedLanguageManager, final @NotNull Consumer<? super HighlightInfo> outInfos) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(13);
        }
        HighlightInfoFilter[] filters = HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        final EditorColorsScheme actualScheme = this.getColorsScheme() == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.getColorsScheme();
        return new HighlightInfoHolder(injectedPsi, filters){

            @Override
            @NotNull
            public TextAttributesScheme getColorsScheme() {
                EditorColorsScheme editorColorsScheme = actualScheme;
                if (editorColorsScheme == null) {
                    2.$$$reportNull$$$0(0);
                }
                return editorColorsScheme;
            }

            @Override
            public boolean add(@Nullable HighlightInfo info2) {
                boolean added = super.add(info2);
                if (info2 != null && added) {
                    InjectedGeneralHighlightingPass.addPatchedInfos(info2, injectedPsi, documentWindow, injectedLanguageManager, outInfos);
                }
                return added;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass$2", "getColorsScheme"));
            }
        };
    }

    private void addInjectedPsiHighlights(@NotNull InjectedLanguageManager injectedLanguageManager, @NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places, @Nullable TextAttributesKey attributesKey, @NotNull Consumer<? super HighlightInfo> outInfos) {
        DocumentWindow documentWindow;
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        if (places == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        if ((documentWindow = (DocumentWindow)PsiDocumentManager.getInstance(this.myProject).getCachedDocument(injectedPsi)) == null) {
            return;
        }
        boolean addTooltips = places.size() < 100;
        for (PsiLanguageInjectionHost.Shred shred : places) {
            TextRange textRange;
            PsiLanguageInjectionHost host = shred.getHost();
            if (host == null || (textRange = shred.getRangeInsideHost().shiftRight(host.getTextRange().getStartOffset())).isEmpty()) continue;
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(textRange);
            if (attributesKey != null && InjectedLanguageUtil.isHighlightInjectionBackground(host)) {
                builder2.textAttributes(attributesKey);
            }
            if (addTooltips) {
                String desc = injectedPsi.getLanguage().getDisplayName() + ": " + injectedPsi.getText();
                builder2.unescapedToolTip(desc);
            }
            HighlightInfo info2 = builder2.createUnconditionally();
            info2.markFromInjection();
            outInfos.accept(info2);
        }
        HighlightInfoHolder holder = this.createInfoHolder(injectedPsi, documentWindow, injectedLanguageManager, outInfos);
        this.runHighlightVisitorsForInjected(injectedPsi, holder);
        this.highlightInjectedSyntax(injectedPsi, places, outInfos);
        if (!this.isDumbMode()) {
            ArrayList arrayList = new ArrayList();
            InjectedGeneralHighlightingPass.highlightTodos(injectedPsi, injectedPsi.getText(), 0, injectedPsi.getTextLength(), this.myPriorityRange, arrayList, arrayList);
            for (HighlightInfo info3 : arrayList) {
                InjectedGeneralHighlightingPass.addPatchedInfos(info3, injectedPsi, documentWindow, injectedLanguageManager, outInfos);
            }
        }
    }

    private static void addPatchedInfos(@NotNull HighlightInfo info2, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull InjectedLanguageManager injectedLanguageManager, @NotNull Consumer<? super HighlightInfo> outInfos) {
        if (info2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        ProperTextRange infoRange = new ProperTextRange(info2.startOffset, info2.endOffset);
        List<TextRange> editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, infoRange);
        for (TextRange editable : editables) {
            TextRange hostRange = documentWindow.injectedToHost(editable);
            boolean isAfterEndOfLine = info2.isAfterEndOfLine();
            if (isAfterEndOfLine) {
                int hostEndOffset = hostRange.getEndOffset();
                int lineNumber = documentWindow.getDelegate().getLineNumber(hostEndOffset);
                int hostLineEndOffset = documentWindow.getDelegate().getLineEndOffset(lineNumber);
                if (hostEndOffset < hostLineEndOffset) {
                    isAfterEndOfLine = false;
                    hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
                }
            }
            HighlightInfo patched = new HighlightInfo(info2.forcedTextAttributes, info2.forcedTextAttributesKey, info2.type, hostRange.getStartOffset(), hostRange.getEndOffset(), info2.getDescription(), info2.getToolTip(), info2.getSeverity(), isAfterEndOfLine, null, false, 0, info2.getProblemGroup(), info2.getInspectionToolId(), info2.getGutterIconRenderer(), info2.getGroup(), info2.unresolvedReference, injectedPsi);
            patched.setHint(info2.hasHint());
            info2.findRegisteredQuickFix((descriptor2, quickfixTextRange) -> {
                List<TextRange> editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)quickfixTextRange);
                for (TextRange editableRange : editableQF) {
                    TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                    patched.registerFix(descriptor2.getAction(), descriptor2.myOptions, descriptor2.getDisplayName(), hostEditableRange, descriptor2.myKey);
                }
                return null;
            });
            patched.markFromInjection();
            outInfos.accept(patched);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHighlightVisitorsForInjected(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        HighlightVisitor[] filtered = this.getHighlightVisitors(injectedPsi);
        try {
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange(injectedPsi, 0, injectedPsi.getTextLength());
            for (HighlightVisitor visitor2 : filtered) {
                visitor2.analyze(injectedPsi, true, holder, () -> {
                    for (PsiElement element : elements) {
                        ProgressManager.checkCanceled();
                        visitor2.visit(element);
                    }
                });
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private void highlightInjectedSyntax(@NotNull PsiFile injectedPsi, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places, @NotNull Consumer<? super HighlightInfo> outInfos) {
        List<InjectedLanguageUtilBase.TokenInfo> tokens;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        if (places == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(26);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(27);
        }
        if ((tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi)) == null) {
            return;
        }
        int shredIndex = -1;
        int injectionHostTextRangeStart = -1;
        for (InjectedLanguageUtilBase.TokenInfo token : tokens) {
            ProgressManager.checkCanceled();
            ProperTextRange range = token.rangeInsideInjectionHost();
            if (range.getLength() == 0) continue;
            if (shredIndex != token.shredIndex()) {
                shredIndex = token.shredIndex();
                PsiLanguageInjectionHost.Shred shred = places.get(shredIndex);
                PsiLanguageInjectionHost host = shred.getHost();
                if (host == null) {
                    return;
                }
                injectionHostTextRangeStart = host.getTextRange().getStartOffset();
            }
            TextRange hostRange = ((TextRange)range).shiftRight(injectionHostTextRangeStart);
            InjectedGeneralHighlightingPass.addSyntaxInjectedFragmentInfo(this.myGlobalScheme, hostRange, token.textAttributesKeys(), outInfos);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    static void addSyntaxInjectedFragmentInfo(@NotNull EditorColorsScheme scheme, @NotNull TextRange hostRange, TextAttributesKey @NotNull [] keys2, @NotNull Consumer<? super HighlightInfo> outInfos) {
        if (scheme == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(28);
        }
        if (hostRange == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(29);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(30);
        }
        if (keys2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(31);
        }
        if (hostRange.isEmpty()) {
            return;
        }
        HighlightInfo info2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(hostRange).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
        outInfos.accept(info2);
        LayeredTextAttributes injectedAttributes = LayeredTextAttributes.create((EditorColorsScheme)scheme, (TextAttributesKey[])keys2);
        if (injectedAttributes.isEmpty() || keys2.length == 1 && keys2[0] == HighlighterColors.TEXT) {
            return;
        }
        HighlightInfo injectedInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(hostRange).textAttributes((TextAttributes)injectedAttributes).createUnconditionally();
        outInfos.accept(injectedInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 12: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguageManager";
                break;
            }
            case 13: 
            case 17: 
            case 22: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRange";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedPsiFiles";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInfoHolder";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedPsiHighlights";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedInfos";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runHighlightVisitorsForInjected";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "highlightInjectedSyntax";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addSyntaxInjectedFragmentInfo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

