/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.InjectionUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class LineMarkersPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(LineMarkersPass.class);
    private volatile List<LineMarkerInfo<?>> myMarkers;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myPriorityBounds;
    @NotNull
    private final TextRange myRestrictRange;
    @NotNull
    private final Mode myMode;

    LineMarkersPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange priorityBounds, @NotNull TextRange restrictRange, @NotNull Mode mode) {
        if (project2 == null) {
            LineMarkersPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LineMarkersPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(2);
        }
        if (priorityBounds == null) {
            LineMarkersPass.$$$reportNull$$$0(3);
        }
        if (restrictRange == null) {
            LineMarkersPass.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            LineMarkersPass.$$$reportNull$$$0(5);
        }
        super(project2, document, false);
        this.myMarkers = Collections.emptyList();
        this.myFile = file2;
        this.myPriorityBounds = priorityBounds;
        this.myRestrictRange = restrictRange;
        this.myMode = mode;
    }

    @Override
    public void doApplyInformationToEditor() {
        try {
            LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), this.myRestrictRange, this.myMarkers, this.getId());
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
            FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
            fileStatusMap.markFileUpToDate(this.myDocument, this.getId());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            LineMarkersPass.$$$reportNull$$$0(6);
        }
        if (!EditorSettingsExternalizable.getInstance().areGutterIconsShown() && !Registry.is("calculate.gutter.actions.always")) {
            return;
        }
        ArrayList lineMarkers = new ArrayList();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        int passId = this.getId();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            if (root == null) {
                LOG.error(viewProvider + " for file " + this.myFile + " returned null root for language " + language + " despite listing it as one of its own languages: " + viewProvider.getLanguages());
                continue;
            }
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myProject);
            if (!highlightingLevelManager.shouldHighlight(root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, TextRangeScalarUtil.toScalarRange(this.myRestrictRange), TextRangeScalarUtil.toScalarRange(this.myPriorityBounds), elements -> {
                List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
                ArrayList<LineMarkerProvider> providersList = new ArrayList<LineMarkerProvider>(providers);
                this.queryProviders(elements.inside, root, providersList, (__, info2) -> {
                    info2.updatePass = passId;
                    lineMarkers.add((LineMarkerInfo<?>)info2);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isValid()) {
                            LineMarkersUtil.addLineMarkerToEditorIncrementally(this.myProject, this.getDocument(), info2);
                        }
                    }, this.myProject.getDisposed());
                });
                this.queryProviders(elements.outside, root, providersList, (__, info2) -> {
                    info2.updatePass = passId;
                    lineMarkers.add((LineMarkerInfo<?>)info2);
                });
                return true;
            });
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers(lineMarkers, this.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersPass.doCollectInformation. lineMarkers: " + lineMarkers + "; merged: " + this.myMarkers);
        }
    }

    @NotNull
    private static List<LineMarkerInfo<?>> mergeLineMarkers(@NotNull List<LineMarkerInfo<?>> markers, @NotNull Document document) {
        if (markers == null) {
            LineMarkersPass.$$$reportNull$$$0(7);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(8);
        }
        Int2ObjectOpenHashMap<ArrayList<MergeableLineMarkerInfo>> sameLineMarkers = new Int2ObjectOpenHashMap<ArrayList<MergeableLineMarkerInfo>>();
        for (int i2 = markers.size() - 1; i2 >= 0; --i2) {
            LineMarkerInfo<?> marker = markers.get(i2);
            if (!(marker instanceof MergeableLineMarkerInfo)) continue;
            MergeableLineMarkerInfo mergeable = (MergeableLineMarkerInfo)marker;
            markers.remove(i2);
            int line = document.getLineNumber(marker.startOffset);
            ArrayList<MergeableLineMarkerInfo> infos = (ArrayList<MergeableLineMarkerInfo>)sameLineMarkers.get(line);
            if (infos == null) {
                infos = new ArrayList<MergeableLineMarkerInfo>();
                sameLineMarkers.put(line, infos);
            }
            infos.add(mergeable);
        }
        if (sameLineMarkers.isEmpty()) {
            List<LineMarkerInfo<?>> list2 = markers;
            if (list2 == null) {
                LineMarkersPass.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList result2 = new ArrayList(markers);
        for (List value : sameLineMarkers.values()) {
            result2.addAll(MergeableLineMarkerInfo.merge(value));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            LineMarkersPass.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<LineMarkerProvider> getMarkerProviders(@NotNull Language language, @NotNull Project project2) {
        if (language == null) {
            LineMarkersPass.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            LineMarkersPass.$$$reportNull$$$0(12);
        }
        List forLanguage = LineMarkerProviders.getInstance().allForLanguageOrAny(language);
        List providers = DumbService.getInstance(project2).filterByDumbAwareness(forLanguage);
        LineMarkerSettings settings = LineMarkerSettings.getSettings();
        List<LineMarkerProvider> list2 = ContainerUtil.filter(providers, provider2 -> !(provider2 instanceof LineMarkerProviderDescriptor) || settings.isEnabled((LineMarkerProviderDescriptor)provider2));
        if (list2 == null) {
            LineMarkersPass.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private void queryProviders(@NotNull List<? extends PsiElement> elements, @NotNull PsiFile containingFile, @NotNull List<? extends LineMarkerProvider> providers, @NotNull PairConsumer<? super PsiElement, ? super LineMarkerInfo<?>> consumer2) {
        if (elements == null) {
            LineMarkersPass.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            LineMarkersPass.$$$reportNull$$$0(15);
        }
        if (providers == null) {
            LineMarkersPass.$$$reportNull$$$0(16);
        }
        if (consumer2 == null) {
            LineMarkersPass.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myMode != Mode.SLOW) {
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                PsiElement element = elements.get(i2);
                for (int j = 0; j < providers.size(); ++j) {
                    LineMarkerInfo<?> info2;
                    ProgressManager.checkCanceled();
                    LineMarkerProvider provider2 = providers.get(j);
                    try {
                        info2 = provider2.getLineMarkerInfo(element);
                    }
                    catch (ProcessCanceledException | IndexNotReadyException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error("During querying provider " + provider2 + " (" + provider2.getClass() + ")", (Throwable)e, new Attachment(containingFile.getViewProvider().getVirtualFile().getName(), containingFile.getText()));
                        continue;
                    }
                    if (info2 == null) continue;
                    if (info2.endOffset > this.getDocument().getTextLength()) {
                        IllegalStateException exception = new IllegalStateException(provider2 + " (" + provider2.getClass() + ") generated invalid LineMarker " + info2 + " for element " + element + " (" + element.getClass() + "). document length: " + this.getDocument().getTextLength());
                        LOG.error(PluginException.createByClass(exception, provider2.getClass()));
                    }
                    consumer2.consume(element, info2);
                }
            }
        }
        if (this.myMode == Mode.FAST) {
            return;
        }
        if (InjectionUtils.shouldCollectLineMarkersForInjectedFiles(this.myFile)) {
            HashSet visitedInjectedFiles = new HashSet();
            for (int i3 = 0; i3 < elements.size(); ++i3) {
                PsiElement element = elements.get(i3);
                this.queryLineMarkersForInjected(element, containingFile, visitedInjectedFiles, consumer2);
            }
        }
        NotNullList slowLineMarkers = new NotNullList();
        for (int j = 0; j < providers.size(); ++j) {
            ProgressManager.checkCanceled();
            LineMarkerProvider provider3 = providers.get(j);
            try {
                provider3.collectSlowLineMarkers(elements, slowLineMarkers);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
                continue;
            }
            if (slowLineMarkers.isEmpty()) continue;
            for (int k = 0; k < slowLineMarkers.size(); ++k) {
                LineMarkerInfo slowInfo = (LineMarkerInfo)slowLineMarkers.get(k);
                Object element = slowInfo.getElement();
                consumer2.consume((PsiElement)element, slowInfo);
            }
            slowLineMarkers.clear();
        }
    }

    private void queryLineMarkersForInjected(@NotNull PsiElement element, @NotNull PsiFile containingFile, @NotNull Set<? super PsiFile> visitedInjectedFiles, @NotNull PairConsumer<? super PsiElement, ? super LineMarkerInfo<?>> consumer2) {
        InjectedLanguageManager manager;
        if (element == null) {
            LineMarkersPass.$$$reportNull$$$0(18);
        }
        if (containingFile == null) {
            LineMarkersPass.$$$reportNull$$$0(19);
        }
        if (visitedInjectedFiles == null) {
            LineMarkersPass.$$$reportNull$$$0(20);
        }
        if (consumer2 == null) {
            LineMarkersPass.$$$reportNull$$$0(21);
        }
        if ((manager = InjectedLanguageManager.getInstance(containingFile.getProject())).isInjectedFragment(containingFile)) {
            return;
        }
        InjectedLanguageManager.getInstance(containingFile.getProject()).enumerateEx(element, containingFile, false, (injectedPsi, places) -> {
            if (!visitedInjectedFiles.add(injectedPsi)) {
                return;
            }
            Project project2 = injectedPsi.getProject();
            Document document = PsiDocumentManager.getInstance(project2).getCachedDocument(injectedPsi);
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange(injectedPsi, 0, injectedPsi.getTextLength());
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project2);
            this.queryProviders(injElements, injectedPsi, providers, (injectedElement, injectedMarker) -> {
                GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                List<TextRange> editables = manager.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                for (TextRange editable : editables) {
                    TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, editable);
                    Icon icon2 = gutterRenderer == null ? null : gutterRenderer.getIcon();
                    GutterIconNavigationHandler navigationHandler = injectedMarker.getNavigationHandler();
                    LineMarkerInfo<PsiElement> converted = icon2 == null ? new LineMarkerInfo<PsiElement>((PsiElement)injectedElement, hostRange) : new LineMarkerInfo<PsiElement>((PsiElement)injectedElement, hostRange, icon2, e -> injectedMarker.getLineMarkerTooltip(), navigationHandler, GutterIconRenderer.Alignment.RIGHT, () -> gutterRenderer.getAccessibleName());
                    consumer2.consume((PsiElement)injectedElement, (LineMarkerInfo<?>)converted);
                }
            });
        });
    }

    @NotNull
    public static Collection<LineMarkerInfo<?>> queryLineMarkers(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            LineMarkersPass.$$$reportNull$$$0(22);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(23);
        }
        if (file2.getNode() == null) {
            List<LineMarkerInfo<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                LineMarkersPass.$$$reportNull$$$0(24);
            }
            return list2;
        }
        LineMarkersPass pass2 = new LineMarkersPass(file2.getProject(), file2, document, file2.getTextRange(), file2.getTextRange(), Mode.ALL);
        pass2.doCollectInformation(new EmptyProgressIndicator());
        List<LineMarkerInfo<?>> list3 = pass2.myMarkers;
        if (list3 == null) {
            LineMarkersPass.$$$reportNull$$$0(25);
        }
        return list3;
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            LineMarkersPass.$$$reportNull$$$0(26);
        }
        if (colorsManager == null) {
            LineMarkersPass.$$$reportNull$$$0(27);
        }
        LineMarkerInfo<PsiElement> info2 = new LineMarkerInfo<PsiElement>(startFrom, startFrom.getTextRange());
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info2.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info2.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo<PsiElement> lineMarkerInfo = info2;
        if (lineMarkerInfo == null) {
            LineMarkersPass.$$$reportNull$$$0(28);
        }
        return lineMarkerInfo;
    }

    @Override
    public String toString() {
        return super.toString() + "; myBounds: " + this.myPriorityBounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 13, 24, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityBounds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LineMarkersPass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedInjectedFiles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFrom";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LineMarkersPass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLineMarkers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkerProviders";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "queryLineMarkers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSeparatorLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeLineMarkers";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMarkerProviders";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "queryProviders";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "queryLineMarkersForInjected";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "queryLineMarkers";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSeparatorLineMarker";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 10, 13, 24, 25, 28 -> new IllegalStateException(string2);
        };
    }

    static enum Mode {
        NONE,
        FAST,
        SLOW,
        ALL;

    }
}

