/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ClientFileEditorManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Functions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class PassExecutorService
implements Disposable {
    static final Logger LOG = Logger.getInstance(PassExecutorService.class);
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses;
    private final Project myProject;
    private volatile boolean isDisposed;
    private static final Key<Throwable> THROWABLE_KEY = Key.create("THROWABLE_KEY");

    PassExecutorService(@NotNull Project project2) {
        if (project2 == null) {
            PassExecutorService.$$$reportNull$$$0(0);
        }
        this.mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
        this.myProject = project2;
    }

    private int getNextAvailablePassId() {
        return ((TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject)).getNextAvailableId();
    }

    @Override
    public void dispose() {
        this.cancelAll(true);
        ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.SECONDS);
        this.isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll(boolean waitForTermination) {
        for (Map.Entry<ScheduledPass, Job<Void>> entry : this.mySubmittedPasses.entrySet()) {
            Job<Void> job2 = entry.getValue();
            ScheduledPass pass2 = entry.getKey();
            pass2.myUpdateProgress.cancel();
            job2.cancel();
        }
        try {
            if (waitForTermination) {
                while (!this.waitFor(50)) {
                    boolean bl = false;
                }
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        finally {
            this.mySubmittedPasses.clear();
        }
    }

    void submitPasses(@NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile, @NotNull FileEditor fileEditor, HighlightingPass @NotNull [] passes, @NotNull DaemonProgressIndicator updateProgress) {
        if (document == null) {
            PassExecutorService.$$$reportNull$$$0(1);
        }
        if (virtualFile2 == null) {
            PassExecutorService.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            PassExecutorService.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(4);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(5);
        }
        if (passes == null) {
            PassExecutorService.$$$reportNull$$$0(6);
        }
        if (this.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ArrayList<TextEditorHighlightingPass> documentBoundPasses = new ArrayList<TextEditorHighlightingPass>();
        ArrayList<EditorBoundHighlightingPass> editorBoundPasses = new ArrayList<EditorBoundHighlightingPass>();
        Int2ObjectOpenHashMap<TextEditorHighlightingPass> id2Pass = new Int2ObjectOpenHashMap<TextEditorHighlightingPass>(30);
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>();
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (HighlightingPass highlightingPass : passes) {
            if (highlightingPass instanceof EditorBoundHighlightingPass) {
                EditorBoundHighlightingPass editorPass = (EditorBoundHighlightingPass)highlightingPass;
                this.assignUniqueId(editorPass, id2Pass);
                editorBoundPasses.add(editorPass);
                continue;
            }
            if (highlightingPass instanceof TextEditorHighlightingPass) {
                TextEditorHighlightingPass tePass = (TextEditorHighlightingPass)highlightingPass;
                this.assignUniqueId(tePass, id2Pass);
                documentBoundPasses.add(tePass);
                continue;
            }
            freePasses.add(new ScheduledPass(fileEditor, highlightingPass, updateProgress, threadsToStartCountdown));
        }
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>();
        Int2ObjectOpenHashMap<ScheduledPass> toBeSubmitted = new Int2ObjectOpenHashMap<ScheduledPass>();
        PassExecutorService.sortById(documentBoundPasses);
        for (TextEditorHighlightingPass textEditorHighlightingPass : documentBoundPasses) {
            this.createScheduledPass(fileEditor, document, virtualFile2, psiFile, textEditorHighlightingPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        for (EditorBoundHighlightingPass editorBoundHighlightingPass : editorBoundPasses) {
            this.createScheduledPass(fileEditor, document, virtualFile2, psiFile, editorBoundHighlightingPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        if (CHECK_CONSISTENCY && !ApplicationManagerEx.isInStressTest()) {
            this.assertConsistency(freePasses, toBeSubmitted, threadsToStartCountdown);
        }
        if (LOG.isDebugEnabled()) {
            PassExecutorService.log(updateProgress, null, virtualFile2 + " ----- starting " + threadsToStartCountdown.get(), freePasses);
        }
        for (ScheduledPass scheduledPass : dependentPasses) {
            this.mySubmittedPasses.put(scheduledPass, Job.nullJob());
        }
        for (ScheduledPass scheduledPass : freePasses) {
            this.submit(scheduledPass);
        }
    }

    private void assignUniqueId(@NotNull TextEditorHighlightingPass pass2, @NotNull Int2ObjectMap<TextEditorHighlightingPass> id2Pass) {
        int id;
        int oldId;
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(7);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(8);
        }
        if ((oldId = pass2.getId()) == -1 || oldId == 0) {
            id = this.getNextAvailablePassId();
            pass2.setId(id);
        } else {
            id = oldId;
        }
        TextEditorHighlightingPass prevPass = id2Pass.put(id, pass2);
        if (prevPass != null) {
            LOG.error("Duplicate pass id found: " + id + ". Both passes returned the same getId(): " + prevPass + " (" + prevPass.getClass() + ") and " + pass2 + " (" + pass2.getClass() + "). oldId=" + oldId);
        }
    }

    private void assertConsistency(@NotNull List<ScheduledPass> freePasses, @NotNull Int2ObjectMap<ScheduledPass> toBeSubmitted, @NotNull AtomicInteger threadsToStartCountdown) {
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(9);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(10);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(11);
        }
        assert (threadsToStartCountdown.get() == toBeSubmitted.size());
        Map<ScheduledPass, Pair<ScheduledPass, Integer>> id2Visits = CollectionFactory.createCustomHashingStrategyMap(new HashingStrategy<ScheduledPass>(){

            @Override
            public int hashCode(@Nullable ScheduledPass sp) {
                if (sp == null) {
                    return 0;
                }
                return ((TextEditorHighlightingPass)sp.myPass).getId() * 31 + sp.myFileEditor.hashCode();
            }

            @Override
            public boolean equals(@Nullable ScheduledPass sp1, @Nullable ScheduledPass sp2) {
                int id2;
                if (sp1 == null || sp2 == null) {
                    return sp1 == sp2;
                }
                int id1 = ((TextEditorHighlightingPass)sp1.myPass).getId();
                return id1 == (id2 = ((TextEditorHighlightingPass)sp2.myPass).getId()) && sp1.myFileEditor == sp2.myFileEditor;
            }
        });
        for (ScheduledPass scheduledPass : freePasses) {
            HighlightingPass pass2 = scheduledPass.myPass;
            if (!(pass2 instanceof TextEditorHighlightingPass)) continue;
            id2Visits.put(scheduledPass, Pair.create(scheduledPass, 0));
            this.checkConsistency(scheduledPass, id2Visits);
        }
        for (Map.Entry entry : id2Visits.entrySet()) {
            int count2 = (Integer)((Pair)entry.getValue()).second;
            assert (count2 == 0) : (ScheduledPass)entry.getKey();
        }
        assert (id2Visits.size() == threadsToStartCountdown.get()) : "Expected " + threadsToStartCountdown + " but got " + id2Visits.size() + ": " + id2Visits;
    }

    private void checkConsistency(@NotNull ScheduledPass pass2, Map<ScheduledPass, Pair<ScheduledPass, Integer>> id2Visits) {
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(12);
        }
        for (ScheduledPass successor : ContainerUtil.concat(pass2.mySuccessorsOnCompletion, pass2.mySuccessorsOnSubmit)) {
            Pair<ScheduledPass, Integer> pair = id2Visits.get(successor);
            if (pair == null) {
                pair = Pair.create(successor, successor.myRunningPredecessorsCount.get());
                id2Visits.put(successor, pair);
            }
            int newPred = (Integer)pair.second - 1;
            id2Visits.put(successor, Pair.create(successor, newPred));
            assert (newPred >= 0);
            if (newPred != 0) continue;
            this.checkConsistency(successor, id2Visits);
        }
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull FileEditor fileEditor, @NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile, @NotNull TextEditorHighlightingPass pass2, @NotNull Int2ObjectMap<ScheduledPass> toBeSubmitted, @NotNull Int2ObjectMap<TextEditorHighlightingPass> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        ScheduledPass predecessor;
        int passId;
        ScheduledPass scheduledPass;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(13);
        }
        if (document == null) {
            PassExecutorService.$$$reportNull$$$0(14);
        }
        if (virtualFile2 == null) {
            PassExecutorService.$$$reportNull$$$0(15);
        }
        if (psiFile == null) {
            PassExecutorService.$$$reportNull$$$0(16);
        }
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(17);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(18);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(19);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(20);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(21);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(22);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(23);
        }
        if ((scheduledPass = (ScheduledPass)toBeSubmitted.get(passId = pass2.getId())) != null) {
            ScheduledPass scheduledPass2 = scheduledPass;
            if (scheduledPass2 == null) {
                PassExecutorService.$$$reportNull$$$0(24);
            }
            return scheduledPass2;
        }
        scheduledPass = new ScheduledPass(fileEditor, pass2, updateProgress, threadsToStartCountdown);
        threadsToStartCountdown.incrementAndGet();
        toBeSubmitted.put(passId, scheduledPass);
        for (int predecessorId : pass2.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, document, virtualFile2, psiFile, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, toBeSubmitted, id2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnCompletion(scheduledPass);
        }
        for (int predecessorId : pass2.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, document, virtualFile2, psiFile, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, toBeSubmitted, id2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnSubmit(scheduledPass);
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        if (pass2.isRunIntentionPassAfter() && fileEditor instanceof TextEditor) {
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            ShowIntentionsPass ip = new ShowIntentionsPass(psiFile, editor2, false);
            this.assignUniqueId(ip, id2Pass);
            ip.setCompletionPredecessorIds(new int[]{passId});
            this.createScheduledPass(fileEditor, document, virtualFile2, psiFile, ip, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        ScheduledPass scheduledPass3 = scheduledPass;
        if (scheduledPass3 == null) {
            PassExecutorService.$$$reportNull$$$0(25);
        }
        return scheduledPass3;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull FileEditor fileEditor, @NotNull Document document, @NotNull VirtualFile virtualFile2, @NotNull PsiFile psiFile, @NotNull Int2ObjectMap<ScheduledPass> toBeSubmitted, @NotNull Int2ObjectMap<TextEditorHighlightingPass> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int predecessorId, @NotNull Int2ObjectMap<ScheduledPass> thisEditorId2ScheduledPass, @NotNull Int2ObjectMap<? extends TextEditorHighlightingPass> thisEditorId2Pass) {
        ScheduledPass predecessor;
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(26);
        }
        if (document == null) {
            PassExecutorService.$$$reportNull$$$0(27);
        }
        if (virtualFile2 == null) {
            PassExecutorService.$$$reportNull$$$0(28);
        }
        if (psiFile == null) {
            PassExecutorService.$$$reportNull$$$0(29);
        }
        if (toBeSubmitted == null) {
            PassExecutorService.$$$reportNull$$$0(30);
        }
        if (id2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(31);
        }
        if (freePasses == null) {
            PassExecutorService.$$$reportNull$$$0(32);
        }
        if (dependentPasses == null) {
            PassExecutorService.$$$reportNull$$$0(33);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(34);
        }
        if (myThreadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(35);
        }
        if (thisEditorId2ScheduledPass == null) {
            PassExecutorService.$$$reportNull$$$0(36);
        }
        if (thisEditorId2Pass == null) {
            PassExecutorService.$$$reportNull$$$0(37);
        }
        if ((predecessor = (ScheduledPass)thisEditorId2ScheduledPass.get(predecessorId)) == null) {
            TextEditorHighlightingPass textEditorPass = (TextEditorHighlightingPass)thisEditorId2Pass.get(predecessorId);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditor, document, virtualFile2, psiFile, textEditorPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown);
        }
        return predecessor;
    }

    private void submit(@NotNull ScheduledPass pass2) {
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(38);
        }
        if (!pass2.myUpdateProgress.isCanceled()) {
            Job<Void> job2 = JobLauncher.getInstance().submitToJobThread(pass2, future -> {
                try {
                    if (!future.isCancelled()) {
                        future.get();
                    }
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause());
                }
            });
            this.mySubmittedPasses.put(pass2, job2);
        }
    }

    private void applyInformationToEditorsLater(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass2, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, @NotNull Runnable callbackOnApplied) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(39);
        }
        if (pass2 == null) {
            PassExecutorService.$$$reportNull$$$0(40);
        }
        if (updateProgress == null) {
            PassExecutorService.$$$reportNull$$$0(41);
        }
        if (threadsToStartCountdown == null) {
            PassExecutorService.$$$reportNull$$$0(42);
        }
        if (callbackOnApplied == null) {
            PassExecutorService.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed() || !fileEditor.isValid()) {
                updateProgress.cancel();
            }
            if (updateProgress.isCanceled()) {
                PassExecutorService.log(updateProgress, pass2, " is canceled during apply, sorry");
                return;
            }
            try (AccessToken ignored = ClientId.withClientId(ClientFileEditorManager.getClientId((FileEditor)fileEditor));){
                if (UIUtil.isShowing(fileEditor.getComponent())) {
                    pass2.applyInformationToEditor();
                    this.repaintErrorStripeAndIcon(fileEditor);
                    if (pass2 instanceof TextEditorHighlightingPass) {
                        FileStatusMap fileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
                        Document document = ((TextEditorHighlightingPass)pass2).getDocument();
                        int passId = ((TextEditorHighlightingPass)pass2).getId();
                        fileStatusMap.markFileUpToDate(document, passId);
                    }
                    PassExecutorService.log(updateProgress, pass2, " Applied");
                }
            }
            catch (ProcessCanceledException e) {
                PassExecutorService.log(updateProgress, pass2, "Error " + e);
                throw e;
            }
            catch (RuntimeException e) {
                VirtualFile file2 = fileEditor.getFile();
                FileType fileType = file2 == null ? null : file2.getFileType();
                String message = "Exception while applying information to " + fileEditor + "(" + fileType + ")";
                PassExecutorService.log(updateProgress, pass2, message + e);
                throw new RuntimeException(message, e);
            }
            if (threadsToStartCountdown.decrementAndGet() == 0) {
                HighlightingSessionImpl.waitForAllSessionsHighlightInfosApplied(updateProgress);
                PassExecutorService.log(updateProgress, pass2, "Stopping ");
                updateProgress.stopIfRunning();
                this.clearStaleEntries();
            } else {
                PassExecutorService.log(updateProgress, pass2, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
            }
            callbackOnApplied.run();
        }, updateProgress.getModalityState(), pass2.getExpiredCondition());
    }

    private void clearStaleEntries() {
        this.mySubmittedPasses.keySet().removeIf(pass2 -> pass2.myUpdateProgress.isCanceled());
    }

    private void repaintErrorStripeAndIcon(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            PassExecutorService.$$$reportNull$$$0(44);
        }
        if (fileEditor instanceof TextEditor) {
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor2, this.myProject, PsiDocumentManager.getInstance(this.myProject).getCachedPsiFile(editor2.getDocument()));
        }
    }

    private boolean isDisposed() {
        return this.isDisposed || this.myProject.isDisposed();
    }

    @NotNull
    List<HighlightingPass> getAllSubmittedPasses() {
        List<HighlightingPass> list2 = ContainerUtil.mapNotNull(this.mySubmittedPasses.keySet(), scheduledPass -> scheduledPass.myUpdateProgress.isCanceled() ? null : scheduledPass.myPass);
        if (list2 == null) {
            PassExecutorService.$$$reportNull$$$0(45);
        }
        return list2;
    }

    private static void sortById(@NotNull List<? extends TextEditorHighlightingPass> result2) {
        if (result2 == null) {
            PassExecutorService.$$$reportNull$$$0(46);
        }
        ContainerUtil.quickSort(result2, Comparator.comparingInt(TextEditorHighlightingPass::getId));
    }

    private static int getThreadNum() {
        Matcher matcher = Pattern.compile("JobScheduler FJ pool (\\d*)/(\\d*)").matcher(Thread.currentThread().getName());
        String num = matcher.matches() ? matcher.group(1) : null;
        return StringUtil.parseInt(num, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void log(ProgressIndicator progressIndicator, HighlightingPass pass2, Object ... info2) {
        if (info2 == null) {
            PassExecutorService.$$$reportNull$$$0(47);
        }
        if (!LOG.isDebugEnabled()) return;
        Document document = pass2 instanceof TextEditorHighlightingPass ? ((TextEditorHighlightingPass)pass2).getDocument() : null;
        String docText = document == null ? "" : ": '" + StringUtil.first(document.getCharsSequence(), 10, true) + "'";
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            String infos = StringUtil.join(info2, Functions.TO_STRING(), " ");
            String message = StringUtil.repeatSymbol(' ', PassExecutorService.getThreadNum() * 4) + " " + pass2 + " " + infos + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + docText;
            LOG.debug(message);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    static void saveException(@NotNull Throwable e, @NotNull DaemonProgressIndicator indicator) {
        if (e == null) {
            PassExecutorService.$$$reportNull$$$0(48);
        }
        if (indicator == null) {
            PassExecutorService.$$$reportNull$$$0(49);
        }
        indicator.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    @TestOnly
    static Throwable getSavedException(@NotNull DaemonProgressIndicator indicator) {
        if (indicator == null) {
            PassExecutorService.$$$reportNull$$$0(50);
        }
        return indicator.getUserData(THROWABLE_KEY);
    }

    boolean waitFor(int millis) {
        long deadline = System.currentTimeMillis() + (long)millis;
        try {
            for (Job<Void> job2 : this.mySubmittedPasses.values()) {
                if (job2.waitForCompletion((int)(System.currentTimeMillis() - deadline))) continue;
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24, 25, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 13: 
            case 26: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 5: 
            case 22: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProgress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passes";
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 8: 
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id2Pass";
                break;
            }
            case 9: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freePasses";
                break;
            }
            case 10: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toBeSubmitted";
                break;
            }
            case 11: 
            case 23: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadsToStartCountdown";
                break;
            }
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPasses";
                break;
            }
            case 24: 
            case 25: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myThreadsToStartCountdown";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisEditorId2ScheduledPass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisEditorId2Pass";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackOnApplied";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createScheduledPass";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubmittedPasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "submitPasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assignUniqueId";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createScheduledPass";
                break;
            }
            case 24: 
            case 25: 
            case 45: {
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreatePredecessorPass";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "applyInformationToEditorsLater";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripeAndIcon";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sortById";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "saveException";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSavedException";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 24, 25, 45 -> new IllegalStateException(string2);
        };
    }

    private final class ScheduledPass
    implements Runnable {
        private final FileEditor myFileEditor;
        private final HighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final AtomicInteger myRunningPredecessorsCount;
        private final List<ScheduledPass> mySuccessorsOnCompletion;
        private final List<ScheduledPass> mySuccessorsOnSubmit;
        @NotNull
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass2, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown) {
            if (fileEditor == null) {
                ScheduledPass.$$$reportNull$$$0(0);
            }
            if (pass2 == null) {
                ScheduledPass.$$$reportNull$$$0(1);
            }
            if (progressIndicator == null) {
                ScheduledPass.$$$reportNull$$$0(2);
            }
            if (threadsToStartCountdown == null) {
                ScheduledPass.$$$reportNull$$$0(3);
            }
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditor = fileEditor;
            this.myPass = pass2;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> {
                try {
                    this.doRun();
                }
                catch (ApplicationUtil.CannotRunReadActionException e) {
                    this.myUpdateProgress.cancel();
                }
                catch (Error | RuntimeException e) {
                    PassExecutorService.saveException(e, this.myUpdateProgress);
                    throw e;
                }
            });
        }

        private void doRun() {
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    block11: {
                        try {
                            if (DumbService.getInstance(PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware(this.myPass)) {
                                return;
                            }
                            if (this.myUpdateProgress.isCanceled() || PassExecutorService.this.myProject.isDisposed()) break block11;
                            try (AccessToken ignored = ClientId.withClientId(ClientFileEditorManager.getClientId((FileEditor)this.myFileEditor));){
                                this.myPass.collectInformation((ProgressIndicator)this.myUpdateProgress);
                            }
                        }
                        catch (ProcessCanceledException e) {
                            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Canceled ");
                            if (!this.myUpdateProgress.isCanceled()) {
                                this.myUpdateProgress.cancel(e);
                            }
                        }
                        catch (Error | RuntimeException e) {
                            this.myUpdateProgress.cancel(e);
                            LOG.error(e);
                            throw e;
                        }
                    }
                });
                if (!success) {
                    this.myUpdateProgress.cancel();
                }
            }, this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditor, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown, () -> {
                    for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                        int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                        if (predecessorsToRun != 0) continue;
                        PassExecutorService.this.submit(successor);
                    }
                });
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }

        private void addSuccessorOnCompletion(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(4);
            }
            this.mySuccessorsOnCompletion.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private void addSuccessorOnSubmit(@NotNull ScheduledPass successor) {
            if (successor == null) {
                ScheduledPass.$$$reportNull$$$0(5);
            }
            this.mySuccessorsOnSubmit.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadsToStartCountdown";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "successor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnCompletion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSuccessorOnSubmit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

