/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressableTextEditorHighlightingPass
extends TextEditorHighlightingPass {
    private volatile boolean myFinished;
    private volatile long myProgressLimit;
    private final AtomicLong myProgressCount;
    private final AtomicLong myNextChunkThreshold;
    @NotNull
    @Nls
    private final String myPresentableName;
    protected final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    final TextRange myRestrictRange;
    @NotNull
    final HighlightInfoProcessor myHighlightInfoProcessor;
    HighlightingSession myHighlightingSession;

    protected ProgressableTextEditorHighlightingPass(@NotNull Project project2, @NotNull Document document, @NotNull @Nls String presentableName, @Nullable PsiFile file2, @Nullable Editor editor2, @NotNull TextRange restrictRange, boolean runIntentionPassAfter, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project2 == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(3);
        }
        if (highlightInfoProcessor == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(4);
        }
        super(project2, document, runIntentionPassAfter);
        this.myProgressCount = new AtomicLong();
        this.myNextChunkThreshold = new AtomicLong();
        this.myPresentableName = presentableName;
        this.myFile = file2;
        this.myEditor = editor2;
        this.myRestrictRange = restrictRange;
        this.myHighlightInfoProcessor = highlightInfoProcessor;
        if (file2 != null) {
            if (file2.getProject() != project2) {
                throw new IllegalArgumentException("File '" + file2 + "' (" + file2.getClass() + ") is from an alien project (" + file2.getProject() + ") but expected: " + project2);
            }
            if (InjectedLanguageManager.getInstance(project2).isInjectedFragment(file2)) {
                throw new IllegalArgumentException("File '" + file2 + "' (" + file2.getClass() + ") is an injected fragment but expected top-level");
            }
        }
        if (editor2 != null) {
            if (editor2.getProject() != null && editor2.getProject() != project2) {
                throw new IllegalArgumentException("Editor '" + editor2 + "' (" + editor2.getClass() + ") belongs to an alien project '" + editor2.getProject() + "' but expected: '" + project2 + "'");
            }
            if (editor2.getDocument() != document) {
                throw new IllegalArgumentException("Editor '" + editor2 + "' (" + editor2.getClass() + ") has document " + editor2.getDocument() + " but expected: " + document);
            }
        }
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && (this.myFile == null || this.myFile.isValid());
    }

    private void sessionFinished() {
        this.advanceProgress(Math.max(1L, this.myProgressLimit - this.myProgressCount.get()));
    }

    @Override
    public final void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ProgressableTextEditorHighlightingPass.$$$reportNull$$$0(5);
        }
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        this.myFinished = false;
        if (this.myFile != null) {
            this.myHighlightingSession = HighlightingSessionImpl.getFromCurrentIndicator(this.myFile);
        }
        try {
            this.collectInformationWithProgress(progress);
        }
        finally {
            if (this.myFile != null) {
                this.sessionFinished();
            }
        }
    }

    protected abstract void collectInformationWithProgress(@NotNull ProgressIndicator var1);

    @Override
    public final void doApplyInformationToEditor() {
        this.myFinished = true;
        this.applyInformationWithProgress();
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
    }

    protected abstract void applyInformationWithProgress();

    public double getProgress() {
        long progressLimit = this.getProgressLimit();
        if (progressLimit == 0L) {
            return -1.0;
        }
        long progressCount = this.getProgressCount();
        return progressCount > progressLimit ? 1.0 : (double)progressCount / (double)progressLimit;
    }

    private long getProgressLimit() {
        return this.myProgressLimit;
    }

    private long getProgressCount() {
        return this.myProgressCount.get();
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    @Nullable(value="null means do not show progress")
    @Nls
    protected @Nullable(value="null means do not show progress") @Nls String getPresentableName() {
        return this.myPresentableName;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    public void setProgressLimit(long limit2) {
        this.myProgressLimit = limit2;
        this.myNextChunkThreshold.set(Math.max(1L, limit2 / 100L));
    }

    public void advanceProgress(long delta) {
        long current;
        if (this.myHighlightingSession != null && (current = this.myProgressCount.addAndGet(delta)) >= this.myNextChunkThreshold.get() && current >= this.myNextChunkThreshold.updateAndGet(old -> current >= old ? old + Math.max(1L, this.myProgressLimit / 100L) : old)) {
            this.myHighlightInfoProcessor.progressIsAdvanced(this.myHighlightingSession, this.getEditor(), this.getProgress());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class EmptyPass
    extends TextEditorHighlightingPass {
        EmptyPass(@NotNull Project project2, @NotNull Document document) {
            if (project2 == null) {
                EmptyPass.$$$reportNull$$$0(0);
            }
            if (document == null) {
                EmptyPass.$$$reportNull$$$0(1);
            }
            super(project2, document, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                EmptyPass.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            FileStatusMap statusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
            statusMap.markFileUpToDate(this.getDocument(), this.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass$EmptyPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

