/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ProjectDisposeAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.util.SmartList;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiChangeHandler
extends PsiTreeChangeAdapter {
    private static final ExtensionPointName<ChangeLocalityDetector> EP_NAME = new ExtensionPointName("com.intellij.daemon.changeLocalityDetector");
    private final Key<Boolean> UPDATE_ON_COMMIT_ENGAGED;
    private final Project myProject;
    private final Map<Document, List<Pair<PsiElement, Boolean>>> changedElements;
    private final FileStatusMap myFileStatusMap;

    PsiChangeHandler(@NotNull Project project2, @NotNull SimpleMessageBusConnection connection, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            PsiChangeHandler.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            PsiChangeHandler.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            PsiChangeHandler.$$$reportNull$$$0(2);
        }
        this.UPDATE_ON_COMMIT_ENGAGED = Key.create("UPDATE_ON_COMMIT_ENGAGED");
        this.changedElements = new WeakHashMap<Document, List<Pair<PsiElement, Boolean>>>();
        this.myProject = project2;
        this.myFileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(ProjectDisposeAwareDocumentListener.create((Project)project2, (DocumentListener)new DocumentListener(){

            @Override
            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document = event.getDocument();
                PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance(PsiChangeHandler.this.myProject);
                if (documentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                PsiFile psi = documentManager.getCachedPsiFile(document);
                if (psi == null || !psi.getViewProvider().isEventSystemEnabled()) {
                    return;
                }
                if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) == null) {
                    document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, Boolean.TRUE);
                    documentManager.addRunOnCommit(document, () -> {
                        if (document.getUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED) != null) {
                            PsiChangeHandler.this.updateChangesForDocument(document);
                            document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$1", "beforeDocumentChange"));
            }
        }), parentDisposable);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file2) {
                if (document == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                PsiChangeHandler.this.updateChangesForDocument(document);
                document.putUserData(PsiChangeHandler.this.UPDATE_ON_COMMIT_ENGAGED, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiChangeHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateChangesForDocument(@NotNull Document document) {
        if (document == null) {
            PsiChangeHandler.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        if (this.myProject.isDisposed()) {
            return;
        }
        List<Pair<PsiElement, Boolean>> toUpdate = this.changedElements.get(document);
        if (toUpdate == null) {
            if (UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document)) {
                return;
            }
            PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getCachedPsiFile(document);
            if (file2 == null) {
                return;
            }
            toUpdate = Collections.singletonList(Pair.create(file2, true));
        }
        Application application = ApplicationManager.getApplication();
        Editor editor2 = FileEditorManager.getInstance(this.myProject).getSelectedTextEditor();
        if (editor2 != null && !application.isUnitTestMode()) {
            application.invokeLater(() -> {
                if (!editor2.isDisposed()) {
                    EditorMarkupModel markupModel = (EditorMarkupModel)editor2.getMarkupModel();
                    PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(editor2.getDocument());
                    ErrorStripeUpdateManager.getInstance(this.myProject).setOrRefreshErrorStripeRenderer(markupModel, file2);
                }
            }, ModalityState.stateForComponent(editor2.getComponent()), this.myProject.getDisposed());
        }
        for (Pair<PsiElement, Boolean> changedElement : toUpdate) {
            PsiElement element = changedElement.getFirst();
            Boolean whiteSpaceOptimizationAllowed = changedElement.getSecond();
            this.updateByChange(element, document, whiteSpaceOptimizationAllowed);
        }
        this.changedElements.remove(document);
    }

    @Override
    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(4);
        }
        this.queueElement(event.getParent(), true, event);
    }

    @Override
    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(5);
        }
        this.queueElement(event.getParent(), true, event);
    }

    @Override
    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(6);
        }
        this.queueElement(event.getNewChild(), PsiChangeHandler.typesEqual(event.getNewChild(), event.getOldChild()), event);
    }

    private static boolean typesEqual(PsiElement newChild, PsiElement oldChild) {
        return newChild != null && oldChild != null && newChild.getClass() == oldChild.getClass();
    }

    @Override
    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(7);
        }
        if (((PsiTreeChangeEventImpl)event).isGenericChange()) {
            return;
        }
        this.queueElement(event.getParent(), true, event);
    }

    @Override
    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(8);
        }
        this.queueElement(event.getOldParent(), true, event);
        this.queueElement(event.getNewParent(), true, event);
    }

    @Override
    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(9);
        }
        if ((psiFile = event.getFile()) != null) {
            this.myFileStatusMap.markFileScopeDirtyDefensively(psiFile, event);
        }
    }

    @Override
    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        String propertyName;
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(10);
        }
        if (!(propertyName = event.getPropertyName()).equals("writable")) {
            Object oldValue = event.getOldValue();
            if (oldValue instanceof VirtualFile && this.shouldBeIgnored((VirtualFile)oldValue)) {
                return;
            }
            this.myFileStatusMap.markAllFilesDirty(event);
        }
    }

    private void queueElement(@NotNull PsiElement child, boolean whitespaceOptimizationAllowed, @NotNull PsiTreeChangeEvent event) {
        if (child == null) {
            PsiChangeHandler.$$$reportNull$$$0(11);
        }
        if (event == null) {
            PsiChangeHandler.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        PsiFile file2 = event.getFile();
        if (file2 == null) {
            file2 = child.getContainingFile();
        }
        if (file2 == null) {
            this.myFileStatusMap.markAllFilesDirty(child);
            return;
        }
        if (!child.isValid()) {
            return;
        }
        PsiDocumentManagerImpl pdm = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance(this.myProject);
        Document document = pdm.getCachedDocument(file2);
        if (document != null) {
            if (pdm.getSynchronizer().getTransaction(document) == null) {
                this.myFileStatusMap.markAllFilesDirty(child);
                return;
            }
            List<Pair<PsiElement, Boolean>> toUpdate = this.changedElements.get(document);
            if (toUpdate == null) {
                toUpdate = new SmartList<Pair<PsiElement, Boolean>>();
                this.changedElements.put(document, toUpdate);
            }
            toUpdate.add(Pair.create(child, whitespaceOptimizationAllowed));
        }
    }

    private void updateByChange(@NotNull PsiElement child, @NotNull Document document, boolean whitespaceOptimizationAllowed) {
        PsiElement element;
        PsiFile file2;
        if (child == null) {
            PsiChangeHandler.$$$reportNull$$$0(13);
        }
        if (document == null) {
            PsiChangeHandler.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        try {
            file2 = child.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            this.myFileStatusMap.markAllFilesDirty(e);
            return;
        }
        if (file2 == null || file2 instanceof PsiCompiledElement) {
            this.myFileStatusMap.markAllFilesDirty(child);
            return;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 != null && this.shouldBeIgnored(virtualFile2)) {
            return;
        }
        int fileLength = file2.getTextLength();
        if (!file2.getViewProvider().isPhysical()) {
            this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, fileLength), fileLength, "Non-physical file update: " + file2);
            return;
        }
        TextRange existingDirtyScope = this.myFileStatusMap.getFileDirtyScopeForAllPassesCombined(document);
        PsiElement psiElement = element = whitespaceOptimizationAllowed && UpdateHighlightersUtil.isWhitespaceOptimizationAllowed(document) ? child : child.getParent();
        while (true) {
            if (element == null || element instanceof PsiFile || element instanceof PsiDirectory) {
                this.myFileStatusMap.markAllFilesDirty("Top element: " + element);
                return;
            }
            PsiElement scope = PsiChangeHandler.getChangeHighlightingScope(element);
            if (scope != null) {
                TextRange scopeRange = scope.getTextRange();
                if (existingDirtyScope == null || scopeRange.contains(existingDirtyScope)) {
                    this.myFileStatusMap.markFileScopeDirty(document, scopeRange, fileLength, "Scope: " + scope);
                    return;
                }
                existingDirtyScope = existingDirtyScope.union(scopeRange);
            }
            element = element.getParent();
        }
    }

    private boolean shouldBeIgnored(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiChangeHandler.$$$reportNull$$$0(15);
        }
        return ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile2) || ProjectRootManager.getInstance(this.myProject).getFileIndex().isExcluded(virtualFile2);
    }

    @Nullable
    private static PsiElement getChangeHighlightingScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiChangeHandler.$$$reportNull$$$0(16);
        }
        DefaultChangeLocalityDetector defaultDetector = null;
        for (ChangeLocalityDetector detector : EP_NAME.getExtensionList()) {
            if (detector instanceof DefaultChangeLocalityDetector) {
                assert (defaultDetector == null) : defaultDetector;
                defaultDetector = (DefaultChangeLocalityDetector)detector;
                continue;
            }
            PsiElement scope = detector.getChangeHighlightingDirtyScopeFor(element);
            if (scope == null) continue;
            return scope;
        }
        assert (defaultDetector != null) : "com.intellij.codeInsight.daemon.impl.DefaultChangeLocalityDetector is unregistered";
        return defaultDetector.getChangeHighlightingDirtyScopeFor(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiChangeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateChangesForDocument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildMovement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildrenChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "queueElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateByChange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeIgnored";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangeHighlightingScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

