/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.find.FindUtil;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementListNavigator {
    private PsiElementListNavigator() {
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull MouseEvent e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer) {
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(0);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(1);
        }
        PsiElementListNavigator.openTargets((MouseEvent)e, targets2, (String)title, (String)findUsagesTitle, listRenderer, null);
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull MouseEvent e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2;
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(2);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(3);
        }
        if ((popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask)) != null) {
            RelativePoint point = new RelativePoint(e);
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.show(point), listUpdaterTask);
            } else {
                popup2.show(point);
            }
        }
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull Editor e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer) {
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(4);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(5);
        }
        PsiElementListNavigator.openTargets((Editor)e, targets2, (String)title, (String)findUsagesTitle, listRenderer, null);
    }

    public static <T extends NavigatablePsiElement> void openTargets(@NotNull Editor e, T @NotNull [] targets2, @NlsContexts.PopupTitle String title, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2;
        if (e == null) {
            PsiElementListNavigator.$$$reportNull$$$0(6);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(7);
        }
        if ((popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask)) != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.showInBestPositionFor(e), listUpdaterTask);
            } else {
                popup2.showInBestPositionFor(e);
            }
        }
    }

    private static void runActionAndListUpdaterTask(@NotNull Runnable action2, @NotNull BackgroundUpdaterTask listUpdaterTask) {
        if (action2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(8);
        }
        if (listUpdaterTask == null) {
            PsiElementListNavigator.$$$reportNull$$$0(9);
        }
        action2.run();
        ProgressManager.getInstance().run(listUpdaterTask);
    }

    @Nullable
    public static <T extends NavigatablePsiElement> JBPopup navigateOrCreatePopup(T @NotNull [] targets2, @NlsContexts.PopupTitle String title, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(10);
        }
        return PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask, (T selectedElements) -> {
            for (NavigatablePsiElement selected : selectedElements) {
                if (!selected.isValid()) continue;
                selected.navigate(true);
            }
        });
    }

    @Nullable
    public static <T extends NavigatablePsiElement> JBPopup navigateOrCreatePopup(T @NotNull [] targets2, @NlsContexts.PopupTitle String title, @NlsContexts.TabTitle String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask, @NotNull Consumer<? super T[]> consumer2) {
        if (consumer2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(11);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(12);
        }
        return new NavigateOrPopupHelper(targets2, title).setFindUsagesTitle(findUsagesTitle).setListRenderer(listRenderer).setListUpdaterTask(listUpdaterTask).setTargetsConsumer(consumer2).navigateOrCreatePopup();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listUpdaterTask";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openTargets";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runActionAndListUpdaterTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateOrCreatePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NavigateOrPopupHelper<T extends NavigatablePsiElement> {
        private final T @NotNull [] myTargets;
        private final @NlsContexts.PopupTitle String myTitle;
        private Consumer<? super T[]> myTargetsConsumer;
        @Nullable
        @NlsContexts.TabTitle
        private String myFindUsagesTitle;
        @Nullable
        private ListCellRenderer<? super T> myListRenderer;
        @Nullable
        private BackgroundUpdaterTask myListUpdaterTask;
        @Nullable
        private Project myProject;

        public NavigateOrPopupHelper(T @NotNull [] targets2, @NlsContexts.PopupTitle String title) {
            if (targets2 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(0);
            }
            this.myTargets = targets2;
            this.myTitle = title;
            this.myTargetsConsumer = selectedElements -> {
                for (NavigatablePsiElement element : selectedElements) {
                    if (!element.isValid()) continue;
                    element.navigate(true);
                }
            };
        }

        @NotNull
        public NavigateOrPopupHelper<T> setFindUsagesTitle(@Nullable @NlsContexts.TabTitle String findUsagesTitle) {
            this.myFindUsagesTitle = findUsagesTitle;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(1);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setListRenderer(@Nullable ListCellRenderer<? super T> listRenderer) {
            this.myListRenderer = listRenderer;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(2);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setListUpdaterTask(@Nullable BackgroundUpdaterTask listUpdaterTask) {
            this.myListUpdaterTask = listUpdaterTask;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(3);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setTargetsConsumer(@NotNull Consumer<? super T[]> targetsConsumer) {
            if (targetsConsumer == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(4);
            }
            this.myTargetsConsumer = targetsConsumer;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(5);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper<T> setProject(@Nullable Project project2) {
            this.myProject = project2;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(6);
            }
            return navigateOrPopupHelper;
        }

        @Nullable
        public final JBPopup navigateOrCreatePopup() {
            if (this.myTargets.length == 0) {
                if (!this.allowEmptyTargets()) {
                    return null;
                }
                if (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished()) {
                    return null;
                }
            }
            if (this.myTargets.length == 1 && (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished())) {
                this.myTargetsConsumer.consume((T[])this.myTargets);
                return null;
            }
            List<T> initialTargetsList = Arrays.asList(this.myTargets);
            final Ref<T[]> updatedTargetsList = Ref.create(this.myTargets);
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(initialTargetsList);
            this.afterPopupBuilderCreated(builder2);
            ListCellRenderer<? super T> listCellRenderer = this.myListRenderer;
            if (listCellRenderer instanceof PsiElementListCellRenderer) {
                PsiElementListCellRenderer psiElementListCellRenderer = (PsiElementListCellRenderer)listCellRenderer;
                psiElementListCellRenderer.installSpeedSearch(builder2, true);
                psiElementListCellRenderer.setUsedInPopup(true);
            }
            IPopupChooserBuilder popupChooserBuilder = builder2.setTitle(this.myTitle).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer(this.myListRenderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(elements -> this.myTargetsConsumer.consume((T[])elements.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY))).setCancelCallback(() -> {
                if (this.myListUpdaterTask != null) {
                    this.myListUpdaterTask.cancelTask();
                }
                return true;
            });
            Ref usageView = new Ref();
            if (this.myFindUsagesTitle != null) {
                popupChooserBuilder = popupChooserBuilder.setCouldPin(popup2 -> {
                    usageView.set(FindUtil.showInUsageView(null, (PsiElement[])updatedTargetsList.get(), this.myFindUsagesTitle, this.getProject()));
                    popup2.cancel();
                    return false;
                });
            }
            JBPopup popup3 = popupChooserBuilder.createPopup();
            if (builder2 instanceof PopupChooserBuilder) {
                PopupChooserBuilder castedBuilder = (PopupChooserBuilder)builder2;
                final JBList list2 = (JBList)castedBuilder.getChooserComponent();
                list2.setTransferHandler(new TransferHandler(){

                    @Override
                    protected Transferable createTransferable(JComponent c2) {
                        Object[] selectedValues = list2.getSelectedValues();
                        PsiElement[] copy2 = new PsiElement[selectedValues.length];
                        for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                            copy2[i2] = (PsiElement)selectedValues[i2];
                        }
                        return PsiCopyPasteManager.newTransferable(copy2);
                    }

                    @Override
                    public int getSourceActions(JComponent c2) {
                        return 1;
                    }
                });
                JScrollPane pane = castedBuilder.getScrollPane();
                if (ExperimentalUI.isNewUI()) {
                    list2.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
                } else {
                    pane.setBorder(null);
                }
                pane.setViewportBorder(null);
            }
            if (this.myListUpdaterTask != null) {
                final GenericListComponentUpdater popupUpdater = builder2.getBackgroundUpdater();
                this.myListUpdaterTask.init(popup3, new GenericListComponentUpdater<PsiElement>(){

                    public void replaceModel(@NotNull List<? extends PsiElement> data2) {
                        if (data2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        NavigatablePsiElement[] array = data2.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
                        updatedTargetsList.set(array);
                        popupUpdater.replaceModel(Arrays.asList(array));
                    }

                    public void paintBusy(boolean paintBusy) {
                        popupUpdater.paintBusy(paintBusy);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper$2", "replaceModel"));
                    }
                }, usageView);
            }
            return popup3;
        }

        @NotNull
        private Project getProject() {
            if (this.myProject != null) {
                Project project2 = this.myProject;
                if (project2 == null) {
                    NavigateOrPopupHelper.$$$reportNull$$$0(7);
                }
                return project2;
            }
            assert (!this.allowEmptyTargets()) : "Project was not set and cannot be taken from targets";
            Project project3 = this.myTargets[0].getProject();
            if (project3 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(8);
            }
            return project3;
        }

        protected boolean allowEmptyTargets() {
            return false;
        }

        protected void afterPopupBuilderCreated(@NotNull IPopupChooserBuilder<T> builder2) {
            if (builder2 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetsConsumer";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFindUsagesTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setListRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setListUpdaterTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTargetsConsumer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setProject";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTargetsConsumer";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "afterPopupBuilderCreated";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2, 3, 5, 6, 7, 8 -> new IllegalStateException(string2);
            };
        }
    }
}

