/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SeverityRegistrar
implements Comparator<HighlightSeverity>,
ModificationTracker {
    static final int SHOWN_SEVERITIES_OFFSET = 2;
    private static final Logger LOG = Logger.getInstance(SeverityRegistrar.class);
    private static final Topic<Runnable> STANDARD_SEVERITIES_CHANGED_TOPIC = new Topic<Runnable>("standard severities changed", Runnable.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    @NonNls
    private static final String INFO_TAG = "info";
    @NonNls
    private static final String COLOR_ATTRIBUTE = "color";
    private final Map<String, SeverityBasedTextAttributes> myMap;
    private final Map<String, Color> myRendererColors;
    static final Topic<Runnable> SEVERITIES_CHANGED_TOPIC = new Topic<Runnable>("severities changed", Runnable.class, Topic.BroadcastDirection.TO_PARENT);
    @NotNull
    private final MessageBus myMessageBus;
    private final AtomicReference<Object2IntMap<HighlightSeverity>> orderMap;
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDARD_SEVERITIES;
    private final SimpleModificationTracker myModificationTracker;

    public SeverityRegistrar(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            SeverityRegistrar.$$$reportNull$$$0(0);
        }
        this.myMap = new ConcurrentHashMap<String, SeverityBasedTextAttributes>();
        this.myRendererColors = new ConcurrentHashMap<String, Color>();
        this.orderMap = new AtomicReference();
        this.myModificationTracker = new SimpleModificationTracker();
        this.myMessageBus = messageBus;
        messageBus.simpleConnect().subscribe(STANDARD_SEVERITIES_CHANGED_TOPIC, () -> this.orderMap.set(null));
    }

    public static void registerStandard(@NotNull HighlightInfoType highlightInfoType, @NotNull HighlightSeverity highlightSeverity) {
        if (highlightInfoType == null) {
            SeverityRegistrar.$$$reportNull$$$0(1);
        }
        if (highlightSeverity == null) {
            SeverityRegistrar.$$$reportNull$$$0(2);
        }
        STANDARD_SEVERITIES.put(highlightSeverity.getName(), highlightInfoType);
        ApplicationManager.getApplication().getMessageBus().syncPublisher(STANDARD_SEVERITIES_CHANGED_TOPIC).run();
    }

    public static void registerStandard(@NotNull Map<String, ? extends HighlightInfoType> map2) {
        if (map2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(3);
        }
        STANDARD_SEVERITIES.putAll(map2);
        ApplicationManager.getApplication().getMessageBus().syncPublisher(STANDARD_SEVERITIES_CHANGED_TOPIC).run();
    }

    @NotNull
    public static SeverityRegistrar getSeverityRegistrar(@Nullable Project project2) {
        SeverityRegistrar severityRegistrar = project2 == null ? InspectionProfileManager.getInstance().getSeverityRegistrar() : InspectionProfileManager.getInstance(project2).getCurrentProfile().getProfileManager().getSeverityRegistrar();
        if (severityRegistrar == null) {
            SeverityRegistrar.$$$reportNull$$$0(4);
        }
        return severityRegistrar;
    }

    @Override
    public long getModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    public void registerSeverity(@NotNull SeverityBasedTextAttributes info2, @Nullable Color renderColor) {
        if (info2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(5);
        }
        HighlightSeverity severity = info2.getType().getSeverity(null);
        this.myMap.put(severity.getName(), info2);
        if (renderColor != null) {
            this.myRendererColors.put(severity.getName(), renderColor);
        }
        this.orderMap.set(null);
        HighlightDisplayLevel.registerSeverity(severity, this.getHighlightInfoTypeBySeverity(severity).getAttributesKey(), null);
        this.severitiesChanged();
    }

    private void severitiesChanged() {
        this.myModificationTracker.incModificationCount();
        this.myMessageBus.syncPublisher(SEVERITIES_CHANGED_TOPIC).run();
    }

    public SeverityBasedTextAttributes unregisterSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(6);
        }
        this.severitiesChanged();
        return this.myMap.remove(severity.getName());
    }

    @NotNull
    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(@NotNull HighlightSeverity severity) {
        HighlightInfoType infoType;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(7);
        }
        if ((infoType = STANDARD_SEVERITIES.get(severity.getName())) != null) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)infoType;
            if (highlightInfoTypeImpl == null) {
                SeverityRegistrar.$$$reportNull$$$0(8);
            }
            return highlightInfoTypeImpl;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
            if (highlightInfoTypeImpl == null) {
                SeverityRegistrar.$$$reportNull$$$0(9);
            }
            return highlightInfoTypeImpl;
        }
        SeverityBasedTextAttributes type = this.getAttributesBySeverity(severity);
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)(type == null ? HighlightInfoType.WARNING : type.getType());
        if (highlightInfoTypeImpl == null) {
            SeverityRegistrar.$$$reportNull$$$0(10);
        }
        return highlightInfoTypeImpl;
    }

    private SeverityBasedTextAttributes getAttributesBySeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(11);
        }
        return this.myMap.get(severity.getName());
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(@NotNull HighlightSeverity severity) {
        SeverityBasedTextAttributes infoType;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(12);
        }
        if ((infoType = this.getAttributesBySeverity(severity)) != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    @Nullable
    public TextAttributes getCustomSeverityTextAttributes(@NotNull TextAttributesKey key) {
        SeverityBasedTextAttributes attributes;
        if (key == null) {
            SeverityRegistrar.$$$reportNull$$$0(13);
        }
        return (attributes = this.myMap.get(key.getExternalName())) != null ? attributes.getAttributes() : null;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            SeverityRegistrar.$$$reportNull$$$0(14);
        }
        this.myMap.clear();
        this.myRendererColors.clear();
        for (Element infoElement : element.getChildren(INFO_TAG)) {
            SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes(infoElement);
            String colorStr = infoElement.getAttributeValue(COLOR_ATTRIBUTE);
            Color color = colorStr == null ? null : new Color(Integer.parseInt(colorStr, 16));
            this.registerSeverity(highlightInfo, color);
        }
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.readExternal(element);
        ArrayList<HighlightSeverity> read = new ArrayList<HighlightSeverity>(this.myReadOrder.size());
        List<HighlightSeverity> knownSeverities = this.getDefaultOrder();
        for (String name : this.myReadOrder) {
            HighlightSeverity severity = this.getSeverity(name);
            if (severity == null || !knownSeverities.contains(severity)) continue;
            read.add(severity);
        }
        this.orderMap.set(this.ensureAllStandardIncluded(read, knownSeverities));
        this.severitiesChanged();
    }

    @NotNull
    private Object2IntMap<HighlightSeverity> ensureAllStandardIncluded(@NotNull List<? extends HighlightSeverity> read, @NotNull List<HighlightSeverity> knownSeverities) {
        Object2IntMap<HighlightSeverity> orderMap;
        if (read == null) {
            SeverityRegistrar.$$$reportNull$$$0(15);
        }
        if (knownSeverities == null) {
            SeverityRegistrar.$$$reportNull$$$0(16);
        }
        if ((orderMap = SeverityRegistrar.fromList(read)).isEmpty()) {
            return SeverityRegistrar.fromList(knownSeverities);
        }
        List<HighlightSeverity> list2 = SeverityRegistrar.getSortedSeverities(orderMap);
        block0: for (HighlightSeverity stdSeverity : knownSeverities) {
            if (list2.contains(stdSeverity)) continue;
            for (int oIdx = 0; oIdx < list2.size(); ++oIdx) {
                HighlightSeverity orderSeverity = list2.get(oIdx);
                if (orderSeverity.myVal <= stdSeverity.myVal) continue;
                list2.add(oIdx, stdSeverity);
                this.myReadOrder = null;
                continue block0;
            }
        }
        return SeverityRegistrar.fromList(list2);
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            SeverityRegistrar.$$$reportNull$$$0(17);
        }
        List<HighlightSeverity> list2 = this.getAllSeverities();
        for (HighlightSeverity severity : list2) {
            Element info2 = new Element(INFO_TAG);
            String severityName = severity.getName();
            SeverityBasedTextAttributes severityBasedTextAttributes = this.getAttributesBySeverity(severity);
            if (severityBasedTextAttributes == null) continue;
            severityBasedTextAttributes.writeExternal(info2);
            Color color = this.myRendererColors.get(severityName);
            if (color != null) {
                info2.setAttribute(COLOR_ATTRIBUTE, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element.addContent(info2);
        }
        JDOMExternalizableStringList readOrder = this.myReadOrder;
        if (readOrder != null && !readOrder.isEmpty()) {
            readOrder.writeExternal(element);
        } else if (!this.getDefaultOrder().equals(list2)) {
            Object2IntMap<HighlightSeverity> orderMap = this.getOrderMap();
            JDOMExternalizableStringList ext = new JDOMExternalizableStringList((Collection<String>)Collections.nCopies(orderMap.size(), ""));
            for (Object2IntMap.Entry entry : this.getOrderMap().object2IntEntrySet()) {
                ext.set(entry.getIntValue(), ((HighlightSeverity)entry.getKey()).getName());
            }
            ext.writeExternal(element);
        }
    }

    @NotNull
    public List<HighlightSeverity> getAllSeverities() {
        return SeverityRegistrar.getSortedSeverities(this.getOrderMap());
    }

    @NotNull
    private static List<HighlightSeverity> getSortedSeverities(@NotNull Object2IntMap<HighlightSeverity> map2) {
        if (map2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(18);
        }
        ArrayList<HighlightSeverity> list2 = new ArrayList<HighlightSeverity>(map2.keySet());
        list2.sort((o1, o2) -> SeverityRegistrar.compare(o1, o2, map2));
        ArrayList<HighlightSeverity> arrayList = list2;
        if (arrayList == null) {
            SeverityRegistrar.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    int getSeveritiesCount() {
        return STANDARD_SEVERITIES.size() + this.myMap.size();
    }

    @Nullable
    public HighlightSeverity getSeverityByIndex(int index2) {
        for (Object2IntMap.Entry entry : this.getOrderMap().object2IntEntrySet()) {
            if (entry.getIntValue() != index2) continue;
            return (HighlightSeverity)entry.getKey();
        }
        return null;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull String name) {
        HighlightInfoType type;
        if (name == null) {
            SeverityRegistrar.$$$reportNull$$$0(20);
        }
        if ((type = STANDARD_SEVERITIES.get(name)) != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.myMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    @NotNull
    Icon getRendererIconBySeverity(@NotNull HighlightSeverity severity, boolean defaultIcon) {
        HighlightDisplayLevel level;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(21);
        }
        if ((level = HighlightDisplayLevel.find(severity)) != null) {
            Icon icon2 = defaultIcon ? level.getIcon() : level.getOutlineIcon();
            if (icon2 == null) {
                SeverityRegistrar.$$$reportNull$$$0(22);
            }
            return icon2;
        }
        Icon icon3 = HighlightDisplayLevel.createIconByMask(this.myRendererColors.get(severity.getName()));
        if (icon3 == null) {
            SeverityRegistrar.$$$reportNull$$$0(23);
        }
        return icon3;
    }

    public boolean isSeverityValid(@NotNull String severityName) {
        if (severityName == null) {
            SeverityRegistrar.$$$reportNull$$$0(24);
        }
        return STANDARD_SEVERITIES.containsKey(severityName) || this.myMap.containsKey(severityName);
    }

    @Override
    public int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2) {
        if (s1 == null) {
            SeverityRegistrar.$$$reportNull$$$0(25);
        }
        if (s2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(26);
        }
        return SeverityRegistrar.compare(s1, s2, this.getOrderMap());
    }

    private static int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2, @NotNull Object2IntMap<HighlightSeverity> orderMap) {
        if (s1 == null) {
            SeverityRegistrar.$$$reportNull$$$0(27);
        }
        if (s2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(28);
        }
        if (orderMap == null) {
            SeverityRegistrar.$$$reportNull$$$0(29);
        }
        return orderMap.getInt(s1) - orderMap.getInt(s2);
    }

    @NotNull
    private Object2IntMap<HighlightSeverity> getOrderMap() {
        Object2IntMap<HighlightSeverity> map2 = this.orderMap.get();
        if (map2 != null) {
            Object2IntMap<HighlightSeverity> object2IntMap = map2;
            if (object2IntMap == null) {
                SeverityRegistrar.$$$reportNull$$$0(30);
            }
            return object2IntMap;
        }
        Object2IntMap<HighlightSeverity> object2IntMap = this.orderMap.updateAndGet(oldMap -> oldMap == null ? SeverityRegistrar.fromList(this.getDefaultOrder()) : oldMap);
        if (object2IntMap == null) {
            SeverityRegistrar.$$$reportNull$$$0(31);
        }
        return object2IntMap;
    }

    @NotNull
    private static Object2IntMap<HighlightSeverity> fromList(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList == null) {
            SeverityRegistrar.$$$reportNull$$$0(32);
        }
        if (orderList.isEmpty()) {
            Object2IntMap<HighlightSeverity> object2IntMap = Object2IntMaps.emptyMap();
            if (object2IntMap == null) {
                SeverityRegistrar.$$$reportNull$$$0(33);
            }
            return object2IntMap;
        }
        Object2IntOpenHashMap<HighlightSeverity> map2 = new Object2IntOpenHashMap<HighlightSeverity>(orderList.size());
        map2.defaultReturnValue(-1);
        for (int index2 = 0; index2 < orderList.size(); ++index2) {
            HighlightSeverity severity = orderList.get(index2);
            map2.put(severity, index2);
        }
        if (map2.size() != orderList.size()) {
            LOG.error("Severities order list must contain unique severities but got: " + orderList);
        }
        Object2IntMap<HighlightSeverity> object2IntMap = Object2IntMaps.unmodifiable(map2);
        if (object2IntMap == null) {
            SeverityRegistrar.$$$reportNull$$$0(34);
        }
        return object2IntMap;
    }

    @NotNull
    private List<HighlightSeverity> getDefaultOrder() {
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>(STANDARD_SEVERITIES.size() + this.myMap.size());
        for (HighlightInfoType type : STANDARD_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : this.myMap.values()) {
            order.add(attributes.getSeverity());
        }
        order.sort(null);
        ArrayList<HighlightSeverity> arrayList = order;
        if (arrayList == null) {
            SeverityRegistrar.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    public void setOrder(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList == null) {
            SeverityRegistrar.$$$reportNull$$$0(36);
        }
        this.orderMap.set(this.ensureAllStandardIncluded(orderList, this.getDefaultOrder()));
        this.myReadOrder = null;
        this.severitiesChanged();
    }

    int getSeverityIdx(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(37);
        }
        return this.getOrderMap().getInt(severity);
    }

    public static boolean isDefaultSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(38);
        }
        return STANDARD_SEVERITIES.containsKey(severity.myName);
    }

    static boolean isGotoBySeverityEnabled(@NotNull HighlightSeverity minSeverity) {
        if (minSeverity == null) {
            SeverityRegistrar.$$$reportNull$$$0(39);
        }
        for (SeveritiesProvider provider2 : SeveritiesProvider.EP_NAME.getIterable()) {
            if (!provider2.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity != HighlightSeverity.INFORMATION;
    }

    @NotNull
    @NotNull Collection<@NotNull SeverityBasedTextAttributes> allRegisteredAttributes() {
        Collection<SeverityBasedTextAttributes> collection = Collections.unmodifiableCollection(this.myMap.values());
        if (collection == null) {
            SeverityRegistrar.$$$reportNull$$$0(40);
        }
        return collection;
    }

    @NotNull
    public static Collection<HighlightInfoType> standardSeverities() {
        Collection<HighlightInfoType> collection = STANDARD_SEVERITIES.values();
        if (collection == null) {
            SeverityRegistrar.$$$reportNull$$$0(41);
        }
        return collection;
    }

    static {
        HashMap<String, HighlightInfoType> map2 = new HashMap<String, HighlightInfoType>(6);
        map2.put(HighlightSeverity.ERROR.getName(), HighlightInfoType.ERROR);
        map2.put(HighlightSeverity.WARNING.getName(), HighlightInfoType.WARNING);
        map2.put(HighlightSeverity.INFO.getName(), HighlightInfoType.INFO);
        map2.put(HighlightSeverity.WEAK_WARNING.getName(), HighlightInfoType.WEAK_WARNING);
        map2.put(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING.getName(), HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER);
        map2.put(HighlightDisplayLevel.CONSIDERATION_ATTRIBUTES.getName(), HighlightInfoType.TEXT_ATTRIBUTES);
        map2.put(HighlightDisplayLevel.DO_NOT_SHOW.getName(), HighlightInfoType.INFORMATION);
        STANDARD_SEVERITIES = new ConcurrentHashMap<String, HighlightInfoType>(map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9, 10, 19, 22, 23, 30, 31, 33, 34, 35, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = INFO_TAG;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 21: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "read";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownSeverities";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityName";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderMap";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderList";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoTypeBySeverity";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedSeverities";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRendererIconBySeverity";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderMap";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "fromList";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOrder";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "allRegisteredAttributes";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "standardSeverities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerStandard";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerSeverity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSeverity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoTypeBySeverity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesBySeverity";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributesBySeverity";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSeverityTextAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ensureAllStandardIncluded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSortedSeverities";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRendererIconBySeverity";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSeverityValid";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fromList";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setOrder";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSeverityIdx";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSeverity";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isGotoBySeverityEnabled";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 8, 9, 10, 19, 22, 23, 30, 31, 33, 34, 35, 40, 41 -> new IllegalStateException(string2);
        };
    }

    public static final class SeverityBasedTextAttributes {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        SeverityBasedTextAttributes(@NotNull Element element) {
            if (element == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(0);
            }
            this(new TextAttributes(element), new HighlightInfoType.HighlightInfoTypeImpl(element));
        }

        public SeverityBasedTextAttributes(@NotNull TextAttributes attributes, @NotNull HighlightInfoType.HighlightInfoTypeImpl type) {
            if (attributes == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(1);
            }
            if (type == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(2);
            }
            this.myAttributes = attributes;
            this.myType = type;
        }

        @NotNull
        public TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myAttributes;
            if (textAttributes == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(3);
            }
            return textAttributes;
        }

        @NotNull
        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = this.myType;
            if (highlightInfoTypeImpl == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(4);
            }
            return highlightInfoTypeImpl;
        }

        private void writeExternal(@NotNull Element element) {
            if (element == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(5);
            }
            this.myAttributes.writeExternal(element);
            this.myType.writeExternal(element);
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.myType.getSeverity(null);
            if (highlightSeverity == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(6);
            }
            return highlightSeverity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            return this.myAttributes.equals(that.myAttributes) && this.myType.equals(that.myType);
        }

        public int hashCode() {
            return 31 * this.myAttributes.hashCode() + this.myType.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 6 -> new IllegalStateException(string2);
            };
        }
    }
}

