/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class SeverityUtil {
    @NotNull
    public static Collection<SeverityRegistrar.SeverityBasedTextAttributes> getRegisteredHighlightingInfoTypes(@NotNull SeverityRegistrar registrar) {
        if (registrar == null) {
            SeverityUtil.$$$reportNull$$$0(0);
        }
        ArrayList<SeverityRegistrar.SeverityBasedTextAttributes> collection = new ArrayList<SeverityRegistrar.SeverityBasedTextAttributes>(registrar.allRegisteredAttributes());
        for (HighlightInfoType type : SeverityRegistrar.standardSeverities()) {
            if (HighlightInfoType.INFORMATION.equals(type) || HighlightInfoType.INFO.equals(type)) continue;
            collection.add(SeverityUtil.getSeverityBasedTextAttributes(registrar, type));
        }
        collection.sort(Comparator.comparing(SeverityRegistrar.SeverityBasedTextAttributes::getSeverity, registrar.reversed()));
        ArrayList<SeverityRegistrar.SeverityBasedTextAttributes> arrayList = collection;
        if (arrayList == null) {
            SeverityUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static SeverityRegistrar.SeverityBasedTextAttributes getSeverityBasedTextAttributes(@NotNull SeverityRegistrar registrar, @NotNull HighlightInfoType type) {
        EditorColorsScheme scheme;
        TextAttributes textAttributes;
        if (registrar == null) {
            SeverityUtil.$$$reportNull$$$0(2);
        }
        if (type == null) {
            SeverityUtil.$$$reportNull$$$0(3);
        }
        if ((textAttributes = (scheme = EditorColorsManager.getInstance().getGlobalScheme()).getAttributes(type.getAttributesKey())) != null) {
            return new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes, (HighlightInfoType.HighlightInfoTypeImpl)type);
        }
        TextAttributes severity = registrar.getTextAttributesBySeverity(type.getSeverity(null));
        return new SeverityRegistrar.SeverityBasedTextAttributes(severity, (HighlightInfoType.HighlightInfoTypeImpl)type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredHighlightingInfoTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredHighlightingInfoTypes";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSeverityBasedTextAttributes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

