/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final TextRange myVisibleRange;
    private final boolean hasDirtyTextRange;
    private final List<BooleanSupplier> autoImportActions;
    private volatile boolean myInContent;

    ShowAutoImportPass(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull ProperTextRange visibleRange) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(1);
        }
        if (visibleRange == null) {
            ShowAutoImportPass.$$$reportNull$$$0(2);
        }
        super(file2.getProject(), editor2.getDocument(), false);
        this.autoImportActions = Collections.synchronizedList(new ArrayList());
        this.myEditor = editor2;
        this.myVisibleRange = visibleRange;
        this.myFile = file2;
        this.hasDirtyTextRange = FileStatusMap.getDirtyTextRange(editor2, 4) != null;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowAutoImportPass.$$$reportNull$$$0(3);
        }
        Document document = this.myEditor.getDocument();
        ArrayList infos = new ArrayList();
        ArrayList<BooleanSupplier> result2 = new ArrayList<BooleanSupplier>();
        int exceptCaretOffset = this.myEditor.getCaretModel().getOffset();
        VirtualFile virtualFile2 = this.myFile.getVirtualFile();
        this.myInContent = virtualFile2 != null && ModuleUtilCore.projectContainsFile(this.myProject, virtualFile2, false);
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), info2 -> {
            if (info2.isUnresolvedReference() && info2.getSeverity() == HighlightSeverity.ERROR && !info2.containsOffset(exceptCaretOffset, true)) {
                infos.add(info2);
            }
            return true;
        });
        for (HighlightInfo info3 : infos) {
            for (ReferenceImporter importer : ReferenceImporter.EP_NAME.getExtensionList()) {
                BooleanSupplier action2;
                if (!importer.isAddUnambiguousImportsOnTheFlyEnabled(this.myFile) || (action2 = importer.computeAutoImportAtOffset(this.myEditor, this.myFile, info3.getActualStartOffset(), false)) == null) continue;
                result2.add(action2);
            }
        }
        this.autoImportActions.addAll(result2);
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().invokeLater(this::showImports);
    }

    private void showImports() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!UIUtil.hasFocus(this.myEditor.getContentComponent())) {
            return;
        }
        if (DumbService.isDumb(this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        SlowOperations.allowSlowOperations(() -> {
            block1: {
                int caretOffset = this.myEditor.getCaretModel().getOffset();
                this.importUnambiguousImports();
                if (!this.isImportHintEnabled()) break block1;
                List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myVisibleRange, this.myProject, this.myEditor, this.hasDirtyTextRange);
                visibleHighlights.sort(Comparator.comparingInt(info2 -> Math.abs(info2.getActualStartOffset() - caretOffset)));
                for (HighlightInfo visibleHighlight : visibleHighlights) {
                    if (this.showAddImportHint(visibleHighlight)) break;
                }
            }
        });
    }

    private void importUnambiguousImports() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!ShowAutoImportPass.mayAutoImportNow(this.myFile, this.myInContent)) {
            return;
        }
        for (BooleanSupplier autoImportAction : this.autoImportActions) {
            autoImportAction.getAsBoolean();
        }
    }

    public static boolean mayAutoImportNow(@NotNull PsiFile psiFile, boolean isInContent) {
        if (psiFile == null) {
            ShowAutoImportPass.$$$reportNull$$$0(4);
        }
        return ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently(psiFile, isInContent)) && ShowAutoImportPass.isInModelessContext(psiFile.getProject());
    }

    private static boolean isInModelessContext(@NotNull Project project2) {
        if (project2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(5);
        }
        return Registry.is("ide.perProjectModality") ? !LaterInvocator.isInModalContextForProject(project2) : !LaterInvocator.isInModalContext();
    }

    public static boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile psiFile) {
        PsiFile templateFile;
        if (psiFile == null) {
            ShowAutoImportPass.$$$reportNull$$$0(6);
        }
        if ((templateFile = PsiUtilCore.getTemplateLanguageFile(psiFile)) == null) {
            return false;
        }
        return ContainerUtil.exists(ReferenceImporter.EP_NAME.getExtensionList(), importer -> importer.isAddUnambiguousImportsOnTheFlyEnabled(psiFile));
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(@NotNull TextRange visibleRange, @NotNull Project project2, @NotNull Editor editor2, boolean isDirty) {
        if (visibleRange == null) {
            ShowAutoImportPass.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(9);
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        int offset2 = editor2.getCaretModel().getOffset();
        DaemonCodeAnalyzerEx.processHighlights(editor2.getDocument(), project2, null, visibleRange.getStartOffset(), visibleRange.getEndOffset(), info2 -> {
            if (!isDirty && !info2.containsOffset(offset2, true)) {
                return true;
            }
            if (info2.hasHint() && !editor2.getFoldingModel().isOffsetCollapsed(info2.startOffset)) {
                highlights.add((HighlightInfo)info2);
            }
            return true;
        });
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private boolean showAddImportHint(@NotNull HighlightInfo info2) {
        if (info2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(11);
        }
        for (HintAction action2 : ShowAutoImportPass.extractHints(info2)) {
            if (!action2.isAvailable(this.myProject, this.myEditor, this.myFile) || !action2.showHint(this.myEditor)) continue;
            return true;
        }
        return false;
    }

    private boolean isImportHintEnabled() {
        return DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled() && DaemonCodeAnalyzer.getInstance(this.myProject).isImportHintsEnabled(this.myFile);
    }

    @NotNull
    static List<HintAction> extractHints(@NotNull HighlightInfo info2) {
        if (info2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(12);
        }
        ArrayList<HintAction> result2 = new ArrayList<HintAction>();
        info2.findRegisteredQuickFix((descriptor2, range) -> {
            ProgressManager.checkCanceled();
            IntentionAction action2 = descriptor2.getAction();
            if (action2 instanceof HintAction) {
                result2.add((HintAction)action2);
            }
            return null;
        });
        ArrayList<HintAction> arrayList = result2;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    @NlsContexts.HintText
    public static String getMessage(boolean multiple, @NotNull String name) {
        if (name == null) {
            ShowAutoImportPass.$$$reportNull$$$0(14);
        }
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        Object hintText = DaemonBundle.message(messageKey, name);
        Object object = hintText = (String)hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (object == null) {
            ShowAutoImportPass.$$$reportNull$$$0(15);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleHighlights";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHints";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mayAutoImportNow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInModelessContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAddUnambiguousImportsOnTheFlyEnabled";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleHighlights";
                break;
            }
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showAddImportHint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractHints";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 13, 15 -> new IllegalStateException(string2);
        };
    }
}

