/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.SingleAlarm;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

class StatusBarUpdater
implements Disposable {
    private final Project myProject;
    private final SingleAlarm myAlarm;
    private static final HighlightSeverity MIN = new HighlightSeverity("min", HighlightSeverity.INFORMATION.myVal + 1);

    StatusBarUpdater(Project project2) {
        this.myProject = project2;
        this.myAlarm = new SingleAlarm(() -> this.updateStatus(), 100, (Disposable)this);
        project2.getMessageBus().connect(this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                StatusBarUpdater.this.updateLater();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/StatusBarUpdater$1", "selectionChanged"));
            }
        });
        project2.getMessageBus().connect(this).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, new DaemonCodeAnalyzer.DaemonListener(){

            @Override
            public void daemonFinished() {
                StatusBarUpdater.this.updateLater();
            }
        });
    }

    private void updateLater() {
        this.myAlarm.cancelAndRequest();
    }

    @Override
    public void dispose() {
    }

    private void updateStatus() {
        Editor editor2 = FileEditorManager.getInstance(this.myProject).getSelectedTextEditor();
        if (editor2 == null || !editor2.getContentComponent().hasFocus()) {
            return;
        }
        Document document = editor2.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance(this.myProject);
        HighlightInfo info2 = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(document, offset2, false, MIN);
        String text2 = info2 != null && info2.getDescription() != null ? info2.getDescription() : "";
        StatusBar statusBar = WindowManager.getInstance().getStatusBar((Component)editor2.getContentComponent(), this.myProject);
        if (statusBar != null && !text2.equals(statusBar.getInfo())) {
            statusBar.setInfo(text2, "updater");
        }
    }
}

