/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    public static final ExtensionPointName<TextEditorHighlightingPassFactoryRegistrar> EP_NAME = new ExtensionPointName("com.intellij.highlightingPassFactory");
    private final Int2ObjectMap<PassConfig> myRegisteredPassFactories;
    private volatile PassConfig[] myFrozenPassConfigs;
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories;
    private final AtomicInteger nextAvailableId;
    private final Project myProject;
    private boolean serializeCodeInsightPasses;

    public TextEditorHighlightingPassRegistrarImpl(final @NotNull Project project2) {
        if (project2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(0);
        }
        this.myRegisteredPassFactories = new Int2ObjectOpenHashMap<PassConfig>();
        this.myDirtyScopeTrackingFactories = ContainerUtil.createConcurrentList();
        this.nextAvailableId = new AtomicInteger();
        this.myProject = project2;
        this.reRegisterFactories();
        EP_NAME.addExtensionPointListener(new ExtensionPointListener<TextEditorHighlightingPassFactoryRegistrar>(){

            @Override
            public void extensionAdded(@NotNull TextEditorHighlightingPassFactoryRegistrar factoryRegistrar, @NotNull PluginDescriptor pluginDescriptor) {
                if (factoryRegistrar == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                factoryRegistrar.registerHighlightingPassFactory(TextEditorHighlightingPassRegistrarImpl.this, project2);
            }

            @Override
            public void extensionRemoved(@NotNull TextEditorHighlightingPassFactoryRegistrar factoryRegistrar, @NotNull PluginDescriptor pluginDescriptor) {
                if (factoryRegistrar == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                TextEditorHighlightingPassRegistrarImpl.this.reRegisterFactories();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factoryRegistrar";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reRegisterFactories() {
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            this.myRegisteredPassFactories.clear();
            this.myFrozenPassConfigs = null;
            this.nextAvailableId.set(14);
            this.myDirtyScopeTrackingFactories.clear();
        }
        EP_NAME.forEachExtensionSafe(registrar -> registrar.registerHighlightingPassFactory(this, this.myProject));
    }

    private synchronized PassConfig @NotNull [] freezeRegisteredPassFactories() {
        PassConfig[] configs = this.myFrozenPassConfigs;
        if (configs == null) {
            int maxId = this.myRegisteredPassFactories.keySet().intStream().max().orElse(0);
            configs = new PassConfig[maxId + 1];
            for (Int2ObjectMap.Entry entry : this.myRegisteredPassFactories.int2ObjectEntrySet()) {
                PassConfig config;
                int id = entry.getIntKey();
                configs[id] = config = (PassConfig)entry.getValue();
            }
            this.myFrozenPassConfigs = configs;
        }
        if (configs == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(1);
        }
        return configs;
    }

    @ApiStatus.Internal
    void serializeCodeInsightPasses(boolean flag2) {
        this.serializeCodeInsightPasses = flag2;
        this.reRegisterFactories();
    }

    @ApiStatus.Internal
    public boolean isSerializeCodeInsightPasses() {
        return this.serializeCodeInsightPasses;
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory2, int @Nullable [] runAfterCompletionOf, int @Nullable [] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        int[] afterStartingOf;
        if (factory2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(2);
        }
        int[] afterCompletionOf = runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : runAfterCompletionOf;
        int[] nArray = afterStartingOf = runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : runAfterOfStartingOf;
        if (IntStream.of(afterCompletionOf).anyMatch(id -> ArrayUtil.indexOf(afterStartingOf, id) != -1)) {
            throw new IllegalArgumentException("Pass id must not be contained in both 'runAfterCompletionOf' and 'runAfterOfStartingOf' arguments but got " + Arrays.toString(afterCompletionOf) + " and " + Arrays.toString(afterStartingOf));
        }
        if (ArrayUtil.indexOf(afterCompletionOf, forcedPassId) != -1 || ArrayUtil.indexOf(afterStartingOf, forcedPassId) != -1) {
            throw new IllegalArgumentException("Neither 'runAfterCompletionOf' nor 'runAfterOfStartingOf' arguments must contain 'forcedPassId'=" + forcedPassId + " but got " + Arrays.toString(afterCompletionOf) + " and " + Arrays.toString(afterStartingOf));
        }
        this.assertPassIdsAreNotCrazy(afterStartingOf, "afterStartingOf");
        this.assertPassIdsAreNotCrazy(afterCompletionOf, "afterCompletionOf");
        PassConfig info2 = new PassConfig(factory2, afterCompletionOf, afterStartingOf);
        int passId = forcedPassId == -1 ? this.getNextAvailableId() : forcedPassId;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + registered.passFactory;
        this.myRegisteredPassFactories.put(passId, info2);
        this.myFrozenPassConfigs = null;
        if (factory2 instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory2);
        }
        return passId;
    }

    private void assertPassIdsAreNotCrazy(int @NotNull [] ids, @NotNull String name) {
        if (name == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(3);
        }
        if (ids == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(4);
        }
        for (int id : ids) {
            PassConfig config;
            if (id == 1 || id == 3 || id == 4 || id == 7 || id == 8 || id == 9 || id == 11 || id == 13 || id == 12 || (config = (PassConfig)this.myRegisteredPassFactories.get(id)) != null) continue;
            throw new IllegalArgumentException("Argument '" + name + "' must not contain 0 or -1 or other crazy/unknown pass ids, but got " + Arrays.toString(ids));
        }
    }

    int getNextAvailableId() {
        return this.nextAvailableId.incrementAndGet();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull TextEditorHighlightingPass> instantiatePasses(@NotNull PsiFile psiFile, @NotNull Editor editor2, int @NotNull [] passesToIgnore) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (passesToIgnore == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
        Document document = editor2.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile(psiFile);
        }
        PassConfig[] frozenPassConfigs = this.freezeRegisteredPassFactories();
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(frozenPassConfigs.length);
        IntArrayList passesRefusedToCreate = new IntArrayList();
        boolean isDumb = DumbService.getInstance(this.myProject).isDumb();
        try (AccessToken ignored = ClientId.withClientId(ClientEditorManager.getClientId((Editor)editor2));){
            for (int passId = 1; passId < frozenPassConfigs.length; ++passId) {
                TextEditorHighlightingPass pass2;
                PassConfig passConfig = frozenPassConfigs[passId];
                if (passConfig == null || ArrayUtil.find(passesToIgnore, passId) != -1) continue;
                TextEditorHighlightingPassFactory factory2 = passConfig.passFactory;
                TextEditorHighlightingPass textEditorHighlightingPass = pass2 = isDumb && !DumbService.isDumbAware(factory2) || !ProblemHighlightFilter.shouldHighlightFile(psiFile) ? null : factory2.createHighlightingPass(psiFile, editor2);
                if (pass2 == null || isDumb && !DumbService.isDumbAware(pass2)) {
                    passesRefusedToCreate.add(passId);
                    continue;
                }
                pass2.setColorsScheme(editor2.getColorsScheme());
                IntList ids = passConfig.completionPredecessorIds.length == 0 ? IntList.of() : new IntArrayList(passConfig.completionPredecessorIds.length);
                for (int id : passConfig.completionPredecessorIds) {
                    if (id >= frozenPassConfigs.length || frozenPassConfigs[id] == null) continue;
                    ids.add(id);
                }
                pass2.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : ids.toIntArray());
                ids = passConfig.startingPredecessorIds.length == 0 ? IntList.of() : new IntArrayList(passConfig.startingPredecessorIds.length);
                for (int id : passConfig.startingPredecessorIds) {
                    if (id >= frozenPassConfigs.length || frozenPassConfigs[id] == null) continue;
                    ids.add(id);
                }
                pass2.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : ids.toIntArray());
                pass2.setId(passId);
                result2.add(pass2);
            }
        }
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        IntListIterator iterator2 = passesRefusedToCreate.iterator();
        while (iterator2.hasNext()) {
            statusMap.markFileUpToDate(document, iterator2.nextInt());
        }
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull TextEditorHighlightingPass> instantiateMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(9);
        }
        if (document == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(10);
        }
        if (highlightInfoProcessor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(11);
        }
        HashSet<TextEditorHighlightingPass> ids = new HashSet<TextEditorHighlightingPass>();
        PassConfig[] frozenPassConfigs = this.freezeRegisteredPassFactories();
        for (int passId = 0; passId < frozenPassConfigs.length; ++passId) {
            TextEditorHighlightingPass pass2;
            TextEditorHighlightingPassFactory factory2;
            PassConfig passConfig = frozenPassConfigs[passId];
            if (passConfig == null || !((factory2 = passConfig.passFactory) instanceof MainHighlightingPassFactory) || (pass2 = ((MainHighlightingPassFactory)factory2).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) == null) continue;
            ids.add(pass2);
            pass2.setId(passId);
        }
        return new ArrayList<TextEditorHighlightingPass>(ids);
    }

    @Override
    @NotNull
    public Iterable<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        List<DirtyScopeTrackingHighlightingPassFactory> list2 = this.myDirtyScopeTrackingFactories;
        if (list2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeRegisteredPassFactories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiatePasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeTrackingFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerTextEditorHighlightingPass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertPassIdsAreNotCrazy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePasses";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiateMainPasses";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 8, 12 -> new IllegalStateException(string2);
        };
    }

    private record PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, int @NotNull [] completionPredecessorIds, int @NotNull [] startingPredecessorIds) {
        @NotNull
        private final TextEditorHighlightingPassFactory passFactory;
        private final int @NotNull [] completionPredecessorIds;
        private final int @NotNull [] startingPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, int @NotNull [] completionPredecessorIds, int @NotNull [] startingPredecessorIds) {
            if (passFactory == null) {
                PassConfig.$$$reportNull$$$0(0);
            }
            if (completionPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(1);
            }
            if (startingPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        public TextEditorHighlightingPassFactory passFactory() {
            TextEditorHighlightingPassFactory textEditorHighlightingPassFactory = this.passFactory;
            if (textEditorHighlightingPassFactory == null) {
                PassConfig.$$$reportNull$$$0(3);
            }
            return textEditorHighlightingPassFactory;
        }

        public int @NotNull [] completionPredecessorIds() {
            if (this.completionPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(4);
            }
            return this.completionPredecessorIds;
        }

        public int @NotNull [] startingPredecessorIds() {
            if (this.startingPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(5);
            }
            return this.startingPredecessorIds;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "passFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionPredecessorIds";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startingPredecessorIds";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "passFactory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "completionPredecessorIds";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startingPredecessorIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

