/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.UtilBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.ConfigureInspectionsAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.StatusItemMerger;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeverityStatusItem;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private final Object2IntMap<HighlightSeverity> errorCount;
    @NotNull
    private final UIController myUIController;
    private final boolean inLibrary;
    private final boolean shouldHighlight;
    private int[] cachedErrors;
    private final Map<Language, FileHighlightingSetting> myFileHighlightingSettings;
    private volatile long myHighlightingSettingsModificationCount;

    public TrafficLightRenderer(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TrafficLightRenderer.$$$reportNull$$$0(1);
        }
        this(project2, document, null);
    }

    protected TrafficLightRenderer(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(3);
        }
        this(project2, editor2.getDocument(), editor2);
    }

    private TrafficLightRenderer(@NotNull Project project2, @NotNull Document document, @Nullable Editor editor2) {
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(4);
        }
        if (document == null) {
            TrafficLightRenderer.$$$reportNull$$$0(5);
        }
        this.errorCount = new Object2IntOpenHashMap<HighlightSeverity>();
        this.cachedErrors = ArrayUtilRt.EMPTY_INT_ARRAY;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        this.myProject = project2;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project2);
        this.myDocument = document;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.init(project2, this.myDocument);
        this.myUIController = editor2 == null ? this.createUIController() : this.createUIController(editor2);
        record Stuff(@NotNull Map<Language, FileHighlightingSetting> fileHighlightingSettings, boolean inLibrary, boolean shouldHighlight) {
            @NotNull
            private final Map<Language, FileHighlightingSetting> fileHighlightingSettings;

            Stuff(@NotNull Map<Language, FileHighlightingSetting> fileHighlightingSettings, boolean inLibrary, boolean shouldHighlight) {
                if (fileHighlightingSettings == null) {
                    Stuff.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public Map<Language, FileHighlightingSetting> fileHighlightingSettings() {
                Map<Language, FileHighlightingSetting> map2 = this.fileHighlightingSettings;
                if (map2 == null) {
                    Stuff.$$$reportNull$$$0(1);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileHighlightingSettings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1Stuff";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1Stuff";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fileHighlightingSettings";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }
        Stuff info2 = ReadAction.compute(() -> {
            PsiFile psiFile = this.getPsiFile();
            if (psiFile == null) {
                return new Stuff(Collections.emptyMap(), false, false);
            }
            FileViewProvider viewProvider = psiFile.getViewProvider();
            Set<Language> languages = viewProvider.getLanguages();
            HashMap<Language, FileHighlightingSetting> settingMap = new HashMap<Language, FileHighlightingSetting>(languages.size());
            HighlightingSettingsPerFile settings = HighlightingSettingsPerFile.getInstance(project2);
            for (PsiFile psiRoot : viewProvider.getAllFiles()) {
                FileHighlightingSetting setting = settings.getHighlightingSettingForRoot(psiRoot);
                settingMap.put(psiRoot.getLanguage(), setting);
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            assert (virtualFile2 != null);
            boolean inLib = fileIndex.isInLibrary(virtualFile2) && !fileIndex.isInContent(virtualFile2);
            boolean shouldHighlight = ProblemHighlightFilter.shouldHighlightFile(this.getPsiFile());
            return new Stuff(settingMap, inLib, shouldHighlight);
        });
        this.myFileHighlightingSettings = info2.fileHighlightingSettings();
        this.inLibrary = info2.inLibrary();
        this.shouldHighlight = info2.shouldHighlight();
        this.myHighlightingSettingsModificationCount = HighlightingSettingsPerFile.getInstance(project2).getModificationCount();
    }

    private void init(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(6);
        }
        if (document == null) {
            TrafficLightRenderer.$$$reportNull$$$0(7);
        }
        this.refresh(null);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        model2.addMarkupModelListener((Disposable)this, new MarkupModelListener(){

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                TrafficLightRenderer.this.incErrorCount((RangeHighlighter)highlighter, 1);
            }

            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                TrafficLightRenderer.this.incErrorCount((RangeHighlighter)highlighter, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            for (RangeHighlighter rangeHighlighter : model2.getAllHighlighters()) {
                this.incErrorCount(rangeHighlighter, 1);
            }
        });
    }

    private PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument);
    }

    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(8);
        }
        return severityRegistrar;
    }

    public int @NotNull [] getErrorCounts() {
        int[] nArray = (int[])this.cachedErrors.clone();
        if (nArray == null) {
            TrafficLightRenderer.$$$reportNull$$$0(9);
        }
        return nArray;
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
        List<HighlightSeverity> severities = this.mySeverityRegistrar.getAllSeverities();
        if (this.cachedErrors.length != severities.size()) {
            this.cachedErrors = new int[severities.size()];
        }
        for (HighlightSeverity severity : severities) {
            int severityIndex = this.mySeverityRegistrar.getSeverityIdx(severity);
            this.cachedErrors[severityIndex] = this.errorCount.getInt(severity);
        }
    }

    @Override
    public void dispose() {
        this.errorCount.clear();
        this.cachedErrors = ArrayUtilRt.EMPTY_INT_ARRAY;
    }

    private void incErrorCount(@NotNull RangeHighlighter highlighter, int delta) {
        HighlightInfo info2;
        if (highlighter == null) {
            TrafficLightRenderer.$$$reportNull$$$0(10);
        }
        if ((info2 = HighlightInfo.fromRangeHighlighter(highlighter)) == null) {
            return;
        }
        HighlightSeverity infoSeverity = info2.getSeverity();
        if (infoSeverity.myVal <= HighlightSeverity.TEXT_ATTRIBUTES.myVal) {
            return;
        }
        this.errorCount.put(infoSeverity, this.errorCount.getInt(infoSeverity) + delta);
    }

    public boolean isValid() {
        PsiFile psiFile = this.getPsiFile();
        return psiFile != null && HighlightingSettingsPerFile.getInstance(psiFile.getProject()).getModificationCount() == this.myHighlightingSettingsModificationCount;
    }

    @ApiStatus.Internal
    @NotNull
    public DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus() {
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(11);
        }
        return daemonCodeAnalyzerStatus;
    }

    @NotNull
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(12);
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        status.errorAnalyzingFinished = true;
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            status.reasonWhyDisabled = DaemonBundle.message("process.title.no.file", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(13);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (this.myProject.isDisposed()) {
            status.reasonWhyDisabled = DaemonBundle.message("process.title.project.is.disposed", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(14);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (!this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
            if (!psiFile.isPhysical()) {
                status.reasonWhyDisabled = DaemonBundle.message("process.title.file.is.generated", new Object[0]);
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(15);
                }
                return daemonCodeAnalyzerStatus;
            }
            if (psiFile instanceof PsiCompiledElement) {
                status.reasonWhyDisabled = DaemonBundle.message("process.title.file.is.decompiled", new Object[0]);
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(16);
                }
                return daemonCodeAnalyzerStatus;
            }
            FileType fileType = psiFile.getFileType();
            if (fileType.isBinary()) {
                status.reasonWhyDisabled = DaemonBundle.message("process.title.file.is.binary", new Object[0]);
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(17);
                }
                return daemonCodeAnalyzerStatus;
            }
            status.reasonWhyDisabled = DaemonBundle.message("process.title.highlighting.is.disabled.for.this.file", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(18);
            }
            return daemonCodeAnalyzerStatus;
        }
        FileViewProvider provider2 = psiFile.getViewProvider();
        Set<Language> languages = provider2.getLanguages();
        boolean shouldHighlight = languages.isEmpty();
        for (Map.Entry<Language, FileHighlightingSetting> entry : this.myFileHighlightingSettings.entrySet()) {
            FileHighlightingSetting level = entry.getValue();
            shouldHighlight |= level != FileHighlightingSetting.SKIP_HIGHLIGHTING;
            status.minimumLevel = status.minimumLevel.compareTo(level) < 0 ? status.minimumLevel : level;
        }
        if (!(shouldHighlight &= this.shouldHighlight)) {
            status.reasonWhyDisabled = DaemonBundle.message("process.title.highlighting.level.is.none", new Object[0]);
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(19);
            }
            return daemonCodeAnalyzerStatus;
        }
        HeavyProcessLatch.Operation heavyOperation = HeavyProcessLatch.INSTANCE.findRunningExcept(HeavyProcessLatch.Type.Syncing);
        if (heavyOperation != null) {
            status.reasonWhySuspended = heavyOperation.getDisplayName();
            status.heavyProcessType = heavyOperation.getType();
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(20);
            }
            return daemonCodeAnalyzerStatus;
        }
        status.errorCounts = this.getErrorCounts();
        status.passes = ContainerUtil.filter(this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument), p -> !StringUtil.isEmpty(p.getPresentableName()) && p.getProgress() >= 0.0);
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(psiFile);
        if (!this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled()) {
            status.reasonWhySuspended = DaemonBundle.message("process.title.highlighting.is.paused.temporarily", new Object[0]);
        }
        this.fillDaemonCodeAnalyzerErrorsStatus(status, severityRegistrar);
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(21);
        }
        return daemonCodeAnalyzerStatus;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(22);
        }
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(23);
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(24);
        }
        return project2;
    }

    @NotNull
    public AnalyzerStatus getStatus() {
        String details2;
        String title;
        if (PowerSaveMode.isEnabled()) {
            return new AnalyzerStatus(AllIcons.General.InspectionsPowerSaveMode, InspectionsBundle.message("code.analysis.is.disabled.in.power.save.mode", new Object[0]), "", this.myUIController);
        }
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        boolean isDumb = DumbService.isDumb(this.myProject);
        ArrayList<SeverityStatusItem> statusItems = new ArrayList<SeverityStatusItem>();
        int[] errorCounts = status.errorCounts;
        for (int i3 = errorCounts.length - 1; i3 >= 0; --i3) {
            SeverityStatusItem merged;
            HighlightSeverity severity;
            int count2 = errorCounts[i3];
            if (count2 <= 0 || (severity = this.mySeverityRegistrar.getSeverityByIndex(i3)) == null) continue;
            Icon icon2 = this.mySeverityRegistrar.getRendererIconBySeverity(severity, status.minimumLevel == FileHighlightingSetting.FORCE_HIGHLIGHTING);
            SeverityStatusItem next2 = new SeverityStatusItem(severity, icon2, count2, severity.getCountMessage(count2));
            while (!statusItems.isEmpty() && (merged = StatusItemMerger.runMerge((SeverityStatusItem)ContainerUtil.getLastItem(statusItems), next2)) != null) {
                statusItems.remove(statusItems.size() - 1);
                next2 = merged;
            }
            statusItems.add(next2);
        }
        if (status.errorAnalyzingFinished) {
            if (isDumb) {
                title = DaemonBundle.message("shallow.analysis.completed", new Object[0]);
                details2 = DaemonBundle.message("shallow.analysis.completed.details", new Object[0]);
            } else if (this.myFileHighlightingSettings.containsValue((Object)FileHighlightingSetting.ESSENTIAL)) {
                title = DaemonBundle.message("essential.analysis.completed", new Object[0]);
                details2 = DaemonBundle.message("essential.analysis.completed.details", new Object[0]);
            } else {
                title = statusItems.isEmpty() ? DaemonBundle.message("no.errors.or.warnings.found", new Object[0]) : "";
                details2 = "";
            }
        } else {
            title = DaemonBundle.message("performing.code.analysis", new Object[0]);
            details2 = "";
        }
        if (!statusItems.isEmpty()) {
            AnalyzerStatus result2 = new AnalyzerStatus(((SeverityStatusItem)statusItems.get(0)).getIcon(), title, "", this.myUIController).withNavigation().withExpandedStatus(ContainerUtil.map(statusItems, i2 -> new StatusItem(Integer.toString(i2.getProblemCount()), i2.getIcon(), i2.getCountMessage())));
            AnalyzerStatus analyzerStatus = status.errorAnalyzingFinished ? result2 : result2.withAnalyzingType(AnalyzingType.PARTIAL).withPasses(ContainerUtil.map(status.passes, pass2 -> new PassWrapper(pass2.getPresentableName(), TrafficLightRenderer.toPercent(pass2.getProgress(), pass2.isFinished()))));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(25);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty(status.reasonWhyDisabled)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsTrafficOff, DaemonBundle.message("no.analysis.performed", new Object[0]), status.reasonWhyDisabled, this.myUIController).withTextStatus(DaemonBundle.message("iw.status.off", new Object[0]));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(26);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty(status.reasonWhySuspended)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsPause, DaemonBundle.message("analysis.suspended", new Object[0]), status.reasonWhySuspended, this.myUIController).withTextStatus(status.heavyProcessType != null ? status.heavyProcessType.toString() : DaemonBundle.message("iw.status.paused", new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED);
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(27);
            }
            return analyzerStatus;
        }
        if (status.errorAnalyzingFinished) {
            Icon inspectionsCompletedIcon = status.minimumLevel == FileHighlightingSetting.FORCE_HIGHLIGHTING ? AllIcons.General.InspectionsOK : AllIcons.General.InspectionsOKEmpty;
            return isDumb ? new AnalyzerStatus(AllIcons.General.InspectionsPause, title, details2, this.myUIController).withTextStatus(UtilBundle.message("heavyProcess.type.indexing", new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED) : new AnalyzerStatus(inspectionsCompletedIcon, title, details2, this.myUIController);
        }
        AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsEye, DaemonBundle.message("no.errors.or.warnings.found", new Object[0]), details2, this.myUIController).withTextStatus(DaemonBundle.message("iw.status.analyzing", new Object[0])).withAnalyzingType(AnalyzingType.EMPTY).withPasses(ContainerUtil.map(status.passes, pass2 -> new PassWrapper(pass2.getPresentableName(), TrafficLightRenderer.toPercent(pass2.getProgress(), pass2.isFinished()))));
        if (analyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(28);
        }
        return analyzerStatus;
    }

    private static int toPercent(double progress, boolean finished) {
        int percent = (int)(progress * 100.0);
        return percent == 100 && !finished ? 99 : percent;
    }

    @NotNull
    protected UIController createUIController() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return new AbstractUIController();
    }

    @NotNull
    protected final UIController createUIController(@NotNull Editor editor2) {
        if (editor2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        boolean mergeEditor = editor2.getUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG) == Boolean.TRUE;
        return editor2.getEditorKind() == EditorKind.DIFF && !mergeEditor ? new AbstractUIController() : new DefaultUIController();
    }

    private static void applyPanel(@NotNull HectorComponentPanel panel2) {
        if (panel2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(30);
        }
        try {
            panel2.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @NotNull
    protected UIController getUIController() {
        UIController uIController = this.myUIController;
        if (uIController == null) {
            TrafficLightRenderer.$$$reportNull$$$0(31);
        }
        return uIController;
    }

    void invalidate() {
        this.myHighlightingSettingsModificationCount = -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 24, 25, 26, 27, 28, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorCounts";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "incErrorCount";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createUIController";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyPanel";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 24, 25, 26, 27, 28, 31 -> new IllegalStateException(string2);
        };
    }

    @ApiStatus.Internal
    public static final class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        List<ProgressableTextEditorHighlightingPass> passes = Collections.emptyList();
        public int[] errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
        @Nls
        public String reasonWhyDisabled;
        @Nls
        public String reasonWhySuspended;
        public HeavyProcessLatch.Type heavyProcessType;
        private FileHighlightingSetting minimumLevel = FileHighlightingSetting.FORCE_HIGHLIGHTING;

        DaemonCodeAnalyzerStatus() {
        }

        public String toString() {
            StringBuilder s = new StringBuilder("DS: finished=" + this.errorAnalyzingFinished + "; pass statuses: " + this.passes.size() + "; ");
            for (ProgressableTextEditorHighlightingPass passStatus : this.passes) {
                s.append(String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished()));
            }
            s.append("; error counts: ").append(this.errorCounts.length).append(": ").append(new IntArrayList(this.errorCounts));
            if (this.reasonWhyDisabled != null) {
                s.append("; reasonWhyDisabled=").append(this.reasonWhyDisabled);
            }
            if (this.reasonWhySuspended != null) {
                s.append("; reasonWhySuspended").append(this.reasonWhySuspended);
            }
            return s.toString();
        }
    }

    protected class AbstractUIController
    implements UIController {
        @NotNull
        private List<HectorComponentPanel> myAdditionalPanels = Collections.emptyList();

        AbstractUIController() {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }

        @NotNull
        public List<InspectionsLevel> getAvailableLevels() {
            List<InspectionsLevel> list2 = TrafficLightRenderer.this.inLibrary ? Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX) : (ApplicationManager.getApplication().isInternal() ? Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX, InspectionsLevel.ESSENTIAL, InspectionsLevel.ALL) : Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX, InspectionsLevel.ALL));
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @NotNull
        public List<LanguageHighlightLevel> getHighlightLevels() {
            List<LanguageHighlightLevel> list2 = ContainerUtil.map(TrafficLightRenderer.this.myFileHighlightingSettings.entrySet(), entry -> new LanguageHighlightLevel(((Language)entry.getKey()).getID(), FileHighlightingSetting.toInspectionsLevel((FileHighlightingSetting)((Object)((Object)entry.getValue())))));
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public void setHighLightLevel(@NotNull LanguageHighlightLevel level) {
            PsiFile psiFile;
            if (level == null) {
                AbstractUIController.$$$reportNull$$$0(2);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null && !TrafficLightRenderer.this.getProject().isDisposed() && !this.getHighlightLevels().contains(level)) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                Language language = Language.findLanguageByID(level.getLangID());
                if (language != null) {
                    PsiFile root = viewProvider.getPsi(language);
                    if (root == null) {
                        return;
                    }
                    FileHighlightingSetting setting = FileHighlightingSetting.fromInspectionsLevel(level.getLevel());
                    HighlightLevelUtil.forceRootHighlighting(root, setting);
                    InjectedLanguageManager.getInstance(TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
            }
        }

        public void fillHectorPanels(@NotNull Container container, @NotNull GridBag gc) {
            PsiFile psiFile;
            if (container == null) {
                AbstractUIController.$$$reportNull$$$0(3);
            }
            if (gc == null) {
                AbstractUIController.$$$reportNull$$$0(4);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                ArrayList<HectorComponentPanel> list2 = new ArrayList<HectorComponentPanel>();
                for (HectorComponentPanelsProvider hp : HectorComponentPanelsProvider.EP_NAME.getExtensionList(TrafficLightRenderer.this.getProject())) {
                    HectorComponentPanel configurable2 = hp.createConfigurable(psiFile);
                    if (configurable2 == null) continue;
                    list2.add(configurable2);
                }
                this.myAdditionalPanels = list2;
                for (HectorComponentPanel panel2 : this.myAdditionalPanels) {
                    JComponent c2;
                    try {
                        panel2.reset();
                        c2 = panel2.createComponent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Logger.getInstance(TrafficLightRenderer.class).error(e);
                        continue;
                    }
                    if (c2 == null) continue;
                    container.add((Component)c2, gc.nextLine().next().fillCellHorizontally().coverLine().weightx(1.0));
                }
            }
        }

        public boolean canClosePopup() {
            if (this.myAdditionalPanels.isEmpty()) {
                return true;
            }
            if (ContainerUtil.all(this.myAdditionalPanels, p -> p.canClose())) {
                PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
                if (this.myAdditionalPanels.stream().filter(p -> p.isModified()).peek(TrafficLightRenderer::applyPanel).count() > 0L) {
                    if (psiFile != null) {
                        InjectedLanguageManager.getInstance(TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    }
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
                return true;
            }
            return false;
        }

        public void onClosePopup() {
            this.myAdditionalPanels.forEach(p -> p.disposeUIResources());
            this.myAdditionalPanels = Collections.emptyList();
        }

        public void toggleProblemsView() {
            PsiFile file2 = TrafficLightRenderer.this.getPsiFile();
            ProblemsView.toggleCurrentFileProblems(TrafficLightRenderer.this.getProject(), file2 == null ? null : file2.getVirtualFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightLevels";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setHighLightLevel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fillHectorPanels";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3, 4 -> new IllegalArgumentException(string2);
            };
        }
    }

    protected class DefaultUIController
    extends AbstractUIController {
        private final List<AnAction> myMenuActions = this.initActions();

        protected DefaultUIController() {
        }

        @NotNull
        private List<AnAction> initActions() {
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            result2.add((AnAction)new ConfigureInspectionsAction());
            result2.add((AnAction)DaemonEditorPopup.createGotoGroup());
            result2.add((AnAction)Separator.create());
            result2.add((AnAction)new ShowImportTooltipAction());
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                DefaultUIController.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = this.myMenuActions;
            if (list2 == null) {
                DefaultUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public boolean isToolbarEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class ShowImportTooltipAction
        extends ToggleAction {
            private ShowImportTooltipAction() {
                super(EditorBundle.message((String)"iw.show.import.tooltip", (Object[])new Object[0]));
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                PsiFile psiFile;
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(0);
                }
                return (psiFile = TrafficLightRenderer.this.getPsiFile()) != null && TrafficLightRenderer.this.myDaemonCodeAnalyzer.isImportHintsEnabled(psiFile);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                PsiFile psiFile;
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(2);
                }
                if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.setImportHintsEnabled(psiFile, state);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(3);
                }
                super.update(e);
                PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
                e.getPresentation().setEnabled(psiFile != null && TrafficLightRenderer.this.myDaemonCodeAnalyzer.isAutohintsAvailable(psiFile));
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController$ShowImportTooltipAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController$ShowImportTooltipAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        }
    }
}

