/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.B;
import com.intellij.codeInsight.daemon.impl.CanISilentlyChange;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoB;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixUpdater;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
@ApiStatus.Experimental
public class UnresolvedReferenceQuickFixUpdaterImpl
implements UnresolvedReferenceQuickFixUpdater {
    private static final Key<Future<?>> JOB = Key.create("JOB");
    private final Project myProject;
    private volatile boolean enabled = true;

    public UnresolvedReferenceQuickFixUpdaterImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void waitQuickFixesSynchronously(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull List<? extends HighlightInfo> infos) {
        if (file2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessNotAllowed();
        for (HighlightInfo highlightInfo : infos) {
            CompletableFuture newFuture;
            PsiReference reference2 = highlightInfo.unresolvedReference;
            if (reference2 == null || highlightInfo.isUnresolvedReferenceQuickFixesComputed()) continue;
            PsiElement refElement = ReadAction.compute(() -> reference2.getElement());
            Future job2 = refElement.getUserData(JOB);
            if (job2 == null && (job2 = (Future)((UserDataHolderEx)((Object)refElement)).putUserDataIfAbsent(JOB, newFuture = new CompletableFuture())) == newFuture) {
                try {
                    ReadAction.run(() -> this.registerReferenceFixes(info2, editor2, file2, reference2));
                    newFuture.complete(null);
                }
                catch (Throwable t) {
                    newFuture.completeExceptionally(t);
                }
            }
            try {
                job2.get(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void registerQuickFixesLater(@NotNull PsiReference ref, @NotNull HighlightInfo.Builder info2) {
        if (ref == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(3);
        }
        if (info2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(4);
        }
        ((HighlightInfoB)info2).setUnresolvedReference(ref);
    }

    @Override
    public void registerQuickFixesLater(@NotNull PsiReference ref, @NotNull AnnotationBuilder builder2) {
        if (ref == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(5);
        }
        if (builder2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(6);
        }
        ((B)builder2).unresolvedReference(ref);
    }

    @Override
    public void startComputingNextQuickFixes(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull ProperTextRange visibleRange) {
        if (file2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(8);
        }
        if (visibleRange == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int offset2 = editor2.getCaretModel().getOffset();
        Project project2 = file2.getProject();
        Document document = editor2.getDocument();
        AtomicInteger unresolvedInfosProcessed = new AtomicInteger();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, HighlightSeverity.ERROR, offset2, document.getTextLength(), info2 -> {
            if (!info2.isUnresolvedReference()) {
                return true;
            }
            this.startUnresolvedRefsJob((HighlightInfo)info2, editor2, file2);
            return unresolvedInfosProcessed.incrementAndGet() <= 2;
        });
        if (DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled() && DaemonCodeAnalyzer.getInstance(this.myProject).isImportHintsEnabled(file2)) {
            DaemonCodeAnalyzerEx.processHighlights(document, project2, HighlightSeverity.ERROR, visibleRange.getStartOffset(), visibleRange.getEndOffset(), info2 -> {
                if (info2.isUnresolvedReference()) {
                    this.startUnresolvedRefsJob((HighlightInfo)info2, editor2, file2);
                }
                return true;
            });
        }
    }

    private void startUnresolvedRefsJob(@NotNull HighlightInfo info2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (info2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.enabled) {
            return;
        }
        PsiReference reference2 = info2.unresolvedReference;
        if (reference2 == null) {
            return;
        }
        PsiElement refElement = reference2.getElement();
        Future job2 = refElement.getUserData(JOB);
        if (job2 != null) {
            return;
        }
        if (info2.isUnresolvedReferenceQuickFixesComputed()) {
            return;
        }
        job2 = ForkJoinPool.commonPool().submit(() -> ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.registerReferenceFixes(info2, editor2, file2, reference2), (ProgressIndicator)new DaemonProgressIndicator())), (Object)null);
        refElement.putUserData(JOB, job2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerReferenceFixes(@NotNull HighlightInfo info2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull PsiReference reference2) {
        if (info2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(15);
        }
        if (reference2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement referenceElement = reference2.getElement();
        if (this.myProject.isDisposed() || !file2.isValid() || editor2.isDisposed() || DumbService.getInstance(this.myProject).isDumb() || !referenceElement.isValid()) {
            return;
        }
        final AtomicBoolean changed2 = new AtomicBoolean();
        try {
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(reference2, new QuickFixActionRegistrarImpl(info2){

                @Override
                void doRegister(@NotNull IntentionAction action2, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
                    if (action2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.doRegister(action2, displayName, fixRange, key);
                    changed2.set(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/UnresolvedReferenceQuickFixUpdaterImpl$1", "doRegister"));
                }
            });
            info2.setUnresolvedReferenceQuickFixesComputed();
        }
        finally {
            referenceElement.putUserData(JOB, null);
        }
        if (changed2.get()) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            boolean isInContent = ModuleUtilCore.projectContainsFile(this.myProject, virtualFile2, false);
            ApplicationManager.getApplication().invokeLater(() -> {
                DaemonProgressIndicator sessionIndicator = new DaemonProgressIndicator();
                boolean canChangeFileSilently = CanISilentlyChange.thisFile(file2).canIReally(isInContent);
                ProgressManager.getInstance().executeProcessUnderProgress(() -> HighlightingSessionImpl.runInsideHighlightingSession(file2, null, ProperTextRange.create(file2.getTextRange()), canChangeFileSilently, () -> DefaultHighlightInfoProcessor.showAutoImportHints(editor2, file2, sessionIndicator)), sessionIndicator);
            }, __ -> editor2.isDisposed() || file2.getProject().isDisposed());
        }
    }

    @TestOnly
    void stopUntil(@NotNull Disposable disposable) {
        if (disposable == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(17);
        }
        this.enabled = false;
        Disposer.register(disposable, () -> {
            this.enabled = true;
        });
    }

    @TestOnly
    void waitForBackgroundJobIfStartedInTests(@NotNull HighlightInfo info2) throws InterruptedException, ExecutionException, TimeoutException {
        PsiReference reference2;
        if (info2 == null) {
            UnresolvedReferenceQuickFixUpdaterImpl.$$$reportNull$$$0(18);
        }
        if ((reference2 = info2.unresolvedReference) == null) {
            return;
        }
        Future<?> job2 = reference2.getElement().getUserData(JOB);
        if (job2 != null) {
            job2.get(60L, TimeUnit.SECONDS);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UnresolvedReferenceQuickFixUpdaterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitQuickFixesSynchronously";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerQuickFixesLater";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "startComputingNextQuickFixes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "startUnresolvedRefsJob";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceFixes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "stopUntil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForBackgroundJobIfStartedInTests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

