/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.CanISilentlyChange;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoPostFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InternalLayerSupplier;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateHighlightersUtil {
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NO_DUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare(o1.getSeverity(), o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal(o1.type, o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal(o1.getGutterIconRenderer(), o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributes, o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributesKey, o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare(o1.getDescription(), o2.getDescription());
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create("TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(@NotNull HighlightInfo info2, @NotNull HighlightInfo coveredBy) {
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(0);
        }
        if (coveredBy == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(1);
        }
        return coveredBy.startOffset <= info2.startOffset && info2.endOffset <= coveredBy.endOffset && info2.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange restrictRange, @NotNull HighlightInfo info2, @Nullable EditorColorsScheme colorsScheme, int group2, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache) {
        if (file2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(2);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(3);
        }
        if (restrictRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(4);
        }
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(5);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project2 = file2.getProject();
        if (!HighlightInfoPostFilters.accept(project2, info2)) {
            return;
        }
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info2)) {
            return;
        }
        if (!restrictRange.intersects(info2)) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info2, severityRegistrar);
        Processor<HighlightInfo> otherHighlightInTheWayProcessor = oldInfo -> {
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info2, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group2 || !oldInfo.equalsByActualOffset(info2);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project2, null, info2.getActualStartOffset(), info2.getActualEndOffset(), otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info2, colorsScheme, document, group2, file2, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        }
    }

    public static boolean isFileLevelOrGutterAnnotation(@NotNull HighlightInfo info2) {
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(7);
        }
        return info2.isFileLevelAnnotation() || info2.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToSingleEditor(@NotNull Project project2, @NotNull Editor editor2, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group2) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(9);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = editor2.getDocument();
        MarkupModelEx markup = (MarkupModelEx)editor2.getMarkupModel();
        UpdateHighlightersUtil.setHighlightersToEditor(project2, document, startOffset, endOffset, highlights, colorsScheme, group2, markup);
    }

    public static void setHighlightersToEditor(@NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group2) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(11);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(12);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        UpdateHighlightersUtil.setHighlightersToEditor(project2, document, startOffset, endOffset, highlights, colorsScheme, group2, markup);
    }

    private static void setHighlightersToEditor(@NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int group2, @NotNull MarkupModelEx markup) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(14);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(15);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(16);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(17);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        if (psiFile instanceof PsiCompiledFile) {
            psiFile = ((PsiCompiledFile)psiFile).getDecompiledPsiFile();
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        if (psiFile != null) {
            codeAnalyzer.cleanFileLevelHighlights(group2, psiFile);
        }
        UpdateHighlightersUtil.assertMarkupConsistent((MarkupModel)markup, project2);
        if (psiFile != null) {
            HighlightingSession session = HighlightingSessionImpl.createHighlightingSession(psiFile, new DaemonProgressIndicator(), colorsScheme, ProperTextRange.create(startOffset, endOffset), CanISilentlyChange.Result.UH_UH);
            UpdateHighlightersUtil.setHighlightersInRange(document, range, new ArrayList<HighlightInfo>(infos), markup, group2, session);
        }
    }

    static void setHighlightersOutsideRange(@NotNull Document document, @NotNull List<? extends HighlightInfo> infos, int startOffset, int endOffset, @NotNull TextRange priorityRange, int group2, @NotNull HighlightingSession session) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(18);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(19);
        }
        if (priorityRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(20);
        }
        if (session == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = session.getPsiFile();
        Project project2 = session.getProject();
        List<HighlightInfo> filteredInfos = HighlightInfoPostFilters.applyPostFilter(project2, infos);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(group2, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NO_DUPS);
        HashSet<HighlightInfo> infoSet = new HashSet<HighlightInfo>(filteredInfos);
        Processor<HighlightInfo> processor = info2 -> {
            if (info2.getGroup() == group2) {
                boolean toRemove2;
                RangeHighlighterEx highlighter = info2.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                if (!info2.isFromInjection() && hiEnd < document.getTextLength() && (hiEnd != 0 && hiEnd <= startOffset || hiStart >= endOffset)) {
                    return true;
                }
                boolean bl = toRemove2 = infoSet.contains(info2) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
                if (toRemove2) {
                    infosToRemove.recycleHighlighter((RangeHighlighter)highlighter);
                    info2.setHighlighter(null);
                }
            }
            return true;
        };
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project2, priorityRange.getStartOffset(), priorityRange.getEndOffset(), processor);
        Long2ObjectOpenHashMap ranges2markersCache = new Long2ObjectOpenHashMap(10);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = proc -> ContainerUtil.process(filteredInfos, proc);
        SweepProcessor.sweep(generator, (offset2, info2, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (!(info2.isFromInjection() || info2.getEndOffset() >= document.getTextLength() || info2.getEndOffset() > startOffset && info2.getStartOffset() < endOffset)) {
                return true;
            }
            if (info2.isFileLevelAnnotation()) {
                codeAnalyzer.addFileLevelHighlight(group2, (HighlightInfo)info2, psiFile);
                changed2[0] = true;
                return true;
            }
            if (UpdateHighlightersUtil.isWarningCoveredByError(info2, severityRegistrar, overlappingIntervals)) {
                return true;
            }
            if (info2.getStartOffset() < priorityRange.getStartOffset() || info2.getEndOffset() > priorityRange.getEndOffset()) {
                EditorColorsScheme colorsScheme = session.getColorsScheme();
                UpdateHighlightersUtil.createOrReuseHighlighterFor(info2, colorsScheme, document, group2, psiFile, (MarkupModelEx)markup, infosToRemove, ranges2markersCache, severityRegistrar);
                changed2[0] = true;
            }
            return true;
        });
        changed2[0] = changed2[0] | UpdateHighlightersUtil.incinerateObsoleteHighlighters(infosToRemove, session);
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
    }

    static void setHighlightersInRange(@NotNull Document document, @NotNull TextRange range, @NotNull List<? extends HighlightInfo> infos, @NotNull MarkupModelEx markup, int group2, @NotNull HighlightingSession session) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(22);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(23);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(24);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(25);
        }
        if (session == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project2 = session.getProject();
        PsiFile psiFile = session.getPsiFile();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(markup, project2, null, range.getStartOffset(), range.getEndOffset(), info2 -> {
            if (info2.getGroup() == group2) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info2.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range.getEndOffset() == document.getTextLength() || range.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter((RangeHighlighter)highlighter);
                    info2.setHighlighter(null);
                }
            }
            return true;
        });
        List<HighlightInfo> filteredInfos = HighlightInfoPostFilters.applyPostFilter(project2, infos);
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NO_DUPS);
        Long2ObjectOpenHashMap ranges2markersCache = new Long2ObjectOpenHashMap(10);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = processor -> ContainerUtil.process(filteredInfos, processor);
        SweepProcessor.sweep(generator, (offset2, info2, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (info2.isFileLevelAnnotation()) {
                codeAnalyzer.addFileLevelHighlight(group2, (HighlightInfo)info2, psiFile);
                changed2[0] = true;
                return true;
            }
            if (UpdateHighlightersUtil.isWarningCoveredByError(info2, severityRegistrar, overlappingIntervals)) {
                return true;
            }
            if (info2.getStartOffset() >= range.getStartOffset() && info2.getEndOffset() <= range.getEndOffset()) {
                EditorColorsScheme colorsScheme = session.getColorsScheme();
                UpdateHighlightersUtil.createOrReuseHighlighterFor(info2, colorsScheme, document, group2, psiFile, markup, infosToRemove, ranges2markersCache, severityRegistrar);
                changed2[0] = true;
            }
            return true;
        });
        changed2[0] = changed2[0] | UpdateHighlightersUtil.incinerateObsoleteHighlighters(infosToRemove, session);
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent((MarkupModel)markup, project2);
    }

    private static boolean incinerateObsoleteHighlighters(@NotNull HighlightersRecycler infosToRemove, @NotNull HighlightingSession session) {
        if (infosToRemove == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(27);
        }
        if (session == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(28);
        }
        boolean changed2 = false;
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            if (!UpdateHighlightersUtil.shouldRemoveHighlighter(rangeHighlighter, session)) continue;
            rangeHighlighter.dispose();
            changed2 = true;
        }
        return changed2;
    }

    static boolean shouldRemoveHighlighter(@NotNull RangeHighlighter highlighter, @NotNull HighlightingSession session) {
        if (highlighter == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(29);
        }
        if (session == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(30);
        }
        return !session.isEssentialHighlightingOnly() || UpdateHighlightersUtil.shouldRemoveInfoEvenInEssentialMode(highlighter);
    }

    private static boolean shouldRemoveInfoEvenInEssentialMode(@NotNull RangeHighlighter highlighter) {
        Object tooltip;
        if (highlighter == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(31);
        }
        if (!((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo)) {
            return true;
        }
        HighlightInfo info2 = (HighlightInfo)tooltip;
        int group2 = info2.getGroup();
        if (group2 != 7 && group2 != 8 && group2 != 12 && group2 != 4 && group2 != 5) {
            return true;
        }
        return group2 == 4 && (info2.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY || info2.getSeverity() == HighlightSeverity.ERROR);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info2, @NotNull SeverityRegistrar severityRegistrar, @NotNull Collection<? extends HighlightInfo> overlappingIntervals) {
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(32);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(33);
        }
        if (overlappingIntervals == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(34);
        }
        if (!UpdateHighlightersUtil.isSevere(info2, severityRegistrar)) {
            for (HighlightInfo highlightInfo : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info2, severityRegistrar, highlightInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (warning == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(35);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(36);
        }
        if (candidate == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(37);
        }
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        if (candidate.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info2, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(38);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(39);
        }
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity = info2.getSeverity()) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info2, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group2, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        RangeHighlighterEx highlighter;
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(40);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(41);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(42);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(43);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(44);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(45);
        }
        int infoStartOffset = info2.startOffset;
        int infoEndOffset = info2.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info2.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info2.setGroup(group2);
        int layer = UpdateHighlightersUtil.getLayer(info2, severityRegistrar);
        long finalInfoRange = TextRangeScalarUtil.toScalarRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info2.getTextAttributes(psiFile, colorsScheme);
        Consumer<RangeHighlighterEx> changeAttributes = finalHighlighter -> {
            Color attributesErrorStripeColor;
            TextAttributesKey textAttributesKey = info2.forcedTextAttributesKey == null ? info2.type.getAttributesKey() : info2.forcedTextAttributesKey;
            finalHighlighter.setTextAttributesKey(textAttributesKey);
            if (infoAttributes != null && !infoAttributes.equals(finalHighlighter.getTextAttributes(colorsScheme)) || infoAttributes == TextAttributes.ERASE_MARKER) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            info2.setHighlighter((RangeHighlighterEx)finalHighlighter);
            finalHighlighter.setAfterEndOfLine(info2.isAfterEndOfLine());
            Color infoErrorStripeColor = info2.getErrorStripeMarkColor(psiFile, colorsScheme);
            TextAttributes attributes = finalHighlighter.getTextAttributes(colorsScheme);
            Color color = attributesErrorStripeColor = attributes != null ? attributes.getErrorStripeColor() : null;
            if (infoErrorStripeColor != null && !infoErrorStripeColor.equals(attributesErrorStripeColor)) {
                finalHighlighter.setErrorStripeMarkColor(infoErrorStripeColor);
            }
            if (info2 != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip((Object)info2);
            }
            GutterMark renderer = info2.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, (RangeMarker)finalHighlighter);
            info2.updateQuickFixFields(document, ranges2markersCache, finalInfoRange);
        };
        RangeHighlighterEx rangeHighlighterEx = highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer);
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(null, infoStartOffset, infoEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
            if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info2.type)) {
                highlighter.setVisibleIfFolded(true);
            }
        } else {
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        if (infoAttributes != null) {
            boolean attributesSet = Comparing.equal(infoAttributes, highlighter.getTextAttributes(colorsScheme));
            assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes(colorsScheme);
        }
    }

    private static int getLayer(@NotNull HighlightInfo info2, @NotNull SeverityRegistrar severityRegistrar) {
        int hardCodedLayer;
        if (info2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(46);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(47);
        }
        if ((hardCodedLayer = InternalLayerSuppliers.getLayerFromSuppliers(info2)) > 0) {
            return hardCodedLayer;
        }
        HighlightSeverity severity = info2.getSeverity();
        int layer = severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severityRegistrar.compare(severity, HighlightSeverity.WARNING) >= 0 ? 4000 : (severityRegistrar.compare(severity, HighlightSeverity.WEAK_WARNING) >= 0 || severity == HighlightSeverity.TEXT_ATTRIBUTES ? 3750 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || severity == HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY ? 1999 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY ? 1998 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : (severityRegistrar.getAllSeverities().contains(severity) && !SeverityRegistrar.isDefaultSeverity(severity) ? 4000 : 3000))))));
        return layer;
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(48);
        }
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(49);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(50);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project2, @NotNull DocumentEvent e) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(51);
        }
        if (e == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(52);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        int start = e.getOffset() - 1;
        int end = start + e.getOldLength();
        ArrayList toRemove2 = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, start, end, info2 -> {
            if (!info2.needUpdateOnTyping()) {
                return true;
            }
            RangeHighlighterEx highlighter = info2.getHighlighter();
            int highlighterStart = highlighter.getStartOffset();
            int highlighterEnd = highlighter.getEndOffset();
            if (info2.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start < highlighterEnd && highlighterStart <= end) {
                toRemove2.add(info2);
            }
            return true;
        });
        for (HighlightInfo info3 : toRemove2) {
            if (info3.getHighlighter().isValid() && !info3.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info3.getHighlighter().dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        if (!toRemove2.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project2) {
        RangeHighlighter[] allHighlighters;
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(53);
        }
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(54);
        }
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, 0, document.getTextLength(), info2 -> {
            assert (((MarkupModelEx)markup).containsHighlighter((RangeHighlighter)info2.getHighlighter()));
            return true;
        });
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            HighlightInfo info3;
            if (!highlighter.isValid() || (info3 = HighlightInfo.fromRangeHighlighter(highlighter)) == null) continue;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)markup, project2, null, info3.getActualStartOffset(), info3.getActualEndOffset(), highlightInfo -> BY_START_OFFSET_NO_DUPS.compare((HighlightInfo)highlightInfo, info3) != 0);
            assert (contains) : info3;
        }
    }

    public static void removeHighlightersWithExactRange(@NotNull Document document, @NotNull Project project2, @NotNull Segment range) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(55);
        }
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(56);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(57);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel model2 = DocumentMarkupModel.forDocument((Document)document, (Project)project2, (boolean)false);
        if (model2 == null) {
            return;
        }
        for (RangeHighlighter highlighter : model2.getAllHighlighters()) {
            if (!TextRange.areSegmentsEqual(range, (Segment)highlighter)) continue;
            model2.removeHighlighter(highlighter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredBy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 6: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2markersCache";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 51: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 17: 
            case 25: 
            case 43: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 21: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 23: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infosToRemove";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 33: 
            case 36: 
            case 39: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlappingIntervals";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCoveredByOffsets";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlighterToEditorIncrementally";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileLevelOrGutterAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersToSingleEditor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersToEditor";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersOutsideRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersInRange";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "incinerateObsoleteHighlighters";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRemoveHighlighter";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRemoveInfoEvenInEssentialMode";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "isWarningCoveredByError";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "isCovered";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "isSevere";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrReuseHighlighterFor";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "getLayer";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOptimizationAllowed";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "disableWhiteSpaceOptimization";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "clearWhiteSpaceOptimizationFlag";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "updateHighlightersByTyping";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "assertMarkupConsistent";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "removeHighlightersWithExactRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HighlightInfoPostFilters {
        private static final ExtensionPointName<HighlightInfoPostFilter> EP_NAME = new ExtensionPointName("com.intellij.highlightInfoPostFilter");

        private HighlightInfoPostFilters() {
        }

        private static boolean accept(@NotNull Project project2, @NotNull HighlightInfo info2) {
            if (project2 == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(0);
            }
            if (info2 == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(1);
            }
            for (HighlightInfoPostFilter filter2 : EP_NAME.getExtensions(project2)) {
                if (filter2.accept(info2)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private static List<HighlightInfo> applyPostFilter(@NotNull Project project2, @NotNull List<? extends HighlightInfo> highlightInfos) {
            if (project2 == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(2);
            }
            if (highlightInfos == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(3);
            }
            ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(highlightInfos.size());
            for (HighlightInfo highlightInfo : highlightInfos) {
                if (!HighlightInfoPostFilters.accept(project2, highlightInfo)) continue;
                result2.add(highlightInfo);
            }
            ArrayList<HighlightInfo> arrayList = result2;
            if (arrayList == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfos";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil$HighlightInfoPostFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil$HighlightInfoPostFilters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPostFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPostFilter";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static class InternalLayerSuppliers {
        private static final ExtensionPointName<InternalLayerSupplier> EP_NAME = ExtensionPointName.create("com.intellij.internalHighlightingLayerSupplier");

        private InternalLayerSuppliers() {
        }

        private static int getLayerFromSuppliers(@NotNull HighlightInfo info2) {
            if (info2 == null) {
                InternalLayerSuppliers.$$$reportNull$$$0(0);
            }
            for (InternalLayerSupplier extension2 : EP_NAME.getExtensions()) {
                int layer = extension2.getLayer(info2);
                if (layer <= 0) continue;
                return layer;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil$InternalLayerSuppliers", "getLayerFromSuppliers"));
        }
    }
}

