/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class VisibleHighlightingPassFactory {
    private static final Key<ProperTextRange> HEADLESS_VISIBLE_AREA = Key.create("Editor.headlessVisibleArea");

    @NotNull
    public static ProperTextRange calculateVisibleRange(@NotNull Editor editor2) {
        if (editor2 == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ProperTextRange textRange = (ProperTextRange)editor2.getUserData(HEADLESS_VISIBLE_AREA);
            ProperTextRange entireTextRange = new ProperTextRange(0, editor2.getDocument().getTextLength());
            if (textRange != null && entireTextRange.contains(textRange)) {
                ProperTextRange properTextRange = textRange;
                if (properTextRange == null) {
                    VisibleHighlightingPassFactory.$$$reportNull$$$0(1);
                }
                return properTextRange;
            }
            ProperTextRange properTextRange = entireTextRange;
            if (properTextRange == null) {
                VisibleHighlightingPassFactory.$$$reportNull$$$0(2);
            }
            return properTextRange;
        }
        Rectangle rect2 = editor2.getScrollingModel().getVisibleArea();
        LogicalPosition startPosition = editor2.xyToLogicalPosition(new Point(rect2.x, rect2.y));
        int visibleStart = editor2.logicalPositionToOffset(startPosition);
        LogicalPosition endPosition = editor2.xyToLogicalPosition(new Point(rect2.x + rect2.width, rect2.y + rect2.height));
        int visibleEnd = editor2.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
        return new ProperTextRange(visibleStart, Math.max(visibleEnd, visibleStart));
    }

    public static void setVisibleRangeForHeadlessMode(@NotNull Editor editor2, @NotNull ProperTextRange range) {
        if (editor2 == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        if (range == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(4);
        }
        if (range.getEndOffset() > editor2.getDocument().getTextLength()) {
            throw new IllegalArgumentException("Invalid range: " + range + "; document length: " + editor2.getDocument().getTextLength());
        }
        editor2.putUserData(HEADLESS_VISIBLE_AREA, (Object)range);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateVisibleRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateVisibleRange";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setVisibleRangeForHeadlessMode";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

