/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
final class WholeFileLocalInspectionPassTracker
implements Disposable {
    private final Set<PsiFile> mySkipWholeInspectionsCache;
    private final ObjectIntMap<PsiFile> myPsiModificationCount;

    WholeFileLocalInspectionPassTracker(@NotNull Project project2) {
        if (project2 == null) {
            WholeFileLocalInspectionPassTracker.$$$reportNull$$$0(0);
        }
        this.mySkipWholeInspectionsCache = ContainerUtil.createWeakSet();
        this.myPsiModificationCount = ContainerUtil.createWeakKeyIntValueMap();
        project2.getMessageBus().connect().subscribe(ProfileChangeAdapter.TOPIC, new ProfileChangeAdapter(){

            @Override
            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    1.$$$reportNull$$$0(0);
                }
                WholeFileLocalInspectionPassTracker.this.clearCaches();
            }

            @Override
            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                WholeFileLocalInspectionPassTracker.this.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionPassTracker$1", "profileChanged"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canSkipFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            WholeFileLocalInspectionPassTracker.$$$reportNull$$$0(1);
        }
        Set<PsiFile> set2 = this.mySkipWholeInspectionsCache;
        synchronized (set2) {
            if (this.mySkipWholeInspectionsCache.contains(file2)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lookThereAreNoWholeFileToolsConfiguredForThisFileSoWeCanProbablySkipItAltogether(@NotNull PsiFile file2) {
        if (file2 == null) {
            WholeFileLocalInspectionPassTracker.$$$reportNull$$$0(2);
        }
        Set<PsiFile> set2 = this.mySkipWholeInspectionsCache;
        synchronized (set2) {
            this.mySkipWholeInspectionsCache.add(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informationApplied(@NotNull PsiFile file2) {
        if (file2 == null) {
            WholeFileLocalInspectionPassTracker.$$$reportNull$$$0(3);
        }
        long modificationCount = file2.getManager().getModificationTracker().getModificationCount();
        ObjectIntMap<PsiFile> objectIntMap = this.myPsiModificationCount;
        synchronized (objectIntMap) {
            this.myPsiModificationCount.put(file2, (int)modificationCount);
        }
    }

    static WholeFileLocalInspectionPassTracker getInstance(Project project2) {
        return project2.getService(WholeFileLocalInspectionPassTracker.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isChanged(@NotNull PsiFile file2) {
        if (file2 == null) {
            WholeFileLocalInspectionPassTracker.$$$reportNull$$$0(4);
        }
        long actualCount = file2.getManager().getModificationTracker().getModificationCount();
        ObjectIntMap<PsiFile> objectIntMap = this.myPsiModificationCount;
        synchronized (objectIntMap) {
            return actualCount != (long)this.myPsiModificationCount.get(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Object object = this.mySkipWholeInspectionsCache;
        synchronized (object) {
            this.mySkipWholeInspectionsCache.clear();
        }
        object = this.myPsiModificationCount;
        synchronized (object) {
            this.myPsiModificationCount.clear();
        }
    }

    @Override
    public void dispose() {
        this.clearCaches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionPassTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canSkipFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lookThereAreNoWholeFileToolsConfiguredForThisFileSoWeCanProbablySkipItAltogether";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "informationApplied";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

