/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.WholeFileLocalInspectionPassTracker;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WholeFileLocalInspectionsPassFactory
implements MainHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    WholeFileLocalInspectionsPassFactory() {
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(0);
        }
        if (document == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(1);
        }
        if (highlightInfoProcessor == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(2);
        }
        return this.createPass(file2, TextRange.EMPTY_RANGE, document);
    }

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        if (registrar == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(4);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        WholeFileLocalInspectionPassTracker tracker;
        if (file2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(6);
        }
        if (!(tracker = WholeFileLocalInspectionPassTracker.getInstance(file2.getProject())).isChanged(file2)) {
            return null;
        }
        if (tracker.canSkipFile(file2)) {
            return null;
        }
        ProperTextRange visibleRange = HighlightingSessionImpl.getFromCurrentIndicator(file2).getVisibleRange();
        return this.createPass(file2, visibleRange, editor2.getDocument());
    }

    @NotNull
    private LocalInspectionsPass createPass(final @NotNull PsiFile file2, @NotNull TextRange visibleRange, @NotNull Document document) {
        if (file2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(7);
        }
        if (visibleRange == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(8);
        }
        if (document == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(9);
        }
        return new LocalInspectionsPass(file2, document, 0, file2.getTextLength(), visibleRange, true, new DefaultHighlightInfoProcessor(), false){

            @Override
            protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
                if (wrapper2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return wrapper2.runForWholeFile();
            }

            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
                List<LocalInspectionToolWrapper> result2;
                if (profile == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((result2 = super.getInspectionTools(profile)).isEmpty()) {
                    WholeFileLocalInspectionPassTracker tracker = WholeFileLocalInspectionPassTracker.getInstance(file2.getProject());
                    tracker.lookThereAreNoWholeFileToolsConfiguredForThisFileSoWeCanProbablySkipItAltogether(file2);
                }
                List<LocalInspectionToolWrapper> list2 = result2;
                if (list2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message("pass.whole.inspections", new Object[0]);
            }

            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                WholeFileLocalInspectionPassTracker.getInstance(file2.getProject()).informationApplied(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wrapper";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInspectionTools";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isAcceptableLocalTool";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getInspectionTools";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRange";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainHighlightingPass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

