/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.WolfTheProblemSolverImpl;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.CommonProcessors;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class WolfListeners
implements Disposable {
    private final Project myProject;
    private final WolfTheProblemSolverImpl myWolfTheProblemSolver;
    private final MergingUpdateQueue invalidateFileQueue;

    WolfListeners(@NotNull Project project2, final @NotNull WolfTheProblemSolverImpl wolfTheProblemSolver) {
        if (project2 == null) {
            WolfListeners.$$$reportNull$$$0(0);
        }
        if (wolfTheProblemSolver == null) {
            WolfListeners.$$$reportNull$$$0(1);
        }
        this.invalidateFileQueue = new MergingUpdateQueue("WolfListeners.invalidateFileQueue", 0, true, null, (Disposable)this, null, false);
        this.myProject = project2;
        this.myWolfTheProblemSolver = wolfTheProblemSolver;
        PsiManager.getInstance(project2).addPsiTreeChangeListener(new PsiTreeChangeAdapter(){

            @Override
            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.childrenChanged(event);
            }

            @Override
            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.childrenChanged(event);
            }

            @Override
            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.childrenChanged(event);
            }

            @Override
            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.childrenChanged(event);
            }

            @Override
            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.childrenChanged(event);
            }

            @Override
            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                WolfListeners.this.myWolfTheProblemSolver.clearSyntaxErrorFlag(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WolfListeners$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        SimpleMessageBusConnection busConnection = project2.getMessageBus().simpleConnect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean dirChanged = false;
                HashSet<VirtualFile> toRemove2 = new HashSet<VirtualFile>();
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2.isDirectory()) {
                        dirChanged = true;
                        continue;
                    }
                    toRemove2.add(file2);
                }
                if (dirChanged) {
                    WolfListeners.this.clearInvalidFiles();
                }
                for (VirtualFile virtualFile2 : toRemove2) {
                    WolfListeners.this.myWolfTheProblemSolver.doRemove(virtualFile2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/codeInsight/daemon/impl/WolfListeners$2", "after"));
            }
        });
        busConnection.subscribe(FileStatusListener.TOPIC, new FileStatusListener(){

            public void fileStatusesChanged() {
                WolfListeners.this.clearInvalidFiles();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.fileStatusesChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/daemon/impl/WolfListeners$3", "fileStatusChanged"));
            }
        });
        busConnection.subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                HashSet allFiles = new HashSet();
                wolfTheProblemSolver.processProblemFiles(new CommonProcessors.CollectProcessor(allFiles));
                wolfTheProblemSolver.processProblemFilesFromExternalSources(new CommonProcessors.CollectProcessor(allFiles));
                for (VirtualFile file2 : allFiles) {
                    WolfListeners.this.myWolfTheProblemSolver.doRemove(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/daemon/impl/WolfListeners$4", "beforePluginUnload"));
            }
        });
    }

    private void clearInvalidFiles() {
        this.myWolfTheProblemSolver.processProblemFiles(file2 -> {
            this.invalidateFileQueue.queue(Update.create((Object)file2, () -> {
                boolean toRemove2 = ReadAction.compute(() -> !this.myProject.isDisposed() && (!file2.isValid() || !this.myWolfTheProblemSolver.isToBeHighlighted((VirtualFile)file2)));
                if (toRemove2) {
                    this.myWolfTheProblemSolver.doRemove((VirtualFile)file2);
                }
            }));
            return true;
        });
    }

    @Override
    public void dispose() {
    }

    @TestOnly
    void waitForFilesQueuedForInvalidationAreProcessed() {
        try {
            this.invalidateFileQueue.waitForAllExecuted(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "wolfTheProblemSolver";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/WolfListeners";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

