/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.WolfListeners;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class WolfTheProblemSolverImpl
extends WolfTheProblemSolver
implements Disposable {
    private final Map<VirtualFile, ProblemFileInfo> myProblems;
    private final Map<VirtualFile, Set<Object>> myProblemsFromExternalSources;
    private final Collection<VirtualFile> myCheckingQueue;
    private final Project myProject;
    private final WolfListeners myWolfListeners;

    private WolfTheProblemSolverImpl(@NotNull Project project2) {
        if (project2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(0);
        }
        this.myProblems = new ConcurrentHashMap<VirtualFile, ProblemFileInfo>();
        this.myProblemsFromExternalSources = new ConcurrentHashMap<VirtualFile, Set<Object>>();
        this.myCheckingQueue = new HashSet<VirtualFile>(10);
        this.myProject = project2;
        this.myWolfListeners = new WolfListeners(project2, this);
        Disposer.register(this, this.myWolfListeners);
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemove(@NotNull VirtualFile problemFile) {
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(1);
        }
        ProblemFileInfo old = this.myProblems.remove(problemFile);
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.remove(problemFile);
        }
        if (old != null) {
            if (this.hasProblemsFromExternalSources(problemFile)) {
                this.fireProblemsChanged(problemFile);
            } else {
                this.fireProblemsDisappeared(problemFile);
            }
        }
    }

    void clearSyntaxErrorFlag(@NotNull PsiTreeChangeEvent event) {
        PsiFile file2;
        if (event == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(2);
        }
        if ((file2 = event.getFile()) == null) {
            return;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        ProblemFileInfo info2 = this.myProblems.get(virtualFile2);
        if (info2 != null) {
            info2.hasSyntaxErrors = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCheckingIfVincentSolvedProblemsYet(@NotNull ProgressIndicator progress, @NotNull ProgressableTextEditorHighlightingPass pass2) throws ProcessCanceledException {
        ArrayList<VirtualFile> files2;
        if (progress == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(3);
        }
        if (pass2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(4);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            files2 = new ArrayList<VirtualFile>(this.myCheckingQueue);
        }
        long progressLimit = files2.stream().filter(VirtualFile::isValid).mapToLong(VirtualFile::getLength).sum();
        pass2.setProgressLimit(progressLimit);
        for (VirtualFile virtualFile2 : files2) {
            progress.checkCanceled();
            if (virtualFile2 == null) break;
            if (!virtualFile2.isValid() || this.orderVincentToCleanTheCar(virtualFile2, progress)) {
                this.doRemove(virtualFile2);
            }
            if (!virtualFile2.isValid()) continue;
            pass2.advanceProgress(virtualFile2.getLength());
        }
    }

    private boolean orderVincentToCleanTheCar(@NotNull VirtualFile file2, @NotNull ProgressIndicator progressIndicator) throws ProcessCanceledException {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(5);
        }
        if (progressIndicator == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(6);
        }
        if (!this.isToBeHighlighted(file2)) {
            this.clearProblems(file2);
            return true;
        }
        if (this.hasSyntaxErrors(file2)) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.willBeHighlightedAnyway(file2)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(file2);
        if (psiFile == null) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        final AtomicReference error2 = new AtomicReference();
        final AtomicBoolean hasErrorElement = new AtomicBoolean();
        try {
            ProperTextRange visibleRange = new ProperTextRange(0, document.getTextLength());
            HighlightingSessionImpl.getOrCreateHighlightingSession(psiFile, (DaemonProgressIndicator)progressIndicator, visibleRange);
            GeneralHighlightingPass pass2 = new GeneralHighlightingPass(psiFile, document, 0, document.getTextLength(), false, visibleRange, null, HighlightInfoProcessor.getEmpty()){

                @Override
                @NotNull
                protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new HighlightInfoHolder(file2, new HighlightInfoFilter[0]){

                        @Override
                        public boolean add(@Nullable HighlightInfo info2) {
                            if (info2 != null && info2.getSeverity() == HighlightSeverity.ERROR) {
                                error2.set(info2);
                                hasErrorElement.set(myHasErrorElement);
                                throw new ProcessCanceledException();
                            }
                            return super.add(info2);
                        }
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/WolfTheProblemSolverImpl$1", "createInfoHolder"));
                }
            };
            pass2.collectInformation(progressIndicator);
        }
        catch (ProcessCanceledException e) {
            if (error2.get() != null) {
                ProblemImpl problem = new ProblemImpl(file2, (HighlightInfo)error2.get(), hasErrorElement.get());
                this.reportProblems(file2, Collections.singleton(problem));
            }
            return false;
        }
        this.clearProblems(file2);
        return true;
    }

    @Override
    public boolean hasSyntaxErrors(@NotNull VirtualFile file2) {
        ProblemFileInfo info2;
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(7);
        }
        return (info2 = this.myProblems.get(file2)) != null && info2.hasSyntaxErrors;
    }

    private boolean willBeHighlightedAnyway(@NotNull VirtualFile file2) {
        FileEditor[] selectedEditors;
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(8);
        }
        for (FileEditor editor2 : selectedEditors = FileEditorManager.getInstance(this.myProject).getSelectedEditors()) {
            if (!(editor2 instanceof TextEditor)) continue;
            Document document = ((TextEditor)editor2).getEditor().getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getCachedPsiFile(document);
            if (psiFile == null || !Comparing.equal(file2, psiFile.getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasProblemFilesBeneath(@NotNull Condition<? super VirtualFile> condition) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(9);
        }
        if (!this.myProject.isOpen()) {
            return false;
        }
        return WolfTheProblemSolverImpl.checkProblemFilesInMap(condition, this.myProblems) || WolfTheProblemSolverImpl.checkProblemFilesInMap(condition, this.myProblemsFromExternalSources);
    }

    private static boolean checkProblemFilesInMap(@NotNull Condition<? super VirtualFile> condition, @NotNull Map<? extends VirtualFile, ?> map2) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(10);
        }
        if (map2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(11);
        }
        if (!map2.isEmpty()) {
            for (VirtualFile virtualFile2 : map2.keySet()) {
                if (!virtualFile2.isValid() || !condition.value(virtualFile2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasProblemFilesBeneath(@NotNull Module scope) {
        if (scope == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(12);
        }
        return this.hasProblemFilesBeneath((? super VirtualFile virtualFile2) -> ModuleUtilCore.moduleContainsFile(scope, virtualFile2, false));
    }

    @Override
    public void addProblemListener(@NotNull WolfTheProblemSolver.ProblemListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(14);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(ProblemListener.TOPIC, listener2);
    }

    @Override
    public void queue(@NotNull VirtualFile suspiciousFile) {
        if (suspiciousFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.isToBeHighlighted(suspiciousFile)) {
            return;
        }
        this.doQueue(suspiciousFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull VirtualFile suspiciousFile) {
        if (suspiciousFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(16);
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.add(suspiciousFile);
        }
    }

    @Override
    public boolean isProblemFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(17);
        }
        return this.hasRegularProblems(virtualFile2) || this.hasProblemsFromExternalSources(virtualFile2);
    }

    private boolean hasRegularProblems(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(18);
        }
        return this.myProblems.containsKey(virtualFile2);
    }

    private boolean hasProblemsFromExternalSources(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(19);
        }
        return this.myProblemsFromExternalSources.containsKey(virtualFile2);
    }

    boolean isToBeHighlighted(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(20);
        }
        return ReadAction.compute(() -> {
            for (Condition filter2 : (Condition[])FILTER_EP_NAME.getExtensions(this.myProject)) {
                ProgressManager.checkCanceled();
                if (!filter2.value(virtualFile2)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public void weHaveGotProblems(@NotNull VirtualFile virtualFile2, @NotNull List<? extends Problem> problems) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(21);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (problems.isEmpty()) {
            return;
        }
        if (!this.isToBeHighlighted(virtualFile2)) {
            return;
        }
        this.weHaveGotNonIgnorableProblems(virtualFile2, problems);
    }

    @Override
    public void weHaveGotNonIgnorableProblems(@NotNull VirtualFile virtualFile2, @NotNull List<? extends Problem> problems) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(23);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(24);
        }
        if (problems.isEmpty()) {
            return;
        }
        ProblemFileInfo storedProblems = this.myProblems.computeIfAbsent(virtualFile2, __ -> new ProblemFileInfo());
        boolean fireListener = storedProblems.problems.isEmpty();
        storedProblems.problems.addAll(problems);
        this.doQueue(virtualFile2);
        if (fireListener) {
            if (this.hasProblemsFromExternalSources(virtualFile2)) {
                this.fireProblemsChanged(virtualFile2);
            } else {
                this.fireProblemsAppeared(virtualFile2);
            }
        }
    }

    private void fireProblemsAppeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(25);
        }
        this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC).problemsAppeared(file2);
    }

    private void fireProblemsChanged(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(26);
        }
        this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC).problemsChanged(virtualFile2);
    }

    private void fireProblemsDisappeared(@NotNull VirtualFile problemFile) {
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(27);
        }
        this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC).problemsDisappeared(problemFile);
    }

    @Override
    public void clearProblems(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(28);
        }
        this.doRemove(virtualFile2);
    }

    @Override
    public Problem convertToProblem(@NotNull VirtualFile virtualFile2, int line, int column, String @NotNull [] message) {
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(29);
        }
        if (message == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(30);
        }
        if (virtualFile2.isDirectory() || virtualFile2.getFileType().isBinary()) {
            return null;
        }
        HighlightInfo info2 = ReadAction.compute(() -> {
            TextRange textRange = WolfTheProblemSolverImpl.getTextRange(virtualFile2, line, column);
            String description = StringUtil.join(message, "\n");
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        });
        if (info2 == null) {
            return null;
        }
        return new ProblemImpl(virtualFile2, info2, false);
    }

    @Override
    public void reportProblems(@NotNull VirtualFile file2, @NotNull Collection<? extends Problem> problems) {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(31);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(32);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (problems.isEmpty()) {
            this.clearProblems(file2);
            return;
        }
        if (!this.isToBeHighlighted(file2)) {
            return;
        }
        ProblemFileInfo newInfo = new ProblemFileInfo();
        for (Problem problem : problems) {
            newInfo.problems.add(problem);
            newInfo.hasSyntaxErrors |= ((ProblemImpl)problem).isSyntaxOnly();
        }
        ProblemFileInfo oldInfo = this.myProblems.put(file2, newInfo);
        boolean hasProblemsBefore = oldInfo != null;
        boolean fireChanged = hasProblemsBefore && !oldInfo.equals(newInfo);
        this.doQueue(file2);
        boolean bl = this.hasProblemsFromExternalSources(file2);
        if (!hasProblemsBefore && !bl) {
            this.fireProblemsAppeared(file2);
        } else if (fireChanged || bl) {
            this.fireProblemsChanged(file2);
        }
    }

    @Override
    public void reportProblemsFromExternalSource(@NotNull VirtualFile file2, @NotNull Object source) {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(33);
        }
        if (source == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.isToBeHighlighted(file2)) {
            return;
        }
        Set problems = this.myProblemsFromExternalSources.computeIfAbsent(file2, __ -> ContainerUtil.newConcurrentSet());
        boolean isNewFileForExternalSource = problems.isEmpty();
        problems.add(source);
        if (isNewFileForExternalSource && !this.hasRegularProblems(file2)) {
            this.fireProblemsAppeared(file2);
        } else {
            this.fireProblemsChanged(file2);
        }
    }

    @Override
    public void clearProblemsFromExternalSource(@NotNull VirtualFile file2, @NotNull Object source) {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(35);
        }
        if (source == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        AtomicBoolean isLastExternalSource = new AtomicBoolean();
        this.myProblemsFromExternalSources.compute(file2, (__, problems) -> {
            if (problems == null) {
                return null;
            }
            problems.remove(source);
            boolean wasLastProblem = problems.isEmpty();
            isLastExternalSource.set(wasLastProblem);
            return wasLastProblem ? null : problems;
        });
        if (isLastExternalSource.get() && !this.hasRegularProblems(file2)) {
            this.fireProblemsDisappeared(file2);
        } else {
            this.fireProblemsChanged(file2);
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull VirtualFile virtualFile2, int line, int column) {
        Document document;
        if (virtualFile2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(37);
        }
        if (line > (document = FileDocumentManager.getInstance().getDocument(virtualFile2)).getLineCount()) {
            line = document.getLineCount();
        }
        line = line <= 0 ? 0 : line - 1;
        int offset2 = document.getLineStartOffset(line) + (column <= 0 ? 0 : column - 1);
        return new TextRange(offset2, offset2);
    }

    public boolean processProblemFiles(@NotNull Processor<? super VirtualFile> processor) {
        if (processor == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(38);
        }
        return ContainerUtil.process(this.myProblems.keySet(), processor);
    }

    public boolean processProblemFilesFromExternalSources(@NotNull Processor<? super VirtualFile> processor) {
        if (processor == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(39);
        }
        return ContainerUtil.process(this.myProblemsFromExternalSources.keySet(), processor);
    }

    @NotNull
    @TestOnly
    public static WolfTheProblemSolver createTestInstance(@NotNull Project project2) {
        if (project2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(40);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return new WolfTheProblemSolverImpl(project2);
    }

    @TestOnly
    void waitForFilesQueuedForInvalidationAreProcessed() {
        this.myWolfListeners.waitForFilesQueuedForInvalidationAreProcessed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 25: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspiciousFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 22: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WolfTheProblemSolverImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doRemove";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearSyntaxErrorFlag";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startCheckingIfVincentSolvedProblemsYet";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "orderVincentToCleanTheCar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSyntaxErrors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "willBeHighlightedAnyway";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProblemFilesBeneath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProblemFilesInMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addProblemListener";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "queue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doQueue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isProblemFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRegularProblems";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProblemsFromExternalSources";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isToBeHighlighted";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "weHaveGotProblems";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "weHaveGotNonIgnorableProblems";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsAppeared";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsChanged";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsDisappeared";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProblems";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToProblem";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProblems";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProblemsFromExternalSource";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProblemsFromExternalSource";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextRange";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "processProblemFiles";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "processProblemFilesFromExternalSources";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProblemFileInfo {
        private final Collection<Problem> problems = ContainerUtil.newConcurrentSet();
        private volatile boolean hasSyntaxErrors;

        private ProblemFileInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemFileInfo that = (ProblemFileInfo)o;
            return this.hasSyntaxErrors == that.hasSyntaxErrors && this.problems.equals(that.problems);
        }

        public int hashCode() {
            int result2 = this.problems.hashCode();
            result2 = 31 * result2 + (this.hasSyntaxErrors ? 1 : 0);
            return result2;
        }
    }
}

