/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBatchSuppressByNoInspectionCommentFix
implements ContainerBasedSuppressQuickFix,
InjectionAwareSuppressQuickFix,
Iconable {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;
    private ThreeState myShouldBeAppliedToInjectionHost;
    @IntentionName
    private String myText;

    @Override
    @Nullable
    public abstract PsiElement getContainer(PsiElement var1);

    public AbstractBatchSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        if (ID2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(0);
        }
        this.myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;
        this.myText = "";
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    @Override
    public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
        if (shouldBeAppliedToInjectionHost == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(1);
        }
        this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
    }

    @Override
    @NotNull
    public ThreeState isShouldBeAppliedToInjectionHost() {
        ThreeState threeState = this.myShouldBeAppliedToInjectionHost;
        if (threeState == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(2);
        }
        return threeState;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getText();
        if (string2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public Icon getIcon(int flags) {
        return AllIcons.Ide.HectorOff;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string2 = this.myText;
        if (string2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(4);
        }
        return string2;
    }

    protected void setText(@IntentionName @NotNull String text2) {
        if (text2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(5);
        }
        this.myText = text2;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(7);
        }
        if ((element = descriptor2.getStartElement()) == null) {
            return;
        }
        this.invoke(project2, element);
    }

    @Override
    public boolean isSuppressAll() {
        return "ALL".equalsIgnoreCase(this.myID);
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (comment == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(8);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(comment)) {
            return;
        }
        WriteAction.run(() -> SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment)));
    }

    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(9);
        }
        if (element == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(10);
        }
        if (container == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(11);
        }
        SuppressionUtil.createSuppression(project2, container, this.myID, this.getCommentLanguage(element));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element) {
        if (element == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(12);
        }
        Language language = element.getLanguage();
        if (language == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(13);
        }
        return language;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context2) {
        if (project2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(15);
        }
        return context2.isValid() && this.getContainer(context2) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(16);
        }
        if (element == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(17);
        }
        if (!this.isAvailable(project2, element)) {
            return;
        }
        PsiElement container = this.getContainer(element);
        PsiFile file2 = element.getContainingFile();
        if (container == null) {
            return;
        }
        if (this.replaceSuppressionComments(container)) {
            return;
        }
        this.createSuppression(project2, element, container);
        UndoUtil.markPsiFileForUndo(file2);
    }

    protected boolean replaceSuppressionComments(@NotNull PsiElement container) {
        List<? extends PsiElement> comments;
        if (container == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(18);
        }
        if ((comments = this.getCommentsFor(container)) != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                this.replaceSuppressionComment(psiElement);
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        PsiElement prev;
        if (container == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(19);
        }
        if ((prev = PsiTreeUtil.skipWhitespacesBackward(container)) == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
        if (project2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(20);
        }
        if (previewDescriptor == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(21);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(22);
        }
        return intentionPreviewInfo;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String text2 = this.getText();
        String string2 = StringUtil.isEmpty(text2) ? AnalysisBundle.message("suppress.inspection.family", new Object[0]) : text2;
        if (string2 == null) {
            AbstractBatchSuppressByNoInspectionCommentFix.$$$reportNull$$$0(23);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 13, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldBeAppliedToInjectionHost";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "isShouldBeAppliedToInjectionHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentLanguage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setShouldBeAppliedToInjectionHost";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceSuppressionComment";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommentLanguage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceSuppressionComments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsFor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 13, 22, 23 -> new IllegalStateException(string2);
        };
    }
}

