/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableHighlightingIntentionAction
extends IntentionAndQuickFixAction {
    private final String myShortName;

    public DisableHighlightingIntentionAction(String shortName) {
        this.myShortName = shortName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = AnalysisBundle.message("intention.family.name.disable.highlighting.keep.fix", new Object[0]);
        if (string2 == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        InspectionProfileImpl profile;
        HighlightSeverity usedSeverity;
        if (project2 == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(1);
        }
        return (usedSeverity = (profile = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile()).getErrorLevel(HighlightDisplayKey.find(this.myShortName), file2).getSeverity()).compareTo(HighlightSeverity.INFORMATION) > 0;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getFamilyName();
        if (string2 == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public void applyFix(@NotNull Project project2, PsiFile file2, @Nullable Editor editor2) {
        if (project2 == null) {
            DisableHighlightingIntentionAction.$$$reportNull$$$0(3);
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project2, it -> {
            ToolsImpl tools = it.getToolsOrNull(this.myShortName, project2);
            if (tools != null) {
                tools.setLevel(HighlightDisplayLevel.DO_NOT_SHOW);
            }
        });
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/DisableHighlightingIntentionAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/DisableHighlightingIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3 -> new IllegalArgumentException(string2);
        };
    }
}

