/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class FixAllHighlightingProblems
implements IntentionAction {
    private final IntentionActionWithFixAllOption myAction;

    FixAllHighlightingProblems(@NotNull IntentionActionWithFixAllOption action2) {
        if (action2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(0);
        }
        this.myAction = action2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = this.myAction.getFixAllText();
        if (string2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = AnalysisBundle.message("intention.family.name.fix.all.problems.like.this", new Object[0]);
        if (string2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(4);
        }
        ArrayList actions = new ArrayList();
        Document document = editor2.getDocument();
        Processor<HighlightInfo> processor = info2 -> {
            IntentionAction fix2 = info2.getSameFamilyFix(this.myAction);
            if (fix2 != null) {
                TextRange range = TextRange.create(info2.getActualStartOffset(), info2.getActualEndOffset());
                SmartPsiFileRange pointer = SmartPointerManager.getInstance(project2).createSmartPsiFileRangePointer(file2, range);
                actions.add(Pair.create(fix2, pointer));
            }
            return true;
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> DaemonCodeAnalyzerEx.processHighlights(document, project2, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)processor)), AnalysisBundle.message("command.name.gather.fixes", new Object[0]), true, project2)) {
            return;
        }
        if (actions.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite(file2)) {
            return;
        }
        Collections.reverse(actions);
        ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(this.myAction.getFamilyName(), project2, null, indicator -> {
            indicator.setIndeterminate(false);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project2);
            for (int i2 = 0; i2 < actions.size(); ++i2) {
                indicator.setFraction((double)i2 / (double)actions.size());
                Pair pair = (Pair)actions.get(i2);
                IntentionAction action2 = (IntentionAction)pair.getFirst();
                Segment range = ((SmartPsiFileRange)pair.getSecond()).getRange();
                if (range == null) continue;
                editor2.getCaretModel().moveToOffset(range.getStartOffset());
                if (!action2.isAvailable(project2, editor2, file2)) continue;
                action2.invoke(project2, editor2, file2);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                psiDocumentManager.commitDocument(document);
            }
        });
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

