/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

abstract class GotoElementUnderCaretUsageBase
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    @NotNull
    private final Direction myDirection;

    GotoElementUnderCaretUsageBase(@NotNull Direction direction) {
        if (direction == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(0);
        }
        this.myDirection = direction;
    }

    @Override
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoElementUnderCaretUsageBase gotoElementUnderCaretUsageBase = this;
        if (gotoElementUnderCaretUsageBase == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(1);
        }
        return gotoElementUnderCaretUsageBase;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(4);
        }
        Comparator<Integer> ordering = this.myDirection.ordering;
        int caretOffset = editor2.getCaretModel().getOffset();
        int startOffset = file2.getTextRange().getStartOffset();
        int endOffset = file2.getTextRange().getEndOffset();
        Ref first2 = new Ref();
        Ref next2 = new Ref();
        DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)editor2.getMarkupModel(), project2, null, startOffset, endOffset, info2 -> {
            if (HighlightInfoType.ELEMENT_UNDER_CARET_READ.equals(info2.type) || HighlightInfoType.ELEMENT_UNDER_CARET_WRITE.equals(info2.type)) {
                if (ordering.compare(info2.startOffset, caretOffset) > 0 && ordering.compare(info2.endOffset, caretOffset) > 0 && (next2.isNull() || ordering.compare((Integer)next2.get(), info2.startOffset) > 0)) {
                    next2.set(info2.startOffset);
                }
                if (first2.isNull() || ordering.compare((Integer)first2.get(), info2.startOffset) > 0) {
                    first2.set(info2.startOffset);
                }
            }
            return true;
        });
        if (!next2.isNull()) {
            GotoElementUnderCaretUsageBase.moveCaret(editor2, (Integer)next2.get());
        } else if (!first2.isNull()) {
            GotoElementUnderCaretUsageBase.moveCaret(editor2, (Integer)first2.get());
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static void moveCaret(Editor editor2, int toOffset) {
        Caret caret = editor2.getCaretModel().getCurrentCaret();
        caret.removeSelection();
        caret.moveToOffset(toOffset);
        FoldingModel foldingModel = editor2.getFoldingModel();
        FoldRegion region = foldingModel.getCollapsedRegionAtOffset(toOffset);
        if (region != null) {
            foldingModel.runBatchFoldingOperation(() -> region.setExpanded(true));
        }
        if (caret == editor2.getCaretModel().getPrimaryCaret()) {
            editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/GotoElementUnderCaretUsageBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/GotoElementUnderCaretUsageBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    protected static enum Direction {
        FORWARD(Comparator.naturalOrder()),
        BACKWARD(Comparator.reverseOrder());

        public final Comparator<Integer> ordering;

        private Direction(Comparator<Integer> ordering) {
            this.ordering = ordering;
        }
    }
}

