/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingReference
implements PsiReference,
EmptyResolveMessageProvider {
    private final PsiElement myElement;
    private final String myCharsetName;
    private final TextRange myRangeInElement;

    public EncodingReference(PsiElement element, String charsetName, TextRange rangeInElement) {
        this.myElement = element;
        this.myCharsetName = charsetName;
        this.myRangeInElement = rangeInElement;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            EncodingReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            EncodingReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        return CharsetToolkit.forName(this.myCharsetName) == null ? null : this.myElement;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = this.myCharsetName;
        if (string2 == null) {
            EncodingReference.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            EncodingReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            EncodingReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            EncodingReference.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Override
    public Object @NotNull [] getVariants() {
        Charset[] charsets = CharsetToolkit.getAvailableCharsets();
        ArrayList<LookupElementBuilder> suggestions = new ArrayList<LookupElementBuilder>(charsets.length);
        for (Charset charset : charsets) {
            suggestions.add(LookupElementBuilder.create(charset.name()).withCaseSensitivity(false));
        }
        Object[] objectArray = suggestions.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            EncodingReference.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String string2 = CodeInsightBundle.message("unknown.encoding.0", new Object[0]);
        if (string2 == null) {
            EncodingReference.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/EncodingReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/EncodingReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }
}

