/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(RenameElementFix.class);
    private final String myNewName;
    @IntentionName
    private final String myText;

    public RenameElementFix(@NotNull PsiNamedElement element) {
        if (element == null) {
            RenameElementFix.$$$reportNull$$$0(0);
        }
        super(element);
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        assert (vFile != null) : element;
        this.myNewName = vFile.getNameWithoutExtension();
        this.myText = CodeInsightBundle.message("rename.public.class.text", element.getName(), this.myNewName);
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName2) {
        if (element == null) {
            RenameElementFix.$$$reportNull$$$0(1);
        }
        if (newName2 == null) {
            RenameElementFix.$$$reportNull$$$0(2);
        }
        this(element, newName2, CodeInsightBundle.message("rename.named.element.text", element.getName(), newName2));
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName2, @NotNull @IntentionName String text2) {
        if (element == null) {
            RenameElementFix.$$$reportNull$$$0(3);
        }
        if (newName2 == null) {
            RenameElementFix.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            RenameElementFix.$$$reportNull$$$0(5);
        }
        super(element);
        this.myNewName = newName2;
        this.myText = text2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = this.myText;
        if (string2 == null) {
            RenameElementFix.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("rename.element.family", new Object[0]);
        if (string2 == null) {
            RenameElementFix.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            RenameElementFix.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            RenameElementFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            RenameElementFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            RenameElementFix.$$$reportNull$$$0(11);
        }
        if (this.isAvailable(project2, null, file2)) {
            LOG.assertTrue(file2 == startElement.getContainingFile());
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            RenameProcessor processor = new RenameProcessor(project2, startElement, this.myNewName, false, false);
            processor.run();
        }
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        PsiElement element;
        if (project2 == null) {
            RenameElementFix.$$$reportNull$$$0(12);
        }
        if (editor2 == null) {
            RenameElementFix.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            RenameElementFix.$$$reportNull$$$0(14);
        }
        if (!((element = PsiTreeUtil.findSameElementInCopy(this.getStartElement(), file2)) instanceof PsiNamedElement)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                RenameElementFix.$$$reportNull$$$0(15);
            }
            return intentionPreviewInfo;
        }
        ((PsiNamedElement)element).setName(this.myNewName);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            RenameElementFix.$$$reportNull$$$0(16);
        }
        return intentionPreviewInfo;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            RenameElementFix.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            RenameElementFix.$$$reportNull$$$0(18);
        }
        if (startElement == null) {
            RenameElementFix.$$$reportNull$$$0(19);
        }
        if (endElement == null) {
            RenameElementFix.$$$reportNull$$$0(20);
        }
        return RenameUtil.isValidName((Project)project2, (PsiElement)startElement, (String)this.myNewName);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix";
                break;
            }
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameElementFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 15, 16 -> new IllegalStateException(string2);
        };
    }
}

