/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RenameFileFix
implements IntentionAction,
LocalQuickFix {
    private final String myNewFileName;

    public RenameFileFix(@NotNull String newFileName) {
        if (newFileName == null) {
            RenameFileFix.$$$reportNull$$$0(0);
        }
        this.myNewFileName = newFileName;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = CodeInsightBundle.message("rename.file.fix", new Object[0]);
        if (string2 == null) {
            RenameFileFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getText();
        if (string2 == null) {
            RenameFileFix.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("rename.file.fix", new Object[0]);
        if (string2 == null) {
            RenameFileFix.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        PsiFile file2;
        if (project2 == null) {
            RenameFileFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            RenameFileFix.$$$reportNull$$$0(5);
        }
        if (this.isAvailable(project2, null, file2 = descriptor2.getPsiElement().getContainingFile())) {
            WriteCommandAction.writeCommandAction(project2).run(() -> this.invoke(project2, null, file2));
        }
    }

    @Override
    public final boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            RenameFileFix.$$$reportNull$$$0(6);
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        VirtualFile parent2 = vFile.getParent();
        if (parent2 == null) {
            return false;
        }
        VirtualFile newVFile = parent2.findChild(this.myNewFileName);
        return newVFile == null || newVFile.equals(vFile);
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            RenameFileFix.$$$reportNull$$$0(7);
        }
        VirtualFile vFile = file2.getVirtualFile();
        Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
        FileDocumentManager.getInstance().saveDocument(document);
        try {
            vFile.rename(file2.getManager(), this.myNewFileName);
        }
        catch (IOException e) {
            MessagesEx.error((Project)project2, (String)e.getMessage()).showLater();
        }
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
        if (project2 == null) {
            RenameFileFix.$$$reportNull$$$0(8);
        }
        if (previewDescriptor == null) {
            RenameFileFix.$$$reportNull$$$0(9);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.rename(previewDescriptor.getPsiElement().getContainingFile(), this.myNewFileName);
        if (intentionPreviewInfo == null) {
            RenameFileFix.$$$reportNull$$$0(10);
        }
        return intentionPreviewInfo;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            RenameFileFix.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            RenameFileFix.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            RenameFileFix.$$$reportNull$$$0(13);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.rename(file2, this.myNewFileName);
        if (intentionPreviewInfo == null) {
            RenameFileFix.$$$reportNull$$$0(14);
        }
        return intentionPreviewInfo;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 10, 14 -> new IllegalStateException(string2);
        };
    }
}

