/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tooltips;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TooltipActionProvider {
    public static final ExtensionPointName<TooltipActionProvider> EP_NAME = ExtensionPointName.create("com.intellij.daemon.tooltipActionProvider");
    public static final String SHOW_FIXES_KEY = "tooltips.show.actions.in.key";
    public static final boolean SHOW_FIXES_DEFAULT_VALUE = true;

    @Nullable
    public TooltipAction getTooltipAction(@NotNull HighlightInfo var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    public static TooltipAction calcTooltipAction(@NotNull HighlightInfo info2, @NotNull Project project2, @NotNull Editor editor2) {
        PsiFile file2;
        if (info2 == null) {
            TooltipActionProvider.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            TooltipActionProvider.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            TooltipActionProvider.$$$reportNull$$$0(2);
        }
        if ((file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument())) == null) {
            return null;
        }
        return EP_NAME.getExtensionList().stream().map(extension2 -> extension2.getTooltipAction(info2, editor2, file2)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Deprecated
    public static TooltipAction calcTooltipAction(@NotNull HighlightInfo info2, @NotNull Editor editor2) {
        if (info2 == null) {
            TooltipActionProvider.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            TooltipActionProvider.$$$reportNull$$$0(4);
        }
        return TooltipActionProvider.calcTooltipAction(info2, editor2.getProject(), editor2);
    }

    public static boolean isShowActions() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_FIXES_KEY, true);
    }

    public static void setShowActions(boolean newValue) {
        PropertiesComponent.getInstance().setValue(SHOW_FIXES_KEY, newValue, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/tooltips/TooltipActionProvider";
        objectArray[2] = "calcTooltipAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

