/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Optional;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RenameFileReferenceIntentionAction
implements IntentionAction,
LocalQuickFix {
    private final String myExistingElementName;
    private final FileReference myFileReference;

    RenameFileReferenceIntentionAction(String existingElementName, FileReference fileReference) {
        this.myExistingElementName = existingElementName;
        this.myFileReference = fileReference;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = CodeInsightBundle.message("rename.file.reference.text", this.myExistingElementName);
        if (string2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getText();
        if (string2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message("rename.file.reference.family", new Object[0]);
        if (string2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(4);
        }
        if (this.isAvailable(project2, null, null)) {
            this.invoke(project2, null, descriptor2.getPsiElement().getContainingFile());
        }
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
        if (target2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(5);
        }
        PsiElement element = this.myFileReference.getElement();
        PsiElement copy2 = PsiTreeUtil.findSameElementInCopy(element, target2);
        return ((Optional)StreamEx.of((Object[])copy2.getReferences()).select(FileReference.class).collect(MoreCollectors.onlyOne())).map(ref -> new RenameFileReferenceIntentionAction(this.myExistingElementName, (FileReference)ref)).orElse(null);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            RenameFileReferenceIntentionAction.$$$reportNull$$$0(7);
        }
        this.myFileReference.handleElementRename(this.myExistingElementName);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

