/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Rectangle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class DockablePopupManager<T extends JComponent> {
    private static final Logger LOG = Logger.getInstance(DockablePopupManager.class);
    protected ToolWindow myToolWindow;
    private Runnable myAutoUpdateRequest;
    private boolean myAutoUpdateMuted;
    @NotNull
    protected final Project myProject;

    public DockablePopupManager(@NotNull Project project2) {
        if (project2 == null) {
            DockablePopupManager.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @NonNls
    protected abstract String getShowInToolWindowProperty();

    @NonNls
    protected abstract String getAutoUpdateEnabledProperty();

    protected boolean getAutoUpdateDefault() {
        return false;
    }

    @Nls
    protected abstract String getAutoUpdateTitle();

    @Nls
    protected abstract String getRestorePopupDescription();

    @Nls
    protected abstract String getAutoUpdateDescription();

    protected abstract T createComponent();

    protected void doUpdateComponent(@NotNull CompletableFuture<? extends PsiElement> elementFuture, PsiElement originalElement, T component2) {
        if (elementFuture == null) {
            DockablePopupManager.$$$reportNull$$$0(1);
        }
        this.doUpdateComponent(elementFuture, originalElement, component2, false);
    }

    protected void doUpdateComponent(@NotNull CompletableFuture<? extends PsiElement> elementFuture, PsiElement originalElement, T component2, boolean onAutoUpdate) {
        if (elementFuture == null) {
            DockablePopupManager.$$$reportNull$$$0(2);
        }
        try {
            this.doUpdateComponent(elementFuture.get(), originalElement, component2, onAutoUpdate);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Cannot update component", e);
        }
    }

    protected abstract void doUpdateComponent(@NotNull PsiElement var1, PsiElement var2, T var3);

    protected void doUpdateComponent(@NotNull PsiElement element, PsiElement originalElement, T component2, boolean onAutoUpdate) {
        if (element == null) {
            DockablePopupManager.$$$reportNull$$$0(3);
        }
        this.doUpdateComponent(element, originalElement, component2);
    }

    protected void doUpdateComponent(Editor editor2, PsiFile psiFile, boolean requestFocus) {
        this.doUpdateComponent(editor2, psiFile);
    }

    protected void doUpdateComponent(Editor editor2, PsiFile psiFile, boolean requestFocus, boolean onAutoUpdate) {
        this.doUpdateComponent(editor2, psiFile, requestFocus);
    }

    protected abstract void doUpdateComponent(Editor var1, PsiFile var2);

    protected abstract void doUpdateComponent(@NotNull PsiElement var1);

    protected void doUpdateComponent(@NotNull PsiElement element, boolean onAutoUpdate) {
        if (element == null) {
            DockablePopupManager.$$$reportNull$$$0(4);
        }
        this.doUpdateComponent(element);
    }

    @NlsContexts.TabTitle
    protected abstract String getTitle(PsiElement var1);

    protected abstract String getToolwindowId();

    @NlsContexts.TabTitle
    protected String getToolwindowTitle() {
        LOG.error(this.getClass().getName() + " should override getToolwindowTitle() method");
        return this.getToolwindowId();
    }

    public Content recreateToolWindow(PsiElement element, PsiElement originalElement) {
        if (this.myToolWindow == null) {
            this.createToolWindow(element, originalElement);
            return null;
        }
        Content content2 = this.myToolWindow.getContentManager().getSelectedContent();
        if (content2 == null || !this.myToolWindow.isVisible()) {
            this.restorePopupBehavior();
            this.createToolWindow(element, originalElement);
            return null;
        }
        return content2;
    }

    public void createToolWindow(@NotNull PsiElement element, PsiElement originalElement) {
        if (element == null) {
            DockablePopupManager.$$$reportNull$$$0(5);
        }
        this.doCreateToolWindow(element, null, originalElement);
    }

    public void createToolWindow(@NotNull CompletableFuture<PsiElement> elementFuture, PsiElement originalElement) {
        if (elementFuture == null) {
            DockablePopupManager.$$$reportNull$$$0(6);
        }
        this.doCreateToolWindow(null, elementFuture, originalElement);
    }

    private void doCreateToolWindow(@Nullable PsiElement element, @Nullable CompletableFuture<PsiElement> elementFuture, PsiElement originalElement) {
        assert (this.myToolWindow == null);
        T component2 = this.createComponent();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolwindowId());
        if (toolWindow == null) {
            toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable((String)this.getToolwindowId(), this::getToolwindowTitle, (Icon)AllIcons.Toolwindows.Documentation, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
        } else {
            toolWindow.setAvailable(true);
        }
        this.myToolWindow = toolWindow;
        toolWindow.setToHideOnEmptyContent(false);
        this.setToolwindowDefaultState(this.myToolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        String displayName = element != null ? this.getTitle(element) : "";
        contentManager.addContent(ContentFactory.getInstance().createContent(component2, displayName, false));
        contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockablePopupManager.this.restorePopupBehavior();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/DockablePopupManager$1", "contentRemoved"));
            }
        });
        this.installComponentActions(toolWindow, component2);
        new UiNotifyConnector(component2, new Activatable(){

            public void showNotify() {
                DockablePopupManager.this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(DockablePopupManager.this.getAutoUpdateEnabledProperty(), DockablePopupManager.this.getAutoUpdateDefault()));
            }

            public void hideNotify() {
                DockablePopupManager.this.restartAutoUpdate(false);
            }
        });
        this.myToolWindow.show(null);
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.TRUE.toString());
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), true));
        if (element != null) {
            this.doUpdateComponent(element, originalElement, component2, false);
        } else {
            this.doUpdateComponent(elementFuture, originalElement, component2, false);
        }
    }

    protected void installComponentActions(@NotNull ToolWindow toolWindow, T component2) {
        if (toolWindow == null) {
            DockablePopupManager.$$$reportNull$$$0(7);
        }
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(this.createActions()));
    }

    protected void setToolwindowDefaultState(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            DockablePopupManager.$$$reportNull$$$0(8);
        }
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        toolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, rectangle);
    }

    protected AnAction[] createActions() {
        ToggleAction toggleAutoUpdateAction = new ToggleAction(this.getAutoUpdateTitle(), this.getAutoUpdateDescription(), AllIcons.General.AutoscrollFromSource){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PropertiesComponent.getInstance().getBoolean(DockablePopupManager.this.getAutoUpdateEnabledProperty(), DockablePopupManager.this.getAutoUpdateDefault());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                PropertiesComponent.getInstance().setValue(DockablePopupManager.this.getAutoUpdateEnabledProperty(), state, DockablePopupManager.this.getAutoUpdateDefault());
                DockablePopupManager.this.restartAutoUpdate(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/documentation/DockablePopupManager$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/documentation/DockablePopupManager$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1 -> new IllegalStateException(string2);
                };
            }
        };
        return new AnAction[]{this.createRestorePopupAction(), toggleAutoUpdateAction};
    }

    @NotNull
    protected AnAction createRestorePopupAction() {
        return new DumbAwareAction(CodeInsightBundle.messagePointer("action.AnActionButton.text.open.as.popup", new Object[0]), () -> this.getRestorePopupDescription(), null){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                DockablePopupManager.this.restorePopupBehavior();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DockablePopupManager$4", "actionPerformed"));
            }
        };
    }

    void restartAutoUpdate(boolean state) {
        boolean enabled;
        boolean bl = enabled = state && this.myToolWindow != null && !this.myAutoUpdateMuted;
        if (enabled) {
            if (this.myAutoUpdateRequest == null) {
                this.myAutoUpdateRequest = () -> this.updateComponent(false, true);
                UIUtil.invokeLaterIfNeeded(() -> IdeEventQueue.getInstance().addIdleListener(this.myAutoUpdateRequest, 500));
            }
        } else if (this.myAutoUpdateRequest != null) {
            IdeEventQueue.getInstance().removeIdleListener(this.myAutoUpdateRequest);
            this.myAutoUpdateRequest = null;
        }
    }

    public void muteAutoUpdateTill(@NotNull Disposable disposable) {
        if (disposable == null) {
            DockablePopupManager.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAutoUpdateMuted = true;
        this.resetAutoUpdateState();
        Disposer.register(disposable, () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myAutoUpdateMuted = false;
            this.resetAutoUpdateState();
        });
    }

    public void resetAutoUpdateState() {
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), this.getAutoUpdateDefault()));
    }

    public void updateComponent() {
        this.updateComponent(false);
    }

    public void updateComponent(boolean requestFocus) {
        this.updateComponent(requestFocus, false);
    }

    protected void updateComponent(boolean requestFocus, boolean onAutoUpdate) {
        if (this.myProject.isDisposed()) {
            return;
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext2 -> {
            if (!this.myProject.isOpen()) {
                return;
            }
            this.updateComponentInner((DataContext)dataContext2, requestFocus, onAutoUpdate);
        });
    }

    private void updateComponentInner(@NotNull DataContext dataContext2, boolean requestFocus, boolean onAutoUpdate) {
        if (dataContext2 == null) {
            DockablePopupManager.$$$reportNull$$$0(10);
        }
        if (CommonDataKeys.PROJECT.getData(dataContext2) != this.myProject) {
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
            if (element != null) {
                this.doUpdateComponent(element, onAutoUpdate);
            }
            return;
        }
        PsiDocumentManager.getInstance(this.myProject).performLaterWhenAllCommitted(() -> {
            if (editor2.isDisposed()) {
                return;
            }
            PsiFile file2 = PsiUtilBase.getPsiFileInEditor(editor2, this.myProject);
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor2, file2);
            PsiFile injectedFile = PsiUtilBase.getPsiFileInEditor(injectedEditor, this.myProject);
            if (injectedFile != null) {
                this.doUpdateComponent(injectedEditor, injectedFile, requestFocus, onAutoUpdate);
            } else if (file2 != null) {
                this.doUpdateComponent(editor2, file2, requestFocus, onAutoUpdate);
            }
        });
    }

    public void restorePopupBehavior() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            return;
        }
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.FALSE.toString());
        toolWindow.remove();
        Disposer.dispose((Disposable)toolWindow.getContentManager());
        this.myToolWindow = null;
        this.restartAutoUpdate(false);
    }

    public boolean hasActiveDockedDocWindow() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFuture";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/DockablePopupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "installComponentActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setToolwindowDefaultState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "muteAutoUpdateTill";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateComponentInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

