/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.documentation.CornerAwareScrollPaneLayout;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.DocumentationActionProvider;
import com.intellij.codeInsight.documentation.DocumentationComponentListener;
import com.intellij.codeInsight.documentation.DocumentationFontSize;
import com.intellij.codeInsight.documentation.DocumentationHintEditorPane;
import com.intellij.codeInsight.documentation.DocumentationLinkHandler;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationScrollPane;
import com.intellij.codeInsight.documentation.FontSizeMouseWheelListener;
import com.intellij.codeInsight.documentation.PopupDragListener;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.documentation.ToggleShowDocsOnHoverAction;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.ide.actions.WindowAction;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ide.DocumentationUtil;
import com.intellij.lang.documentation.psi.PsiElementDocumentationTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.backend.documentation.impl.DocumentationRequest;
import com.intellij.platform.backend.documentation.impl.ImplKt;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DocumentationComponent
extends JPanel
implements Disposable,
DataProvider,
WidthBasedLayout {
    private static final Logger LOG = Logger.getInstance(DocumentationComponent.class);
    static final DataProvider HELP_DATA_PROVIDER = dataId -> PlatformCoreDataKeys.HELP_ID.is(dataId) ? "reference.toolWindows.Documentation" : null;
    public static final ColorKey COLOR_KEY = EditorColors.DOCUMENTATION_COLOR;
    public static final Color SECTION_COLOR = Gray.get(144);
    private static final int PREFERRED_HEIGHT_MAX_EM = 10;
    static final JBDimension MIN_DEFAULT = new JBDimension(300, 36);
    static final JBDimension MAX_DEFAULT = new JBDimension(950, 500);
    private final ExternalDocAction myExternalDocAction;
    private DocumentationManager myManager;
    private SmartPsiElementPointer<PsiElement> myElement;
    private long myModificationCount;
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private final List<? extends AnAction> myNavigationActions;
    private final ActionToolbarImpl myToolBar;
    private volatile boolean myIsEmpty;
    private boolean mySizeTrackerRegistered;
    private String myExternalUrl;
    private DocumentationProvider myProvider;
    private Reference<Component> myReferenceComponent;
    private Runnable myToolwindowCallback;
    private final ActionButton myCorner;
    private final JScrollPane myScrollPane;
    private final DocumentationHintEditorPane myEditorPane;
    private final JComponent myControlPanel;
    private boolean myControlPanelVisible;
    private final DocumentationLinkHandler myLinkHandler;
    private final boolean myStoreSize;
    private boolean myManuallyResized;
    private AbstractPopup myHint;

    @Deprecated
    @NotNull
    public static JComponent createAndFetch(@NotNull Project project2, @NotNull PsiElement element, @NotNull Disposable disposable) {
        if (project2 == null) {
            DocumentationComponent.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DocumentationComponent.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            DocumentationComponent.$$$reportNull$$$0(2);
        }
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            DocumentationRequest request2;
            try (AccessToken ignored = SlowOperations.allowSlowOperations("generic");){
                request2 = ImplKt.documentationRequest(new PsiElementDocumentationTarget(project2, element));
            }
            JComponent jComponent = DocumentationUtil.documentationComponent(project2, request2, disposable);
            if (jComponent == null) {
                DocumentationComponent.$$$reportNull$$$0(3);
            }
            return jComponent;
        }
        DocumentationManager manager = DocumentationManager.getInstance(project2);
        DocumentationComponent component2 = new DocumentationComponent(manager);
        Disposer.register(disposable, component2);
        manager.fetchDocInfo(element, component2);
        DocumentationComponent documentationComponent = component2;
        if (documentationComponent == null) {
            DocumentationComponent.$$$reportNull$$$0(4);
        }
        return documentationComponent;
    }

    public DocumentationComponent(DocumentationManager manager) {
        this(manager, true);
    }

    /*
     * WARNING - void declaration
     */
    public DocumentationComponent(DocumentationManager manager, boolean storeSize) {
        void var9_13;
        this.myManager = manager;
        this.myIsEmpty = true;
        this.myStoreSize = storeSize;
        this.myScrollPane = new DocumentationScrollPane();
        this.myEditorPane = new DocumentationHintEditorPane(manager.getProject(), DocumentationScrollPane.keyboardActions(this.myScrollPane), this::getElementImage);
        this.myScrollPane.setViewportView(this.myEditorPane);
        this.myScrollPane.addMouseWheelListener(new FontSizeMouseWheelListener(this.myEditorPane::applyFontProps));
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        BackAction back = new BackAction();
        ForwardAction forward = new ForwardAction();
        EditDocumentationSourceAction edit = new EditDocumentationSourceAction();
        this.myNavigationActions = List.of(back, forward, edit);
        final ArrayList<? extends AnAction> navigationAndAdditionalActions = new ArrayList<AnAction>(this.myNavigationActions);
        DocumentationActionProvider[] documentationActionProviderArray = DocumentationActionProvider.EP_NAME.getExtensions();
        int n = documentationActionProviderArray.length;
        boolean bl = false;
        while (var9_13 < n) {
            DocumentationActionProvider provider2 = documentationActionProviderArray[var9_13];
            navigationAndAdditionalActions.addAll(provider2.additionalActions(this));
            ++var9_13;
        }
        try {
            String backKey = ScreenReader.isActive() ? "alt LEFT" : "LEFT";
            CustomShortcutSet backShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)backKey), KeymapUtil.parseMouseShortcut((String)"button4")});
            String string2 = ScreenReader.isActive() ? "alt RIGHT" : "RIGHT";
            CustomShortcutSet forwardShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)string2), KeymapUtil.parseMouseShortcut((String)"button5")});
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this);
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this.myEditorPane);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this.myEditorPane);
        }
        catch (InvalidDataException e) {
            LOG.error(e);
        }
        this.myExternalDocAction = new ExternalDocAction();
        this.myExternalDocAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"UP"}), this);
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        edit.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu contextMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu("JavadocToolbar", (ActionGroup)new DefaultActionGroup(navigationAndAdditionalActions), (PresentationFactory)new MenuItemPresentationFactory(true));
                contextMenu.getComponent().show(comp, x, y);
            }
        };
        this.myEditorPane.addMouseListener((MouseListener)popupHandler);
        Disposer.register(this, () -> this.myEditorPane.removeMouseListener((MouseListener)popupHandler));
        this.myLinkHandler = DocumentationLinkHandler.createAndRegister(this.myEditorPane, this, href -> manager.navigateByLink(this, null, (String)href));
        for (AnAction anAction : this.myLinkHandler.createLinkActions()) {
            anAction.registerCustomShortcutSet((JComponent)this, (Disposable)this);
        }
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.addAll(navigationAndAdditionalActions);
        toolbarActions.addAction((AnAction)new ShowAsToolwindowAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ToggleShowDocsOnHoverAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new MyShowSettingsAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ShowToolbarAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new ShowPopupAutomaticallyAction()).setAsSecondary(true);
        toolbarActions.addAction((AnAction)new RestoreDefaultSizeAction()).setAsSecondary(true);
        this.myToolBar = new ActionToolbarImpl("JavadocToolbar", (ActionGroup)toolbarActions, true);
        this.myToolBar.setSecondaryActionsIcon(AllIcons.Actions.More, true);
        this.myToolBar.setTargetComponent((JComponent)this);
        JBLayeredPane jBLayeredPane = new JBLayeredPane(){

            public void doLayout() {
                Rectangle r = this.getBounds();
                for (Component component2 : this.getComponents()) {
                    if (component2 instanceof JScrollPane) {
                        component2.setBounds(0, 0, r.width, r.height);
                        continue;
                    }
                    Dimension d = component2.getPreferredSize();
                    component2.setBounds(r.width - d.width - 2, r.height - d.height - 7, d.width, d.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension size = DocumentationComponent.this.myScrollPane.getPreferredSize();
                if (DocumentationComponent.this.myHint == null && DocumentationComponent.this.myManager != null && DocumentationComponent.this.myManager.myToolWindow == null) {
                    int em = DocumentationComponent.this.myEditorPane.getFont().getSize();
                    int prefHeightMax = 10 * em;
                    return new Dimension(size.width, Math.min(prefHeightMax, size.height + (DocumentationComponent.this.needsToolbar() ? DocumentationComponent.this.myControlPanel.getPreferredSize().height : 0)));
                }
                return size;
            }
        };
        jBLayeredPane.add(this.myScrollPane);
        jBLayeredPane.setLayer(this.myScrollPane, 0);
        MyGearActionGroup gearActions = new MyGearActionGroup(new AnAction[0]);
        ShowAsToolwindowAction showAsToolwindowAction = new ShowAsToolwindowAction();
        gearActions.add(showAsToolwindowAction);
        gearActions.add((AnAction)new ToggleShowDocsOnHoverAction());
        gearActions.add(new MyShowSettingsAction());
        gearActions.add((AnAction)new ShowToolbarAction());
        gearActions.add((AnAction)new ShowPopupAutomaticallyAction());
        gearActions.add(new RestoreDefaultSizeAction());
        gearActions.addSeparator();
        gearActions.addAll(navigationAndAdditionalActions);
        Presentation presentation2 = new Presentation();
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
        this.myCorner = new ActionButton((AnAction)gearActions, presentation2, "unknown", new Dimension(20, 20)){

            protected DataContext getDataContext() {
                return DataManager.getInstance().getDataContext((Component)DocumentationComponent.this.myCorner);
            }
        };
        this.myCorner.setNoIconsInPopup(true);
        this.myScrollPane.setLayout((LayoutManager)((Object)new CornerAwareScrollPaneLayout((Component)this.myCorner)));
        showAsToolwindowAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc"), (JComponent)this.myCorner);
        jBLayeredPane.add((Component)this.myCorner);
        jBLayeredPane.setLayer((Component)this.myCorner, JLayeredPane.POPUP_LAYER);
        this.add((Component)jBLayeredPane, "Center");
        this.myControlPanel = this.myToolBar.getComponent();
        this.myControlPanel.setBorder(IdeBorderFactory.createBorder((Color)UIUtil.getTooltipSeparatorColor(), (int)8));
        this.myControlPanelVisible = false;
        if (this.myHint != null) {
            Disposer.register((Disposable)this.myHint, this);
        } else if (this.myManager.myToolWindow != null) {
            Disposer.register((Disposable)this.myManager.myToolWindow.getContentManager(), this);
        }
        DataManager.registerDataProvider((JComponent)this.myEditorPane, (DataProvider)HELP_DATA_PROVIDER);
        DataManager.registerDataProvider((JComponent)this.myScrollPane, (DataProvider)HELP_DATA_PROVIDER);
        this.updateControlState();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.myEditorPane != null) {
            this.myEditorPane.setBackground(color);
        }
        if (this.myControlPanel != null) {
            this.myControlPanel.setBackground(color);
        }
    }

    public List<? extends AnAction> getNavigationActions() {
        return this.myNavigationActions;
    }

    public AnAction getFontSizeAction() {
        return new MyShowSettingsAction();
    }

    public void removeCornerMenu() {
        this.myCorner.setVisible(false);
    }

    public void setToolwindowCallback(Runnable callback) {
        this.myToolwindowCallback = callback;
    }

    public void showExternalDoc() {
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
        this.myExternalDocAction.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2));
    }

    @Override
    public boolean requestFocusInWindow() {
        if (ScreenReader.isActive()) {
            return this.myEditorPane.requestFocusInWindow();
        }
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            if (ScreenReader.isActive()) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditorPane, true);
            } else {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myScrollPane, true);
            }
        });
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DocumentationComponent.$$$reportNull$$$0(5);
        }
        if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.is(dataId)) {
            String selectedText = this.myEditorPane.getSelectedText();
            return selectedText == null ? null : selectedText.replace('\u00a0', ' ');
        }
        return null;
    }

    @NotNull
    public static FontSize getQuickDocFontSize() {
        FontSize fontSize = DocumentationFontSize.getDocumentationFontSize();
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(6);
        }
        return fontSize;
    }

    public static void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            DocumentationComponent.$$$reportNull$$$0(7);
        }
        DocumentationFontSize.setDocumentationFontSize(fontSize);
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible() {
        if (this.myControlPanelVisible) {
            return;
        }
        this.add((Component)this.myControlPanel, "North");
        this.myControlPanelVisible = true;
    }

    public void setHint(JBPopup hint) {
        this.myHint = (AbstractPopup)hint;
        PopupDragListener.dragPopupByComponent(hint, this.myControlPanel);
        this.myEditorPane.setHint(hint);
    }

    public JBPopup getHint() {
        return this.myHint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    private void setElement(SmartPsiElementPointer<PsiElement> element) {
        this.myElement = element;
        this.myModificationCount = this.getCurrentModificationCount();
    }

    public boolean isUpToDate() {
        return this.getElement() != null && this.myModificationCount == this.getCurrentModificationCount();
    }

    private long getCurrentModificationCount() {
        return this.myElement != null ? PsiModificationTracker.getInstance(this.myElement.getProject()).getModificationCount() : -1L;
    }

    public void setText(@NotNull @Nls String text2, @Nullable PsiElement element, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(8);
        }
        this.setData(element, text2, null, null, provider2);
    }

    public void replaceText(@NotNull @Nls String text2, @Nullable PsiElement element) {
        PsiElement current;
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(9);
        }
        if ((current = this.getElement()) == null || !current.getManager().areElementsEquivalent(current, element)) {
            return;
        }
        this.restoreContext(this.saveContext().withText(text2));
    }

    public void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    private void pushHistory() {
        if (this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
    }

    public void setData(@Nullable PsiElement element, @NotNull @Nls String text2, @Nullable String effectiveExternalUrl, @Nullable String ref, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(10);
        }
        this.pushHistory();
        this.myExternalUrl = effectiveExternalUrl;
        this.myProvider = provider2;
        SmartPsiElementPointer<PsiElement> pointer = null;
        if (element != null && element.isValid()) {
            pointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        }
        this.setDataInternal(pointer, text2, new Rectangle(0, 0), ref);
    }

    private void setDataInternal(@Nullable SmartPsiElementPointer<PsiElement> element, @NotNull @Nls String text2, @NotNull Rectangle viewRect, @Nullable String ref) {
        if (text2 == null) {
            DocumentationComponent.$$$reportNull$$$0(11);
        }
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(12);
        }
        this.myIsEmpty = false;
        if (this.myManager == null) {
            return;
        }
        this.myEditorPane.setText(text2);
        this.setElement(element);
        if (element != null && element.getElement() != null) {
            this.myManager.updateToolWindowTabName(element.getElement());
        }
        this.showHint(viewRect, ref);
        if (this.myManager != null) {
            this.myManager.getProject().getMessageBus().syncPublisher(DocumentationComponentListener.TOPIC).onComponentDataChanged();
        }
    }

    protected void showHint(@NotNull Rectangle viewRect, @Nullable String ref) {
        Rectangle viewRectToUse;
        String refToUse;
        if (viewRect == null) {
            DocumentationComponent.$$$reportNull$$$0(13);
        }
        if ("$keepScrollingPosition$".equals(ref)) {
            refToUse = null;
            viewRectToUse = this.myScrollPane.getViewport().getViewRect();
        } else {
            refToUse = ref;
            viewRectToUse = viewRect;
        }
        this.updateControlState();
        this.myLinkHandler.highlightLink(-1);
        this.myEditorPane.applyFontProps(DocumentationComponent.getQuickDocFontSize());
        this.showHint();
        SwingUtilities.invokeLater(() -> {
            this.myEditorPane.scrollRectToVisible(viewRectToUse);
            if (refToUse != null) {
                UIUtil.scrollToReference(this.myEditorPane, refToUse);
            } else if (ScreenReader.isActive()) {
                this.myEditorPane.setCaretPosition(0);
            }
        });
    }

    protected void showHint() {
        if (this.myHint == null) {
            return;
        }
        this.setHintSize();
        DataContext dataContext2 = this.getDataContext();
        PopupPositionManager.positionPopupInBestPosition((JBPopup)this.myHint, this.myManager.getEditor(), dataContext2, PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT);
        Window window = this.myHint.getPopupWindow();
        if (window != null) {
            window.setFocusableWindowState(true);
        }
        this.registerSizeTracker();
    }

    private DataContext getDataContext() {
        Component referenceComponent;
        if (this.myReferenceComponent == null) {
            referenceComponent = IdeFocusManager.getInstance((Project)this.myManager.myProject).getFocusOwner();
            this.myReferenceComponent = new WeakReference<Component>(referenceComponent);
        } else {
            referenceComponent = SoftReference.dereference(this.myReferenceComponent);
            if (referenceComponent == null || !referenceComponent.isShowing()) {
                referenceComponent = this.myHint.getComponent();
            }
        }
        return DataManager.getInstance().getDataContext(referenceComponent);
    }

    private void setHintSize() {
        Dimension hintSize = this.myManuallyResized ? DocumentationComponent.ensureMinimum(this.myHint.getContentSize()) : this.getDefaultHintSize();
        this.myHint.setSize(hintSize);
    }

    @NotNull
    private Dimension getDefaultHintSize() {
        if (this.myHint.getDimensionServiceKey() == null) {
            return this.getOptimalSize();
        }
        Dimension storedSize = DimensionService.getInstance().getSize("javadoc.popup.new", this.myManager.myProject);
        if (storedSize != null) {
            return DocumentationComponent.ensureMinimum(storedSize);
        }
        return new Dimension(MIN_DEFAULT);
    }

    @NotNull
    private static Dimension ensureMinimum(@NotNull Dimension hintSize) {
        if (hintSize == null) {
            DocumentationComponent.$$$reportNull$$$0(14);
        }
        return new Dimension(Math.max(hintSize.width, DocumentationComponent.MIN_DEFAULT.width), Math.max(hintSize.height, DocumentationComponent.MIN_DEFAULT.height));
    }

    @NotNull
    private Dimension getOptimalSize() {
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight(width);
        return new Dimension(width, height);
    }

    @Override
    public int getPreferredWidth() {
        int minWidth = JBUIScale.scale(300);
        int maxWidth = this.getPopupAnchor() != null ? JBUIScale.scale(435) : JBUIScale.scale(DocumentationComponent.MAX_DEFAULT.width);
        int width = this.myEditorPane.getPreferredWidth();
        Insets insets = this.getInsets();
        return MathUtil.clamp(width, minWidth, maxWidth) + insets.left + insets.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        this.myEditorPane.setBounds(0, 0, width, DocumentationComponent.MAX_DEFAULT.height);
        Dimension preferredSize = this.myEditorPane.getPreferredSize();
        int height = preferredSize.height + (this.needsToolbar() ? this.myControlPanel.getPreferredSize().height : 0);
        JScrollBar scrollBar = this.myScrollPane.getHorizontalScrollBar();
        int reservedForScrollBar = width < preferredSize.width && scrollBar.isOpaque() ? scrollBar.getPreferredSize().height : 0;
        Insets insets = this.getInsets();
        return MathUtil.clamp(height, DocumentationComponent.MIN_DEFAULT.height, DocumentationComponent.MAX_DEFAULT.height) + insets.top + insets.bottom + reservedForScrollBar;
    }

    private Component getPopupAnchor() {
        LookupEx lookup2;
        LookupEx lookupEx = lookup2 = this.myManager == null ? null : LookupManager.getActiveLookup(this.myManager.getEditor());
        if (lookup2 != null && lookup2.getCurrentItem() != null && lookup2.getComponent().isShowing()) {
            return lookup2.getComponent();
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null && popup2 != this.myHint && !popup2.isDisposed()) {
            return popup2.getContent();
        }
        return null;
    }

    private void registerSizeTracker() {
        AbstractPopup hint = this.myHint;
        if (hint == null || this.mySizeTrackerRegistered) {
            return;
        }
        this.mySizeTrackerRegistered = true;
        hint.addResizeListener(this::onManualResizing, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(AnActionListener.TOPIC, new AnActionListener(){

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
                if (action2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (action2 instanceof WindowAction) {
                    DocumentationComponent.this.onManualResizing();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$4";
                objectArray[2] = "afterActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onManualResizing() {
        this.myManuallyResized = true;
        if (this.myStoreSize && this.myHint != null) {
            this.myHint.setDimensionServiceKey("javadoc.popup.new");
            this.myHint.storeDimensionSize();
        }
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context2 = this.myBackStack.pop();
        this.myForwardStack.push(this.saveContext());
        this.restoreContext(context2);
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context2 = this.myForwardStack.pop();
        this.myBackStack.push(this.saveContext());
        this.restoreContext(context2);
    }

    private Context saveContext() {
        Rectangle rect2 = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myEditorPane.getText(), this.myExternalUrl, this.myProvider, rect2, this.myLinkHandler.getHighlightedLink());
    }

    private void restoreContext(@NotNull Context context2) {
        PsiElement element;
        if (context2 == null) {
            DocumentationComponent.$$$reportNull$$$0(15);
        }
        this.myExternalUrl = context2.externalUrl;
        this.myProvider = context2.provider;
        this.setDataInternal(context2.element, context2.text, context2.viewRect, null);
        this.myLinkHandler.highlightLink(context2.highlightedLink);
        if (this.myManager != null && (element = context2.element.getElement()) != null) {
            this.myManager.updateToolWindowTabName(element);
        }
    }

    private void updateControlState() {
        if (this.needsToolbar()) {
            this.myToolBar.updateActionsImmediately();
            this.setControlPanelVisible();
            this.removeCornerMenu();
        } else {
            this.myControlPanelVisible = false;
            this.remove(this.myControlPanel);
            if (this.myManager.myToolWindow != null) {
                return;
            }
            this.myCorner.setVisible(true);
        }
    }

    public boolean needsToolbar() {
        return this.myManager.myToolWindow == null && Registry.is("documentation.show.toolbar");
    }

    @Nullable
    private Image getElementImage(@NotNull String imageSpec) {
        PsiElement element;
        if (imageSpec == null) {
            DocumentationComponent.$$$reportNull$$$0(16);
        }
        return (element = this.getElement()) == null ? null : DocumentationManager.getElementImage(element, imageSpec);
    }

    private static boolean isToolbar(@NotNull AnActionEvent e) {
        if (e == null) {
            DocumentationComponent.$$$reportNull$$$0(17);
        }
        return "JavadocToolbar".equals(e.getPlace());
    }

    private boolean hasExternalDoc() {
        boolean enabled = false;
        if (this.myElement != null && this.myProvider != null) {
            PsiElement element = this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            enabled = element != null && CompositeDocumentationProvider.hasUrlsFor(this.myProvider, element, originalElement);
        }
        return enabled;
    }

    @Nls
    public String getText() {
        return this.myEditorPane.getText();
    }

    @Nls
    public String getDecoratedText() {
        return this.myEditorPane.getText();
    }

    @Override
    public void dispose() {
        this.myEditorPane.getCaret().setVisible(false);
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontSize";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintSize";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndFetch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocFontSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndFetch";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setQuickDocFontSize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setDataInternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureMinimum";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "restoreContext";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getElementImage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isToolbar";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 6 -> new IllegalStateException(string2);
        };
    }

    protected class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        BackAction() {
            super(CodeInsightBundle.messagePointer("javadoc.action.back", new Object[0]), AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goBack();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BackAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation2.setVisible(presentation2.isEnabled());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                BackAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$BackAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$BackAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    protected class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ForwardAction() {
            super(CodeInsightBundle.messagePointer("javadoc.action.forward", new Object[0]), AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(0);
            }
            DocumentationComponent.this.goForward();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ForwardAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
            if (!DocumentationComponent.isToolbar(e)) {
                presentation2.setVisible(presentation2.isEnabled());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ForwardAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$ForwardAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ForwardAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    protected final class EditDocumentationSourceAction
    extends BaseNavigateToSourceAction {
        private EditDocumentationSourceAction() {
            super(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer("action.presentation.DocumentationComponent.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditDocumentationSourceAction.$$$reportNull$$$0(0);
            }
            super.actionPerformed(e);
            AbstractPopup hint = DocumentationComponent.this.myHint;
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        }

        protected Navigatable @Nullable [] getNavigatables(DataContext dataContext2) {
            SmartPsiElementPointer<PsiElement> element = DocumentationComponent.this.myElement;
            if (element != null) {
                Navigatable[] navigatableArray;
                PsiElement psiElement = element.getElement();
                if (psiElement instanceof Navigatable) {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = (Navigatable)((Object)psiElement);
                } else {
                    navigatableArray = null;
                }
                return navigatableArray;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$EditDocumentationSourceAction", "actionPerformed"));
        }
    }

    private final class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ExternalDocAction() {
            super(CodeInsightBundle.message("javadoc.action.view.external", new Object[0]), null, AllIcons.Actions.PreviousOccurence);
            this.setShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(0);
            }
            if (DocumentationComponent.this.myElement == null) {
                return;
            }
            PsiElement element = DocumentationComponent.this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            ExternalJavaDocAction.showExternalJavadoc(element, originalElement, DocumentationComponent.this.myExternalUrl, e.getDataContext());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExternalDocAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(DocumentationComponent.this.hasExternalDoc());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ExternalDocAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$ExternalDocAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ExternalDocAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    protected class ShowAsToolwindowAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ShowAsToolwindowAction() {
            super(CodeInsightBundle.messagePointer("javadoc.open.as.tool.window", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            if (DocumentationComponent.this.myManager == null) {
                presentation2.setEnabledAndVisible(false);
            } else {
                presentation2.setIcon(ToolWindowManager.getInstance((Project)DocumentationComponent.this.myManager.myProject).getLocationIcon("Documentation", EmptyIcon.ICON_16));
                presentation2.setEnabledAndVisible(DocumentationComponent.this.myToolwindowCallback != null);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowAsToolwindowAction.$$$reportNull$$$0(2);
            }
            DocumentationComponent.this.myToolwindowCallback.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowAsToolwindowAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowAsToolwindowAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyShowSettingsAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        MyShowSettingsAction() {
            super(CodeInsightBundle.message("javadoc.adjust.font.size", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowSettingsAction.$$$reportNull$$$0(0);
            }
            DocFontSizePopup.show((Component)DocumentationComponent.this, size -> {
                DocumentationComponent.this.myEditorPane.applyFontProps((FontSize)size);
                if (!DocumentationComponent.this.myManuallyResized && DocumentationComponent.this.myHint != null && DocumentationComponent.this.myHint.getDimensionServiceKey() == null) {
                    DocumentationComponent.this.showHint();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationComponent$MyShowSettingsAction", "actionPerformed"));
        }
    }

    protected class ShowToolbarAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        ShowToolbarAction() {
            super(CodeInsightBundle.messagePointer("javadoc.show.toolbar", new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(0);
            }
            return Registry.get("documentation.show.toolbar").asBoolean();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowToolbarAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowToolbarAction.$$$reportNull$$$0(2);
            }
            Registry.get("documentation.show.toolbar").setValue(state);
            DocumentationComponent.this.updateControlState();
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowToolbarAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowToolbarAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    protected static class ShowPopupAutomaticallyAction
    extends ToggleAction
    implements HintManagerImpl.ActionToIgnore {
        ShowPopupAutomaticallyAction() {
            super(CodeInsightBundle.messagePointer("javadoc.show.popup.automatically", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowPopupAutomaticallyAction.$$$reportNull$$$0(0);
            }
            Project project2 = e.getProject();
            e.getPresentation().setEnabledAndVisible(project2 != null && LookupManager.getInstance(project2).getActiveLookup() != null);
            super.update(e);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowPopupAutomaticallyAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowPopupAutomaticallyAction.$$$reportNull$$$0(2);
            }
            return CodeInsightSettings.getInstance().AUTO_POPUP_JAVADOC_INFO;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowPopupAutomaticallyAction.$$$reportNull$$$0(3);
            }
            CodeInsightSettings.getInstance().AUTO_POPUP_JAVADOC_INFO = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowPopupAutomaticallyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$ShowPopupAutomaticallyAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    protected class RestoreDefaultSizeAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        RestoreDefaultSizeAction() {
            super(CodeInsightBundle.messagePointer("javadoc.restore.size", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(DocumentationComponent.this.myHint != null && (DocumentationComponent.this.myManuallyResized || DocumentationComponent.this.myHint.getDimensionServiceKey() != null));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RestoreDefaultSizeAction.$$$reportNull$$$0(2);
            }
            DocumentationComponent.this.myManuallyResized = false;
            if (DocumentationComponent.this.myStoreSize) {
                DimensionService.getInstance().setSize("javadoc.popup.new", null, DocumentationComponent.this.myManager.myProject);
                DocumentationComponent.this.myHint.setDimensionServiceKey(null);
            }
            DocumentationComponent.this.showHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationComponent$RestoreDefaultSizeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationComponent$RestoreDefaultSizeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class MyGearActionGroup
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        MyGearActionGroup(AnAction ... actions) {
            if (actions == null) {
                MyGearActionGroup.$$$reportNull$$$0(0);
            }
            super(actions);
            this.setPopup(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/documentation/DocumentationComponent$MyGearActionGroup", "<init>"));
        }
    }

    private record Context(SmartPsiElementPointer<PsiElement> element, @Nls String text, String externalUrl, DocumentationProvider provider, Rectangle viewRect, int highlightedLink) {
        @NotNull
        Context withText(@NotNull @Nls String text2) {
            if (text2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            return new Context(this.element, text2, this.externalUrl, this.provider, this.viewRect, this.highlightedLink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/documentation/DocumentationComponent$Context", "withText"));
        }
    }
}

