/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DocumentationHtmlUtil {
    private DocumentationHtmlUtil() {
    }

    public static ExtendableHTMLViewFactory.Extension getIconsExtension(@NotNull @NotNull Function<? super @NotNull String, ? extends @Nullable Icon> iconResolver) {
        if (iconResolver == null) {
            DocumentationHtmlUtil.$$$reportNull$$$0(0);
        }
        return ExtendableHTMLViewFactory.Extensions.icons((Function1<? super String, ? extends Icon>)((Function1)key -> {
            Icon resolved = (Icon)iconResolver.apply((String)key);
            if (resolved != null) {
                return resolved;
            }
            ModuleType moduleType = ModuleTypeManager.getInstance().findByID(key);
            return moduleType instanceof UnknownModuleType ? null : moduleType.getIcon();
        }));
    }

    private static int getMonospaceFontSizeCorrection() {
        return SystemInfo.isWin10OrNewer && !ApplicationManager.getApplication().isUnitTestMode() ? 96 : 100;
    }

    public static void addDocumentationPaneDefaultCssRules(@NotNull HTMLEditorKit editorKit) {
        if (editorKit == null) {
            DocumentationHtmlUtil.$$$reportNull$$$0(1);
        }
        StyleSheet styleSheet = editorKit.getStyleSheet();
        for (String rule : DocumentationHtmlUtil.getDocumentationPaneDefaultCssRules()) {
            styleSheet.addRule(rule);
        }
    }

    @NotNull
    public static List<String> getDocumentationPaneDefaultCssRules() {
        int leftPadding = 8;
        int definitionTopPadding = 4;
        String linkColor = ColorUtil.toHtmlColor(JBUI.CurrentTheme.Link.Foreground.ENABLED);
        String borderColor = ColorUtil.toHtmlColor(UIUtil.getTooltipSeparatorColor());
        String sectionColor = ColorUtil.toHtmlColor(DocumentationComponent.SECTION_COLOR);
        String editorFontStyle = "{ font-family:\"_EditorFontNoLigatures_\";font-size:" + DocumentationHtmlUtil.getMonospaceFontSizeCorrection() + "%; }";
        int fontSize = StartupUiUtil.getLabelFont().getSize();
        List<String> list2 = List.of("tt " + editorFontStyle, "code " + editorFontStyle, "pre " + editorFontStyle, ".pre " + editorFontStyle, "html { padding-bottom: 8px; }", "h5, h6 { margin-top: 8px; margin-bottom: 0 }", "h4 { margin-top: 8px; margin-bottom: 0; font-size: " + fontSize + "}", "h3 { margin-top: 8px; margin-bottom: 0; font-size: " + (fontSize + 3) + "}", "h2 { margin-top: 8px; margin-bottom: 0; font-size: " + (fontSize + 5) + "}", "h1 { margin-top: 8px; margin-bottom: 0; font-size: " + (fontSize + 9) + "}", "h0 { margin-top: 8px; margin-bottom: 0; font-size: " + (fontSize + 12) + "}", "a { color: " + linkColor + "; text-decoration: none;}", ".definition { padding: " + definitionTopPadding + "px 17px 1px " + leftPadding + "px;              border-bottom: thin solid " + borderColor + "; }", ".definition-only { padding: " + definitionTopPadding + "px 17px 0 " + leftPadding + "px; }", ".definition-only pre { margin-bottom: 0 }", ".content { padding: 5px 16px 0 " + leftPadding + "px; max-width: 100% }", ".content-separated { padding: 5px 16px 5px " + leftPadding + "px; max-width: 100%;                     border-bottom: thin solid " + borderColor + "; }", ".content-only { padding: 8px 16px 0 " + leftPadding + "px; max-width: 100% }", ".bottom { padding: 3px 16px 0 " + leftPadding + "px; }", ".bottom-no-content { padding: 5px 16px 0 " + leftPadding + "px; }", "p { padding: 1px 0 2px 0; }", "ol { padding: 0 16px 0 0; }", "ul { padding: 0 16px 0 0; }", "li { padding: 1px 0 2px 0; }", ".grayed { color: #909090; display: inline;}", ".centered { text-align: center}", ".sections { padding: 0 16px 0 " + leftPadding + "px; border-spacing: 0; }", "tr { margin: 0 0 0 0; padding: 0 0 0 0; }", "table p { padding-bottom: 0}", "td { margin: 4px 0 0 0; padding: 0 0 0 0; }", "th { text-align: left; }", "td pre { padding: 1px 0 0 0; margin: 0 0 0 0 }", ".section { color: " + sectionColor + "; padding-right: 4px; white-space:nowrap;}");
        if (list2 == null) {
            DocumentationHtmlUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorKit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationHtmlUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationHtmlUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationPaneDefaultCssRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIconsExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentationPaneDefaultCssRules";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

