/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationEditorPane;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EventListeners;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class DocumentationLinkHandler {
    @NotNull
    private final DocumentationEditorPane myEditorPane;
    @NotNull
    private final @NotNull Consumer<? super @NotNull String> myUrlConsumer;
    private int myHighlightedLink;

    private DocumentationLinkHandler(@NotNull DocumentationEditorPane pane, @NotNull @NotNull Consumer<? super @NotNull String> urlConsumer) {
        if (pane == null) {
            DocumentationLinkHandler.$$$reportNull$$$0(0);
        }
        if (urlConsumer == null) {
            DocumentationLinkHandler.$$$reportNull$$$0(1);
        }
        this.myEditorPane = pane;
        this.myUrlConsumer = urlConsumer;
        this.myHighlightedLink = -1;
    }

    @RequiresEdt
    public int getHighlightedLink() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myHighlightedLink;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void highlightLink(int n) {
        void n2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myHighlightedLink = n2;
        this.myEditorPane.highlightLink((int)n2);
    }

    @NotNull
    public @Unmodifiable @NotNull List<? extends @NotNull AnAction> createLinkActions() {
        List<ActivateLinkAction> list2 = List.of(new PreviousLinkAction(), new NextLinkAction(), new ActivateLinkAction());
        if (list2 == null) {
            DocumentationLinkHandler.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static DocumentationLinkHandler createAndRegister(@NotNull DocumentationEditorPane pane, @NotNull Disposable parent2, @NotNull @NotNull Consumer<? super @NotNull String> urlConsumer) {
        if (pane == null) {
            DocumentationLinkHandler.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            DocumentationLinkHandler.$$$reportNull$$$0(4);
        }
        if (urlConsumer == null) {
            DocumentationLinkHandler.$$$reportNull$$$0(5);
        }
        EventListeners.addHyperLinkListener(pane, parent2, e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                urlConsumer.accept(e.getDescription());
            }
        });
        return new DocumentationLinkHandler(pane, urlConsumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationLinkHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationLinkHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegister";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    private final class PreviousLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        PreviousLinkAction() {
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int linkCount;
            if (e == null) {
                PreviousLinkAction.$$$reportNull$$$0(0);
            }
            if ((linkCount = DocumentationLinkHandler.this.myEditorPane.getLinkCount()) <= 0) {
                return;
            }
            DocumentationLinkHandler.this.highlightLink(DocumentationLinkHandler.this.myHighlightedLink < 0 ? linkCount - 1 : (DocumentationLinkHandler.this.myHighlightedLink + linkCount - 1) % linkCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationLinkHandler$PreviousLinkAction", "actionPerformed"));
        }
    }

    private final class NextLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        NextLinkAction() {
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int linkCount;
            if (e == null) {
                NextLinkAction.$$$reportNull$$$0(0);
            }
            if ((linkCount = DocumentationLinkHandler.this.myEditorPane.getLinkCount()) <= 0) {
                return;
            }
            DocumentationLinkHandler.this.highlightLink((DocumentationLinkHandler.this.myHighlightedLink + 1) % linkCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationLinkHandler$NextLinkAction", "actionPerformed"));
        }
    }

    private final class ActivateLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        ActivateLinkAction() {
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String href;
            if (e == null) {
                ActivateLinkAction.$$$reportNull$$$0(0);
            }
            if ((href = DocumentationLinkHandler.this.myEditorPane.getLinkHref(DocumentationLinkHandler.this.myHighlightedLink)) != null) {
                DocumentationLinkHandler.this.myUrlConsumer.accept(href);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DocumentationLinkHandler$ActivateLinkAction", "actionPerformed"));
        }
    }
}

