/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

final class DocumentationLinkHighlightPainter
implements Highlighter.HighlightPainter {
    public static final Highlighter.HighlightPainter INSTANCE = new DocumentationLinkHighlightPainter();
    private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);

    private DocumentationLinkHighlightPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c2) {
        try {
            Rectangle target2 = c2.getUI().getRootView(c2).modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, bounds).getBounds();
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.setStroke(STROKE);
                g2d.setColor(c2.getSelectionColor());
                g2d.drawRect(target2.x, target2.y, target2.width - 1, target2.height - 1);
            }
            finally {
                g2d.dispose();
            }
        }
        catch (Exception e) {
            DocumentationManager.LOG.warn("Error painting link highlight", e);
        }
    }
}

