/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.documentation.DocToolWindowManager;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.WindowAction;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SwingActionDelegate;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@Deprecated
public class DocumentationManager
extends DockablePopupManager<DocumentationComponent> {
    public static final String JAVADOC_LOCATION_AND_SIZE = "javadoc.popup";
    public static final String NEW_JAVADOC_LOCATION_AND_SIZE = "javadoc.popup.new";
    public static final DataKey<String> SELECTED_QUICK_DOC_TEXT = DataKey.create((String)"QUICK_DOC.SELECTED_TEXT");
    static final Logger LOG = Logger.getInstance(DocumentationManager.class);
    private static final String SHOW_DOCUMENTATION_IN_TOOL_WINDOW = "ShowDocumentationInToolWindow";
    private static final String DOCUMENTATION_AUTO_UPDATE_ENABLED = "DocumentationAutoUpdateEnabled";
    private static final Class<?>[] ACTION_CLASSES_TO_IGNORE = new Class[]{HintManagerImpl.ActionToIgnore.class, ScrollingUtil.ScrollingAction.class, SwingActionDelegate.class, BaseNavigateToSourceAction.class, WindowAction.class};
    private static final String[] ACTION_IDS_TO_IGNORE = new String[]{"EditorDown", "EditorUp", "EditorPageDown", "EditorPageUp", "EditorEscape"};
    private static final String[] ACTION_PLACES_TO_IGNORE = new String[]{"JavadocInplaceSettings", "JavadocToolbar"};
    private Editor myEditor;
    private final Alarm myUpdateDocAlarm;
    private WeakReference<JBPopup> myDocInfoHintRef;
    private WeakReference<Component> myFocusedBeforePopup;
    public static final Key<SmartPsiElementPointer<?>> ORIGINAL_ELEMENT_KEY = Key.create("Original element");
    public static final Key<Boolean> IS_FROM_LOOKUP = Key.create("IS FROM LOOKUP");
    private boolean myCloseOnSneeze;
    @Nls
    private String myPrecalculatedDocumentation;
    private ActionCallback myLastAction;
    private DocumentationComponent myTestDocumentationComponent;
    private AnAction myRestorePopupAction;
    private ToolWindow myDefaultDocToolWindow;
    private final Map<String, ToolWindow> myLangToolWindows;
    private static final Pattern EXTERNAL_LINK_PATTERN = Pattern.compile("(<a\\s*href=[\"']http[^>]*>)([^>]*)(</a>)");
    @NlsSafe
    private static final String EXTERNAL_LINK_REPLACEMENT = "$1$2<icon src='AllIcons.Ide.External_link_arrow'>$3";

    @Override
    protected String getToolwindowId() {
        return "Documentation";
    }

    @Override
    protected String getToolwindowTitle() {
        return CodeInsightBundle.message("documentation.tool.window.title", new Object[0]);
    }

    @Override
    protected DocumentationComponent createComponent() {
        return new DocumentationComponent(this);
    }

    @Override
    public String getRestorePopupDescription() {
        return CodeInsightBundle.message("action.description.restore.popup.view.mode", new Object[0]);
    }

    @Override
    public String getAutoUpdateDescription() {
        return CodeInsightBundle.message("action.description.refresh.documentation.on.selection.change.automatically", new Object[0]);
    }

    @Override
    public String getAutoUpdateTitle() {
        return CodeInsightBundle.message("popup.title.auto.update.from.source", new Object[0]);
    }

    @Override
    protected boolean getAutoUpdateDefault() {
        return true;
    }

    @Override
    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction anAction = this.myRestorePopupAction = super.createRestorePopupAction();
        if (anAction == null) {
            DocumentationManager.$$$reportNull$$$0(0);
        }
        return anAction;
    }

    @Override
    public void restorePopupBehavior() {
        ToolWindow defaultToolWindow = this.myDefaultDocToolWindow;
        if (defaultToolWindow == null && this.myLangToolWindows.isEmpty()) {
            return;
        }
        this.myToolWindow = null;
        this.myDefaultDocToolWindow = null;
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.FALSE.toString());
        if (defaultToolWindow != null) {
            defaultToolWindow.remove();
            Disposer.dispose((Disposable)defaultToolWindow.getContentManager());
        }
        for (Map.Entry<String, ToolWindow> entry : this.myLangToolWindows.entrySet()) {
            DocToolWindowManager toolWindowManager;
            Language language = Language.findLanguageByID(entry.getKey());
            if (language == null || (toolWindowManager = (DocToolWindowManager)DocToolWindowManager.LANGUAGE_MANAGER.forLanguage(language)) == null) continue;
            toolWindowManager.disposeToolWindow(entry.getValue(), this);
        }
        this.myLangToolWindows.clear();
        this.restartAutoUpdate(false);
        Component previouslyFocused = SoftReference.dereference(this.myFocusedBeforePopup);
        if (previouslyFocused != null && previouslyFocused.isShowing()) {
            UIUtil.runWhenFocused(previouslyFocused, () -> this.updateComponent(true));
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(previouslyFocused, true);
        }
    }

    @Override
    public Content recreateToolWindow(PsiElement element, PsiElement originalElement) {
        Language language = element.getLanguage();
        DocToolWindowManager toolWindowManager = (DocToolWindowManager)DocToolWindowManager.LANGUAGE_MANAGER.forLanguage(language);
        ToolWindow toolWindow = toolWindowManager == null ? this.myDefaultDocToolWindow : this.myLangToolWindows.get(language.getID());
        if (toolWindow == null) {
            this.createToolWindow(element, originalElement);
            return null;
        }
        Content content2 = toolWindowManager != null ? toolWindowManager.getDocumentationContent(toolWindow, this) : toolWindow.getContentManager().getSelectedContent();
        if (content2 == null || !toolWindow.isVisible()) {
            this.restorePopupBehavior();
            this.createToolWindow(element, originalElement);
            return null;
        }
        return content2;
    }

    public void registerQuickDocShortcutSet(JComponent component2, AnAction restorePopupAction) {
        ShortcutSet quickDocShortcut = ActionManager.getInstance().getAction("QuickJavaDoc").getShortcutSet();
        restorePopupAction.registerCustomShortcutSet(quickDocShortcut, component2);
    }

    @Override
    public void createToolWindow(@NotNull PsiElement element, PsiElement originalElement) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(1);
        }
        this.createToolWindow(element, originalElement, false);
    }

    protected void createToolWindow(@NotNull PsiElement element, PsiElement originalElement, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(2);
        }
        this.doCreateToolWindow(element, originalElement, onAutoUpdate);
        if (this.myToolWindow != null) {
            this.myToolWindow.getComponent().putClientProperty("ChooseByNameBase.TemporarilyFocusableComponent", Boolean.TRUE);
        }
    }

    private void doCreateDefaultToolWindow(@NotNull PsiElement element, PsiElement originalElement) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(3);
        }
        this.myToolWindow = null;
        super.createToolWindow(element, originalElement);
        this.myDefaultDocToolWindow = this.myToolWindow;
        if (this.myRestorePopupAction != null) {
            this.registerQuickDocShortcutSet(this.myToolWindow.getComponent(), this.myRestorePopupAction);
            this.myRestorePopupAction = null;
        }
    }

    private void doCreateToolWindow(@NotNull PsiElement element, PsiElement originalElement, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(4);
        }
        Language language = element.getLanguage();
        assert (this.myLangToolWindows.get(language.getID()) == null);
        DocToolWindowManager toolWindowManager = (DocToolWindowManager)DocToolWindowManager.LANGUAGE_MANAGER.forLanguage(language);
        if (toolWindowManager == null) {
            this.doCreateDefaultToolWindow(element, originalElement);
            return;
        }
        if (onAutoUpdate && !toolWindowManager.isAutoUpdateAvailable()) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.createToolWindow(element, originalElement, this);
        final DocumentationComponent component2 = toolWindowManager.getDocumentationComponent(toolWindow, this);
        if (component2 == null) {
            this.doCreateDefaultToolWindow(element, originalElement);
            return;
        }
        this.myToolWindow = toolWindow;
        this.myLangToolWindows.put(language.getID(), toolWindow);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(false);
        toolWindow.show(null);
        toolWindowManager.installToolWindowActions(toolWindow, this);
        toolWindowManager.setToolWindowDefaultState(toolWindow, this);
        toolWindowManager.prepareForShowDocumentation(toolWindow, this);
        toolWindowManager.updateToolWindowDocumentationTabName(toolWindow, element, this);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getContent().getComponent() == component2) {
                    DocumentationManager.this.restorePopupBehavior();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/DocumentationManager$1", "contentRemoved"));
            }
        });
        new UiNotifyConnector((Component)component2, new Activatable(){

            public void showNotify() {
                DocumentationManager.this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(DocumentationManager.this.getAutoUpdateEnabledProperty(), DocumentationManager.this.getAutoUpdateDefault()));
            }

            public void hideNotify() {
                DocumentationManager.this.restartAutoUpdate(false);
            }
        });
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.TRUE.toString());
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), true));
        this.doUpdateComponent(element, originalElement, component2, onAutoUpdate);
    }

    @Override
    protected void installComponentActions(@NotNull ToolWindow toolWindow, DocumentationComponent component2) {
        if (toolWindow == null) {
            DocumentationManager.$$$reportNull$$$0(5);
        }
        toolWindow.setTitleActions(component2.getNavigationActions());
        DefaultActionGroup group2 = new DefaultActionGroup(this.createActions());
        group2.add(component2.getFontSizeAction());
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        component2.removeCornerMenu();
    }

    @Override
    protected void setToolwindowDefaultState(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            DocumentationManager.$$$reportNull$$$0(6);
        }
        Rectangle rectangle = Objects.requireNonNull(WindowManager.getInstance().getIdeFrame(this.myProject)).suggestChildFrameBounds();
        toolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.DOCKED, new Rectangle(rectangle.width / 4, rectangle.height));
        toolWindow.setType(ToolWindowType.DOCKED, null);
        toolWindow.setSplitMode(true, null);
        toolWindow.setAutoHide(false);
    }

    public static DocumentationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(7);
        }
        return project2.getService(DocumentationManager.class);
    }

    public DocumentationManager(@NotNull Project project2) {
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(8);
        }
        super(project2);
        this.myLangToolWindows = new HashMap<String, ToolWindow>();
        AnActionListener actionListener = new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                JBPopup hint;
                if (action2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((hint = DocumentationManager.this.getDocInfoHint()) != null && LookupManager.getActiveLookup(DocumentationManager.this.myEditor) == null && !Conditions.instanceOf(ACTION_CLASSES_TO_IGNORE).value(action2) && !ArrayUtil.contains(event.getPlace(), ACTION_PLACES_TO_IGNORE) && !ContainerUtil.exists(ACTION_IDS_TO_IGNORE, id -> ActionManager.getInstance().getAction(id) == action2) && this.clientOwns(hint)) {
                    DocumentationManager.this.closeDocHint();
                }
            }

            public void beforeEditorTyping(char c2, @NotNull DataContext dataContext2) {
                JBPopup hint;
                if (dataContext2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((hint = DocumentationManager.this.getDocInfoHint()) != null && LookupManager.getActiveLookup(DocumentationManager.this.myEditor) == null && this.clientOwns(hint)) {
                    hint.cancel();
                }
            }

            private boolean clientOwns(@NotNull JBPopup hint) {
                ClientId ownerId;
                if (hint == null) {
                    3.$$$reportNull$$$0(3);
                }
                return (ownerId = (ClientId)hint.getUserData(ClientId.class)) == null || ownerId.equals(ClientId.getCurrent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hint";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "clientOwns";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect(project2).subscribe(AnActionListener.TOPIC, actionListener);
        this.myUpdateDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        DocToolWindowManager.DocToolWindowLanguageManager.EP_NAME.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<DocToolWindowManager>>(){

            @Override
            public void extensionRemoved(@NotNull KeyedLazyInstance<DocToolWindowManager> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                String language;
                ToolWindow toolWindow;
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((toolWindow = DocumentationManager.this.myLangToolWindows.remove(language = extension2.getKey())) == null) {
                    return;
                }
                if (DocumentationManager.this.myToolWindow == toolWindow) {
                    DocumentationManager.this.myToolWindow = DocumentationManager.this.myDefaultDocToolWindow;
                    if (DocumentationManager.this.myToolWindow == null) {
                        DocumentationManager.this.myToolWindow = DocumentationManager.this.myLangToolWindows.values().stream().findFirst().orElse(null);
                    }
                }
                toolWindow.remove();
                Disposer.dispose((Disposable)toolWindow.getContentManager());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/documentation/DocumentationManager$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project2);
    }

    private void closeDocHint() {
        JBPopup hint = this.getDocInfoHint();
        if (hint == null) {
            return;
        }
        this.myCloseOnSneeze = false;
        hint.cancel();
        Component toFocus = SoftReference.dereference(this.myFocusedBeforePopup);
        hint.cancel();
        if (toFocus != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true);
        }
    }

    public void setAllowContentUpdateFromContext(boolean allow) {
        if (this.hasActiveDockedDocWindow()) {
            this.restartAutoUpdate(allow);
        }
    }

    public void updateToolwindowContext() {
        if (this.hasActiveDockedDocWindow()) {
            this.updateComponent();
        }
    }

    public void showJavaDocInfoAtToolWindow(@NotNull PsiElement element, @NotNull PsiElement original) {
        Content content2;
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(9);
        }
        if (original == null) {
            DocumentationManager.$$$reportNull$$$0(10);
        }
        if ((content2 = this.recreateToolWindow(element, original)) == null) {
            return;
        }
        DocumentationComponent component2 = (DocumentationComponent)content2.getComponent();
        this.myUpdateDocAlarm.cancelAllRequests();
        this.doFetchDocInfo(component2, new MyCollector(this.myProject, element, original, null, false, false)).doWhenDone(() -> component2.clearHistory());
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(11);
        }
        this.showJavaDocInfo(element, original, null);
    }

    public void showJavaDocInfo(@NotNull Editor editor2, @NotNull PsiElement element, @NotNull PsiElement original, @Nullable Runnable closeCallback, @Nullable @Nls String documentation, boolean closeOnSneeze, boolean useStoredPopupSize) {
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(12);
        }
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(13);
        }
        if (original == null) {
            DocumentationManager.$$$reportNull$$$0(14);
        }
        this.myEditor = editor2;
        this.myCloseOnSneeze = closeOnSneeze;
        this.showJavaDocInfo(element, original, false, closeCallback, documentation, useStoredPopupSize);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original, @Nullable Runnable closeCallback) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(15);
        }
        this.showJavaDocInfo(element, original, closeCallback, false);
    }

    protected void showJavaDocInfo(@NotNull PsiElement element, PsiElement original, @Nullable Runnable closeCallback, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(16);
        }
        this.showJavaDocInfo(element, original, false, closeCallback, null, true, onAutoUpdate);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original, boolean requestFocus, @Nullable Runnable closeCallback) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(17);
        }
        this.showJavaDocInfo(element, original, requestFocus, closeCallback, null, true);
    }

    public void showJavaDocInfo(@NotNull Editor editor2, @NotNull PsiElement element, PsiElement original, boolean requestFocus, @Nullable Runnable closeCallback) {
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(18);
        }
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(19);
        }
        this.myEditor = editor2;
        this.showJavaDocInfo(element, original, requestFocus, closeCallback, null, true);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, PsiElement original, boolean requestFocus, @Nullable Runnable closeCallback, @Nullable @Nls String documentation, boolean useStoredPopupSize) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(20);
        }
        this.showJavaDocInfo(element, original, requestFocus, closeCallback, documentation, useStoredPopupSize, false);
    }

    protected void showJavaDocInfo(@NotNull PsiElement element, final PsiElement original, final boolean requestFocus, @Nullable Runnable closeCallback, @Nullable @Nls String documentation, final boolean useStoredPopupSize, final boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(21);
        }
        if (!element.isValid()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(element.getProject()){

            public void updatePopup(Object lookupItemObject) {
                PsiElement psiElement = PSIPresentationBgRendererWrapper.toPsi(lookupItemObject);
                if (psiElement != null) {
                    DocumentationManager.this.doShowJavaDocInfo(psiElement, requestFocus, (PopupUpdateProcessor)this, original, null, null, useStoredPopupSize, onAutoUpdate);
                }
            }
        };
        this.doShowJavaDocInfo(element, requestFocus, updateProcessor, original, closeCallback, documentation, useStoredPopupSize, onAutoUpdate);
    }

    public void showJavaDocInfo(Editor editor2, @Nullable PsiFile file2, boolean requestFocus) {
        this.showJavaDocInfo(editor2, file2, requestFocus, null);
    }

    public void showJavaDocInfo(Editor editor2, @Nullable PsiFile file2, boolean requestFocus, @Nullable Runnable closeCallback) {
        this.showJavaDocInfo(editor2, file2, requestFocus, closeCallback, false);
    }

    protected void showJavaDocInfo(Editor editor2, @Nullable PsiFile file2, boolean requestFocus, final @Nullable Runnable closeCallback, final boolean onAutoUpdate) {
        this.myEditor = editor2;
        Project project2 = this.getProject(file2);
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        if (file2 != null && !file2.isValid()) {
            file2 = null;
        }
        final PsiFile finalFile = file2;
        final PsiElement originalElement = DocumentationManager.getContextElement(editor2, file2);
        int offset2 = editor2.getCaretModel().getOffset();
        CancellablePromise<PsiElement> elementPromise = ReadAction.nonBlocking(() -> this.findTargetElementFromContext(editor2, offset2, finalFile)).coalesceBy(this).submit(AppExecutorUtil.getAppExecutorService());
        final CompletableFuture elementFuture = Promises.asCompletableFuture(elementPromise);
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project2){

            public void updatePopup(Object lookupItemObject) {
                if (lookupItemObject == null) {
                    DocumentationManager.this.doShowJavaDocInfo(elementFuture, false, (PopupUpdateProcessor)this, originalElement, closeCallback, CodeInsightBundle.message("no.documentation.found", new Object[0]), true, onAutoUpdate);
                    return;
                }
                PsiElement psiElement = PSIPresentationBgRendererWrapper.toPsi(lookupItemObject);
                if (psiElement != null) {
                    DocumentationManager.this.doShowJavaDocInfo(psiElement, false, (PopupUpdateProcessor)this, originalElement, closeCallback, null, true, onAutoUpdate);
                    return;
                }
                DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(finalFile);
                PsiElement element = documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance(DocumentationManager.this.myProject), lookupItemObject, originalElement);
                if (element == null) {
                    DocumentationManager.this.doShowJavaDocInfo(elementFuture, false, (PopupUpdateProcessor)this, originalElement, closeCallback, CodeInsightBundle.message("no.documentation.found", new Object[0]), true, onAutoUpdate);
                    return;
                }
                if (DocumentationManager.this.myEditor != null) {
                    PsiFile file2 = element.getContainingFile();
                    if (file2 != null) {
                        Editor editor2 = DocumentationManager.this.myEditor;
                        DocumentationManager.this.showJavaDocInfo(DocumentationManager.this.myEditor, file2, false);
                        DocumentationManager.this.myEditor = editor2;
                    }
                } else {
                    DocumentationManager.this.doShowJavaDocInfo(element, false, (PopupUpdateProcessor)this, originalElement, closeCallback, null, true, onAutoUpdate);
                }
            }
        };
        this.doShowJavaDocInfo(elementFuture, requestFocus, updateProcessor, originalElement, closeCallback, null, true, onAutoUpdate);
    }

    public PsiElement findTargetElement(Editor editor2, PsiFile file2) {
        return this.findTargetElement(editor2, file2, DocumentationManager.getContextElement(editor2, file2));
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getContextElement(Editor editor2, PsiFile file2) {
        return DocumentationManager.getContextElement(file2, editor2.getCaretModel().getOffset());
    }

    @Nullable
    private static PsiElement getContextElement(@Nullable PsiFile file2, int offset2) {
        if (file2 == null) {
            return null;
        }
        if (offset2 == file2.getTextLength()) {
            offset2 = Math.max(0, offset2 - 1);
        }
        return file2.findElementAt(offset2);
    }

    protected void doShowJavaDocInfo(@NotNull PsiElement element, boolean requestFocus, @NotNull PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, @Nullable @Nls String documentation, boolean useStoredPopupSize, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(22);
        }
        if (updateProcessor == null) {
            DocumentationManager.$$$reportNull$$$0(23);
        }
        this.doShowJavaDocInfo(element, requestFocus, updateProcessor, originalElement, closeCallback, null, documentation, useStoredPopupSize, onAutoUpdate);
    }

    protected void doShowJavaDocInfo(@NotNull PsiElement element, boolean requestFocus, @NotNull PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, @Nullable ActionCallback actionCallback, @Nullable @Nls String documentation, boolean useStoredPopupSize, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(24);
        }
        if (updateProcessor == null) {
            DocumentationManager.$$$reportNull$$$0(25);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        ReadAction.run(() -> {
            this.assertSameProject(element);
            DocumentationManager.storeOriginalElement(this.myProject, originalElement, element);
        });
        JBPopup prevHint = this.getDocInfoHint();
        Language language = element.getLanguage();
        DocToolWindowManager toolWindowManager = (DocToolWindowManager)DocToolWindowManager.LANGUAGE_MANAGER.forLanguage(language);
        ToolWindow newToolWindow = toolWindowManager == null ? this.myDefaultDocToolWindow : this.myLangToolWindows.get(language.getID());
        this.myPrecalculatedDocumentation = documentation;
        if (newToolWindow == null && PropertiesComponent.getInstance().isTrueValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW)) {
            this.createToolWindow(element, originalElement, onAutoUpdate);
        } else if (newToolWindow != null) {
            this.myToolWindow = newToolWindow;
            Content content2 = toolWindowManager != null ? toolWindowManager.getDocumentationContent(this.myToolWindow, this) : this.myToolWindow.getContentManager().getSelectedContent();
            if (content2 != null) {
                DocumentationComponent component2 = (DocumentationComponent)content2.getComponent();
                boolean sameElement = element.getManager().areElementsEquivalent(component2.getElement(), element);
                if (sameElement) {
                    boolean focus;
                    JComponent preferredFocusableComponent = content2.getPreferredFocusableComponent();
                    boolean bl = focus = requestFocus || CommandProcessor.getInstance().getCurrentCommand() != null;
                    if (preferredFocusableComponent != null && focus) {
                        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusableComponent, true);
                    }
                }
                if (!sameElement || !component2.isUpToDate()) {
                    this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, element, originalElement, null, actionCallback, false, onAutoUpdate)).doWhenDone(() -> component2.clearHistory());
                }
            }
            if (!this.myToolWindow.isVisible()) {
                this.myToolWindow.show(null);
            }
        } else if (prevHint != null && prevHint.isVisible() && prevHint instanceof AbstractPopup) {
            DocumentationComponent component3 = (DocumentationComponent)((AbstractPopup)prevHint).getComponent();
            ActionCallback result2 = this.cancelAndFetchDocInfo(component3, new MyCollector(this.myProject, element, originalElement, null, actionCallback, false, false));
            if (requestFocus) {
                result2.doWhenDone(() -> {
                    JBPopup hint = this.getDocInfoHint();
                    if (hint != null) {
                        ((AbstractPopup)hint).focusPreferredComponent();
                    }
                });
            }
        } else {
            this.showInPopup(element, requestFocus, updateProcessor, originalElement, closeCallback, actionCallback, useStoredPopupSize);
        }
    }

    protected void doShowJavaDocInfo(@NotNull CompletableFuture<? extends PsiElement> elementFuture, boolean requestFocus, @NotNull PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, @Nullable @Nls String documentation, boolean useStoredPopupSize, boolean onAutoUpdate) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(26);
        }
        if (updateProcessor == null) {
            DocumentationManager.$$$reportNull$$$0(27);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        PsiElement targetElement = null;
        try {
            targetElement = elementFuture.get(50L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.debug("Failed to calculate targetElement in 50ms", e);
        }
        if (targetElement != null) {
            this.doShowJavaDocInfo(targetElement, requestFocus, updateProcessor, originalElement, closeCallback, documentation, useStoredPopupSize, onAutoUpdate);
        } else {
            ActionCallback actionCallback = this.createActionCallback();
            elementFuture.thenAccept(element -> {
                if (element != null) {
                    AppUIUtil.invokeOnEdt(() -> this.doShowJavaDocInfo((PsiElement)element, requestFocus, updateProcessor, originalElement, closeCallback, actionCallback, documentation, useStoredPopupSize, onAutoUpdate));
                }
            });
        }
    }

    private void showInPopup(@NotNull PsiElement element, boolean requestFocus, PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, @Nullable ActionCallback actionCallback, boolean useStoredPopupSize) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(28);
        }
        Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myFocusedBeforePopup = new WeakReference<Component>(focusedComponent);
        DocumentationComponent component2 = this.myTestDocumentationComponent == null ? new DocumentationComponent(this, useStoredPopupSize) : this.myTestDocumentationComponent;
        ActionListener actionListener = __ -> {
            this.createToolWindow(element, originalElement);
            JBPopup hint = this.getDocInfoHint();
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        };
        SmartList<Pair<ActionListener, KeyStroke>> actions = new SmartList<Pair<ActionListener, KeyStroke>>();
        AnAction quickDocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        for (Shortcut shortcut : quickDocAction.getShortcutSet().getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            actions.add(Pair.create(actionListener, ((KeyboardShortcut)shortcut).getFirstKeyStroke()));
        }
        boolean hasLookup = LookupManager.getActiveLookup(this.myEditor) != null;
        AbstractPopup hint = (AbstractPopup)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component2, (JComponent)component2).setProject(this.myProject).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).addUserData((Object)ClientId.getCurrent()).setKeyboardActions(actions).setResizable(true).setMovable(true).setFocusable(true).setRequestFocus(requestFocus).setCancelOnClickOutside(!hasLookup).setModalContext(false).setCancelCallback(() -> {
            if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                return false;
            }
            this.myCloseOnSneeze = false;
            if (closeCallback != null) {
                closeCallback.run();
            }
            this.findQuickSearchComponent().ifPresent(QuickSearchComponent::unregisterHint);
            Disposer.dispose(component2);
            this.myEditor = null;
            return Boolean.TRUE;
        }).setKeyEventHandler(e -> {
            if (this.myCloseOnSneeze) {
                this.closeDocHint();
            }
            if (AbstractPopup.isCloseRequest((KeyEvent)e) && this.getDocInfoHint() != null) {
                this.closeDocHint();
                return true;
            }
            return false;
        }).createPopup();
        component2.setHint((JBPopup)hint);
        component2.setToolwindowCallback(() -> {
            this.createToolWindow(element, originalElement);
            this.myToolWindow.setAutoHide(false);
            hint.cancel();
        });
        if (useStoredPopupSize && DimensionService.getInstance().getSize(NEW_JAVADOC_LOCATION_AND_SIZE, this.myProject) != null) {
            hint.setDimensionServiceKey(NEW_JAVADOC_LOCATION_AND_SIZE);
        }
        if (this.myEditor == null) {
            LookupEx lookup2 = LookupManager.getInstance(this.myProject).getActiveLookup();
            this.myEditor = lookup2 != null ? lookup2.getEditor() : null;
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, element, originalElement, null, actionCallback, false, false));
        this.myDocInfoHintRef = new WeakReference<AbstractPopup>(hint);
        this.findQuickSearchComponent().ifPresent(quickSearch -> quickSearch.registerHint((JBPopup)hint));
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e.getID() == 501 && e.getSource() == hint.getPopupWindow()) {
                this.myCloseOnSneeze = false;
            }
            return false;
        }, (Disposable)component2);
    }

    public static void storeOriginalElement(Project project2, PsiElement originalElement, PsiElement element) {
        if (element == null) {
            return;
        }
        try {
            element.putUserData(ORIGINAL_ELEMENT_KEY, SmartPointerManager.getInstance(project2).createSmartPsiElementPointer(originalElement));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nullable
    private PsiElement findTargetElementFromContext(@NotNull Editor editor2, int offset2, @Nullable PsiFile file2) {
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(29);
        }
        if (LookupManager.getInstance(this.myProject).getActiveLookup() != null) {
            try {
                return this.assertSameProject(this.getElementFromLookup(editor2, file2));
            }
            catch (IndexNotReadyException e) {
                return null;
            }
        }
        Pair<PsiElement, PsiElement> elementAndContext = this.findTargetElementAndContext(editor2, offset2, file2);
        return elementAndContext == null ? null : (PsiElement)elementAndContext.first;
    }

    @ApiStatus.Internal
    @Nullable
    public @Nullable Pair<@NotNull PsiElement, @Nullable PsiElement> findTargetElementAndContext(@NotNull Editor editor2, int offset2, @Nullable PsiFile file2) {
        Object list2;
        PsiElement originalElement;
        PsiElement element;
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(30);
        }
        if ((element = this.findTargetElementAtOffset(editor2, offset2, file2, originalElement = DocumentationManager.getContextElement(file2, offset2))) == null && (list2 = ParameterInfoControllerBase.findArgumentList(file2, offset2, -1)) != null) {
            element = list2;
        }
        if (element == null && file2 == null) {
            return null;
        }
        if (element == null) {
            element = this.assertSameProject(originalElement);
            if (element == null) {
                return null;
            }
            PsiComment comment = PsiTreeUtil.getParentOfType(element, PsiComment.class);
            if (comment == null) {
                return null;
            }
            PsiElement psiElement = element = comment instanceof PsiDocCommentBase ? ((PsiDocCommentBase)comment).getOwner() : comment.getParent();
            if (element == null) {
                return null;
            }
        }
        return Pair.create(element, originalElement);
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor2, @Nullable PsiFile file2, PsiElement contextElement) {
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(31);
        }
        return this.findTargetElement(editor2, editor2.getCaretModel().getOffset(), file2, contextElement);
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor2, int offset2, @Nullable PsiFile file2, PsiElement contextElement) {
        try {
            return this.findTargetElementUnsafe(editor2, offset2, file2, contextElement);
        }
        catch (IndexNotReadyException ex) {
            LOG.debug(ex);
            return null;
        }
    }

    @Nullable
    private PsiElement findTargetElementUnsafe(Editor editor2, int offset2, @Nullable PsiFile file2, PsiElement contextElement) {
        if (LookupManager.getInstance(this.myProject).getActiveLookup() != null) {
            return this.assertSameProject(this.getElementFromLookup(editor2, file2));
        }
        return this.findTargetElementAtOffset(editor2, offset2, file2, contextElement);
    }

    @ApiStatus.Internal
    @Nullable
    public PsiElement findTargetElementAtOffset(@NotNull Editor editor2, int offset2, @Nullable PsiFile file2, @Nullable PsiElement contextElement) {
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(32);
        }
        PsiElement element = this.assertSameProject(DocumentationManager.doFindTargetElementAtOffset(editor2, offset2, file2, contextElement));
        DocumentationManager.storeOriginalElement(this.myProject, contextElement, element);
        DocumentationManager.storeIsFromLookup(element, false);
        return element;
    }

    @Nullable
    private static PsiElement doFindTargetElementAtOffset(@NotNull Editor editor2, int offset2, @Nullable PsiFile file2, @Nullable PsiElement contextElement) {
        PsiElement element;
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(33);
        }
        if ((element = DocumentationManager.customElement(editor2, file2, offset2, contextElement)) != null) {
            return element;
        }
        element = DocumentationManager.fromTargetUtil(editor2, offset2, contextElement);
        if (element != null) {
            return element;
        }
        return DocumentationManager.fromReference(editor2, offset2);
    }

    @Nullable
    private static PsiElement customElement(@NotNull Editor editor2, @Nullable PsiFile file2, int offset2, @Nullable PsiElement contextElement) {
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(34);
        }
        if (file2 == null) {
            return null;
        }
        return DocumentationManager.getProviderFromElement(file2).getCustomDocumentationElement(editor2, file2, contextElement, offset2);
    }

    @Nullable
    private static PsiElement fromTargetUtil(@NotNull Editor editor2, int offset2, @Nullable PsiElement contextElement) {
        TargetElementUtil util;
        PsiElement element;
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(35);
        }
        if ((element = (util = TargetElementUtil.getInstance()).findTargetElement(editor2, util.getAllAccepted(), offset2)) == null && contextElement == null) {
            return null;
        }
        PsiElement adjusted = util.adjustElement(editor2, util.getAllAccepted(), element, contextElement);
        return adjusted != null ? adjusted : element;
    }

    @Nullable
    private static PsiElement fromReference(@NotNull Editor editor2, int offset2) {
        PsiReference ref;
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(36);
        }
        if ((ref = TargetElementUtil.findReference(editor2, offset2)) == null) {
            return null;
        }
        if (ref instanceof PsiPolyVariantReference) {
            return ref.getElement();
        }
        return TargetElementUtil.getInstance().adjustReference(ref);
    }

    private static void storeIsFromLookup(@Nullable PsiElement element, boolean value) {
        if (element == null) {
            return;
        }
        element.putUserData(IS_FROM_LOOKUP, value ? Boolean.valueOf(true) : null);
    }

    @Nullable
    public PsiElement getElementFromLookup(Editor editor2, @Nullable PsiFile file2) {
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null) {
            return DocumentationManager.getElementFromLookup(this.myProject, editor2, file2, item);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getElementFromLookup(@NotNull Project project2, @NotNull Editor editor2, @Nullable PsiFile file2, @NotNull LookupElement item) {
        PsiElement fromProvider;
        PsiElement targetElement;
        int offset2;
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(37);
        }
        if (editor2 == null) {
            DocumentationManager.$$$reportNull$$$0(38);
        }
        if (item == null) {
            DocumentationManager.$$$reportNull$$$0(39);
        }
        if ((offset2 = editor2.getCaretModel().getOffset()) > 0 && offset2 == editor2.getDocument().getTextLength()) {
            --offset2;
        }
        PsiReference ref = TargetElementUtil.findReference(editor2, offset2);
        PsiElement contextElement = file2 == null ? null : (PsiElement)ObjectUtils.coalesce(file2.findElementAt(offset2), file2);
        PsiElement psiElement = targetElement = ref != null ? ref.getElement() : contextElement;
        if (targetElement != null) {
            PsiUtilCore.ensureValid(targetElement);
        }
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(file2);
        PsiManager psiManager = PsiManager.getInstance(project2);
        PsiElement psiElement2 = fromProvider = targetElement == null ? null : documentationProvider.getDocumentationElementForLookupItem(psiManager, item.getObject(), targetElement);
        if (fromProvider == null) {
            return CompletionUtil.getTargetElement(item);
        }
        DocumentationManager.storeIsFromLookup(fromProvider, true);
        return fromProvider;
    }

    @NlsSafe
    public String generateDocumentation(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean onHover) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(40);
        }
        return new MyCollector(this.myProject, element, originalElement, null, onHover, false).getDocumentation();
    }

    public @NotNull Pair<@NlsSafe String, @Nullable DocumentationProvider> getDocumentationAndProvider(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean onHover) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(41);
        }
        MyCollector collector2 = new MyCollector(this.myProject, element, originalElement, null, onHover, false);
        Pair<String, DocumentationProvider> pair = Pair.create(collector2.getDocumentation(), collector2.provider);
        if (pair == null) {
            DocumentationManager.$$$reportNull$$$0(42);
        }
        return pair;
    }

    @Nullable
    public JBPopup getDocInfoHint() {
        if (this.myDocInfoHintRef == null) {
            return null;
        }
        JBPopup hint = (JBPopup)this.myDocInfoHintRef.get();
        if (hint == null || !hint.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (hint != null) {
                hint.cancel();
            }
            this.myDocInfoHintRef = null;
            return null;
        }
        return hint;
    }

    public void fetchDocInfo(@NotNull PsiElement element, @NotNull DocumentationComponent component2) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(43);
        }
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(44);
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, element, null, null, false, false));
    }

    public ActionCallback queueFetchDocInfo(@NotNull PsiElement element, @NotNull DocumentationComponent component2) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(45);
        }
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(46);
        }
        return this.doFetchDocInfo(component2, new MyCollector(this.myProject, element, null, null, false, false));
    }

    private ActionCallback cancelAndFetchDocInfo(@NotNull DocumentationComponent component2, @NotNull DocumentationCollector provider2) {
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(47);
        }
        if (provider2 == null) {
            DocumentationManager.$$$reportNull$$$0(48);
        }
        this.myUpdateDocAlarm.cancelAllRequests();
        return this.doFetchDocInfo(component2, provider2);
    }

    void updateToolWindowTabName(@NotNull PsiElement element) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(49);
        }
        if (this.myToolWindow != null) {
            DocToolWindowManager toolWindowManager = (DocToolWindowManager)DocToolWindowManager.LANGUAGE_MANAGER.forLanguage(element.getLanguage());
            if (toolWindowManager != null) {
                toolWindowManager.updateToolWindowDocumentationTabName(this.myToolWindow, element, this);
            } else {
                Content content2 = this.myToolWindow.getContentManager().getSelectedContent();
                if (content2 != null) {
                    content2.setDisplayName(this.getTitle(element));
                }
            }
        }
    }

    private ActionCallback doFetchDocInfo(@NotNull DocumentationComponent component2, @NotNull DocumentationCollector collector2) {
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(50);
        }
        if (collector2 == null) {
            DocumentationManager.$$$reportNull$$$0(51);
        }
        ActionCallback callback = collector2.actionCallback != null ? collector2.actionCallback : this.createActionCallback();
        boolean wasEmpty = component2.isEmpty();
        if (wasEmpty) {
            component2.setText(CodeInsightBundle.message("javadoc.fetching.progress", new Object[0]), null, collector2.provider);
        }
        ModalityState modality = ModalityState.defaultModalityState();
        String precalculatedDocumentation = this.myPrecalculatedDocumentation;
        this.myPrecalculatedDocumentation = null;
        this.myUpdateDocAlarm.addRequest(() -> {
            DocumentationProvider provider2;
            String text2;
            if (this.myProject.isDisposed()) {
                return;
            }
            LOG.debug("Started fetching documentation...");
            PsiElement element = collector2.getElement(true);
            if (element == null || !ReadAction.compute(() -> element.isValid()).booleanValue()) {
                LOG.debug("Element for which documentation was requested is not available anymore");
                ModalityUiUtil.invokeLaterIfNeeded(ModalityState.any(), () -> component2.setText(CodeInsightBundle.message("no.documentation.found", new Object[0]), null, collector2.provider));
                callback.setDone();
                return;
            }
            Language elementLanguage = ReadAction.compute(() -> element.getLanguage());
            DocToolWindowManager toolWindowManager = (DocToolWindowManager)DocToolWindowManager.LANGUAGE_MANAGER.forLanguage(elementLanguage);
            if (toolWindowManager != null) {
                if (collector2.onAutoUpdate && !toolWindowManager.isAutoUpdateAvailable()) {
                    callback.setDone();
                    return;
                }
                if (this.myToolWindow != null) {
                    toolWindowManager.prepareForShowDocumentation(this.myToolWindow, this);
                }
            }
            component2.startWait();
            try {
                if (precalculatedDocumentation != null) {
                    LOG.debug("Setting precalculated documentation:\n", precalculatedDocumentation);
                    text2 = precalculatedDocumentation;
                    PsiElement originalElement = DocumentationManager.getOriginalElement(collector2, element);
                    provider2 = ReadAction.compute(() -> DocumentationManager.getProviderFromElement(element, originalElement));
                } else {
                    text2 = collector2.getDocumentation();
                    provider2 = collector2.provider;
                }
            }
            catch (Throwable e) {
                LOG.info(e);
                ModalityUiUtil.invokeLaterIfNeeded(ModalityState.any(), () -> {
                    String message = e instanceof IndexNotReadyException ? CodeInsightBundle.message("documentation.message.documentation.is.not.available", new Object[0]) : CodeInsightBundle.message("javadoc.external.fetch.error.message", new Object[0]);
                    component2.setText(message, null, collector2.provider);
                    component2.clearHistory();
                    callback.setDone();
                });
                return;
            }
            LOG.debug("Documentation fetched successfully:\n", text2);
            @Nls String decoratedText = ReadAction.compute(() -> {
                if (text2 == null) {
                    return this.decorate(element, CodeInsightBundle.message("no.documentation.found", new Object[0]), null, provider2);
                }
                if (text2.isEmpty()) {
                    return null;
                }
                if (precalculatedDocumentation != null) {
                    return text2;
                }
                return this.decorate(element, text2, collector2.effectiveUrl, provider2);
            });
            PsiDocumentManager.getInstance(this.myProject).performLaterWhenAllCommitted(modality, () -> {
                if (!element.isValid()) {
                    LOG.debug("Element for which documentation was requested is not valid");
                    callback.setDone();
                    return;
                }
                if (text2 == null) {
                    component2.setText(decoratedText, element, provider2);
                } else if (text2.isEmpty()) {
                    component2.setText(component2.getDecoratedText(), element, provider2);
                } else {
                    component2.setData(element, decoratedText, collector2.effectiveUrl, collector2.ref, provider2);
                }
                if (wasEmpty) {
                    component2.clearHistory();
                }
                callback.setDone();
            });
        }, 10);
        return callback;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(PsiElement element) {
        return DocumentationManager.getProviderFromElement(element, null);
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (originalElement != null && !originalElement.isValid()) {
            originalElement = null;
        }
        if (originalElement == null) {
            originalElement = DocumentationManager.getOriginalElement(element);
        }
        PsiFile containingFile = originalElement != null ? originalElement.getContainingFile() : (element != null ? element.getContainingFile() : null);
        LinkedHashSet result2 = new LinkedHashSet();
        Language containingFileLanguage = containingFile != null ? containingFile.getLanguage() : null;
        DocumentationProvider originalProvider = containingFile != null ? LanguageDocumentation.INSTANCE.forLanguage(containingFileLanguage) : null;
        Language elementLanguage = element != null ? element.getLanguage() : null;
        DocumentationProvider elementProvider = element == null || elementLanguage.is(containingFileLanguage) ? null : LanguageDocumentation.INSTANCE.forLanguage(elementLanguage);
        ContainerUtil.addIfNotNull(result2, elementProvider);
        ContainerUtil.addIfNotNull(result2, originalProvider);
        if (containingFile != null) {
            Language baseLanguage = containingFile.getViewProvider().getBaseLanguage();
            if (!baseLanguage.is(containingFileLanguage)) {
                ContainerUtil.addIfNotNull(result2, LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        } else if (element instanceof PsiDirectory) {
            HashSet<Language> set2 = new HashSet<Language>();
            for (PsiFile file2 : ((PsiDirectory)element).getFiles()) {
                Language baseLanguage = file2.getViewProvider().getBaseLanguage();
                if (set2.contains(baseLanguage)) continue;
                set2.add(baseLanguage);
                ContainerUtil.addIfNotNull(result2, LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        }
        DocumentationProvider documentationProvider = CompositeDocumentationProvider.wrapProviders(result2);
        if (documentationProvider == null) {
            DocumentationManager.$$$reportNull$$$0(52);
        }
        return documentationProvider;
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiElement element) {
        SmartPsiElementPointer<?> originalElementPointer = element != null ? element.getUserData(ORIGINAL_ELEMENT_KEY) : null;
        return originalElementPointer != null ? (PsiElement)originalElementPointer.getElement() : null;
    }

    @Nullable
    public PsiElement getTargetElement(@Nullable PsiElement context2, @Nullable String url) {
        Pair<@NotNull PsiElement, @Nullable String> target2 = this.getTarget(context2, url);
        return target2 == null ? null : (PsiElement)target2.first;
    }

    @Nullable
    private @Nullable Pair<@NotNull PsiElement, @Nullable String> getTarget(@Nullable PsiElement context2, @Nullable String url) {
        if (context2 == null || url == null) {
            return null;
        }
        return DocumentationManager.targetAndRef(this.getProject(context2), url, context2);
    }

    @ApiStatus.Internal
    @Nullable
    public static @Nullable Pair<@NotNull PsiElement, @Nullable String> targetAndRef(@NotNull Project project2, @NotNull String url, @Nullable PsiElement context2) {
        Pair<String, String> linkAndRef;
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(53);
        }
        if (url == null) {
            DocumentationManager.$$$reportNull$$$0(54);
        }
        if ((linkAndRef = DocumentationManager.parseUrl(url)) == null) {
            return null;
        }
        PsiElement targetElement = DocumentationManager.targetElement(project2, (String)linkAndRef.first, context2);
        if (targetElement != null) {
            return Pair.create(targetElement, (String)linkAndRef.second);
        }
        return null;
    }

    @Nullable
    private static @Nullable Pair<@NotNull String, @Nullable String> parseUrl(@NotNull String url) {
        if (url == null) {
            DocumentationManager.$$$reportNull$$$0(55);
        }
        if (!url.startsWith("psi_element://")) {
            return null;
        }
        String withoutProtocol = url.substring("psi_element://".length());
        int separatorPos = withoutProtocol.lastIndexOf("###");
        if (separatorPos >= 0) {
            return Pair.create(withoutProtocol.substring(0, separatorPos), withoutProtocol.substring(separatorPos + "###".length()));
        }
        return Pair.create(withoutProtocol, null);
    }

    @Nullable
    private static PsiElement targetElement(@NotNull Project project2, @NotNull String link, @Nullable PsiElement context2) {
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(56);
        }
        if (link == null) {
            DocumentationManager.$$$reportNull$$$0(57);
        }
        PsiManager manager = PsiManager.getInstance(project2);
        DocumentationProvider provider2 = DocumentationManager.getProviderFromElement(context2);
        PsiElement targetElement = provider2.getDocumentationElementForLink(manager, link, context2);
        if (targetElement != null) {
            return targetElement;
        }
        return DocumentationManager.targetFromLanguageProviders(manager, link, context2);
    }

    @Nullable
    private static PsiElement targetFromLanguageProviders(@NotNull PsiManager manager, @NotNull String link, @Nullable PsiElement context2) {
        if (manager == null) {
            DocumentationManager.$$$reportNull$$$0(58);
        }
        if (link == null) {
            DocumentationManager.$$$reportNull$$$0(59);
        }
        for (Language language : Language.getRegisteredLanguages()) {
            PsiElement targetElement;
            DocumentationProvider documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language);
            if (documentationProvider == null || (targetElement = documentationProvider.getDocumentationElementForLink(manager, link, context2)) == null) continue;
            return targetElement;
        }
        return null;
    }

    private static PsiElement getOriginalElement(@NotNull DocumentationCollector collector2, PsiElement targetElement) {
        if (collector2 == null) {
            DocumentationManager.$$$reportNull$$$0(60);
        }
        return collector2 instanceof MyCollector ? ((MyCollector)collector2).originalElement : targetElement;
    }

    public void navigateByLink(@NotNull DocumentationComponent component2, @Nullable PsiElement context2, final @NotNull String url) {
        PsiElement psiElement;
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(61);
        }
        if (url == null) {
            DocumentationManager.$$$reportNull$$$0(62);
        }
        this.myPrecalculatedDocumentation = null;
        component2.setCursor(Cursor.getPredefinedCursor(3));
        PsiElement psiElement2 = psiElement = context2 != null ? context2 : component2.getElement();
        if (psiElement == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance(this.getProject(psiElement));
        if (url.equals("external_doc")) {
            component2.showExternalDoc();
            return;
        }
        if (url.startsWith("open")) {
            OrderEntry libraryEntry2 = DocumentationManager.libraryEntry(this.myProject, psiElement);
            if (libraryEntry2 != null) {
                ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings(libraryEntry2);
            }
        } else {
            if (url.startsWith("psi_element://")) {
                ActionCallback callback = this.createActionCallback();
                callback.doWhenProcessed(() -> component2.setCursor(Cursor.getPredefinedCursor(0)));
                ReadAction.nonBlocking(() -> this.getTarget(psiElement, url)).finishOnUiThread(ModalityState.defaultModalityState(), target2 -> {
                    if (target2 == null) {
                        callback.setDone();
                        return;
                    }
                    this.cancelAndFetchDocInfoByLink(component2, new MyCollector(this.myProject, (PsiElement)target2.first, null, (String)target2.second, callback, false, false));
                }).submit(AppExecutorUtil.getAppExecutorService());
                return;
            }
            DocumentationProvider provider2 = DocumentationManager.getProviderFromElement(psiElement);
            boolean processed2 = false;
            if (provider2 instanceof CompositeDocumentationProvider) {
                for (DocumentationProvider p : ((CompositeDocumentationProvider)provider2).getAllProviders()) {
                    if (!(p instanceof ExternalDocumentationHandler)) continue;
                    final ExternalDocumentationHandler externalHandler = (ExternalDocumentationHandler)((Object)p);
                    if (externalHandler.canFetchDocumentationLink(url)) {
                        String ref = externalHandler.extractRefFromLink(url);
                        this.cancelAndFetchDocInfoByLink(component2, new DocumentationCollector(psiElement, url, ref, p, false){

                            @Override
                            @Nls
                            public String getDocumentation() {
                                return externalHandler.fetchExternalDocumentation(url, psiElement);
                            }
                        });
                        processed2 = true;
                        continue;
                    }
                    if (!externalHandler.handleExternalLink(manager, url, psiElement)) continue;
                    processed2 = true;
                    break;
                }
            }
            if (!processed2) {
                this.cancelAndFetchDocInfoByLink(component2, new DocumentationCollector(psiElement, url, null, provider2, false){

                    @Override
                    @Nls
                    public String getDocumentation() {
                        if (BrowserUtil.isAbsoluteURL((String)url)) {
                            BrowserUtil.browse((String)url);
                            return "";
                        }
                        return CodeInsightBundle.message("javadoc.error.resolving.url", url);
                    }
                });
            }
        }
        component2.setCursor(Cursor.getPredefinedCursor(0));
    }

    @ApiStatus.Internal
    @Nullable
    public static OrderEntry libraryEntry(@NotNull Project project2, @NotNull PsiElement psiElement) {
        PsiFile containingFile;
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(63);
        }
        if (psiElement == null) {
            DocumentationManager.$$$reportNull$$$0(64);
        }
        if ((containingFile = psiElement.getContainingFile()) != null) {
            return DocumentationManager.libraryEntry(project2, containingFile);
        }
        if (psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                OrderEntry libraryEntry2 = DocumentationManager.libraryEntry(project2, directory);
                if (libraryEntry2 == null) continue;
                return libraryEntry2;
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static OrderEntry libraryEntry(@NotNull Project project2, @NotNull PsiFileSystemItem directory) {
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(65);
        }
        if (directory == null) {
            DocumentationManager.$$$reportNull$$$0(66);
        }
        VirtualFile virtualFile2 = directory.getVirtualFile();
        return LibraryUtil.findLibraryEntry(virtualFile2, project2);
    }

    protected ActionCallback cancelAndFetchDocInfoByLink(@NotNull DocumentationComponent component2, @NotNull DocumentationCollector provider2) {
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(67);
        }
        if (provider2 == null) {
            DocumentationManager.$$$reportNull$$$0(68);
        }
        return this.cancelAndFetchDocInfo(component2, provider2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public Project getProject(@Nullable PsiElement element) {
        this.assertSameProject(element);
        return this.myProject;
    }

    private PsiElement assertSameProject(@Nullable PsiElement element) {
        if (element != null && element.isValid() && this.myProject != element.getProject()) {
            throw new AssertionError((Object)(this.myProject + "!=" + element.getProject() + "; element=" + element));
        }
        return element;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label2, boolean plainLink) {
        DocumentationManagerUtil.createHyperlink(buffer, refText, label2, plainLink, false);
    }

    @Override
    public String getShowInToolWindowProperty() {
        return SHOW_DOCUMENTATION_IN_TOOL_WINDOW;
    }

    @Override
    public String getAutoUpdateEnabledProperty() {
        return DOCUMENTATION_AUTO_UPDATE_ENABLED;
    }

    @Override
    protected void doUpdateComponent(@NotNull CompletableFuture<? extends PsiElement> elementFuture, PsiElement originalElement, DocumentationComponent component2) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(69);
        }
        this.doUpdateComponent(elementFuture, originalElement, component2, false);
    }

    @Override
    protected void doUpdateComponent(@NotNull CompletableFuture<? extends PsiElement> elementFuture, PsiElement originalElement, DocumentationComponent component2, boolean onAutoUpdate) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(70);
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, elementFuture, originalElement, null, null, false, onAutoUpdate));
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element, PsiElement originalElement, DocumentationComponent component2) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(71);
        }
        this.doUpdateComponent(element, originalElement, component2, false);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element, PsiElement originalElement, DocumentationComponent component2, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(72);
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, element, originalElement, null, false, onAutoUpdate));
    }

    @Override
    protected void doUpdateComponent(Editor editor2, PsiFile psiFile, boolean requestFocus) {
        this.doUpdateComponent(editor2, psiFile, requestFocus, false);
    }

    @Override
    protected void doUpdateComponent(Editor editor2, PsiFile psiFile, boolean requestFocus, boolean onAutoUpdate) {
        this.showJavaDocInfo(editor2, psiFile, requestFocus, null, onAutoUpdate);
    }

    @Override
    protected void doUpdateComponent(Editor editor2, PsiFile psiFile) {
        this.doUpdateComponent(editor2, psiFile, false);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(73);
        }
        this.doUpdateComponent(element, false);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element, boolean onAutoUpdate) {
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(74);
        }
        this.showJavaDocInfo(element, element, null, onAutoUpdate);
    }

    @Override
    protected String getTitle(PsiElement element) {
        String title = SymbolPresentationUtil.getSymbolPresentableText(element);
        return title != null ? title : element.getText();
    }

    @ApiStatus.Internal
    @Nullable
    public static Image getElementImage(@NotNull PsiElement element, @NotNull String imageSpec) {
        DocumentationProvider provider2;
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(75);
        }
        if (imageSpec == null) {
            DocumentationManager.$$$reportNull$$$0(76);
        }
        if ((provider2 = DocumentationManager.getProviderFromElement(element)) instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider p : ((CompositeDocumentationProvider)provider2).getAllProviders()) {
                Image image;
                if (!(p instanceof DocumentationProviderEx) || (image = ((DocumentationProviderEx)p).getLocalImageForElement(element, imageSpec)) == null) continue;
                return image;
            }
        }
        return null;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    private ActionCallback createActionCallback() {
        ActionCallback callback;
        this.myLastAction = callback = new ActionCallback();
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            DocumentationManager.$$$reportNull$$$0(77);
        }
        return actionCallback;
    }

    @TestOnly
    public ActionCallback getLastAction() {
        return this.myLastAction;
    }

    @TestOnly
    public void setDocumentationComponent(DocumentationComponent documentationComponent) {
        this.myTestDocumentationComponent = documentationComponent;
    }

    @ApiStatus.Internal
    @Nls
    @Nullable
    public static String generateFileDoc(@NotNull PsiFile psiFile, boolean withUrl) {
        VirtualFile file2;
        if (psiFile == null) {
            DocumentationManager.$$$reportNull$$$0(78);
        }
        File ioFile = (file2 = PsiUtilCore.getVirtualFile(psiFile)) == null || !file2.isInLocalFileSystem() ? null : VfsUtilCore.virtualToIoFile(file2);
        BasicFileAttributes attr = null;
        try {
            attr = ioFile == null ? null : Files.readAttributes(Paths.get(ioFile.toURI()), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attr == null) {
            return null;
        }
        FileType type = file2.getFileType();
        @Nls String typeName = type.getDisplayName();
        @Nls String languageName = type.isBinary() ? "" : psiFile.getLanguage().getDisplayName();
        List<HtmlChunk.Element> content2 = List.of(DocumentationManager.getVcsStatus(psiFile.getProject(), file2), DocumentationManager.getScope(psiFile.getProject(), file2), HtmlChunk.p().children(DocumentationMarkup.GRAYED_ELEMENT.addText(CodeInsightBundle.message("documentation.file.size.label", new Object[0])), HtmlChunk.nbsp(), HtmlChunk.text(StringUtil.formatFileSize(attr.size()))), HtmlChunk.p().children(DocumentationMarkup.GRAYED_ELEMENT.addText(CodeInsightBundle.message("documentation.file.type.label", new Object[0])), HtmlChunk.nbsp(), HtmlChunk.text(typeName + (String)(type.isBinary() || typeName.equals(languageName) ? "" : " (" + languageName + ")"))), HtmlChunk.p().children(DocumentationMarkup.GRAYED_ELEMENT.addText(CodeInsightBundle.message("documentation.file.modification.datetime.label", new Object[0])), HtmlChunk.nbsp(), HtmlChunk.text(DateFormatUtil.formatDateTime(attr.lastModifiedTime().toMillis()))), HtmlChunk.p().children(DocumentationMarkup.GRAYED_ELEMENT.addText(CodeInsightBundle.message("documentation.file.creation.datetime.label", new Object[0])), HtmlChunk.nbsp(), HtmlChunk.text(DateFormatUtil.formatDateTime(attr.creationTime().toMillis()))));
        List<HtmlChunk.Element> result2 = !withUrl ? List.of(DocumentationMarkup.CONTENT_ELEMENT.children(content2)) : List.of(DocumentationMarkup.DEFINITION_ELEMENT.children(HtmlChunk.tag("pre").addText(file2.getPresentableUrl())), DocumentationMarkup.CONTENT_ELEMENT.children(content2));
        @Nls StringBuilder sb = new StringBuilder();
        for (HtmlChunk htmlChunk : result2) {
            htmlChunk.appendTo(sb);
        }
        return sb.toString();
    }

    @Nls
    @NotNull
    private static HtmlChunk getScope(@NotNull Project project2, @NotNull VirtualFile file2) {
        FileColorManagerImpl colorManager;
        Color color;
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(79);
        }
        if (file2 == null) {
            DocumentationManager.$$$reportNull$$$0(80);
        }
        if ((color = (colorManager = (FileColorManagerImpl)FileColorManager.getInstance(project2)).getRendererBackground(file2)) == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                DocumentationManager.$$$reportNull$$$0(81);
            }
            return htmlChunk;
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project2)) {
            for (NamedScope scope : holder.getScopes()) {
                PackageSet packageSet = scope.getValue();
                String name = scope.getScopeId();
                if (!(packageSet instanceof PackageSetBase) || !((PackageSetBase)packageSet).contains(file2, project2, holder) || colorManager.getScopeColor(name) != color) continue;
                HtmlChunk.Element element = HtmlChunk.p().children(DocumentationMarkup.GRAYED_ELEMENT.addText(CodeInsightBundle.message("documentation.file.scope.label", new Object[0])), HtmlChunk.nbsp(), HtmlChunk.span().attr("bgcolor", ColorUtil.toHex(color)).addText(scope.getPresentableName()));
                if (element == null) {
                    DocumentationManager.$$$reportNull$$$0(82);
                }
                return element;
            }
        }
        HtmlChunk htmlChunk = HtmlChunk.empty();
        if (htmlChunk == null) {
            DocumentationManager.$$$reportNull$$$0(83);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk getVcsStatus(@NotNull Project project2, @NotNull VirtualFile file2) {
        FileStatus status;
        if (project2 == null) {
            DocumentationManager.$$$reportNull$$$0(84);
        }
        if (file2 == null) {
            DocumentationManager.$$$reportNull$$$0(85);
        }
        if ((status = FileStatusManager.getInstance((Project)project2).getStatus(file2)) == FileStatus.NOT_CHANGED || status == FileStatus.SUPPRESSED) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                DocumentationManager.$$$reportNull$$$0(86);
            }
            return htmlChunk;
        }
        HtmlChunk vcsText = HtmlChunk.text(status.getText());
        Color color = status.getColor();
        HtmlChunk.Element element = HtmlChunk.p().children(DocumentationMarkup.GRAYED_ELEMENT.addText(CodeInsightBundle.message("documentation.file.vcs.status.label", new Object[0])), HtmlChunk.nbsp(), color == null ? vcsText : vcsText.wrapWith(HtmlChunk.span().attr("color", ColorUtil.toHex(color))));
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(87);
        }
        return element;
    }

    private Optional<QuickSearchComponent> findQuickSearchComponent() {
        for (Component c2 = SoftReference.dereference(this.myFocusedBeforePopup); c2 != null; c2 = c2.getParent()) {
            if (!(c2 instanceof QuickSearchComponent)) continue;
            return Optional.of((QuickSearchComponent)((Object)c2));
        }
        return Optional.empty();
    }

    @ApiStatus.Internal
    @RequiresReadLock
    @RequiresBackgroundThread
    @Contract(pure=true)
    @Nls
    public final String decorate(@Nullable PsiElement element, @Nls @NotNull String text2, @NlsSafe @Nullable String externalUrl, @Nullable DocumentationProvider provider2) {
        if (text2 == null) {
            DocumentationManager.$$$reportNull$$$0(88);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        HtmlChunk locationInfo = DocumentationManager.getDefaultLocationInfo(element);
        return DocumentationManager.decorate(text2, locationInfo, this.getExternalText(element, externalUrl, provider2));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    private static HtmlChunk getDefaultLocationInfo(@Nullable PsiElement psiElement) {
        VirtualFile vfile;
        PsiElement element;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile2 = vfile = file2 == null ? null : file2.getVirtualFile();
        if (vfile == null) {
            return null;
        }
        if (element.getUseScope() instanceof LocalSearchScope) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(element.getProject()).getFileIndex();
        Module module2 = fileIndex.getModuleForFile(vfile);
        if (module2 != null) {
            if (ModuleManager.getInstance(element.getProject()).getModules().length == 1) {
                return null;
            }
            return HtmlChunk.fragment(HtmlChunk.tag("icon").attr("src", "AllIcons.Nodes.Module"), HtmlChunk.nbsp(), HtmlChunk.text(module2.getName()));
        }
        return fileIndex.getOrderEntriesForFile(vfile).stream().filter(it -> it instanceof LibraryOrderEntry || it instanceof JdkOrderEntry).findFirst().map(it -> HtmlChunk.fragment(HtmlChunk.tag("icon").attr("src", "AllIcons.Nodes.PpLibFolder"), HtmlChunk.nbsp(), HtmlChunk.text(it.getPresentableName()))).orElse(null);
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    @Nls
    public static String decorate(@Nls @NotNull String text2, @Nullable HtmlChunk location2, @Nullable HtmlChunk links) {
        if (text2 == null) {
            DocumentationManager.$$$reportNull$$$0(89);
        }
        text2 = StringUtil.replaceIgnoreCase((String)text2, "</html>", "");
        text2 = StringUtil.replaceIgnoreCase((String)text2, "</body>", "");
        text2 = DocumentationManager.replaceIgnoreQuotesType((String)text2, "<table class='sections'></table>", "");
        boolean hasContent2 = DocumentationManager.containsIgnoreQuotesType((String)(text2 = DocumentationManager.replaceIgnoreQuotesType((String)text2, "<table class='sections'><p></table>", "")), "<div class='content'>");
        if (!hasContent2) {
            if (!DocumentationManager.containsIgnoreQuotesType((String)text2, "<div class='definition'><pre>")) {
                int bodyStart = DocumentationManager.findContentStart((String)text2);
                text2 = bodyStart > 0 ? ((String)text2).substring(0, bodyStart) + "<div class='content'>" + ((String)text2).substring(bodyStart) + "</div>" : "<div class='content'>" + (String)text2 + "</div>";
                hasContent2 = true;
            } else if (!DocumentationManager.containsIgnoreQuotesType((String)text2, "<table class='sections'>")) {
                text2 = DocumentationManager.replaceIgnoreQuotesType((String)text2, "<div class='definition'><pre>", "<div class='definition-only'><pre>");
            }
        }
        if (!DocumentationManager.containsIgnoreQuotesType((String)text2, "<div class='definition'><pre>")) {
            text2 = DocumentationManager.replaceIgnoreQuotesType((String)text2, "class='content'", "class='content-only'");
        }
        if (location2 != null) {
            text2 = (String)text2 + DocumentationManager.getBottom(hasContent2).child(location2);
        }
        if (links != null) {
            text2 = (String)text2 + DocumentationManager.getBottom(location2 != null).child(links);
        }
        text2 = ((String)text2).replaceAll("<p>\\s*(<(?:[uo]l|h\\d|p))", "$1");
        text2 = DocumentationManager.addExternalLinksIcon((String)text2);
        return text2;
    }

    private static boolean containsIgnoreQuotesType(@NotNull String text2, @NotNull String substring) {
        if (text2 == null) {
            DocumentationManager.$$$reportNull$$$0(90);
        }
        if (substring == null) {
            DocumentationManager.$$$reportNull$$$0(91);
        }
        return text2.contains(substring) || text2.contains(substring.replace("\"", "'")) || text2.contains(substring.replace("'", "\""));
    }

    @NlsSafe
    @NotNull
    private static String replaceIgnoreQuotesType(@NotNull String text2, @NotNull String oldString, @NotNull String newString) {
        if (text2 == null) {
            DocumentationManager.$$$reportNull$$$0(92);
        }
        if (oldString == null) {
            DocumentationManager.$$$reportNull$$$0(93);
        }
        if (newString == null) {
            DocumentationManager.$$$reportNull$$$0(94);
        }
        String replaced = !text2.contains(oldString) ? (oldString.contains("\"") ? oldString.replace("\"", "'") : oldString.replace("'", "\"")) : oldString;
        String string2 = StringUtil.replaceIgnoreCase(text2, replaced, newString);
        if (string2 == null) {
            DocumentationManager.$$$reportNull$$$0(95);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    private HtmlChunk getExternalText(@Nullable PsiElement psiElement, @NlsSafe @Nullable String string2, @Nullable DocumentationProvider documentationProvider) {
        void externalUrl;
        void provider2;
        void element;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (element == null || provider2 == null) {
            return null;
        }
        PsiElement originalElement = DocumentationManager.getOriginalElement((PsiElement)element);
        if (!DocumentationManager.shouldShowExternalDocumentationLink((DocumentationProvider)provider2, (PsiElement)element, originalElement)) {
            return null;
        }
        String title = this.getTitle((PsiElement)element);
        if (externalUrl == null) {
            List<String> urls = provider2.getUrlFor((PsiElement)element, originalElement);
            if (urls == null) {
                return null;
            }
            HtmlChunk links = DocumentationManager.getExternalLinks(title, urls);
            if (links != null) {
                return links;
            }
        } else {
            HtmlChunk link = DocumentationManager.getLink(title, (String)externalUrl);
            if (link != null) {
                return link;
            }
        }
        return DocumentationManager.getGenericExternalDocumentationLink(title);
    }

    @Nullable
    public static HtmlChunk getExternalLinks(@Nls String title, @NotNull List<String> urls) {
        if (urls == null) {
            DocumentationManager.$$$reportNull$$$0(96);
        }
        SmartList<HtmlChunk> result2 = new SmartList<HtmlChunk>();
        for (String url : urls) {
            HtmlChunk link = DocumentationManager.getLink(title, url);
            if (link == null) {
                return null;
            }
            result2.add(link);
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.appendWithSeparators(HtmlChunk.p(), result2);
        return builder2.toFragment();
    }

    @NotNull
    public static HtmlChunk getGenericExternalDocumentationLink(@Nullable String title) {
        String linkText = CodeInsightBundle.message("html.external.documentation.component.header", title, title == null ? 0 : 1);
        HtmlChunk.Element element = HtmlChunk.link("external_doc", linkText).child(DocumentationMarkup.EXTERNAL_LINK_ICON);
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(97);
        }
        return element;
    }

    @ApiStatus.Internal
    @Nullable
    public static HtmlChunk getLink(@Nls String title, @NlsSafe String url) {
        String hostname = DocumentationManager.getHostname(url);
        if (hostname == null) {
            return null;
        }
        String linkText = title == null ? CodeInsightBundle.message("link.text.documentation.on", hostname) : CodeInsightBundle.message("link.text.element.documentation.on.url", title, hostname);
        return HtmlChunk.link(url, linkText);
    }

    static boolean shouldShowExternalDocumentationLink(DocumentationProvider provider2, PsiElement element, PsiElement originalElement) {
        if (provider2 instanceof CompositeDocumentationProvider) {
            List<DocumentationProvider> providers = ((CompositeDocumentationProvider)provider2).getProviders();
            for (DocumentationProvider p : providers) {
                if (!(p instanceof ExternalDocumentationHandler)) continue;
                return ((ExternalDocumentationHandler)((Object)p)).canHandleExternal(element, originalElement);
            }
        } else if (provider2 instanceof ExternalDocumentationHandler) {
            return ((ExternalDocumentationHandler)((Object)provider2)).canHandleExternal(element, originalElement);
        }
        return true;
    }

    private static String getHostname(String url) {
        try {
            return new URL(url).toURI().getHost();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return null;
        }
    }

    private static int findContentStart(String text2) {
        int index2 = StringUtil.indexOfIgnoreCase(text2, "<body>", 0);
        if (index2 >= 0) {
            return index2 + 6;
        }
        index2 = StringUtil.indexOfIgnoreCase(text2, "</head>", 0);
        if (index2 >= 0) {
            return index2 + 7;
        }
        index2 = StringUtil.indexOfIgnoreCase(text2, "</style>", 0);
        if (index2 >= 0) {
            return index2 + 8;
        }
        index2 = StringUtil.indexOfIgnoreCase(text2, "<html>", 0);
        if (index2 >= 0) {
            return index2 + 6;
        }
        return -1;
    }

    @NotNull
    private static HtmlChunk.Element getBottom(boolean hasContent2) {
        HtmlChunk.Element element = HtmlChunk.div().setClass(hasContent2 ? "bottom" : "bottom-no-content");
        if (element == null) {
            DocumentationManager.$$$reportNull$$$0(98);
        }
        return element;
    }

    @Contract(pure=true)
    public static String addExternalLinksIcon(String text2) {
        return EXTERNAL_LINK_PATTERN.matcher(text2).replaceAll(EXTERNAL_LINK_REPLACEMENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 79, 80, 84, 85, 88, 89, 90, 91, 92, 93, 94, 96 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 37: 
            case 53: 
            case 56: 
            case 63: 
            case 65: 
            case 79: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 12: 
            case 18: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 26: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFuture";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 48: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 51: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 54: 
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 80: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substring";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestorePopupAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationAndProvider";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFromElement";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionCallback";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsStatus";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreQuotesType";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericExternalDocumentationLink";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottom";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCreateDefaultToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateToolWindow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installComponentActions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setToolwindowDefaultState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showJavaDocInfoAtToolWindow";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showJavaDocInfo";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doShowJavaDocInfo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showInPopup";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementFromContext";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementAndContext";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementAtOffset";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doFindTargetElementAtOffset";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "customElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fromTargetUtil";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fromReference";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromLookup";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateDocumentation";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationAndProvider";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fetchDocInfo";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "queueFetchDocInfo";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndFetchDocInfo";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindowTabName";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doFetchDocInfo";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "targetAndRef";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "parseUrl";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "targetElement";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "targetFromLanguageProviders";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "navigateByLink";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "libraryEntry";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndFetchDocInfoByLink";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateComponent";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getElementImage";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "generateFileDoc";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getVcsStatus";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "decorate";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreQuotesType";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreQuotesType";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getExternalLinks";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 79, 80, 84, 85, 88, 89, 90, 91, 92, 93, 94, 96 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyCollector
    extends DocumentationCollector {
        final Project project;
        final PsiElement originalElement;
        final boolean onHover;

        MyCollector(@NotNull Project project2, @NotNull PsiElement element, PsiElement originalElement, String ref, boolean onHover, boolean onAutoUpdate) {
            if (project2 == null) {
                MyCollector.$$$reportNull$$$0(0);
            }
            if (element == null) {
                MyCollector.$$$reportNull$$$0(1);
            }
            this(project2, element, originalElement, ref, null, onHover, onAutoUpdate);
        }

        MyCollector(@NotNull Project project2, @NotNull PsiElement element, PsiElement originalElement, String ref, ActionCallback actionCallback, boolean onHover, boolean onAutoUpdate) {
            if (project2 == null) {
                MyCollector.$$$reportNull$$$0(2);
            }
            if (element == null) {
                MyCollector.$$$reportNull$$$0(3);
            }
            this(project2, CompletableFuture.completedFuture(element), originalElement, ref, actionCallback, onHover, onAutoUpdate);
        }

        MyCollector(@NotNull Project project2, @NotNull CompletableFuture<? extends PsiElement> elementSupplier, PsiElement originalElement, String ref, ActionCallback actionCallback, boolean onHover, boolean onAutoUpdate) {
            if (project2 == null) {
                MyCollector.$$$reportNull$$$0(4);
            }
            if (elementSupplier == null) {
                MyCollector.$$$reportNull$$$0(5);
            }
            super(elementSupplier, null, ref, actionCallback, null, onAutoUpdate);
            this.project = project2;
            this.originalElement = originalElement;
            this.onHover = onHover;
        }

        @Override
        @Nullable
        @Nls
        public String getDocumentation() {
            PsiElement element = this.getElement(true);
            if (element == null) {
                return null;
            }
            this.provider = ReadAction.compute(() -> DocumentationManager.getProviderFromElement(element, this.originalElement));
            LOG.debug("Using provider ", this.provider);
            if (this.provider instanceof ExternalDocumentationProvider) {
                List urls = ReadAction.nonBlocking(() -> {
                    SmartPsiElementPointer<?> originalElementPtr = element.getUserData(ORIGINAL_ELEMENT_KEY);
                    PsiElement originalElement = originalElementPtr != null ? (PsiElement)originalElementPtr.getElement() : null;
                    return this.provider.getUrlFor(element, originalElement);
                }).executeSynchronously();
                LOG.debug("External documentation URLs: ", urls);
                if (urls != null) {
                    for (String url : urls) {
                        String doc = ((ExternalDocumentationProvider)((Object)this.provider)).fetchExternalDocumentation(this.project, element, Collections.singletonList(url), this.onHover);
                        if (doc == null) continue;
                        LOG.debug("Fetched documentation from ", url);
                        this.effectiveUrl = url;
                        return doc;
                    }
                }
            }
            return ReadAction.nonBlocking(() -> this.doGetDocumentation(element)).executeSynchronously();
        }

        @Nullable
        @Nls
        private String doGetDocumentation(@NotNull PsiElement element) {
            String fileDoc;
            String doc;
            if (element == null) {
                MyCollector.$$$reportNull$$$0(6);
            }
            if (!element.isValid()) {
                return null;
            }
            SmartPsiElementPointer<?> originalPointer = element.getUserData(ORIGINAL_ELEMENT_KEY);
            PsiElement originalPsi = originalPointer != null ? (PsiElement)originalPointer.getElement() : null;
            String string2 = doc = this.onHover ? this.provider.generateHoverDoc(element, originalPsi) : this.provider.generateDoc(element, originalPsi);
            if (element instanceof PsiFile && (fileDoc = DocumentationManager.generateFileDoc((PsiFile)element, doc == null)) != null) {
                return doc == null ? fileDoc : doc + fileDoc;
            }
            return doc;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementSupplier";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager$MyCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doGetDocumentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class DocumentationCollector {
        private final CompletableFuture<? extends PsiElement> myElementFuture;
        final String ref;
        final boolean onAutoUpdate;
        final ActionCallback actionCallback;
        volatile DocumentationProvider provider;
        String effectiveUrl;

        DocumentationCollector(PsiElement element, String effectiveUrl, String ref, DocumentationProvider provider2, boolean onAutoUpdate) {
            this(element, effectiveUrl, ref, null, provider2, onAutoUpdate);
        }

        DocumentationCollector(PsiElement element, String effectiveUrl, String ref, ActionCallback actionCallback, DocumentationProvider provider2, boolean onAutoUpdate) {
            this(CompletableFuture.completedFuture(element), effectiveUrl, ref, actionCallback, provider2, onAutoUpdate);
        }

        DocumentationCollector(@NotNull CompletableFuture<? extends PsiElement> elementFuture, String effectiveUrl, String ref, ActionCallback actionCallback, DocumentationProvider provider2, boolean onAutoUpdate) {
            if (elementFuture == null) {
                DocumentationCollector.$$$reportNull$$$0(0);
            }
            this.myElementFuture = elementFuture;
            this.actionCallback = actionCallback;
            this.ref = ref;
            this.effectiveUrl = effectiveUrl;
            this.provider = provider2;
            this.onAutoUpdate = onAutoUpdate;
        }

        @Nullable
        public PsiElement getElement(boolean wait) {
            try {
                return wait ? this.myElementFuture.get() : (PsiElement)this.myElementFuture.getNow(null);
            }
            catch (Exception e) {
                LOG.debug("Cannot get target element", e);
                return null;
            }
        }

        @Nullable
        @Nls
        abstract String getDocumentation() throws Exception;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFuture", "com/intellij/codeInsight/documentation/DocumentationManager$DocumentationCollector", "<init>"));
        }
    }
}

