/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationEditorPane;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.lang.documentation.ide.ui.UiKt;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DocumentationScrollPane
extends JBScrollPane {
    public DocumentationScrollPane() {
        super(20, 30);
        this.setBorder(JBUI.Borders.empty());
        this.setViewportBorder(null);
    }

    public Dimension getPreferredSize() {
        if (!QuickDocUtil.isDocumentationV2Enabled()) {
            return super.getPreferredSize();
        }
        Integer forcedWidth = UIUtil.getClientProperty((Object)this, UiKt.FORCED_WIDTH);
        int minWidth = forcedWidth == null ? DocumentationComponent.MIN_DEFAULT.width() : forcedWidth.intValue();
        return this.getPreferredSize(minWidth, DocumentationComponent.MAX_DEFAULT.width(), DocumentationComponent.MAX_DEFAULT.height());
    }

    @NotNull
    private Dimension getPreferredSize(int minWidth, int maxWidth, int maxHeight) {
        Dimension paneSize = ((DocumentationEditorPane)this.getViewport().getView()).getPackedSize(minWidth, maxWidth);
        JScrollBar hBar = this.getHorizontalScrollBar();
        boolean hasHBar = paneSize.width > maxWidth && hBar.isOpaque();
        int hBarHeight = hasHBar ? hBar.getPreferredSize().height : 0;
        JScrollBar vBar = this.getVerticalScrollBar();
        boolean hasVBar = paneSize.height + hBarHeight > maxHeight && vBar.isOpaque();
        int vBarWidth = hasVBar ? vBar.getPreferredSize().width : 0;
        Insets insets = this.getInsets();
        int preferredWidth = paneSize.width + vBarWidth + insets.left + insets.right;
        int preferredHeight = paneSize.height + hBarHeight + insets.top + insets.bottom;
        return new Dimension(Math.min(preferredWidth, maxWidth), Math.min(preferredHeight, maxHeight));
    }

    @NotNull
    public static Map<KeyStroke, ActionListener> keyboardActions(@NotNull JScrollPane target2) {
        if (target2 == null) {
            DocumentationScrollPane.$$$reportNull$$$0(0);
        }
        if (ScreenReader.isActive()) {
            Map<KeyStroke, ActionListener> map2 = Collections.emptyMap();
            if (map2 == null) {
                DocumentationScrollPane.$$$reportNull$$$0(1);
            }
            return map2;
        }
        HashMap<KeyStroke, ActionListener> result2 = new HashMap<KeyStroke, ActionListener>(10);
        result2.put(KeyStroke.getKeyStroke(38, 0), e -> {
            JScrollBar scrollBar = target2.getVerticalScrollBar();
            int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
            value = Math.max(value, 0);
            scrollBar.setValue(value);
        });
        result2.put(KeyStroke.getKeyStroke(40, 0), e -> {
            JScrollBar scrollBar = target2.getVerticalScrollBar();
            int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
            value = Math.min(value, scrollBar.getMaximum());
            scrollBar.setValue(value);
        });
        result2.put(KeyStroke.getKeyStroke(37, 0), e -> {
            JScrollBar scrollBar = target2.getHorizontalScrollBar();
            int value = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
            value = Math.max(value, 0);
            scrollBar.setValue(value);
        });
        result2.put(KeyStroke.getKeyStroke(39, 0), e -> {
            JScrollBar scrollBar = target2.getHorizontalScrollBar();
            int value = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
            value = Math.min(value, scrollBar.getMaximum());
            scrollBar.setValue(value);
        });
        result2.put(KeyStroke.getKeyStroke(33, 0), e -> {
            JScrollBar scrollBar = target2.getVerticalScrollBar();
            int value = scrollBar.getValue() - scrollBar.getBlockIncrement(-1);
            value = Math.max(value, 0);
            scrollBar.setValue(value);
        });
        result2.put(KeyStroke.getKeyStroke(34, 0), e -> {
            JScrollBar scrollBar = target2.getVerticalScrollBar();
            int value = scrollBar.getValue() + scrollBar.getBlockIncrement(1);
            value = Math.min(value, scrollBar.getMaximum());
            scrollBar.setValue(value);
        });
        result2.put(KeyStroke.getKeyStroke(36, 0), e -> {
            JScrollBar scrollBar = target2.getHorizontalScrollBar();
            scrollBar.setValue(0);
        });
        result2.put(KeyStroke.getKeyStroke(35, 0), e -> {
            JScrollBar scrollBar = target2.getHorizontalScrollBar();
            scrollBar.setValue(scrollBar.getMaximum());
        });
        result2.put(KeyStroke.getKeyStroke(36, 2), e -> {
            JScrollBar scrollBar = target2.getVerticalScrollBar();
            scrollBar.setValue(0);
        });
        result2.put(KeyStroke.getKeyStroke(35, 2), e -> {
            JScrollBar scrollBar = target2.getVerticalScrollBar();
            scrollBar.setValue(scrollBar.getMaximum());
        });
        HashMap<KeyStroke, ActionListener> hashMap = result2;
        if (hashMap == null) {
            DocumentationScrollPane.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationScrollPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keyboardActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "keyboardActions";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

