/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PerformWithDocumentsCommitted;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.platform.ide.documentation.ActionsKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/codeInsight/hint/HintManagerImpl$ActionToIgnore;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/PopupAction;", "Lcom/intellij/openapi/actionSystem/PerformWithDocumentsCommitted;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformedV2", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.platform.lang.impl"})
public class ShowQuickDocInfoAction
extends AnAction
implements HintManagerImpl.ActionToIgnore,
DumbAware,
PopupAction,
PerformWithDocumentsCommitted {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CODEASSISTS_QUICKJAVADOC_FEATURE = "codeassists.quickjavadoc";
    @NotNull
    public static final String CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE = "codeassists.quickjavadoc.lookup";
    @NotNull
    public static final String CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE = "codeassists.quickjavadoc.ctrln";

    public ShowQuickDocInfoAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            List list2 = (List)e.getDataContext().getData(ActionsKt.DOCUMENTATION_TARGETS);
            e.getPresentation().setEnabled(list2 != null ? !((Collection)list2).isEmpty() : false);
            return;
        }
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = presentation2;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"e.dataContext");
        DataContext dataContext3 = dataContext2;
        presentation3.setEnabled(false);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext3);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext3);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext3);
        if (editor2 == null && element == null) {
            return;
        }
        if (LookupManager.getInstance(project3).getActiveLookup() != null) {
            presentation3.setEnabled(true);
        } else {
            if (editor2 != null) {
                if (e.getData(EditorGutter.KEY) != null) {
                    return;
                }
                PsiFile file2 = PsiDocumentManager.getInstance(project3).getPsiFile(editor2.getDocument());
                if (file2 == null && element == null) {
                    return;
                }
            }
            presentation3.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"e.dataContext");
            this.actionPerformedV2(dataContext2);
            return;
        }
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"e.dataContext");
        DataContext dataContext4 = dataContext3;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext4);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext4);
        if (editor2 != null) {
            DocumentationManager documentationManager;
            LookupEx activeLookup = LookupManager.getActiveLookup(editor2);
            if (activeLookup != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE);
            }
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor2, project3);
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            JBPopup hint = (documentationManager = DocumentationManager.getInstance(project3)).getDocInfoHint();
            documentationManager.showJavaDocInfo(editor2, psiFile2, hint != null || activeLookup == null);
            return;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext4);
        if (element != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE);
            DocumentationManager documentationManager = DocumentationManager.getInstance(project3);
            JBPopup hint = documentationManager.getDocInfoHint();
            documentationManager.showJavaDocInfo(element, null, hint != null, null);
        }
    }

    private final void actionPerformedV2(DataContext dataContext2) {
        Project project2 = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        com.intellij.lang.documentation.ide.impl.DocumentationManager.actionPerformed$default(com.intellij.lang.documentation.ide.impl.DocumentationManager.Companion.instance(project3), dataContext2, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction$Companion;", "", "()V", "CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE", "", "CODEASSISTS_QUICKJAVADOC_FEATURE", "CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

