/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CachingDataReader
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CachingDataReader.class);
    private static final int MAX_DATA_SIZE = 1000000;
    private final ConcurrentMap<URL, File> myCache = new ConcurrentHashMap<URL, File>();
    private final AtomicInteger myFileNameCounter = new AtomicInteger();

    public static CachingDataReader getInstance() {
        return ApplicationManager.getApplication().getService(CachingDataReader.class);
    }

    @Nullable
    public InputStream getInputStream(@NotNull URL url) {
        File cachedResult;
        if (url == null) {
            CachingDataReader.$$$reportNull$$$0(0);
        }
        if ((cachedResult = (File)this.myCache.get(url)) != null) {
            try {
                return new FileInputStream(cachedResult);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Couldn't open " + cachedResult, e);
            }
        }
        try {
            return CachingDataReader.shouldCache(url) ? new CachingInputStream(url) : url.openStream();
        }
        catch (IOException e) {
            LOG.debug("Couldn't open " + url, e);
            return null;
        }
    }

    private static boolean shouldCache(@NotNull URL url) {
        String protocol;
        if (url == null) {
            CachingDataReader.$$$reportNull$$$0(1);
        }
        return "ftp".equals(protocol = url.getProtocol()) || "http".equals(protocol) || "https".equals(protocol);
    }

    private void cacheResult(@NotNull URL url, byte @NotNull [] data2) {
        File folder;
        if (url == null) {
            CachingDataReader.$$$reportNull$$$0(2);
        }
        if (data2 == null) {
            CachingDataReader.$$$reportNull$$$0(3);
        }
        if (!(folder = CachingDataReader.getCacheFolder()).exists() && !folder.mkdirs()) {
            LOG.warn("Couldn't create " + folder);
            return;
        }
        File file2 = new File(folder, this.generateFileName());
        try {
            Files.write(file2.toPath(), data2, new OpenOption[0]);
            this.myCache.put(url, file2);
        }
        catch (IOException e) {
            LOG.warn("Error writing to " + file2, e);
        }
    }

    private static File getCacheFolder() {
        return new File(PathManager.getTempPath(), "imageCache");
    }

    private String generateFileName() {
        return Integer.toString(this.myFileNameCounter.incrementAndGet());
    }

    @Override
    public void dispose() {
        Path folder = CachingDataReader.getCacheFolder().toPath();
        try {
            NioFiles.deleteRecursively(folder);
        }
        catch (IOException e) {
            LOG.warn("Error deleting folder " + folder, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/CachingDataReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInputStream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cacheResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class CachingInputStream
    extends InputStream {
        private final URL myURL;
        private final InputStream myDelegate;
        private ByteArrayOutputStream myStreamCopy;

        private CachingInputStream(URL url) throws IOException {
            if (url == null) {
                CachingInputStream.$$$reportNull$$$0(0);
            }
            this.myURL = url;
            this.myDelegate = url.openStream();
            this.myStreamCopy = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int data2;
            try {
                data2 = this.myDelegate.read();
            }
            catch (IOException e) {
                this.myStreamCopy = null;
                throw e;
            }
            if (this.myStreamCopy != null) {
                if (data2 < 0) {
                    CachingDataReader.this.cacheResult(this.myURL, this.myStreamCopy.toByteArray());
                    this.myStreamCopy = null;
                } else if (this.myStreamCopy.size() + 1 > 1000000) {
                    this.myStreamCopy = null;
                } else {
                    this.myStreamCopy.write(data2);
                }
            }
            return data2;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result2;
            try {
                result2 = this.myDelegate.read(b, off, len);
            }
            catch (IOException e) {
                this.myStreamCopy = null;
                throw e;
            }
            if (this.myStreamCopy != null) {
                if (result2 < 0) {
                    CachingDataReader.this.cacheResult(this.myURL, this.myStreamCopy.toByteArray());
                    this.myStreamCopy = null;
                } else if (this.myStreamCopy.size() + result2 > 1000000) {
                    this.myStreamCopy = null;
                } else {
                    this.myStreamCopy.write(b, off, result2);
                }
            }
            return result2;
        }

        @Override
        public long skip(long n) throws IOException {
            this.myStreamCopy = null;
            return this.myDelegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.myDelegate.available();
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/codeInsight/documentation/render/CachingDataReader$CachingInputStream", "<init>"));
        }
    }
}

