/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderLinkActivationHandler;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.codeInsight.documentation.render.PsiCommentInlineDocumentation;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import javax.swing.event.HyperlinkEvent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J0\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderDefaultLinkActivationHandler;", "Lcom/intellij/codeInsight/documentation/render/DocRenderLinkActivationHandler;", "()V", "activateLink", "", "event", "Ljavax/swing/event/HyperlinkEvent;", "renderer", "Lcom/intellij/codeInsight/documentation/render/DocRenderer;", "activateLinkV2", "url", "", "location", "Ljava/awt/geom/Rectangle2D;", "isExternalLink", "", "linkUrl", "navigateToDeclaration", "context", "Lcom/intellij/psi/PsiElement;", "showDocumentation", "editor", "Lcom/intellij/openapi/editor/Editor;", "linkLocationWithinInlay", "intellij.platform.lang.impl"})
public final class DocRenderDefaultLinkActivationHandler
implements DocRenderLinkActivationHandler {
    @NotNull
    public static final DocRenderDefaultLinkActivationHandler INSTANCE = new DocRenderDefaultLinkActivationHandler();

    private DocRenderDefaultLinkActivationHandler() {
    }

    @Override
    public void activateLink(@NotNull HyperlinkEvent event, @NotNull DocRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Rectangle2D rectangle2D = this.getLocation(event);
        if (rectangle2D == null) {
            return;
        }
        Rectangle2D location2 = rectangle2D;
        DocRenderItem item = renderer.getItem();
        String url = event.getDescription();
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
            this.activateLinkV2(url, location2, renderer);
            return;
        }
        InlineDocumentation inlineDocumentation = item.getInlineDocumentation();
        if (inlineDocumentation == null) {
            return;
        }
        InlineDocumentation documentation = inlineDocumentation;
        PsiElement psiElement = ((PsiCommentInlineDocumentation)documentation).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"documentation as PsiComm\u2026ineDocumentation).context");
        PsiElement context2 = psiElement;
        if (this.isGotoDeclarationEvent()) {
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
            this.navigateToDeclaration(context2, url);
        } else {
            Editor editor2 = item.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
            this.showDocumentation(editor2, context2, url, location2, renderer);
        }
    }

    private final void activateLinkV2(String url, Rectangle2D location2, DocRenderer renderer) {
        DocRenderItem item = renderer.getItem();
        Editor editor2 = item.getEditor();
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (this.isGotoDeclarationEvent()) {
            com.intellij.lang.documentation.ide.impl.DocumentationManager.Companion.instance(project3).navigateInlineLink(url, (Function0<? extends DocumentationTarget>)((Function0)new Function0<DocumentationTarget>(item){
                final /* synthetic */ DocRenderItem $item;
                {
                    this.$item = $item;
                    super(0);
                }

                @Nullable
                public final DocumentationTarget invoke() {
                    return this.$item.getInlineDocumentationTarget();
                }
            }));
        } else {
            com.intellij.lang.documentation.ide.impl.DocumentationManager.Companion.instance(project3).activateInlineLink(url, (Function0<? extends DocumentationTarget>)((Function0)new Function0<DocumentationTarget>(item){
                final /* synthetic */ DocRenderItem $item;
                {
                    this.$item = $item;
                    super(0);
                }

                @Nullable
                public final DocumentationTarget invoke() {
                    return this.$item.getInlineDocumentationTarget();
                }
            }), editor2, this.popupPosition(location2, renderer));
        }
    }

    @Deprecated(message="Unused in v2 implementation.")
    private final void showDocumentation(Editor editor2, PsiElement context2, String linkUrl, Rectangle2D linkLocationWithinInlay, DocRenderer renderer) {
        DocumentationComponent component2;
        if (this.isExternalLink(linkUrl)) {
            BrowserUtil.open((String)linkUrl);
            return;
        }
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        Project project3 = project2;
        DocumentationManager documentationManager = DocumentationManager.getInstance(project3);
        if (QuickDocUtil.getActiveDocComponent(project3) == null) {
            editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, (Object)this.popupPosition(linkLocationWithinInlay, renderer));
            documentationManager.showJavaDocInfo(editor2, context2, context2, () -> DocRenderDefaultLinkActivationHandler.showDocumentation$lambda$0(editor2), "", false, true);
        }
        if ((component2 = QuickDocUtil.getActiveDocComponent(project3)) != null) {
            if (!documentationManager.hasActiveDockedDocWindow()) {
                component2.startWait();
            }
            documentationManager.navigateByLink(component2, context2, linkUrl);
        }
        if (documentationManager.getDocInfoHint() == null) {
            editor2.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null);
        }
        if (documentationManager.hasActiveDockedDocWindow()) {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
            Disposable disposable2 = disposable;
            editor2.getCaretModel().addCaretListener(new CaretListener(disposable2){
                final /* synthetic */ Disposable $disposable;
                {
                    this.$disposable = $disposable;
                }

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Disposer.dispose(this.$disposable);
                }
            }, disposable2);
            documentationManager.muteAutoUpdateTill(disposable2);
        }
    }

    private final void navigateToDeclaration(PsiElement context2, String linkUrl) {
        PsiElement targetElement = DocumentationManager.getInstance(context2.getProject()).getTargetElement(context2, linkUrl);
        if (targetElement instanceof Navigatable) {
            ((Navigatable)((Object)targetElement)).navigate(true);
        }
    }

    private final boolean isExternalLink(String linkUrl) {
        String string2 = linkUrl.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String l = string2;
        return StringsKt.startsWith$default((String)l, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)l, (String)"https://", (boolean)false, (int)2, null);
    }

    private static final void showDocumentation$lambda$0(Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        $editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null);
    }
}

