/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.render.DocRenderDefaultLinkActivationHandler;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.codeInsight.documentation.render.InlineDocumentationImplKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmInline;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 02\u00020\u0001:\u0003012B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0014\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u0016H\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\u0016\u0010-\u001a\u00020\u00162\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&J\u0016\u0010.\u001a\u00020\u001f2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010/R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R!\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemImpl;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "textToRender", "", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "<set-?>", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "foldRegion", "getFoldRegion", "()Lcom/intellij/openapi/editor/CustomFoldRegion;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isValid", "", "()Z", "getTextToRender", "()Ljava/lang/String;", "setTextToRender", "(Ljava/lang/String;)V", "calcFoldingGutterIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "generateHtmlInBackgroundAndToggle", "", "getInlineDocumentation", "Lcom/intellij/platform/backend/documentation/InlineDocumentation;", "getInlineDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "remove", "foldingTasks", "", "Ljava/lang/Runnable;", "repaintGutter", "startY", "", "setIconVisible", "visible", "toggle", "updateIcon", "", "Companion", "ItemLocation", "MyGutterIconRenderer", "intellij.platform.lang.impl"})
public final class DocRenderItemImpl
implements DocRenderItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @Nullable
    private String textToRender;
    @NotNull
    private final RangeHighlighter highlighter;
    @Nullable
    private CustomFoldRegion foldRegion;

    public DocRenderItemImpl(@NotNull Editor editor2, @NotNull TextRange textRange, @Nullable String textToRender) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.editor = editor2;
        this.textToRender = textToRender;
        MarkupModel markupModel = this.getEditor().getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        RangeHighlighterEx rangeHighlighterEx = ((MarkupModelEx)markupModel).addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 0, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> DocRenderItemImpl._init_$lambda$0(1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"editor.markupModel as Ma\u2026IGHLIGHTER, true)\n      }");
        this.highlighter = (RangeHighlighter)rangeHighlighterEx;
        this.updateIcon(null);
    }

    @Override
    @NotNull
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    @Nullable
    public String getTextToRender() {
        return this.textToRender;
    }

    public void setTextToRender(@Nullable String string2) {
        this.textToRender = string2;
    }

    @Override
    @NotNull
    public RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    @Nullable
    public CustomFoldRegion getFoldRegion() {
        return this.foldRegion;
    }

    @Override
    @Nullable
    public GutterIconRenderer calcFoldingGutterIconRenderer() {
        GutterIconRenderer gutterIconRenderer = this.getHighlighter().getGutterIconRenderer();
        MyGutterIconRenderer myGutterIconRenderer = gutterIconRenderer instanceof MyGutterIconRenderer ? (MyGutterIconRenderer)gutterIconRenderer : null;
        if (myGutterIconRenderer == null) {
            return null;
        }
        boolean isHighlighterIconVisible = myGutterIconRenderer.isIconVisible();
        Icon icon2 = AllIcons.Gutter.JavadocEdit;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"JavadocEdit");
        return new MyGutterIconRenderer(icon2, isHighlighterIconVisible);
    }

    public final boolean isValid() {
        return this.getHighlighter().isValid() && this.getHighlighter().getStartOffset() < this.getHighlighter().getEndOffset() && ItemLocation.matches-impl(ItemLocation.constructor-impl(this.getHighlighter()), this.getFoldRegion());
    }

    public final boolean remove(@NotNull Collection<Runnable> foldingTasks) {
        Intrinsics.checkNotNullParameter(foldingTasks, (String)"foldingTasks");
        this.getHighlighter().dispose();
        CustomFoldRegion region = this.getFoldRegion();
        if (region != null && region.isValid()) {
            foldingTasks.add(() -> DocRenderItemImpl.remove$lambda$1(region));
            return true;
        }
        return false;
    }

    @Override
    public void toggle() {
        if (!this.isValid()) {
            return;
        }
        this.toggle(null);
    }

    public final boolean toggle(@Nullable Collection<Runnable> foldingTasks) {
        if (!(this.getEditor() instanceof EditorEx)) {
            return false;
        }
        FoldingModelEx foldingModelEx = ((EditorEx)this.getEditor()).getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelEx, (String)"editor.foldingModel");
        FoldingModelEx foldingModel = foldingModelEx;
        CustomFoldRegion region = this.getFoldRegion();
        if (region == null) {
            if (this.getTextToRender() == null && foldingTasks == null) {
                this.generateHtmlInBackgroundAndToggle();
                return false;
            }
            RangeHighlighter offsets2 = ItemLocation.constructor-impl(this.getHighlighter());
            Runnable foldingTask = () -> DocRenderItemImpl.toggle$lambda$2(this, foldingModel, offsets2);
            Collection<Runnable> collection = foldingTasks;
            if (collection != null) {
                collection.add(foldingTask);
            } else {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
            }
        } else {
            Runnable foldingTask = () -> DocRenderItemImpl.toggle$lambda$3(region, foldingModel, this);
            Collection<Runnable> collection = foldingTasks;
            if (collection != null) {
                collection.add(foldingTask);
            } else {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
            }
            if (!DocRenderManager.isDocRenderingEnabled(this.getEditor())) {
                this.setTextToRender(null);
            }
        }
        return true;
    }

    private final void generateHtmlInBackgroundAndToggle() {
        Project project2 = this.getEditor().getProject();
        if (project2 == null) {
            return;
        }
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> DocRenderItemImpl.generateHtmlInBackgroundAndToggle$lambda$4(this)).withDocumentsCommitted(project2).coalesceBy(objectArray).finishOnUiThread(ModalityState.any(), arg_0 -> DocRenderItemImpl.generateHtmlInBackgroundAndToggle$lambda$5((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DocRenderItemImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable String html) {
                this.this$0.setTextToRender(html);
                this.this$0.toggle();
            }
        }, arg_0)).submit(AppExecutorUtil.getAppExecutorService());
    }

    @Override
    @Nullable
    public InlineDocumentation getInlineDocumentation() {
        if (this.getHighlighter().isValid()) {
            Project project2 = this.getEditor().getProject();
            if (project2 == null) {
                return null;
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project2);
            PsiFile psiFile = psiDocumentManager.getPsiFile(this.getEditor().getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile file2 = psiFile;
            TextRange textRange = this.getHighlighter().getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"highlighter.textRange");
            return InlineDocumentationImplKt.findInlineDocumentation(file2, textRange);
        }
        return null;
    }

    @Override
    @Nullable
    public DocumentationTarget getInlineDocumentationTarget() {
        InlineDocumentation documentation;
        InlineDocumentation inlineDocumentation = documentation = this.getInlineDocumentation();
        return inlineDocumentation != null ? inlineDocumentation.getOwnerTarget() : null;
    }

    public final void updateIcon(@Nullable List<? extends Runnable> foldingTasks) {
        block3: {
            GutterIconRenderer gutterIconRenderer;
            boolean iconExists;
            boolean iconEnabled = DocRenderDummyLineMarkerProvider.isGutterIconEnabled();
            boolean bl = iconExists = this.getHighlighter().getGutterIconRenderer() != null;
            if (iconEnabled == iconExists) break block3;
            RangeHighlighter rangeHighlighter = this.getHighlighter();
            if (iconEnabled) {
                Icon icon2 = AllIcons.Gutter.JavadocRead;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"JavadocRead");
                gutterIconRenderer = new MyGutterIconRenderer(icon2, false);
            } else {
                gutterIconRenderer = null;
            }
            rangeHighlighter.setGutterIconRenderer(gutterIconRenderer);
            CustomFoldRegion customFoldRegion = this.getFoldRegion();
            CustomFoldRegionRenderer customFoldRegionRenderer = customFoldRegion != null ? customFoldRegion.getRenderer() : null;
            DocRenderer docRenderer = customFoldRegionRenderer instanceof DocRenderer ? (DocRenderer)customFoldRegionRenderer : null;
            if (docRenderer != null) {
                docRenderer.update(false, false, foldingTasks);
            }
        }
    }

    @Override
    public void setIconVisible(boolean visible) {
        MyGutterIconRenderer inlayIconRenderer;
        CustomFoldRegion region;
        MyGutterIconRenderer iconRenderer = (MyGutterIconRenderer)this.getHighlighter().getGutterIconRenderer();
        if (iconRenderer != null) {
            iconRenderer.setIconVisible(visible);
            Editor editor2 = this.getEditor();
            Editor editor3 = this.getEditor();
            Intrinsics.checkNotNull((Object)editor3, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            int y = editor2.visualLineToY(((EditorImpl)editor3).offsetToVisualLine(this.getHighlighter().getStartOffset()));
            this.repaintGutter(y);
        }
        if ((region = this.getFoldRegion()) != null && (inlayIconRenderer = (MyGutterIconRenderer)region.getGutterIconRenderer()) != null) {
            inlayIconRenderer.setIconVisible(visible);
            this.repaintGutter(this.getEditor().offsetToXY((int)region.getStartOffset()).y);
        }
    }

    private final void repaintGutter(int startY) {
        EditorGutter editorGutter = this.getEditor().getGutter();
        Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent gutter = (JComponent)editorGutter;
        gutter.repaint(0, startY, gutter.getWidth(), startY + this.getEditor().getLineHeight());
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void remove$lambda$1(CustomFoldRegion $region) {
        $region.getEditor().getFoldingModel().removeFoldRegion((FoldRegion)$region);
    }

    private static final void toggle$lambda$2(DocRenderItemImpl this$0, FoldingModelEx $foldingModel, RangeHighlighter $offsets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$foldingModel, (String)"$foldingModel");
        Intrinsics.checkNotNullParameter((Object)$offsets, (String)"$offsets");
        this$0.foldRegion = $foldingModel.addCustomLinesFolding(ItemLocation.getFoldStartLine-impl($offsets), ItemLocation.getFoldEndLine-impl($offsets), (CustomFoldRegionRenderer)new DocRenderer(this$0));
    }

    private static final void toggle$lambda$3(CustomFoldRegion $region, FoldingModelEx $foldingModel, DocRenderItemImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)$foldingModel, (String)"$foldingModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int startOffset = $region.getStartOffset();
        int endOffset = $region.getEndOffset();
        $foldingModel.removeFoldRegion((FoldRegion)$region);
        for (FoldRegion r : $foldingModel.getRegionsOverlappingWith(startOffset, endOffset)) {
            if (r.getStartOffset() < startOffset || r.getEndOffset() > endOffset) continue;
            r.setExpanded(true);
        }
        this$0.foldRegion = null;
    }

    private static final String generateHtmlInBackgroundAndToggle$lambda$4(DocRenderItemImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DocRenderPassFactory.calcText(this$0.getInlineDocumentation());
    }

    private static final void generateHtmlInBackgroundAndToggle$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final CustomFoldRegionRenderer createDemoRenderer(@NotNull Editor editor2) {
        return Companion.createDemoRenderer(editor2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemImpl$MyGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "Lcom/intellij/openapi/project/DumbAware;", "icon", "Ljavax/swing/Icon;", "iconVisible", "", "(Lcom/intellij/codeInsight/documentation/render/DocRenderItemImpl;Ljavax/swing/Icon;Z)V", "Lcom/intellij/ui/LayeredIcon;", "visible", "isIconVisible", "()Z", "setIconVisible", "(Z)V", "equals", "other", "", "getAccessibleName", "", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getIcon", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getTooltipText", "hashCode", "", "isNavigateAction", "intellij.platform.lang.impl"})
    private final class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        @NotNull
        private final LayeredIcon icon;

        public MyGutterIconRenderer(Icon icon2, boolean iconVisible) {
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            Icon[] iconArray = new Icon[]{icon2};
            this.icon = new LayeredIcon(iconArray);
            this.setIconVisible(iconVisible);
        }

        public final boolean isIconVisible() {
            return this.icon.isLayerEnabled(0);
        }

        public final void setIconVisible(boolean visible) {
            this.icon.setLayerEnabled(0, visible);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof MyGutterIconRenderer;
        }

        public int hashCode() {
            return 0;
        }

        @NotNull
        public Icon getIcon() {
            return (Icon)this.icon;
        }

        @NotNull
        public String getAccessibleName() {
            String string2 = CodeInsightBundle.message("doc.render.icon.accessible.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"doc.render.icon.accessible.name\")");
            return string2;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            return GutterIconRenderer.Alignment.RIGHT;
        }

        public boolean isNavigateAction() {
            return true;
        }

        @Nullable
        public String getTooltipText() {
            AnAction anAction = ActionManager.getInstance().getAction("ToggleRenderedDocPresentation");
            if (anAction == null) {
                return null;
            }
            AnAction action2 = anAction;
            String string2 = action2.getTemplateText();
            if (string2 == null) {
                return null;
            }
            String actionText = string2;
            return XmlStringUtil.wrapInHtml(actionText + HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2)));
        }

        @NotNull
        public AnAction getClickAction() {
            return (AnAction)new DocRenderer.ToggleRenderingAction(DocRenderItemImpl.this);
        }

        @Nullable
        public ActionGroup getPopupMenuActions() {
            AnAction anAction = ActionManager.getInstance().getAction("DocCommentGutterIconContextMenu");
            return anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0083@\u0018\u00002\u00020\u0001B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0017\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemImpl$ItemLocation;", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "constructor-impl", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "foldEndLine", "", "getFoldEndLine-impl", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)I", "foldStartLine", "getFoldStartLine-impl", "equals", "", "other", "equals-impl", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Ljava/lang/Object;)Z", "hashCode", "hashCode-impl", "matches", "foldRegion", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "matches-impl", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/CustomFoldRegion;)Z", "toString", "", "toString-impl", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Ljava/lang/String;", "intellij.platform.lang.impl"})
    private static final class ItemLocation {
        @NotNull
        private final RangeHighlighter highlighter;

        public static final int getFoldStartLine-impl(RangeHighlighter arg0) {
            return arg0.getDocument().getLineNumber(arg0.getStartOffset());
        }

        public static final int getFoldEndLine-impl(RangeHighlighter arg0) {
            return arg0.getDocument().getLineNumber(arg0.getEndOffset());
        }

        public static final boolean matches-impl(RangeHighlighter arg0, @Nullable CustomFoldRegion foldRegion) {
            return foldRegion == null || foldRegion.isValid() && foldRegion.getStartOffset() == foldRegion.getEditor().getDocument().getLineStartOffset(ItemLocation.getFoldStartLine-impl(arg0)) && foldRegion.getEndOffset() == foldRegion.getEditor().getDocument().getLineEndOffset(ItemLocation.getFoldEndLine-impl(arg0));
        }

        public static String toString-impl(RangeHighlighter arg0) {
            return "ItemLocation(highlighter=" + arg0 + ")";
        }

        public String toString() {
            return ItemLocation.toString-impl(this.highlighter);
        }

        public static int hashCode-impl(RangeHighlighter arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return ItemLocation.hashCode-impl(this.highlighter);
        }

        public static boolean equals-impl(RangeHighlighter arg0, Object other) {
            if (!(other instanceof ItemLocation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((ItemLocation)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return ItemLocation.equals-impl(this.highlighter, other);
        }

        private /* synthetic */ ItemLocation(RangeHighlighter highlighter) {
            this.highlighter = highlighter;
        }

        @NotNull
        public static RangeHighlighter constructor-impl(@NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            return highlighter;
        }

        public static final /* synthetic */ ItemLocation box-impl(RangeHighlighter v) {
            return new ItemLocation(v);
        }

        public final /* synthetic */ RangeHighlighter unbox-impl() {
            return this.highlighter;
        }

        public static final boolean equals-impl0(RangeHighlighter p1, RangeHighlighter p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemImpl$Companion;", "", "()V", "createDemoRenderer", "Lcom/intellij/openapi/editor/CustomFoldRegionRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CustomFoldRegionRenderer createDemoRenderer(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            DocRenderItemImpl item = new DocRenderItemImpl(editor2, new TextRange(0, 0), CodeInsightBundle.message("documentation.rendered.documentation.with.href.link", new Object[0]));
            return new DocRenderer(item, DocRenderDefaultLinkActivationHandler.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

