/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderMouseEventBridge;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderSelectionManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\bg\u0018\u0000 \u00182\u00020\u0001:\u0004\u0018\u0019\u001a\u001bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H&J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H&J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001c\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager;", "", "areListenersAttached", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getItemAroundOffset", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "offset", "", "getItems", "", "isRenderedDocHighlighter", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "removeAllItems", "", "resetToDefaultState", "setItemsToEditor", "itemsToSet", "Lcom/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items;", "collapseNewItems", "setupListeners", "disable", "Companion", "IconVisibilityController", "MyFoldingListener", "MyVisibleAreaListener", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public interface DocRenderItemManager {
    @NotNull
    public static final Companion Companion = com.intellij.codeInsight.documentation.render.DocRenderItemManager$Companion.$$INSTANCE;

    @Nullable
    default public DocRenderItem getItemAroundOffset(@NotNull Editor editor2, int offset2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return null;
    }

    public void removeAllItems(@NotNull Editor var1);

    public void setItemsToEditor(@NotNull Editor var1, @NotNull DocRenderPassFactory.Items var2, boolean var3);

    public void resetToDefaultState(@NotNull Editor var1);

    @Nullable
    public Collection<DocRenderItem> getItems(@NotNull Editor var1);

    public boolean isRenderedDocHighlighter(@NotNull RangeHighlighter var1);

    default public void setupListeners(@NotNull Editor editor2, boolean disable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Disposable existingDisposable = (Disposable)editor2.getUserData(com.intellij.codeInsight.documentation.render.DocRenderItemManager$Companion.LISTENERS_DISPOSABLE);
        if (disable) {
            Disposable disposable = existingDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose(it);
                editor2.putUserData(com.intellij.codeInsight.documentation.render.DocRenderItemManager$Companion.LISTENERS_DISPOSABLE, null);
            }
        } else if (existingDisposable == null) {
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            editor2.putUserData(com.intellij.codeInsight.documentation.render.DocRenderItemManager$Companion.LISTENERS_DISPOSABLE, (Object)connection);
            connection.setDefaultHandler(() -> DocRenderItemManager.setupListeners$lambda$1(editor2));
            Topic topic = EditorColorsManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic);
            Topic topic2 = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
            connection.subscribe(topic2);
            DocRenderSelectionManager selectionManager = new DocRenderSelectionManager(editor2);
            Disposer.register(connection, selectionManager);
            DocRenderMouseEventBridge mouseEventBridge = new DocRenderMouseEventBridge(selectionManager);
            editor2.addEditorMouseListener((EditorMouseListener)mouseEventBridge, (Disposable)connection);
            editor2.addEditorMouseMotionListener((EditorMouseMotionListener)mouseEventBridge, (Disposable)connection);
            IconVisibilityController iconVisibilityController = new IconVisibilityController();
            editor2.addEditorMouseListener((EditorMouseListener)iconVisibilityController, (Disposable)connection);
            editor2.addEditorMouseMotionListener((EditorMouseMotionListener)iconVisibilityController, (Disposable)connection);
            editor2.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)iconVisibilityController, (Disposable)connection);
            Disposer.register(connection, iconVisibilityController);
            editor2.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener(editor2), (Disposable)connection);
            ((EditorEx)editor2).getFoldingModel().addListener((FoldingListener)new MyFoldingListener(), (Disposable)connection);
            Disposer.register(connection, () -> DocRenderItemManager.setupListeners$lambda$2(editor2));
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(editor2, this){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ DocRenderItemManager this$0;
                {
                    this.$editor = $editor;
                    this.this$0 = $receiver;
                }

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (Intrinsics.areEqual((Object)event.getEditor(), (Object)this.$editor)) {
                        this.this$0.removeAllItems(this.$editor);
                    }
                }
            }, (Disposable)connection);
        }
    }

    default public boolean areListenersAttached(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return editor2.getUserData(com.intellij.codeInsight.documentation.render.DocRenderItemManager$Companion.LISTENERS_DISPOSABLE) != null;
    }

    private static void setupListeners$lambda$1(Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        DocRenderItemUpdater.updateRenderers($editor, true);
    }

    private static void setupListeners$lambda$2(Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        DocRenderer.clearCachedLoadingPane($editor);
    }

    @JvmStatic
    @NotNull
    public static DocRenderItemManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager$Companion;", "", "()V", "LISTENERS_DISPOSABLE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager;", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nDocRenderItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocRenderItemManager.kt\ncom/intellij/codeInsight/documentation/render/DocRenderItemManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,221:1\n39#2,3:222\n*S KotlinDebug\n*F\n+ 1 DocRenderItemManager.kt\ncom/intellij/codeInsight/documentation/render/DocRenderItemManager$Companion\n*L\n29#1:222,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Key<Disposable> LISTENERS_DISPOSABLE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DocRenderItemManager getInstance() {
            boolean $i$f$service = false;
            Class<DocRenderItemManager> serviceClass$iv = DocRenderItemManager.class;
            DocRenderItemManager docRenderItemManager = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (docRenderItemManager == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return docRenderItemManager;
        }

        static {
            $$INSTANCE = new Companion();
            Key key = Key.create("doc.render.listeners.disposable");
            Intrinsics.checkNotNullExpressionValue(key, (String)"create<Disposable>(\"doc.\u2026er.listeners.disposable\")");
            LISTENERS_DISPOSABLE = key;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0015H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager$IconVisibilityController;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/openapi/Disposable;", "()V", "myCurrentItem", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "myQueuedEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "dispose", "", "doUpdate", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseExited", "e", "mouseMoved", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Companion", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nDocRenderItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocRenderItemManager.kt\ncom/intellij/codeInsight/documentation/render/DocRenderItemManager$IconVisibilityController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
    private static final class IconVisibilityController
    implements EditorMouseListener,
    EditorMouseMotionListener,
    VisibleAreaListener,
    Disposable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private DocRenderItem myCurrentItem;
        @Nullable
        private EditorImpl myQueuedEditor;

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.editor");
            this.doUpdate(editor2, e);
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.editor");
            this.doUpdate(editor2, e);
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            EditorImpl editor3 = (EditorImpl)editor2;
            if (editor3.isCursorHidden()) {
                return;
            }
            if (this.myQueuedEditor == null) {
                this.myQueuedEditor = editor3;
                SwingUtilities.invokeLater(() -> IconVisibilityController.visibleAreaChanged$lambda$1(this));
            }
        }

        private final void doUpdate(Editor editor2, EditorMouseEvent event) {
            DocRenderItem item;
            int y = 0;
            int offset2 = -1;
            if (event == null) {
                PointerInfo info2 = MouseInfo.getPointerInfo();
                if (info2 != null) {
                    Point screenPoint = info2.getLocation();
                    JComponent jComponent = editor2.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
                    JComponent component2 = jComponent;
                    Point componentPoint = new Point(screenPoint);
                    SwingUtilities.convertPointFromScreen(componentPoint, component2);
                    if (new Rectangle(component2.getSize()).contains(componentPoint)) {
                        Point editorPoint = new Point(screenPoint);
                        SwingUtilities.convertPointFromScreen(editorPoint, editor2.getContentComponent());
                        y = editorPoint.y;
                        offset2 = editor2.visualPositionToOffset(new VisualPosition(editor2.yToVisualLine(y), 0));
                    }
                }
            } else {
                y = event.getMouseEvent().getY();
                offset2 = event.getOffset();
            }
            DocRenderItem docRenderItem = item = offset2 < 0 ? null : IconVisibilityController.Companion.findItem(editor2, y, offset2);
            if (item != this.myCurrentItem) {
                if (this.myCurrentItem != null) {
                    DocRenderItem docRenderItem2 = this.myCurrentItem;
                    Intrinsics.checkNotNull((Object)docRenderItem2);
                    docRenderItem2.setIconVisible(false);
                }
                this.myCurrentItem = item;
                if (this.myCurrentItem != null) {
                    DocRenderItem docRenderItem3 = this.myCurrentItem;
                    Intrinsics.checkNotNull((Object)docRenderItem3);
                    docRenderItem3.setIconVisible(true);
                }
            }
        }

        @Override
        public void dispose() {
            this.myCurrentItem = null;
            this.myQueuedEditor = null;
        }

        private static final void visibleAreaChanged$lambda$1(IconVisibilityController this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.myQueuedEditor != null) {
                EditorImpl editorImpl = this$0.myQueuedEditor;
                boolean bl = editorImpl != null ? !editorImpl.isDisposed() : false;
                if (bl) {
                    EditorImpl editorImpl2 = this$0.myQueuedEditor;
                    if (editorImpl2 != null) {
                        EditorImpl it = editorImpl2;
                        boolean bl2 = false;
                        this$0.doUpdate((Editor)it, null);
                    }
                }
            }
            this$0.myQueuedEditor = null;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager$IconVisibilityController$Companion;", "", "()V", "findItem", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "editor", "Lcom/intellij/openapi/editor/Editor;", "y", "", "neighborOffset", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final DocRenderItem findItem(Editor editor2, int y, int neighborOffset) {
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                Document document2 = document;
                int lineNumber = document2.getLineNumber(neighborOffset);
                int searchStartOffset = document2.getLineStartOffset(RangesKt.coerceAtLeast((int)0, (int)(lineNumber - 1)));
                int searchEndOffset = document2.getLineEndOffset(lineNumber);
                Collection<DocRenderItem> collection = DocRenderItemManager.Companion.getInstance().getItems(editor2);
                if (collection == null) {
                    return null;
                }
                Collection<DocRenderItem> items2 = collection;
                for (DocRenderItem item : items2) {
                    RangeHighlighter highlighter = item.getHighlighter();
                    if (!highlighter.isValid() || highlighter.getStartOffset() > searchEndOffset || highlighter.getEndOffset() < searchStartOffset) continue;
                    int itemStartY = 0;
                    int itemEndY = 0;
                    if (item.getFoldRegion() == null) {
                        itemStartY = editor2.visualLineToY(editor2.offsetToVisualLine(highlighter.getStartOffset(), false));
                        itemEndY = editor2.visualLineToY(editor2.offsetToVisualLine(highlighter.getEndOffset(), true)) + editor2.getLineHeight();
                    } else {
                        CustomFoldRegion cfr;
                        CustomFoldRegion customFoldRegion = cfr = item.getFoldRegion();
                        Intrinsics.checkNotNull((Object)customFoldRegion);
                        Point location2 = customFoldRegion.getLocation();
                        if (location2 != null) {
                            itemStartY = location2.y;
                            itemEndY = itemStartY + cfr.getHeightInPixels();
                        }
                    }
                    boolean bl = itemStartY <= y ? y < itemEndY : false;
                    if (!bl) break;
                    return item;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager$MyVisibleAreaListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "lastFrcTransform", "Ljava/awt/geom/AffineTransform;", "lastWidth", "", "visibleAreaChanged", "", "e", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Companion", "intellij.platform.lang.impl"})
    private static final class MyVisibleAreaListener
    implements VisibleAreaListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int lastWidth;
        @NotNull
        private AffineTransform lastFrcTransform;

        public MyVisibleAreaListener(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.lastWidth = DocRenderer.calcWidth(editor2);
            this.lastFrcTransform = MyVisibleAreaListener.Companion.getTransform(editor2);
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getNewRectangle().isEmpty()) {
                return;
            }
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.editor");
            Editor editor3 = editor2;
            int newWidth = DocRenderer.calcWidth(editor3);
            AffineTransform transform2 = MyVisibleAreaListener.Companion.getTransform(editor3);
            if (newWidth != this.lastWidth || !Intrinsics.areEqual((Object)transform2, (Object)this.lastFrcTransform)) {
                this.lastWidth = newWidth;
                this.lastFrcTransform = transform2;
                DocRenderItemUpdater.updateRenderers(editor3, false);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager$MyVisibleAreaListener$Companion;", "", "()V", "getTransform", "Ljava/awt/geom/AffineTransform;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final AffineTransform getTransform(Editor editor2) {
                AffineTransform affineTransform = FontInfo.getFontRenderContext((Component)editor2.getContentComponent()).getTransform();
                Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getFontRenderContext(edi\u2026ntentComponent).transform");
                return affineTransform;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager$MyFoldingListener;", "Lcom/intellij/openapi/editor/ex/FoldingListener;", "()V", "beforeFoldRegionDisposed", "", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "intellij.platform.lang.impl"})
    private static final class MyFoldingListener
    implements FoldingListener {
        public void beforeFoldRegionDisposed(@NotNull FoldRegion region) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            if (region instanceof CustomFoldRegion) {
                CustomFoldRegionRenderer customFoldRegionRenderer = ((CustomFoldRegion)region).getRenderer();
                Intrinsics.checkNotNullExpressionValue((Object)customFoldRegionRenderer, (String)"region.renderer");
                CustomFoldRegionRenderer renderer = customFoldRegionRenderer;
                if (renderer instanceof DocRenderer) {
                    ((DocRenderer)renderer).dispose();
                }
            }
        }
    }
}

