/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemImpl;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\fH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItemManager;", "()V", "getItemAroundOffset", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "getItems", "", "isRenderedDocHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "removeAllItems", "", "resetToDefaultState", "setItemsToEditor", "itemsToSet", "Lcom/intellij/codeInsight/documentation/render/DocRenderPassFactory$Items;", "collapseNewItems", "setupListeners", "disable", "Companion", "Listener", "MyCaretListener", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nDocRenderItemManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocRenderItemManagerImpl.kt\ncom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n766#2:180\n857#2,2:181\n2333#2,14:183\n*S KotlinDebug\n*F\n+ 1 DocRenderItemManagerImpl.kt\ncom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl\n*L\n25#1:180\n25#1:181,2\n30#1:183,14\n*E\n"})
public final class DocRenderItemManagerImpl
implements DocRenderItemManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Topic<Listener> TOPIC = new Topic<Listener>(Listener.class, Topic.BroadcastDirection.NONE, true);
    @NotNull
    private static final Key<List<DocRenderItemImpl>> OUR_ITEMS;
    @JvmField
    @NotNull
    public static final Key<Boolean> OWN_HIGHLIGHTER;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DocRenderItem getItemAroundOffset(@NotNull Editor editor2, int offset2) {
        DocRenderItemImpl itemOnAdjacentLine;
        Object v2;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List items2 = (List)editor2.getUserData(OUR_ITEMS);
        Collection collection = items2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        if (offset2 < 0 || offset2 > document2.getTextLength()) {
            return null;
        }
        int line = document2.getLineNumber(offset2);
        Iterable $this$filter$iv = items2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            DocRenderItemImpl it = (DocRenderItemImpl)element$iv$iv;
            boolean bl2 = false;
            if (!it.isValid()) {
                bl = false;
            } else {
                int startLine = document2.getLineNumber(it.getHighlighter().getStartOffset());
                int endLine = document2.getLineNumber(it.getHighlighter().getEndOffset());
                bl = line >= startLine - 1 && line <= endLine + 1;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                DocRenderItemImpl it = (DocRenderItemImpl)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getHighlighter().getStartOffset();
                do {
                    Object e$iv = iterator$iv.next();
                    DocRenderItemImpl it2 = (DocRenderItemImpl)e$iv;
                    $i$a$-minByOrNull-DocRenderItemManagerImpl$getItemAroundOffset$itemOnAdjacentLine$2 = false;
                    int v$iv = it2.getHighlighter().getStartOffset();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        DocRenderItemImpl docRenderItemImpl = itemOnAdjacentLine = (DocRenderItemImpl)v2;
        if (docRenderItemImpl != null) {
            return docRenderItemImpl;
        }
        DocRenderItemImpl foundItem = null;
        int foundStartOffset = 0;
        for (DocRenderItemImpl item : items2) {
            InlineDocumentation documentation;
            TextRange ownerTextRange;
            if (!item.isValid() || item.getInlineDocumentation() == null || (ownerTextRange = documentation.getDocumentationOwnerRange()) == null || !ownerTextRange.containsOffset(offset2)) continue;
            int startOffset = ownerTextRange.getStartOffset();
            if (foundItem != null && foundStartOffset >= startOffset) continue;
            foundItem = item;
            foundStartOffset = startOffset;
        }
        return foundItem;
    }

    @Override
    @Nullable
    public Collection<DocRenderItem> getItems(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List list2 = (List)editor2.getUserData(OUR_ITEMS);
        if (list2 == null) {
            return null;
        }
        List items2 = list2;
        return Collections.unmodifiableCollection(items2);
    }

    @Override
    public void removeAllItems(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.setItemsToEditor(editor2, new DocRenderPassFactory.Items(), false);
    }

    @Override
    public void setItemsToEditor(@NotNull Editor editor2, @NotNull DocRenderPassFactory.Items itemsToSet, boolean collapseNewItems) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)itemsToSet, (String)"itemsToSet");
        if (editor2.getUserData(OUR_ITEMS) == null && itemsToSet.isEmpty()) {
            return;
        }
        List list2 = ((UserDataHolderEx)editor2).putUserDataIfAbsent(OUR_ITEMS, (List)new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor as UserDataHolder\u2026R_ITEMS, mutableListOf())");
        List items2 = list2;
        DocRenderItemManagerImpl.Companion.keepScrollingPositionWhile(editor2, () -> DocRenderItemManagerImpl.setItemsToEditor$lambda$4(items2, itemsToSet, editor2, collapseNewItems));
        this.setupListeners(editor2, items2.isEmpty());
    }

    @Override
    public void setupListeners(@NotNull Editor editor2, boolean disable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (disable) {
            editor2.getCaretModel().removeCaretListener((CaretListener)MyCaretListener.INSTANCE);
        } else if (!this.areListenersAttached(editor2)) {
            editor2.getCaretModel().addCaretListener((CaretListener)MyCaretListener.INSTANCE);
        }
        DocRenderItemManager.super.setupListeners(editor2, disable);
    }

    @Override
    public void resetToDefaultState(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        List list2 = (List)editor2.getUserData(OUR_ITEMS);
        if (list2 == null) {
            return;
        }
        List items2 = list2;
        boolean editorSetting = DocRenderManager.isDocRenderingEnabled(editor2);
        DocRenderItemManagerImpl.Companion.keepScrollingPositionWhile(editor2, () -> DocRenderItemManagerImpl.resetToDefaultState$lambda$7(items2, editorSetting, editor2));
    }

    @Override
    public boolean isRenderedDocHighlighter(@NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return Intrinsics.areEqual((Object)Boolean.TRUE, (Object)highlighter.getUserData(OWN_HIGHLIGHTER));
    }

    private static final void setItemsToEditor$lambda$4$lambda$3$lambda$2(Runnable obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.run();
    }

    private static final void setItemsToEditor$lambda$4$lambda$3(List $foldingTasks) {
        Intrinsics.checkNotNullParameter((Object)$foldingTasks, (String)"$foldingTasks");
        $foldingTasks.forEach(DocRenderItemManagerImpl::setItemsToEditor$lambda$4$lambda$3$lambda$2);
    }

    private static final boolean setItemsToEditor$lambda$4(List $items, DocRenderPassFactory.Items $itemsToSet, Editor $editor, boolean $collapseNewItems) {
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        Intrinsics.checkNotNullParameter((Object)$itemsToSet, (String)"$itemsToSet");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        List foldingTasks = new ArrayList();
        List itemsToUpdateRenderers = new ArrayList();
        List itemsToUpdateText = new ArrayList();
        boolean updated = false;
        Iterator it = $items.iterator();
        while (it.hasNext()) {
            Iterator<DocRenderPassFactory.Item> matchingNewItem;
            DocRenderItemImpl existingItem = (DocRenderItemImpl)it.next();
            Iterator<DocRenderPassFactory.Item> iterator2 = matchingNewItem = existingItem.isValid() ? $itemsToSet.removeItem((Segment)existingItem.getHighlighter()) : null;
            if (matchingNewItem == null) {
                updated |= existingItem.remove(foldingTasks);
                it.remove();
                continue;
            }
            if (((DocRenderPassFactory.Item)((Object)matchingNewItem)).textToRender != null && !Intrinsics.areEqual((Object)((DocRenderPassFactory.Item)((Object)matchingNewItem)).textToRender, (Object)existingItem.getTextToRender())) {
                itemsToUpdateRenderers.add(existingItem);
                String string2 = ((DocRenderPassFactory.Item)((Object)matchingNewItem)).textToRender;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matchingNewItem.textToRender");
                itemsToUpdateText.add(string2);
                continue;
            }
            existingItem.updateIcon(foldingTasks);
        }
        Collection newRenderItems = new ArrayList();
        for (DocRenderPassFactory.Item item : $itemsToSet) {
            TextRange textRange = item.textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"item.textRange");
            DocRenderItemImpl newItem = new DocRenderItemImpl($editor, textRange, $collapseNewItems ? null : item.textToRender);
            newRenderItems.add(newItem);
            if (!$collapseNewItems) continue;
            updated |= newItem.toggle(foldingTasks);
            itemsToUpdateRenderers.add(newItem);
            String string3 = item.textToRender;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.textToRender");
            itemsToUpdateText.add(string3);
        }
        $editor.getFoldingModel().runBatchFoldingOperation(() -> DocRenderItemManagerImpl.setItemsToEditor$lambda$4$lambda$3(foldingTasks), true, false);
        int n = itemsToUpdateRenderers.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ((DocRenderItemImpl)itemsToUpdateRenderers.get(i2)).setTextToRender((String)itemsToUpdateText.get(i2));
        }
        DocRenderItemUpdater.updateRenderers(itemsToUpdateRenderers, true);
        ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC).itemsTextChanged($editor, itemsToUpdateRenderers);
        $items.addAll(newRenderItems);
        return updated;
    }

    private static final void resetToDefaultState$lambda$7$lambda$6$lambda$5(Runnable obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.run();
    }

    private static final void resetToDefaultState$lambda$7$lambda$6(List $foldingTasks) {
        Intrinsics.checkNotNullParameter((Object)$foldingTasks, (String)"$foldingTasks");
        $foldingTasks.forEach(DocRenderItemManagerImpl::resetToDefaultState$lambda$7$lambda$6$lambda$5);
    }

    private static final boolean resetToDefaultState$lambda$7(List $items, boolean $editorSetting, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        List foldingTasks = new ArrayList();
        boolean updated = false;
        for (DocRenderItemImpl item : $items) {
            if (!item.isValid() || item.getFoldRegion() == null != $editorSetting) continue;
            updated |= item.toggle(foldingTasks);
        }
        $editor.getFoldingModel().runBatchFoldingOperation(() -> DocRenderItemManagerImpl.resetToDefaultState$lambda$7$lambda$6(foldingTasks), true, false);
        return updated;
    }

    static {
        Key key = Key.create("doc.render.items");
        Intrinsics.checkNotNullExpressionValue(key, (String)"create<MutableList<DocRe\u2026mpl>>(\"doc.render.items\")");
        OUR_ITEMS = key;
        Key key2 = Key.create("doc.render.highlighter");
        Intrinsics.checkNotNullExpressionValue(key2, (String)"create<Boolean>(\"doc.render.highlighter\")");
        OWN_HIGHLIGHTER = key2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0004\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl$Companion;", "", "()V", "OUR_ITEMS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/codeInsight/documentation/render/DocRenderItemImpl;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "OWN_HIGHLIGHTER", "", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl$Listener;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "keepScrollingPositionWhile", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "task", "Ljava/util/function/BooleanSupplier;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        private final void keepScrollingPositionWhile(Editor editor2, BooleanSupplier task2) {
            EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor2);
            keeper.savePosition();
            if (task2.getAsBoolean()) {
                keeper.restorePosition(false);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl$MyCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "()V", "caretAdded", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretPositionChanged", "onCaretUpdate", "intellij.platform.lang.impl"})
    public static final class MyCaretListener
    implements CaretListener {
        @NotNull
        public static final MyCaretListener INSTANCE = new MyCaretListener();

        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onCaretUpdate(event);
        }

        public void caretAdded(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onCaretUpdate(event);
        }

        private final void onCaretUpdate(CaretEvent event) {
            Caret caret = event.getCaret();
            if (caret == null) {
                return;
            }
            Caret caret2 = caret;
            int caretOffset = caret2.getOffset();
            FoldRegion foldRegion = caret2.getEditor().getFoldingModel().getCollapsedRegionAtOffset(caretOffset);
            if (foldRegion instanceof CustomFoldRegion && caretOffset > ((CustomFoldRegion)foldRegion).getStartOffset()) {
                CustomFoldRegionRenderer customFoldRegionRenderer = ((CustomFoldRegion)foldRegion).getRenderer();
                Intrinsics.checkNotNullExpressionValue((Object)customFoldRegionRenderer, (String)"foldRegion.renderer");
                CustomFoldRegionRenderer renderer = customFoldRegionRenderer;
                if (renderer instanceof DocRenderer) {
                    DocRenderItem item = ((DocRenderer)renderer).getItem();
                    item.toggle();
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderItemManagerImpl$Listener;", "", "itemsTextChanged", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "items", "", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "intellij.platform.lang.impl"})
    public static interface Listener {
        public void itemsTextChanged(@NotNull Editor var1, @NotNull Collection<? extends DocRenderItem> var2);
    }
}

