/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

@Service
public final class DocRenderItemUpdater
implements Runnable {
    private static final long MAX_UPDATE_DURATION_MS = 50L;
    private final Map<CustomFoldRegion, Boolean> myQueue = new HashMap<CustomFoldRegion, Boolean>();

    static DocRenderItemUpdater getInstance() {
        return ApplicationManager.getApplication().getService(DocRenderItemUpdater.class);
    }

    public static void updateRenderers(@NotNull Collection<? extends DocRenderItem> items2, boolean recreateContent) {
        if (items2 == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(0);
        }
        DocRenderItemUpdater.getInstance().updateFoldRegions(ContainerUtil.mapNotNull(items2, i2 -> i2.getFoldRegion()), recreateContent);
    }

    static void updateRenderers(@NotNull Editor editor2, boolean recreateContent) {
        Collection<DocRenderItem> items2;
        if (editor2 == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(1);
        }
        if (recreateContent) {
            DocRenderer.clearCachedLoadingPane(editor2);
        }
        if ((items2 = DocRenderItemManager.getInstance().getItems(editor2)) != null) {
            DocRenderItemUpdater.updateRenderers(items2, recreateContent);
        }
    }

    void updateFoldRegions(@NotNull Collection<? extends CustomFoldRegion> foldRegions, boolean recreateContent) {
        if (foldRegions == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(2);
        }
        if (foldRegions.isEmpty()) {
            return;
        }
        boolean wasEmpty = this.myQueue.isEmpty();
        for (CustomFoldRegion customFoldRegion : foldRegions) {
            this.myQueue.merge(customFoldRegion, recreateContent, Boolean::logicalOr);
        }
        if (wasEmpty) {
            this.processChunk();
        }
    }

    @Override
    public void run() {
        this.processChunk();
    }

    private void processChunk() {
        long deadline = System.currentTimeMillis() + 50L;
        HashMap<Editor, EditorScrollingPositionKeeper> keepers = new HashMap<Editor, EditorScrollingPositionKeeper>();
        ArrayList<CustomFoldRegion> toProcess = new ArrayList<CustomFoldRegion>(this.myQueue.keySet());
        Object2IntOpenHashMap memoMap = new Object2IntOpenHashMap();
        toProcess.sort(Comparator.comparingInt(i2 -> -Math.abs(i2.getStartOffset() - DocRenderItemUpdater.getVisibleOffset(i2.getEditor(), memoMap))));
        do {
            CustomFoldRegion region = (CustomFoldRegion)toProcess.remove(toProcess.size() - 1);
            boolean updateContent = this.myQueue.remove(region);
            if (!region.isValid()) continue;
            Editor editor2 = region.getEditor();
            keepers.computeIfAbsent(editor2, e -> {
                EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor2);
                keeper.savePosition();
                return keeper;
            });
            ((DocRenderer)region.getRenderer()).update(true, updateContent, null);
        } while (!toProcess.isEmpty() && System.currentTimeMillis() < deadline);
        keepers.values().forEach(k -> k.restorePosition(false));
        if (!this.myQueue.isEmpty()) {
            SwingUtilities.invokeLater(this);
        }
    }

    private static int getVisibleOffset(Editor editor2, Object2IntMap<Editor> memoMap) {
        return memoMap.computeIntIfAbsent(editor2, e -> {
            Rectangle visibleArea = e.getScrollingModel().getVisibleAreaOnScrollingFinished();
            if (editor2.isDisposed() || visibleArea.height <= 0) {
                return e.getCaretModel().getOffset();
            }
            int y = visibleArea.y + visibleArea.height / 2;
            int visualLine = e.yToVisualLine(y);
            return e.visualPositionToOffset(new VisualPosition(visualLine, 0));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItemUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRenderers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFoldRegions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

