/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/documentation/render/DocRenderLinkActivationHandler;", "", "isGotoDeclarationEvent", "", "()Z", "activateLink", "", "event", "Ljavax/swing/event/HyperlinkEvent;", "renderer", "Lcom/intellij/codeInsight/documentation/render/DocRenderer;", "getLocation", "Ljava/awt/geom/Rectangle2D;", "popupPosition", "Ljava/awt/Point;", "linkLocationWithinInlay", "intellij.platform.lang.impl"})
public interface DocRenderLinkActivationHandler {
    public void activateLink(@NotNull HyperlinkEvent var1, @NotNull DocRenderer var2);

    @Nullable
    default public Rectangle2D getLocation(@NotNull HyperlinkEvent event) {
        Rectangle2D rectangle2D;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Element element = event.getSourceElement();
        if (element == null) {
            return null;
        }
        Element element2 = element;
        try {
            Object object = event.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JEditorPane");
            rectangle2D = ((JEditorPane)object).modelToView2D(element2.getStartOffset());
        }
        catch (BadLocationException ignored) {
            rectangle2D = null;
        }
        Rectangle2D location2 = rectangle2D;
        return location2;
    }

    default public boolean isGotoDeclarationEvent() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null) {
            return false;
        }
        KeymapManager keymapManager2 = keymapManager;
        AWTEvent aWTEvent = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
        MouseEvent mouseEvent = aWTEvent instanceof MouseEvent ? (MouseEvent)aWTEvent : null;
        if (mouseEvent == null) {
            return false;
        }
        MouseEvent event = mouseEvent;
        MouseShortcut mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)event);
        Intrinsics.checkNotNullExpressionValue((Object)mouseShortcut, (String)"createMouseShortcut(event)");
        MouseShortcut mouseShortcut2 = mouseShortcut;
        return keymapManager2.getActiveKeymap().getActionIds(mouseShortcut2).contains("GotoDeclaration");
    }

    @NotNull
    default public Point popupPosition(@NotNull Rectangle2D linkLocationWithinInlay, @NotNull DocRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)linkLocationWithinInlay, (String)"linkLocationWithinInlay");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        CustomFoldRegion customFoldRegion = renderer.getItem().getFoldRegion();
        if (customFoldRegion == null) {
            return new Point(0, 0);
        }
        CustomFoldRegion foldRegion = customFoldRegion;
        Point point = foldRegion.getLocation();
        if (point == null) {
            return new Point(0, 0);
        }
        Point rendererPosition = point;
        Rectangle relativeBounds = renderer.getEditorPaneBoundsWithinRenderer(foldRegion.getWidthInPixels(), foldRegion.getHeightInPixels());
        return new Point(rendererPosition.x + relativeBounds.x + (int)linkLocationWithinInlay.getX(), rendererPosition.y + relativeBounds.y + (int)Math.ceil(linkLocationWithinInlay.getMaxY()));
    }
}

