/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.DocumentationActionProvider;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.render.DocRenderDefaultLinkActivationHandler;
import com.intellij.codeInsight.documentation.render.DocRenderImageManager;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderLinkActivationHandler;
import com.intellij.codeInsight.documentation.render.DocRendererMemoryManager;
import com.intellij.codeInsight.documentation.render.PsiCommentInlineDocumentation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StyleSheetUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DocRenderer
implements CustomFoldRegionRenderer {
    private static final Logger LOG = Logger.getInstance(DocRenderer.class);
    private static final Key<EditorPane> CACHED_LOADING_PANE = Key.create("cached.loading.pane");
    private static final DocRendererMemoryManager MEMORY_MANAGER = new DocRendererMemoryManager();
    private static final DocRenderImageManager IMAGE_MANAGER = new DocRenderImageManager();
    private static final int MIN_WIDTH = 350;
    private static final int MAX_WIDTH = 680;
    private static final int LEFT_INSET = 14;
    private static final int RIGHT_INSET = 12;
    private static final int TOP_BOTTOM_INSETS = 2;
    private static final int TOP_BOTTOM_MARGINS = 4;
    private static final int LINE_WIDTH = 2;
    private static final int ARC_RADIUS = 5;
    private static StyleSheet ourCachedStyleSheet;
    private static String ourCachedStyleSheetLinkColor;
    private final DocRenderItem myItem;
    private boolean myContentUpdateNeeded;
    private EditorPane myPane;
    private int myCachedWidth;
    private int myCachedHeight;
    @NotNull
    private final DocRenderLinkActivationHandler myLinkActivationHandler;

    public DocRenderer(@NotNull DocRenderItem item) {
        if (item == null) {
            DocRenderer.$$$reportNull$$$0(0);
        }
        this(item, DocRenderDefaultLinkActivationHandler.INSTANCE);
    }

    public DocRenderer(@NotNull DocRenderItem item, @NotNull DocRenderLinkActivationHandler linkActivationHandler) {
        if (item == null) {
            DocRenderer.$$$reportNull$$$0(1);
        }
        if (linkActivationHandler == null) {
            DocRenderer.$$$reportNull$$$0(2);
        }
        this.myCachedWidth = -1;
        this.myCachedHeight = -1;
        this.myItem = item;
        this.myLinkActivationHandler = linkActivationHandler;
    }

    void update(boolean updateSize, boolean updateContent, List<Runnable> foldingTasks) {
        CustomFoldRegion foldRegion = this.myItem.getFoldRegion();
        if (foldRegion != null) {
            if (updateSize) {
                this.myCachedWidth = -1;
                this.myCachedHeight = -1;
            }
            this.myContentUpdateNeeded = updateContent;
            Runnable task2 = () -> foldRegion.update();
            if (foldingTasks == null) {
                task2.run();
            } else {
                foldingTasks.add(task2);
            }
        }
    }

    public int calcWidthInPixels(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(3);
        }
        if (this.myCachedWidth < 0) {
            this.myCachedWidth = DocRenderer.calcWidth(region.getEditor());
            return this.myCachedWidth;
        }
        return this.myCachedWidth;
    }

    public int calcHeightInPixels(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(4);
        }
        if (this.myCachedHeight < 0) {
            Editor editor2 = region.getEditor();
            int indent = 0;
            if (this.myItem.getTextToRender() != null) {
                indent = this.calcInlayStartX() - editor2.getInsets().left;
            }
            int width = Math.max(0, DocRenderer.calcWidth(editor2) - indent - DocRenderer.scale(14) - DocRenderer.scale(12));
            EditorPane component2 = this.getRendererComponent(editor2, width);
            this.myCachedHeight = Math.max(editor2.getLineHeight(), ((JComponent)component2).getPreferredSize().height + DocRenderer.scale(2) * 2 + DocRenderer.scale(4) * 2);
            return this.myCachedHeight;
        }
        return this.myCachedHeight;
    }

    public void paint(@NotNull CustomFoldRegion region, @NotNull Graphics2D g, @NotNull Rectangle2D r, @NotNull TextAttributes textAttributes) {
        Color bgColor;
        int endX;
        int startX;
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(5);
        }
        if (g == null) {
            DocRenderer.$$$reportNull$$$0(6);
        }
        if (r == null) {
            DocRenderer.$$$reportNull$$$0(7);
        }
        if (textAttributes == null) {
            DocRenderer.$$$reportNull$$$0(8);
        }
        if ((startX = this.calcInlayStartX()) >= (endX = (int)r.getX() + (int)r.getWidth())) {
            return;
        }
        int margin = DocRenderer.scale(4);
        int filledHeight = (int)r.getHeight() - margin * 2;
        if (filledHeight <= 0) {
            return;
        }
        int filledStartY = (int)r.getY() + margin;
        Editor editor2 = region.getEditor();
        Color defaultBgColor = ((EditorEx)editor2).getBackgroundColor();
        Color currentBgColor = textAttributes.getBackgroundColor();
        Color color = bgColor = currentBgColor == null ? defaultBgColor : ColorUtil.mix(defaultBgColor, textAttributes.getBackgroundColor(), 0.5);
        if (currentBgColor != null) {
            g.setColor(bgColor);
            int arcDiameter = 10;
            if (endX - startX >= arcDiameter) {
                g.fillRect(startX, filledStartY, endX - startX - 5, filledHeight);
                Object savedHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillRoundRect(endX - arcDiameter, filledStartY, arcDiameter, filledHeight, arcDiameter, arcDiameter);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedHint);
            } else {
                g.fillRect(startX, filledStartY, endX - startX, filledHeight);
            }
        }
        g.setColor(editor2.getColorsScheme().getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE));
        g.fillRect(startX, filledStartY, DocRenderer.scale(2), filledHeight);
        int topBottomInset = DocRenderer.scale(2);
        int componentWidth = endX - startX - DocRenderer.scale(14) - DocRenderer.scale(12);
        int componentHeight = filledHeight - topBottomInset * 2;
        if (componentWidth > 0 && componentHeight > 0) {
            EditorPane component2 = this.getRendererComponent(editor2, componentWidth);
            component2.setBackground(bgColor);
            Graphics dg = g.create(startX + DocRenderer.scale(14), filledStartY + topBottomInset, componentWidth, componentHeight);
            UISettings.setupAntialiasing((Graphics)dg);
            ((JComponent)component2).paint(dg);
            dg.dispose();
        }
    }

    @Nullable
    public GutterIconRenderer calcGutterIconRenderer(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(9);
        }
        assert (this.myItem.getFoldRegion() == region || this.myItem.getFoldRegion() == null);
        return this.myItem.calcFoldingGutterIconRenderer();
    }

    public ActionGroup getContextMenuGroup(@NotNull CustomFoldRegion region) {
        if (region == null) {
            DocRenderer.$$$reportNull$$$0(10);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new CopySelection());
        group2.addSeparator();
        group2.add((AnAction)new ToggleRenderingAction(this.myItem));
        AnAction toggleRenderAllAction = ActionManager.getInstance().getAction("ToggleRenderedDocPresentationForAll");
        if (toggleRenderAllAction != null) {
            group2.add(toggleRenderAllAction);
        }
        group2.add((AnAction)new ChangeFontSize());
        PsiDocCommentBase comment = this.getComment();
        for (DocumentationActionProvider provider2 : DocumentationActionProvider.EP_NAME.getExtensions()) {
            provider2.additionalActions(this.myItem.getEditor(), comment, this.myItem.getTextToRender()).forEach(arg_0 -> ((DefaultActionGroup)group2).add(arg_0));
        }
        return group2;
    }

    public DocRenderItem getItem() {
        return this.myItem;
    }

    @Nullable
    private PsiDocCommentBase getComment() {
        InlineDocumentation documentation = this.myItem.getInlineDocumentation();
        return documentation instanceof PsiCommentInlineDocumentation ? ((PsiCommentInlineDocumentation)documentation).getComment() : null;
    }

    private static int scale(int value) {
        return (int)((float)value * UISettings.getDefFontScale());
    }

    static int calcWidth(@NotNull Editor editor2) {
        int availableWidth;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(11);
        }
        if ((availableWidth = editor2.getScrollingModel().getVisibleArea().width) <= 0) {
            return 680;
        }
        return Math.max(DocRenderer.scale(350), Math.min(DocRenderer.scale(680), availableWidth));
    }

    private int calcInlayStartX() {
        Document document;
        int nextLineNumber;
        Editor editor2 = this.myItem.getEditor();
        RangeHighlighter highlighter = this.myItem.getHighlighter();
        if (highlighter.isValid() && (nextLineNumber = (document = editor2.getDocument()).getLineNumber(highlighter.getEndOffset()) + 1) < document.getLineCount()) {
            int lineStartOffset = document.getLineStartOffset(nextLineNumber);
            int contentStartOffset = CharArrayUtil.shiftForward(document.getImmutableCharSequence(), lineStartOffset, " \t\n");
            return editor2.offsetToXY((int)contentStartOffset, (boolean)false, (boolean)true).x;
        }
        return editor2.getInsets().left;
    }

    Rectangle getEditorPaneBoundsWithinRenderer(int width, int height) {
        int relativeX = this.calcInlayStartX() - this.myItem.getEditor().getInsets().left + DocRenderer.scale(14);
        int relativeY = DocRenderer.scale(4) + DocRenderer.scale(2);
        return new Rectangle(relativeX, relativeY, width - relativeX - DocRenderer.scale(12), height - relativeY * 2);
    }

    EditorPane getRendererComponent(Editor editor2, int width) {
        boolean newInstance = false;
        EditorPane pane = this.myPane;
        if (pane == null || this.myContentUpdateNeeded) {
            this.myContentUpdateNeeded = false;
            this.clearCachedComponent();
            if (this.myItem.getTextToRender() == null) {
                pane = this.getLoadingPane(editor2);
            } else {
                this.myPane = pane = this.createEditorPane(editor2, this.myItem.getTextToRender(), false);
                newInstance = true;
            }
        }
        AppUIUtil.targetToDevice((Component)pane, (Component)editor2.getContentComponent());
        pane.setSize(width, 10000000);
        if (newInstance) {
            pane.getPreferredSize();
            pane.startImageTracking();
        }
        return pane;
    }

    private EditorPane getLoadingPane(@NotNull Editor editor2) {
        EditorPane pane;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(12);
        }
        if ((pane = (EditorPane)editor2.getUserData(CACHED_LOADING_PANE)) == null) {
            pane = this.createEditorPane(editor2, CodeInsightBundle.message("doc.render.loading.text", new Object[0]), true);
            editor2.putUserData(CACHED_LOADING_PANE, (Object)pane);
        }
        return pane;
    }

    static void clearCachedLoadingPane(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(13);
        }
        editor2.putUserData(CACHED_LOADING_PANE, null);
    }

    private EditorPane createEditorPane(@NotNull Editor editor2, @Nls @NotNull String text2, boolean reusable) {
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            DocRenderer.$$$reportNull$$$0(15);
        }
        EditorPane pane = new EditorPane(!reusable);
        pane.setEditable(false);
        pane.getCaret().setSelectionVisible(!reusable);
        pane.putClientProperty("caretWidth", 0);
        pane.setEditorKit(DocRenderer.createEditorKit(editor2));
        pane.setBorder(JBUI.Borders.empty());
        HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
        fontAttributes.put(TextAttribute.SIZE, JBUIScale.scale(DocumentationComponent.getQuickDocFontSize().getSize()));
        fontAttributes.put(TextAttribute.KERNING, 0);
        pane.setFont(pane.getFont().deriveFont(fontAttributes));
        Color textColor = DocRenderer.getTextColor(editor2.getColorsScheme());
        pane.setForeground(textColor);
        pane.setSelectedTextColor(textColor);
        pane.setSelectionColor(editor2.getSelectionModel().getTextAttributes().getBackgroundColor());
        UIUtil.enableEagerSoftWrapping(pane);
        pane.setText(text2);
        pane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myLinkActivationHandler.activateLink(e, this);
            }
        });
        pane.getDocument().putProperty("imageCache", IMAGE_MANAGER.getImageProvider());
        return pane;
    }

    void clearCachedComponent() {
        if (this.myPane != null) {
            this.myPane.dispose();
            this.myPane = null;
        }
    }

    void dispose() {
        this.clearCachedComponent();
    }

    @NotNull
    private static Color getTextColor(@NotNull EditorColorsScheme scheme) {
        TextAttributes attributes;
        if (scheme == null) {
            DocRenderer.$$$reportNull$$$0(16);
        }
        Color color = (attributes = scheme.getAttributes(DefaultLanguageHighlighterColors.DOC_COMMENT)) == null ? null : attributes.getForegroundColor();
        Color color2 = color == null ? scheme.getDefaultForeground() : color;
        if (color2 == null) {
            DocRenderer.$$$reportNull$$$0(17);
        }
        return color2;
    }

    private static EditorKit createEditorKit(@NotNull Editor editor2) {
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(18);
        }
        HTMLEditorKit editorKit = new HTMLEditorKitBuilder().withViewFactoryExtensions((element, view) -> view instanceof ImageView ? new MyScalingImageView((Element)element) : null).withFontResolver((CSSFontResolver)EditorCssFontResolver.getInstance((Editor)editor2)).build();
        editorKit.getStyleSheet().addStyleSheet(DocRenderer.getStyleSheet(editor2));
        return editorKit;
    }

    private static StyleSheet getStyleSheet(@NotNull Editor editor2) {
        String linkColorHex;
        EditorColorsScheme colorsScheme;
        Color linkColor;
        if (editor2 == null) {
            DocRenderer.$$$reportNull$$$0(19);
        }
        if ((linkColor = (colorsScheme = editor2.getColorsScheme()).getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_LINK)) == null) {
            linkColor = DocRenderer.getTextColor(colorsScheme);
        }
        if (!Objects.equals(linkColorHex = ColorUtil.toHex(linkColor), ourCachedStyleSheetLinkColor)) {
            String editorFontNamePlaceHolder = "_EditorFontNoLigatures_";
            ourCachedStyleSheet = StyleSheetUtil.loadStyleSheet("body {overflow-wrap: anywhere}code {font-family: \"" + editorFontNamePlaceHolder + "\"}pre {font-family: \"" + editorFontNamePlaceHolder + "\";white-space: pre-wrap}h1, h2, h3, h4, h5, h6 {margin-top: 0; padding-top: 1}a {color: #" + linkColorHex + "; text-decoration: none}p {padding: 7 0 2 0}ol {padding: 0 20 0 0}ul {padding: 0 20 0 0}li {padding: 1 0 2 0}li p {padding-top: 0}table p {padding-bottom: 0}th {text-align: left}td {padding: 2 0 2 0}td p {padding-top: 0}.sections {border-spacing: 0}.section {padding-right: 5; white-space: nowrap}.content {padding: 2 0 2 0}");
            ourCachedStyleSheetLinkColor = linkColorHex;
        }
        return ourCachedStyleSheet;
    }

    static {
        ourCachedStyleSheetLinkColor = "non-existing";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkActivationHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcHeightInPixels";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcGutterIconRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcWidth";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPane";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedLoadingPane";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEditorPane";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTextColor";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditorKit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStyleSheet";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 17 -> new IllegalStateException(string2);
        };
    }

    class EditorPane
    extends JEditorPane {
        private final List<Image> myImages = new ArrayList<Image>();
        private final AtomicBoolean myUpdateScheduled = new AtomicBoolean();
        private final AtomicBoolean myRepaintScheduled = new AtomicBoolean();
        private final ImageObserver myImageObserver = new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 3) != 0) {
                    EditorPane.this.scheduleUpdate();
                    return false;
                }
                return true;
            }
        };
        private boolean myRepaintRequested;

        EditorPane(boolean trackMemory) {
            if (trackMemory) {
                MEMORY_MANAGER.register(DocRenderer.this, 50);
            }
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            this.myRepaintRequested = true;
        }

        void doWithRepaintTracking(Runnable task2) {
            this.myRepaintRequested = false;
            task2.run();
            if (this.myRepaintRequested) {
                this.repaintRenderer();
            }
        }

        private void repaintRenderer() {
            CustomFoldRegion foldRegion = DocRenderer.this.myItem.getFoldRegion();
            if (foldRegion != null) {
                foldRegion.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            MEMORY_MANAGER.notifyPainted(DocRenderer.this);
            for (Image image : this.myImages) {
                IMAGE_MANAGER.notifyPainted(image);
            }
            super.paint(g);
        }

        Editor getEditor() {
            return DocRenderer.this.myItem.getEditor();
        }

        void removeSelection() {
            this.doWithRepaintTracking(() -> this.select(0, 0));
        }

        boolean hasSelection() {
            return this.getSelectionStart() != this.getSelectionEnd();
        }

        @Nullable
        Point getSelectionPositionInEditor() {
            Rectangle2D locationInPane;
            if (DocRenderer.this.myPane != this) {
                return null;
            }
            CustomFoldRegion foldRegion = DocRenderer.this.myItem.getFoldRegion();
            if (foldRegion == null || foldRegion.getRenderer() != DocRenderer.this) {
                return null;
            }
            Point rendererLocation = foldRegion.getLocation();
            if (rendererLocation == null) {
                return null;
            }
            Rectangle boundsWithinRenderer = DocRenderer.this.getEditorPaneBoundsWithinRenderer(foldRegion.getWidthInPixels(), foldRegion.getHeightInPixels());
            try {
                locationInPane = this.modelToView2D(this.getSelectionStart());
            }
            catch (BadLocationException e) {
                LOG.error(e);
                locationInPane = new Rectangle();
            }
            return new Point(rendererLocation.x + boundsWithinRenderer.x + (int)locationInPane.getX(), rendererLocation.y + boundsWithinRenderer.y + (int)locationInPane.getY());
        }

        private void scheduleUpdate() {
            if (this.myUpdateScheduled.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(() -> {
                    CustomFoldRegion foldRegion;
                    this.myRepaintScheduled.set(false);
                    this.myUpdateScheduled.set(false);
                    if (this == DocRenderer.this.myPane && (foldRegion = DocRenderer.this.myItem.getFoldRegion()) != null) {
                        DocRenderItemUpdater.getInstance().updateFoldRegions(Collections.singleton(foldRegion), false);
                    }
                });
            }
        }

        private void scheduleRepaint() {
            if (!this.myUpdateScheduled.get() && this.myRepaintScheduled.compareAndSet(false, true)) {
                SwingUtilities.invokeLater(() -> {
                    this.myRepaintScheduled.set(false);
                    if (this == DocRenderer.this.myPane) {
                        this.repaintRenderer();
                    }
                });
            }
        }

        void startImageTracking() {
            this.collectImages(this.getUI().getRootView(this));
            boolean update2 = false;
            for (Image image : this.myImages) {
                IMAGE_MANAGER.setCompletionListener(image, this::scheduleRepaint);
                update2 |= image.getWidth(this.myImageObserver) >= 0 || image.getHeight(this.myImageObserver) >= 0;
            }
            if (update2) {
                this.myImageObserver.imageUpdate(null, 3, 0, 0, 0, 0);
            }
        }

        private void collectImages(View view) {
            Image image;
            if (view instanceof ImageView && (image = ((ImageView)view).getImage()) != null) {
                this.myImages.add(image);
            }
            int childCount = view.getViewCount();
            for (int i2 = 0; i2 < childCount; ++i2) {
                this.collectImages(view.getView(i2));
            }
        }

        void dispose() {
            MEMORY_MANAGER.unregister(DocRenderer.this);
            this.myImages.forEach(image -> IMAGE_MANAGER.dispose((Image)image));
        }
    }

    private class CopySelection
    extends DumbAwareAction {
        CopySelection() {
            super(CodeInsightBundle.messagePointer("doc.render.copy.action.text", new Object[0]), AllIcons.Actions.Copy);
            AnAction copyAction = ActionManager.getInstance().getAction("$Copy");
            if (copyAction != null) {
                this.copyShortcutFrom(copyAction);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopySelection.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(DocRenderer.this.myPane != null && DocRenderer.this.myPane.hasSelection());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopySelection.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String text2;
            if (e == null) {
                CopySelection.$$$reportNull$$$0(2);
            }
            String string2 = text2 = DocRenderer.this.myPane == null ? null : DocRenderer.this.myPane.getSelectedText();
            if (!StringUtil.isEmpty(text2)) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderer$CopySelection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer$CopySelection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    static class ToggleRenderingAction
    extends DumbAwareAction {
        private final DocRenderItem item;

        ToggleRenderingAction(DocRenderItem i2) {
            this.copyFrom(ActionManager.getInstance().getAction("ToggleRenderedDocPresentation"));
            this.item = i2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleRenderingAction.$$$reportNull$$$0(0);
            }
            this.item.toggle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderer$ToggleRenderingAction", "actionPerformed"));
        }
    }

    private static class ChangeFontSize
    extends DumbAwareAction {
        ChangeFontSize() {
            super(CodeInsightBundle.messagePointer("javadoc.adjust.font.size", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor2;
            if (e == null) {
                ChangeFontSize.$$$reportNull$$$0(0);
            }
            if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                DocFontSizePopup.show((Component)editor2.getContentComponent(), () -> DocRenderItemUpdater.updateRenderers(editor2, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderer$ChangeFontSize", "actionPerformed"));
        }
    }

    private static final class MyScalingImageView
    extends ImageView {
        private int myAvailableWidth;

        private MyScalingImageView(Element element) {
            super(element);
        }

        @Override
        public Icon getLoadingImageIcon() {
            return AllIcons.Process.Step_passive;
        }

        @Override
        public int getResizeWeight(int axis) {
            return 1;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        @Override
        public float getPreferredSpan(int axis) {
            float baseSpan = super.getPreferredSpan(axis);
            if (axis == 0) {
                return baseSpan;
            }
            int availableWidth = this.getAvailableWidth();
            if (availableWidth <= 0) {
                return baseSpan;
            }
            float baseXSpan = super.getPreferredSpan(0);
            if (baseXSpan <= 0.0f) {
                return baseSpan;
            }
            if ((float)availableWidth > baseXSpan) {
                availableWidth = (int)baseXSpan;
            }
            if (this.myAvailableWidth > 0 && availableWidth != this.myAvailableWidth) {
                this.preferenceChanged(null, false, true);
            }
            this.myAvailableWidth = availableWidth;
            return baseSpan * (float)availableWidth / baseXSpan;
        }

        private int getAvailableWidth() {
            View v = this;
            while (v != null) {
                View parent2 = v.getParent();
                if (parent2 instanceof FlowView) {
                    int childCount = parent2.getViewCount();
                    for (int i2 = 0; i2 < childCount; ++i2) {
                        if (parent2.getView(i2) != v) continue;
                        return ((FlowView)parent2).getFlowSpan(i2);
                    }
                }
                v = parent2;
            }
            return 0;
        }

        @Override
        public void paint(Graphics g, Shape a) {
            final Rectangle targetRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            Graphics2DDelegate scalingGraphics = new Graphics2DDelegate((Graphics2D)g){

                @Override
                public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
                    int maxWidth = Math.max(0, targetRect.width - 2 * (x - targetRect.x));
                    int maxHeight = Math.max(0, targetRect.height - 2 * (y - targetRect.y));
                    if (width > maxWidth) {
                        height = height * maxWidth / width;
                        width = maxWidth;
                    }
                    if (height > maxHeight) {
                        width = width * maxHeight / height;
                        height = maxHeight;
                    }
                    return super.drawImage(img, x, y, width, height, observer);
                }
            };
            super.paint(scalingGraphics, a);
        }
    }
}

