/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.BackspaceModeOverride;
import com.intellij.codeInsight.editorActions.LanguageBackspaceModeOverride;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

abstract class AbstractIndentingBackspaceHandler
extends BackspaceHandlerDelegate {
    private final SmartBackspaceMode myMode;
    private boolean myEnabled;

    AbstractIndentingBackspaceHandler(SmartBackspaceMode mode) {
        this.myMode = mode;
    }

    @Override
    public void beforeCharDeleted(char c2, @NotNull PsiFile file2, Editor editor2) {
        if (file2 == null) {
            AbstractIndentingBackspaceHandler.$$$reportNull$$$0(0);
        }
        this.myEnabled = false;
        if (editor2.isColumnMode() || !StringUtil.isWhiteSpace(c2)) {
            return;
        }
        Language language = BackspaceHandler.getLanguageAtCursorPosition(file2, editor2);
        SmartBackspaceMode mode = AbstractIndentingBackspaceHandler.getBackspaceMode(language);
        if (mode != this.myMode) {
            return;
        }
        this.doBeforeCharDeleted(c2, file2, editor2);
        this.myEnabled = true;
    }

    @Override
    public boolean charDeleted(char c2, @NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            AbstractIndentingBackspaceHandler.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            AbstractIndentingBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (!this.myEnabled) {
            return false;
        }
        return this.doCharDeleted(c2, file2, editor2);
    }

    protected abstract void doBeforeCharDeleted(char var1, PsiFile var2, Editor var3);

    protected abstract boolean doCharDeleted(char var1, PsiFile var2, Editor var3);

    @NotNull
    private static SmartBackspaceMode getBackspaceMode(@NotNull Language language) {
        if (language == null) {
            AbstractIndentingBackspaceHandler.$$$reportNull$$$0(3);
        }
        SmartBackspaceMode mode = CodeInsightSettings.getInstance().getBackspaceMode();
        BackspaceModeOverride override = (BackspaceModeOverride)LanguageBackspaceModeOverride.INSTANCE.forLanguage(language);
        if (override != null) {
            mode = override.getBackspaceMode(mode);
        }
        SmartBackspaceMode smartBackspaceMode = mode;
        if (smartBackspaceMode == null) {
            AbstractIndentingBackspaceHandler.$$$reportNull$$$0(4);
        }
        return smartBackspaceMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/AbstractIndentingBackspaceHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/AbstractIndentingBackspaceHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackspaceMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharDeleted";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "charDeleted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBackspaceMode";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

