/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler.ForEachCaret {
    private static final Logger LOGGER = Logger.getInstance(BackspaceHandler.class);
    protected final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            BackspaceHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            BackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!this.handleBackspace(editor2, caret, dataContext2, false)) {
            this.myOriginalHandler.execute(editor2, caret, dataContext2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleBackspace(@NotNull Editor editor2, @NotNull Caret caret, @NotNull DataContext dataContext2, boolean toWordStart) {
        int injectedOffset;
        Project project2;
        if (editor2 == null) {
            BackspaceHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            BackspaceHandler.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            BackspaceHandler.$$$reportNull$$$0(4);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2)) == null) {
            return false;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor(editor2, project2);
        if (file2 == null) {
            return false;
        }
        if (editor2.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset2 = DocumentUtil.getPreviousCodePointOffset(editor2.getDocument(), editor2.getCaretModel().getOffset());
        if (offset2 < 0) {
            return false;
        }
        CharSequence chars = editor2.getDocument().getCharsSequence();
        int c2 = Character.codePointAt(chars, offset2);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c2, editor2, file2);
        Editor originalEditor = editor2;
        if (injectedEditor != editor2 && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(injectedEditor.getDocument());
            editor2 = injectedEditor;
            offset2 = DocumentUtil.getPreviousCodePointOffset(injectedEditor.getDocument(), injectedOffset);
        }
        List<BackspaceHandlerDelegate> delegates = BackspaceHandlerDelegate.EP_NAME.getExtensionList();
        if (!toWordStart && Character.isBmpCodePoint(c2)) {
            for (BackspaceHandlerDelegate delegate2 : delegates) {
                delegate2.beforeCharDeleted((char)c2, file2, editor2);
            }
        }
        FileType fileType = file2.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor2);
        HighlighterIterator hiterator = editor2.getHighlighter().createIterator(offset2);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset2);
        this.myOriginalHandler.execute(originalEditor, caret, dataContext2);
        if (!toWordStart && Character.isBmpCodePoint(c2)) {
            try {
                for (BackspaceHandlerDelegate delegate3 : delegates) {
                    if (!delegate3.charDeleted((char)c2, file2, editor2)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                BackspaceHandler.deleteCustomFoldRegionIfNeeded(caret);
            }
        }
        if (offset2 >= editor2.getDocument().getTextLength()) {
            return true;
        }
        chars = editor2.getDocument().getCharsSequence();
        if ((c2 == 40 || c2 == 91 || c2 == 123) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            boolean matched;
            char c1 = chars.charAt(offset2);
            if (c1 != BackspaceHandler.getRightChar((char)c2)) {
                return true;
            }
            iterator = editor2.getHighlighter().createIterator(offset2);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            if (!braceMatcher.isLBraceToken(iterator, chars, fileType) && !braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator, iterator.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator = editor2.getHighlighter().createIterator(rparenOffset), false, true))) {
                return true;
            }
            editor2.getDocument().deleteString(offset2, offset2 + 1);
        } else if ((c2 == 34 || c2 == 39 || c2 == 96) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            char c1 = chars.charAt(offset2);
            if (c1 != c2) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            iterator = editor2.getHighlighter().createIterator(offset2);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator, offset2)) {
                return true;
            }
            editor2.getDocument().deleteString(offset2, offset2 + 1);
        }
        return true;
    }

    private static void deleteCustomFoldRegionIfNeeded(@NotNull Caret caret) {
        if (caret == null) {
            BackspaceHandler.$$$reportNull$$$0(5);
        }
        int caretOffset = caret.getOffset();
        Editor editor2 = caret.getEditor();
        FoldRegion foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(caretOffset - 1);
        if (foldRegion instanceof CustomFoldRegion && foldRegion.getEndOffset() == caretOffset) {
            editor2.getDocument().deleteString(foldRegion.getStartOffset(), foldRegion.getEndOffset());
        }
    }

    public static char getRightChar(char c2) {
        if (c2 == '(') {
            return ')';
        }
        if (c2 == '[') {
            return ']';
        }
        if (c2 == '{') {
            return '}';
        }
        assert (false);
        return c2;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance(injectedFile.getProject());
        List<TextRange> editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset + 1));
        return editables.size() == 1 && editables.get(0).equals(rangeToEdit);
    }

    @NotNull
    static Language getLanguageAtCursorPosition(PsiFile file2, Editor editor2) {
        Language language;
        if (file2 instanceof PsiFileWithOneLanguage) {
            Language language2 = file2.getLanguage();
            if (language2 == null) {
                BackspaceHandler.$$$reportNull$$$0(6);
            }
            return language2;
        }
        PsiElement element = file2.findElementAt(editor2.getCaretModel().getOffset());
        Language language3 = language = element != null ? PsiUtilCore.findLanguageFromElement(element) : Language.ANY;
        if (language != Language.ANY) {
            Language language4 = language;
            if (language4 == null) {
                BackspaceHandler.$$$reportNull$$$0(7);
            }
            return language4;
        }
        Language language5 = file2.getLanguage();
        if (language5 == null) {
            BackspaceHandler.$$$reportNull$$$0(8);
        }
        return language5;
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file2, Editor editor2) {
        Language language;
        if (editor2.getSelectionModel().hasSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor2.getCaretModel().getLogicalPosition();
        if (caretPos.column == 0) {
            return null;
        }
        if (!BackspaceHandler.isWhitespaceBeforeCaret(editor2)) {
            return null;
        }
        CommonCodeStyleSettings.IndentOptions fileIndentOptions = CodeStyle.getIndentOptions((PsiFile)file2);
        int indent = fileIndentOptions.INDENT_SIZE;
        if (!fileIndentOptions.isOverrideLanguageOptions() && (language = BackspaceHandler.getLanguageAtCursorPosition(file2, editor2)) != file2.getLanguage()) {
            indent = CodeStyle.getSettings((PsiFile)file2).getLanguageIndentOptions((Language)language).INDENT_SIZE;
        }
        int column = indent > 0 ? (caretPos.column - 1) / indent * indent : 0;
        return new LogicalPosition(caretPos.line, column);
    }

    public static void deleteToTargetPosition(@NotNull Editor editor2, @NotNull LogicalPosition pos) {
        if (editor2 == null) {
            BackspaceHandler.$$$reportNull$$$0(9);
        }
        if (pos == null) {
            BackspaceHandler.$$$reportNull$$$0(10);
        }
        LogicalPosition logicalPosition = editor2.getCaretModel().getLogicalPosition();
        if (logicalPosition.line != pos.line) {
            LOGGER.error("Unexpected caret position: " + logicalPosition + ", target indent position: " + pos);
            return;
        }
        if (pos.column < logicalPosition.column) {
            int targetOffset = editor2.logicalPositionToOffset(pos);
            int offset2 = editor2.getCaretModel().getOffset();
            editor2.getCaretModel().getCurrentCaret().setSelection(targetOffset, offset2, false);
            EditorModificationUtilEx.deleteSelectedText((Editor)editor2);
            editor2.getCaretModel().moveToLogicalPosition(pos);
        } else if (pos.column > logicalPosition.column) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)StringUtil.repeatSymbol(' ', pos.column - logicalPosition.column));
        }
    }

    public static boolean isWhitespaceBeforeCaret(Editor editor2) {
        LogicalPosition caretPos = editor2.getCaretModel().getLogicalPosition();
        CharSequence charSeq = editor2.getDocument().getCharsSequence();
        for (int pos = 0; pos < caretPos.column; ++pos) {
            char c2;
            LogicalPosition checkPos = new LogicalPosition(caretPos.line, pos);
            int offset2 = editor2.logicalPositionToOffset(checkPos);
            if (offset2 >= charSeq.length() || (c2 = charSeq.charAt(offset2)) == '\t' || c2 == ' ' || c2 == '\n') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/BackspaceHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/BackspaceHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageAtCursorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleBackspace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteCustomFoldRegionIfNeeded";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteToTargetPosition";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

