/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BraceMatcherBasedSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor2) {
        VirtualFile file2;
        FileType fileType;
        if (e == null) {
            BraceMatcherBasedSelectioner.$$$reportNull$$$0(0);
        }
        if (editorText == null) {
            BraceMatcherBasedSelectioner.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            BraceMatcherBasedSelectioner.$$$reportNull$$$0(2);
        }
        FileType fileType2 = fileType = (file2 = e.getContainingFile().getVirtualFile()) == null ? null : file2.getFileType();
        if (fileType == null) {
            return super.select(e, editorText, cursorOffset, editor2);
        }
        int textLength = editorText.length();
        TextRange totalRange = e.getTextRange();
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(totalRange.getStartOffset());
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        record TokenData(int start, int end, IElementType type) {
        }
        ArrayDeque<TokenData> stack = new ArrayDeque<TokenData>();
        while (!iterator2.atEnd() && iterator2.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator2, editorText, fileType)) {
                stack.addLast(new TokenData(iterator2.getStart(), iterator2.getEnd(), iterator2.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator2, editorText, fileType) && !stack.isEmpty()) {
                TokenData last2 = (TokenData)stack.getLast();
                if (braceMatcher.isPairBraces(last2.type, iterator2.getTokenType())) {
                    int bodyStart;
                    stack.removeLast();
                    result2.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(last2.start, iterator2.getEnd())));
                    int bodyEnd = iterator2.getStart();
                    for (bodyStart = last2.end; bodyStart < textLength && Character.isWhitespace(editorText.charAt(bodyStart)); ++bodyStart) {
                    }
                    while (bodyEnd > 0 && bodyStart < bodyEnd && Character.isWhitespace(editorText.charAt(bodyEnd - 1))) {
                        --bodyEnd;
                    }
                    result2.addAll(BraceMatcherBasedSelectioner.expandToWholeLine(editorText, new TextRange(bodyStart, bodyEnd)));
                }
            }
            iterator2.advance();
        }
        result2.add(e.getTextRange());
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editorText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/BraceMatcherBasedSelectioner";
        objectArray[2] = "select";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

